/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import java.io.CharConversionException;

class DBOriginalDataFormat
implements DBDataFormat {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int REPEATED_LENGTH_ = 54;
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int numberOfFields_ = -1;
    private int length_ = -1;
    private boolean csRsData_ = false;

    public DBOriginalDataFormat() {
    }

    public DBOriginalDataFormat(int n) {
        this.numberOfFields_ = n;
        this.length_ = 8 + this.numberOfFields_ * 54;
    }

    @Override
    public void overlay(byte[] byArray, int n) {
        this.rawBytes_ = byArray;
        this.offset_ = n;
        if (this.numberOfFields_ == -1) {
            this.numberOfFields_ = BinaryConverter.byteArrayToShort(this.rawBytes_, n + 4);
            this.length_ = 8 + this.numberOfFields_ * 54;
        } else {
            this.setNumberOfFields(this.numberOfFields_);
        }
    }

    @Override
    public int getLength() {
        return this.length_;
    }

    @Override
    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    @Override
    public int getNumberOfFields() {
        return this.numberOfFields_;
    }

    @Override
    public int getRecordSize() {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 6);
    }

    @Override
    public int getFieldSQLType(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 10 + n * 54);
    }

    @Override
    public int getFieldLength(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 12 + n * 54);
    }

    @Override
    public int getArrayFieldLength(int n) throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 12 + n * 54);
    }

    @Override
    public int getFieldScale(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 14 + n * 54);
    }

    @Override
    public int getFieldPrecision(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + n * 54);
    }

    @Override
    public int getFieldCCSID(int n) {
        return BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.offset_ + 18 + n * 54);
    }

    @Override
    public int getFieldParameterType(int n) {
        return this.rawBytes_[this.offset_ + 20 + n * 54];
    }

    @Override
    public int getFieldLOBLocator(int n) {
        return -1;
    }

    @Override
    public int getFieldLOBMaxSize(int n) {
        return -1;
    }

    @Override
    public int getFieldNameLength(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 28 + n * 54);
    }

    @Override
    public int getFieldNameCCSID(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 30 + n * 54);
    }

    @Override
    public String getFieldName(int n, ConvTable convTable) {
        return convTable.byteArrayToString(this.rawBytes_, this.offset_ + 32 + n * 54, this.getFieldNameLength(n));
    }

    @Override
    public void setConsistencyToken(int n) {
        BinaryConverter.intToByteArray(n, this.rawBytes_, this.offset_);
    }

    @Override
    public void setNumberOfFields(int n) {
        BinaryConverter.shortToByteArray((short)n, this.rawBytes_, this.offset_ + 4);
    }

    @Override
    public void setRecordSize(int n) {
        BinaryConverter.shortToByteArray((short)n, this.rawBytes_, this.offset_ + 6);
    }

    @Override
    public void setFieldDescriptionLength(int n) {
        BinaryConverter.shortToByteArray((short)54, this.rawBytes_, this.offset_ + n * 54 + 8);
    }

    @Override
    public void setFieldSQLType(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 10);
    }

    @Override
    public void setFieldLength(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 12);
    }

    @Override
    public void setFieldScale(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 14);
    }

    @Override
    public void setFieldPrecision(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 16);
    }

    @Override
    public void setFieldCCSID(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 18);
    }

    @Override
    public void setFieldParameterType(int n, int n2) {
        this.rawBytes_[this.offset_ + n * 54 + 20] = (byte)n2;
    }

    @Override
    public void setFieldNameLength(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 28);
    }

    @Override
    public void setFieldNameCCSID(int n, int n2) {
        BinaryConverter.shortToByteArray((short)n2, this.rawBytes_, this.offset_ + n * 54 + 30);
    }

    @Override
    public void setFieldName(int n, String string, ConvTable convTable) throws DBDataStreamException {
        try {
            convTable.stringToByteArray(string, this.rawBytes_, this.offset_ + n * 54 + 32);
        }
        catch (CharConversionException charConversionException) {
            throw new DBDataStreamException();
        }
        int n2 = string.length();
        int n3 = this.offset_ + n * 54 + 32;
        for (int i = n2; i < 30; ++i) {
            this.rawBytes_[n3 + i] = 0;
        }
    }

    @Override
    public int getDateFormat() throws DBDataStreamException {
        return -1;
    }

    @Override
    public int getTimeFormat() throws DBDataStreamException {
        return -1;
    }

    @Override
    public int getDateSeparator() throws DBDataStreamException {
        return -1;
    }

    @Override
    public int getTimeSeparator() throws DBDataStreamException {
        return -1;
    }

    @Override
    public boolean getCSRSData() {
        return this.csRsData_;
    }

    @Override
    public void setCSRSData(boolean bl) {
        this.csRsData_ = bl;
    }

    @Override
    public int getXMLCharType(int n) {
        return -1;
    }

    @Override
    public int getArrayType(int n) {
        return -1;
    }

    @Override
    public int getUDTNameCCSID(int n) throws DBDataStreamException {
        return -1;
    }

    @Override
    public String getUDTName(int n, ConvTable convTable) throws DBDataStreamException {
        return null;
    }
}

