/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;

class DBSQLDADataFormat
implements DBDataFormat {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int REPEATED_LENGTH_ = 80;
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int numberOfFields_ = -1;
    private int jobCCSID_;
    private int length_ = -1;
    private boolean csRsData_ = false;

    public DBSQLDADataFormat(int n) {
        this.jobCCSID_ = n;
    }

    @Override
    public void overlay(byte[] byArray, int n) {
        this.rawBytes_ = byArray;
        this.offset_ = n;
        if (this.numberOfFields_ == -1) {
            this.numberOfFields_ = BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 14);
        }
        this.length_ = 16 + this.numberOfFields_ * 80;
    }

    @Override
    public int getLength() {
        return this.length_;
    }

    @Override
    public int getConsistencyToken() {
        return -1;
    }

    @Override
    public int getNumberOfFields() {
        return this.numberOfFields_;
    }

    @Override
    public int getRecordSize() {
        int n = 0;
        int n2 = this.getNumberOfFields();
        for (int i = 0; i < n2; ++i) {
            n += this.getFieldLength(i);
        }
        return n;
    }

    @Override
    public int getFieldSQLType(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + n * 80);
    }

    @Override
    public int getArrayFieldLength(int n) {
        return 0;
    }

    @Override
    public int getFieldLength(int n) {
        int n2 = this.getFieldSQLType(n) & 0xFFFE;
        int n3 = BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 18 + n * 80);
        int n4 = this.rawBytes_[this.offset_ + 18 + n * 80];
        if (n2 == 484) {
            n3 = n4 / 2 + 1;
        } else if (n2 == 488) {
            n3 = n4;
        } else if (n2 == 464 || n2 == 472 || n2 == 468) {
            n3 *= 2;
        }
        if (this.isVarType(n)) {
            n3 += 2;
        }
        return n3;
    }

    @Override
    public int getFieldScale(int n) {
        int n2 = this.getFieldSQLType(n) & 0xFFFE;
        if (n2 == 496 || n2 == 500) {
            return 0;
        }
        return this.rawBytes_[this.offset_ + 19 + n * 80];
    }

    @Override
    public int getFieldPrecision(int n) {
        int n2 = this.rawBytes_[this.offset_ + 18 + n * 80];
        if (this.isVarType(n)) {
            n2 += 2;
        }
        return n2;
    }

    @Override
    public int getFieldCCSID(int n) {
        return BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.offset_ + 34 + n * 80);
    }

    @Override
    public int getFieldParameterType(int n) throws DBDataStreamException {
        switch (this.rawBytes_[this.offset_ + 48 + 80 * n]) {
            default: {
                return -16;
            }
            case -42: {
                return -15;
            }
            case -62: 
        }
        return -14;
    }

    @Override
    public int getFieldLOBLocator(int n) {
        return -1;
    }

    @Override
    public int getFieldLOBMaxSize(int n) {
        return -1;
    }

    @Override
    public int getFieldNameLength(int n) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 64 + n * 80);
    }

    @Override
    public int getFieldNameCCSID(int n) {
        return this.jobCCSID_;
    }

    @Override
    public String getFieldName(int n, ConvTable convTable) throws DBDataStreamException {
        return convTable.byteArrayToString(this.rawBytes_, this.offset_ + 66 + n * 80, this.getFieldNameLength(n));
    }

    private boolean isVarType(int n) {
        int n2 = this.getFieldSQLType(n) & 0xFFFE;
        return n2 == 448 || n2 == 456 || n2 == 464 || n2 == 472 || n2 == 908;
    }

    @Override
    public void setConsistencyToken(int n) {
    }

    @Override
    public void setNumberOfFields(int n) {
        this.numberOfFields_ = n;
    }

    @Override
    public void setRecordSize(int n) {
    }

    @Override
    public void setFieldDescriptionLength(int n) {
    }

    @Override
    public void setFieldSQLType(int n, int n2) {
    }

    @Override
    public void setFieldLength(int n, int n2) {
    }

    @Override
    public void setFieldScale(int n, int n2) {
    }

    @Override
    public void setFieldPrecision(int n, int n2) {
    }

    @Override
    public void setFieldCCSID(int n, int n2) {
    }

    @Override
    public void setFieldParameterType(int n, int n2) {
    }

    @Override
    public void setFieldNameLength(int n, int n2) {
    }

    @Override
    public void setFieldNameCCSID(int n, int n2) {
    }

    @Override
    public void setFieldName(int n, String string, ConvTable convTable) throws DBDataStreamException {
    }

    @Override
    public int getDateFormat() throws DBDataStreamException {
        return -1;
    }

    @Override
    public int getTimeFormat() throws DBDataStreamException {
        return -1;
    }

    @Override
    public int getDateSeparator() throws DBDataStreamException {
        return -1;
    }

    @Override
    public int getTimeSeparator() throws DBDataStreamException {
        return -1;
    }

    @Override
    public boolean getCSRSData() {
        return this.csRsData_;
    }

    @Override
    public void setCSRSData(boolean bl) {
        this.csRsData_ = bl;
    }

    @Override
    public int getXMLCharType(int n) {
        return -1;
    }

    @Override
    public int getArrayType(int n) {
        return -1;
    }

    @Override
    public int getUDTNameCCSID(int n) throws DBDataStreamException {
        return -1;
    }

    @Override
    public String getUDTName(int n, ConvTable convTable) throws DBDataStreamException {
        return null;
    }
}

