/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Date;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;

public class DateFieldDescription
extends FieldDescription
implements Serializable {
    static final long serialVersionUID = 4L;
    static HashSet formatsWithFixedSeparators_;
    private String dateFormat_ = null;
    private String dateSeparator_ = null;

    public DateFieldDescription() {
    }

    public DateFieldDescription(AS400Text aS400Text, String string) {
        super(aS400Text, string);
    }

    public DateFieldDescription(AS400Text aS400Text, String string, String string2) {
        super(aS400Text, string, string2);
    }

    public DateFieldDescription(AS400Date aS400Date, String string) {
        super(aS400Date, string);
    }

    public DateFieldDescription(AS400Date aS400Date, String string, String string2) {
        super(aS400Date, string, string2);
    }

    public String getDATFMT() {
        return this.dateFormat_ == null ? "" : this.dateFormat_;
    }

    public String getDATSEP() {
        return this.dateSeparator_ == null ? "" : this.dateSeparator_;
    }

    @Override
    String[] getDDSDescription() {
        Vector<Object> vector = new Vector<Object>();
        StringBuffer stringBuffer = new StringBuffer(this.ddsName_);
        while (stringBuffer.length() < 10) {
            stringBuffer.append(" ");
        }
        if (!this.refFld_.equals("")) {
            stringBuffer.append("R");
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append("     ");
        stringBuffer.append("L");
        stringBuffer.append("  ");
        stringBuffer.append("       ");
        vector.addElement(stringBuffer.toString());
        String[] stringArray = super.getFieldFunctions();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
        }
        if (this.dateFormat_ != null) {
            vector.addElement("DATFMT(" + this.dateFormat_ + ") ");
        }
        if (this.dateSeparator_ != null) {
            if (!DateFieldDescription.formatHasFixedSeparator(this.dateFormat_)) {
                vector.addElement("DATSEP('" + this.dateSeparator_ + "') ");
            } else if (Trace.traceOn_) {
                Trace.log(1, "DDS date format " + this.dateFormat_ + " has a fixed separator.");
            }
        }
        if (this.defaultValue_ != null) {
            vector.addElement("DFT('" + this.defaultValue_.toString() + "') ");
        } else if (this.isDFTNull_) {
            vector.addElement("DFT(*NULL) ");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static boolean formatHasFixedSeparator(String string) {
        return DateFieldDescription.getFormatsWithFixedSeparators().contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashSet getFormatsWithFixedSeparators() {
        if (formatsWithFixedSeparators_ != null) return formatsWithFixedSeparators_;
        Class<DateFieldDescription> clazz = DateFieldDescription.class;
        synchronized (DateFieldDescription.class) {
            if (formatsWithFixedSeparators_ != null) return formatsWithFixedSeparators_;
            formatsWithFixedSeparators_ = new HashSet(6);
            formatsWithFixedSeparators_.add("*ISO");
            formatsWithFixedSeparators_.add("*USA");
            formatsWithFixedSeparators_.add("*EUR");
            formatsWithFixedSeparators_.add("*JIS");
            // ** MonitorExit[var0] (shouldn't be in output)
            return formatsWithFixedSeparators_;
        }
    }

    public void setDataType(AS400Text aS400Text) {
        if (aS400Text == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = aS400Text;
        this.length_ = aS400Text.getByteLength();
    }

    public void setDataType(AS400Date aS400Date) {
        if (aS400Date == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = aS400Date;
        this.length_ = aS400Date.getByteLength();
    }

    public void setDATFMT(String string) {
        if (string == null) {
            throw new NullPointerException("dateFormat");
        }
        this.dateFormat_ = string.startsWith("*") ? string.toUpperCase() : "*" + string.toUpperCase();
        if (this.dataType_ instanceof AS400Date) {
            ((AS400Date)this.dataType_).setFormat(string);
        }
    }

    public void setDATSEP(String string) {
        if (this.dataType_ instanceof AS400Date) {
            if (string != null && string.length() > 1) {
                throw new ExtendedIllegalArgumentException("separator (" + string + ")", 1);
            }
            Character c = string == null ? null : new Character(string.charAt(0));
            ((AS400Date)this.dataType_).setSeparator(c);
        }
        this.dateSeparator_ = string;
    }

    public void setDFT(String string) {
        if (string == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = string;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTCurrent() {
        this.isDFTCurrent_ = true;
        this.isDFTNull_ = false;
        this.defaultValue_ = null;
        this.DFTCurrentValue_ = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }
}

