/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.io.Serializable;
import java.util.Vector;

public class HexFieldDescription
extends FieldDescription
implements VariableLengthFieldDescription,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private int variableLength_;
    private boolean isVariableLength_;

    public HexFieldDescription() {
    }

    public HexFieldDescription(AS400ByteArray aS400ByteArray, String string) {
        super(aS400ByteArray, string);
    }

    public HexFieldDescription(AS400ByteArray aS400ByteArray, String string, String string2) {
        super(aS400ByteArray, string, string2);
    }

    @Override
    String[] getDDSDescription() {
        Vector<Object> vector = new Vector<Object>();
        StringBuffer stringBuffer = new StringBuffer(this.ddsName_);
        while (stringBuffer.length() < 10) {
            stringBuffer.append(" ");
        }
        if (!this.refFld_.equals("")) {
            stringBuffer.append("R");
        } else {
            stringBuffer.append(" ");
        }
        String string = String.valueOf(this.length_);
        int n = 5 - string.length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        stringBuffer.append("H");
        stringBuffer.append("  ");
        stringBuffer.append("       ");
        vector.addElement(stringBuffer.toString());
        String[] stringArray = super.getFieldFunctions();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
        }
        if (this.isVariableLength_) {
            if (this.variableLength_ > 0) {
                vector.addElement("VARLEN(" + new Integer(this.variableLength_).toString() + ") ");
            } else {
                vector.addElement("VARLEN ");
            }
        }
        if (this.defaultValue_ != null) {
            vector.addElement("DFT('" + new String((byte[])this.defaultValue_) + "') ");
        } else if (this.isDFTNull_) {
            vector.addElement("DFT(*NULL) ");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int getVARLEN() {
        return this.variableLength_;
    }

    @Override
    public boolean isVariableLength() {
        return this.isVariableLength_;
    }

    public void setDataType(AS400ByteArray aS400ByteArray) {
        if (aS400ByteArray == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = aS400ByteArray;
        this.length_ = aS400ByteArray.getByteLength();
    }

    public void setDFT(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("defaultValue");
        }
        if (byArray.length < 1) {
            throw new ExtendedIllegalArgumentException("defaultValue (" + String.valueOf(byArray) + ")", 1);
        }
        this.defaultValue_ = byArray;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    @Override
    public void setVariableLength(boolean bl) {
        this.isVariableLength_ = bl;
    }

    public void setVARLEN(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("varLen (" + String.valueOf(n) + ")", 2);
        }
        this.variableLength_ = n;
        this.isVariableLength_ = true;
    }
}

