/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class HexReaderInputStream
extends InputStream {
    private Reader reader_;
    private boolean cached_ = false;
    private char cachedChar_;

    public HexReaderInputStream(Reader reader) {
        this.reader_ = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        HexReaderInputStream hexReaderInputStream = this;
        synchronized (hexReaderInputStream) {
            if (this.cached_ && this.reader_.ready()) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.reader_.close();
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.cached_) {
            this.cached_ = false;
            int n = this.reader_.read();
            if (n == -1) {
                return -1;
            }
            try {
                return BinaryConverter.charsToByte(this.cachedChar_, (char)n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ExtendedIOException(21);
            }
        }
        int n = this.reader_.read();
        if (n == -1) {
            return -1;
        }
        int n2 = this.reader_.read();
        if (n2 == -1) {
            return -1;
        }
        try {
            return BinaryConverter.charsToByte((char)n, (char)n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExtendedIOException(21);
        }
    }

    @Override
    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("b");
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.cached_) {
            this.cached_ = false;
            int n3 = this.reader_.read();
            if (n3 == -1) {
                return -1;
            }
            try {
                byArray[n] = BinaryConverter.charsToByte(this.cachedChar_, (char)n3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ExtendedIOException(21);
            }
            return 1;
        }
        char[] cArray = new char[n2 * 2];
        int n4 = this.reader_.read(cArray);
        if (n4 == -1) {
            return -1;
        }
        if (n4 % 2 != 0) {
            this.cached_ = true;
            this.cachedChar_ = cArray[n4 - 1];
            --n4;
        }
        try {
            return BinaryConverter.stringToBytes(cArray, 0, n4, byArray, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExtendedIOException(21);
        }
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        if (l == 0L) {
            return 0L;
        }
        if (this.cached_) {
            this.cached_ = false;
        }
        long l2 = this.reader_.skip(l * 2L);
        return l2 / 2L;
    }
}

