/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileInputStreamImpl;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyReturnValue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class IFSFileInputStreamImplProxy
extends AbstractProxyImpl
implements IFSFileInputStreamImpl {
    private static final boolean[] ARGS_TO_RETURN = new boolean[]{true, false, false};

    IFSFileInputStreamImplProxy() {
        super("IFSFileInputStream");
    }

    @Override
    public int available() throws IOException {
        try {
            return this.connection_.callMethod(this.pxId_, "available").getReturnValueInt();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow1(invocationTargetException);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "close");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow1(invocationTargetException);
        }
    }

    @Override
    public void connectAndOpen() throws AS400SecurityException, IOException {
        try {
            this.connection_.callMethod(this.pxId_, "connectAndOpen");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof AS400SecurityException) {
                throw (AS400SecurityException)throwable;
            }
            throw ProxyClientConnection.rethrow1(invocationTargetException);
        }
    }

    @Override
    public IFSKey lock(long l) throws IOException {
        try {
            return (IFSKey)this.connection_.callMethod(this.pxId_, "lock", new Class[]{Long.TYPE}, new Object[]{new Long(l)}).getReturnValue();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow1(invocationTargetException);
        }
    }

    @Override
    public void open() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "open");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow1(invocationTargetException);
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            ProxyReturnValue proxyReturnValue = this.connection_.callMethod(this.pxId_, "read", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{byArray, new Integer(n), new Integer(n2)}, ARGS_TO_RETURN, false);
            byte[] byArray2 = (byte[])proxyReturnValue.getArgument(0);
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = byArray2[i];
            }
            return proxyReturnValue.getReturnValueInt();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow1(invocationTargetException);
        }
    }

    @Override
    public String readText(int n) throws IOException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "readText", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValue();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow1(invocationTargetException);
        }
    }

    @Override
    public void setFD(IFSFileDescriptorImpl iFSFileDescriptorImpl) {
        try {
            this.connection_.callMethod(this.pxId_, "setFD", new Class[]{IFSFileDescriptorImpl.class}, new Object[]{iFSFileDescriptorImpl});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow(invocationTargetException);
        }
    }

    @Override
    public long skip(long l) throws IOException {
        try {
            return this.connection_.callMethod(this.pxId_, "skip", new Class[]{Long.TYPE}, new Object[]{new Long(l)}).getReturnValueLong();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow1(invocationTargetException);
        }
    }

    @Override
    public void unlock(IFSKey iFSKey) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "unlock", new Class[]{IFSKey.class}, new Object[]{iFSKey});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow1(invocationTargetException);
        }
    }
}

