/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class IFSFileReader
extends Reader {
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    private transient ConvTableReader reader_;
    private IFSFileInputStream inputStream_;

    public IFSFileReader(IFSFile iFSFile) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        int n = iFSFile.getCCSID();
        if (n == -1) {
            IFSFileReader.throwException(iFSFile.getPath());
        }
        this.inputStream_ = new IFSFileInputStream(iFSFile);
        this.reader_ = new ConvTableReader((InputStream)this.inputStream_, n);
    }

    public IFSFileReader(IFSFile iFSFile, int n) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        this.inputStream_ = new IFSFileInputStream(iFSFile);
        this.reader_ = new ConvTableReader((InputStream)this.inputStream_, n);
    }

    public IFSFileReader(IFSFile iFSFile, int n, int n2) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        this.inputStream_ = new IFSFileInputStream(iFSFile, n2);
        this.reader_ = new ConvTableReader((InputStream)this.inputStream_, n);
    }

    public IFSFileReader(IFSFileDescriptor iFSFileDescriptor) throws AS400SecurityException, IOException {
        int n = iFSFileDescriptor.getCCSID();
        if (n == -1) {
            IFSFileReader.throwException(iFSFileDescriptor.getPath());
        }
        this.inputStream_ = new IFSFileInputStream(iFSFileDescriptor);
        this.reader_ = new ConvTableReader((InputStream)this.inputStream_, n);
    }

    @Override
    public void close() throws IOException {
        this.reader_.close();
    }

    public int getCCSID() {
        return this.reader_.getCcsid();
    }

    public String getEncoding() {
        return this.reader_.getEncoding();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        return this.reader_.read();
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.reader_.read(cArray);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.reader_.read(cArray, n, n2);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader_.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        IFSFileInputStream iFSFileInputStream = this.inputStream_;
        synchronized (iFSFileInputStream) {
            this.inputStream_.reset();
            this.reader_ = new ConvTableReader((InputStream)this.inputStream_, this.reader_.getCcsid());
        }
    }

    @Override
    public long skip(long l) throws IOException {
        return this.reader_.skip(l);
    }

    public IFSKey lockBytes(int n) throws IOException {
        return this.lockBytes((long)n);
    }

    public IFSKey lockBytes(long l) throws IOException {
        return this.inputStream_.lock(l);
    }

    public void unlockBytes(IFSKey iFSKey) throws IOException {
        this.inputStream_.unlock(iFSKey);
    }

    private static final void throwException(String string) throws ExtendedIOException {
        Trace.log(2, "File does not exist or is not readable.");
        throw new ExtendedIOException(string, 2);
    }
}

