/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConvTableWriter;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class IFSFileWriter
extends Writer {
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    private transient ConvTableWriter writer_;
    private IFSFileOutputStream outputStream_;

    public IFSFileWriter(IFSFile iFSFile) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        int n = iFSFile.getCCSID();
        if (n == -1) {
            IFSFileWriter.throwException(iFSFile.getPath());
        }
        this.outputStream_ = new IFSFileOutputStream(iFSFile);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n);
    }

    public IFSFileWriter(IFSFile iFSFile, int n) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        this.outputStream_ = new IFSFileOutputStream(iFSFile);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n);
    }

    public IFSFileWriter(IFSFile iFSFile, boolean bl) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        int n = iFSFile.getCCSID();
        if (n == -1) {
            IFSFileWriter.throwException(iFSFile.getPath());
        }
        this.outputStream_ = new IFSFileOutputStream(iFSFile, -1, bl);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n);
    }

    public IFSFileWriter(IFSFile iFSFile, boolean bl, int n) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        int n2 = iFSFile.getCCSID();
        if (n2 == -1) {
            IFSFileWriter.throwException(iFSFile.getPath());
        }
        this.outputStream_ = new IFSFileOutputStream(iFSFile, n, bl);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n2);
    }

    public IFSFileWriter(IFSFile iFSFile, boolean bl, int n, int n2) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        this.outputStream_ = new IFSFileOutputStream(iFSFile, n, bl);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n2);
    }

    public IFSFileWriter(IFSFileDescriptor iFSFileDescriptor) throws AS400SecurityException, IOException {
        int n = iFSFileDescriptor.getCCSID();
        if (n == -1) {
            IFSFileWriter.throwException(iFSFileDescriptor.getPath());
        }
        this.outputStream_ = new IFSFileOutputStream(iFSFileDescriptor);
        this.writer_ = new ConvTableWriter((OutputStream)this.outputStream_, n);
    }

    @Override
    public void close() throws IOException {
        this.writer_.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer_.flush();
    }

    public int getCCSID() {
        return this.writer_.getCcsid();
    }

    public String getEncoding() {
        return this.writer_.getEncoding();
    }

    public IFSKey lockBytes(int n) throws IOException {
        return this.lockBytes((long)n);
    }

    public IFSKey lockBytes(long l) throws IOException {
        return this.outputStream_.lock(l);
    }

    public void unlockBytes(IFSKey iFSKey) throws IOException {
        this.outputStream_.unlock(iFSKey);
    }

    @Override
    public void write(int n) throws IOException {
        this.writer_.write(n);
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.writer_.write(cArray);
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        this.writer_.write(cArray, n, n2);
    }

    @Override
    public void write(String string) throws IOException {
        this.writer_.write(string);
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        this.writer_.write(string, n, n2);
    }

    private static final void throwException(String string) throws ExtendedIOException {
        Trace.log(2, "File does not exist or is not writable.");
        throw new ExtendedIOException(string, 2);
    }
}

