/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSRandomAccessFileImpl;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UTFDataFormatException;

class IFSRandomAccessFileImplRemote
implements IFSRandomAccessFileImpl {
    private int existenceOption_;
    private IFSFileDescriptorImplRemote fd_;
    private String mode_ = "";
    private boolean forceToStorage_ = false;
    private transient byte[] readCache_ = new byte[4096];
    private transient int readCacheIndex_;
    private transient int readCacheLength_;
    private static final int[] twoToThe = new int[]{1, 2, 4, 8, 16};

    IFSRandomAccessFileImplRemote() {
    }

    @Override
    public void close() throws IOException {
        this.fd_.close0();
    }

    @Override
    public void connectAndOpen() throws AS400SecurityException, IOException {
        this.fd_.connect();
        this.open();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.fd_ != null) {
                this.fd_.finalize0();
            }
        }
        catch (Throwable throwable) {
            Trace.log(2, "Error during finalization.", throwable);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void flush() throws IOException {
        this.open();
        try {
            this.fd_.flush();
        }
        catch (AS400SecurityException aS400SecurityException) {
            IOException iOException = new IOException(aS400SecurityException.getMessage());
            try {
                iOException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
    }

    private long getFilePointer() throws IOException {
        this.open();
        return this.fd_.getFileOffset();
    }

    @Override
    public long length() throws IOException {
        this.open();
        IFSListAttrsRep iFSListAttrsRep = null;
        IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(this.fd_.getFileHandle());
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(iFSListAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.fd_.setServer(null);
            throw connectionDroppedException;
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        boolean bl = false;
        do {
            if (iFSListAttrsRep == null && clientAccessDataStream instanceof IFSListAttrsRep) {
                iFSListAttrsRep = (IFSListAttrsRep)clientAccessDataStream;
            } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 18) {
                    throw new ExtendedIOException(n);
                }
            } else {
                Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            bl = ((IFSDataStream)clientAccessDataStream).isEndOfChain();
            if (bl) continue;
            try {
                clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().receive(iFSListAttrsReq.getCorrelation());
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost");
                this.fd_.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted", (Throwable)interruptedException);
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                try {
                    interruptedIOException.initCause(interruptedException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw interruptedIOException;
            }
        } while (!bl);
        if (iFSListAttrsRep == null) {
            Trace.log(2, "no reply available");
            throw new InternalErrorException(6);
        }
        return iFSListAttrsRep.getSize(this.fd_.serverDatastreamLevel_);
    }

    @Override
    public IFSKey lock(long l, long l2) throws IOException {
        this.open();
        try {
            return this.fd_.lock(l, l2);
        }
        catch (AS400SecurityException aS400SecurityException) {
            IOException iOException = new IOException(aS400SecurityException.getMessage());
            try {
                iOException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public void open() throws IOException {
        if (this.fd_.isOpen_) {
            return;
        }
        if (!this.fd_.isOpenAllowed_) {
            Trace.log(2, "Attempting to re-open a closed stream.");
            throw new ConnectionDroppedException(3);
        }
        String string = this.fd_.getPath();
        if (string.length() == 0) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        if (this.mode_.length() == 0) {
            throw new ExtendedIllegalStateException("mode", 4);
        }
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Access to byte stream server on '" + this.fd_.getSystem().getSystemName() + "' denied.", (Throwable)aS400SecurityException);
            throw new ExtendedIOException(5);
        }
        byte[] byArray = this.fd_.getConverter().stringToByteArray(string);
        int n = 0;
        if (this.mode_.indexOf(114) != -1) {
            n |= 1;
        }
        if (this.mode_.indexOf(119) != -1) {
            n |= 2;
        }
        int n2 = this.fd_.getPreferredCCSID();
        IFSOpenReq iFSOpenReq = new IFSOpenReq(byArray, n2, n2, n, ~this.fd_.getShareOption(), 0, twoToThe[this.existenceOption_], this.fd_.serverDatastreamLevel_);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(iFSOpenReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        if (!(clientAccessDataStream instanceof IFSOpenRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n3 == 2 || n3 == 3) {
                    Trace.log(2, string + " not found.");
                    throw new FileNotFoundException(string);
                }
                if (n3 == 1) {
                    Trace.log(2, "IFSReturnCodeRep return code", n3);
                    throw new ExtendedIOException(32);
                }
                Trace.log(2, "IFSReturnCodeRep return code", n3);
                throw new ExtendedIOException(n3);
            }
            if (clientAccessDataStream == null) {
                Trace.log(2, "Null data stream");
                throw new InternalErrorException("null", 2);
            }
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        IFSOpenRep iFSOpenRep = (IFSOpenRep)clientAccessDataStream;
        this.fd_.setOpen(true, iFSOpenRep.getFileHandle());
        this.fd_.setOpenAllowed(false);
    }

    private int read(byte[] byArray, int n, int n2) throws IOException, AS400SecurityException {
        this.open();
        int n3 = this.fd_.read(byArray, n, n2);
        return n3;
    }

    @Override
    public int read(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        try {
            if (!bl) {
                return this.read(byArray, n, n2);
            }
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.read(byArray, n + n3, n2 - n3);
                if (n4 > 0) {
                    n3 += n4;
                }
                if (n3 == byArray.length) continue;
                try {
                    Thread.sleep(64L);
                }
                catch (Exception exception) {}
            }
            return n3;
        }
        catch (AS400SecurityException aS400SecurityException) {
            IOException iOException = new IOException(aS400SecurityException.getMessage());
            try {
                iOException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
    }

    private int readFromCache() throws IOException {
        int n = this.readCacheLength_ - this.readCacheIndex_;
        if (n == 0) {
            try {
                this.readCacheLength_ = this.read(this.readCache_, 0, this.readCache_.length);
            }
            catch (AS400SecurityException aS400SecurityException) {
                IOException iOException = new IOException(aS400SecurityException.getMessage());
                try {
                    iOException.initCause(aS400SecurityException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw iOException;
            }
            if (this.readCacheLength_ == -1) {
                return -1;
            }
            this.readCacheIndex_ = 0;
        }
        return this.readCache_[this.readCacheIndex_++];
    }

    @Override
    public final synchronized String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        this.readCacheLength_ = 0;
        this.readCacheIndex_ = 0;
        boolean bl = false;
        while (!bl && (n = this.readFromCache()) != -1) {
            stringBuffer.append((char)n);
            if (n == 10) {
                bl = true;
                continue;
            }
            if (n != 13) continue;
            int n2 = this.readFromCache();
            if (n2 == 10) {
                stringBuffer.append((char)n2);
            } else {
                --this.readCacheIndex_;
            }
            bl = true;
        }
        n = this.readCacheLength_ - this.readCacheIndex_;
        if (n > 0) {
            this.fd_.setFileOffset((int)this.getFilePointer() - n);
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        try {
            byte[] byArray;
            byte[] byArray2 = new byte[2];
            int n = this.read(byArray2, 0, 2);
            if (n != 2) {
                throw new EOFException();
            }
            int n2 = (byArray2[0] & 0xFF) << 8 | byArray2[1] & 0xFF;
            if (n2 < 0) {
                n2 += 65536;
            }
            if (this.read(byArray = new byte[n2], 0, n2) != n2) {
                throw new EOFException();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                char c;
                if ((byArray[n3] & 0x80) == 0) {
                    stringBuffer.append((char)byArray[n3]);
                    ++n3;
                    continue;
                }
                if ((byArray[n3] & 0xE0) == 192) {
                    if (n3 + 1 < n2) {
                        c = (char)((byArray[n3] & 0x1F) << 6 | byArray[n3 + 1] & 0x3F);
                        stringBuffer.append(c);
                        n3 += 2;
                        continue;
                    }
                    throw new UTFDataFormatException();
                }
                if ((byArray[n3] & 0xE0) == 224) {
                    if (n3 + 2 < n2) {
                        c = (char)((byArray[n3] & 0xF) << 12 | (byArray[n3 + 1] & 0x3F) << 6 | byArray[n3 + 2] & 0x3F);
                        stringBuffer.append(c);
                        n3 += 3;
                        continue;
                    }
                    throw new UTFDataFormatException();
                }
                throw new UTFDataFormatException();
            }
            return stringBuffer.toString();
        }
        catch (AS400SecurityException aS400SecurityException) {
            IOException iOException = new IOException(aS400SecurityException.getMessage());
            try {
                iOException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
    }

    public void seek(long l) throws IOException {
        this.open();
        this.fd_.setFileOffset((int)l);
    }

    @Override
    public void setExistenceOption(int n) {
        if (this.fd_.isOpen_) {
            throw new ExtendedIllegalStateException("existenceOption", 5);
        }
        this.existenceOption_ = n;
    }

    @Override
    public void setFD(IFSFileDescriptorImpl iFSFileDescriptorImpl) {
        this.fd_ = IFSFileDescriptorImplRemote.castImplToImplRemote(iFSFileDescriptorImpl);
    }

    @Override
    public void setForceToStorage(boolean bl) {
        this.forceToStorage_ = bl;
    }

    @Override
    public void setLength(long l) throws IOException {
        try {
            this.fd_.setLength(l);
        }
        catch (AS400SecurityException aS400SecurityException) {
            IOException iOException = new IOException(aS400SecurityException.getMessage());
            try {
                iOException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public void setMode(String string) {
        if (this.fd_.isOpen_) {
            throw new ExtendedIllegalStateException("mode", 5);
        }
        this.mode_ = string;
    }

    @Override
    public void unlock(IFSKey iFSKey) throws IOException {
        this.open();
        try {
            this.fd_.unlock(iFSKey);
        }
        catch (AS400SecurityException aS400SecurityException) {
            IOException iOException = new IOException(aS400SecurityException.getMessage());
            try {
                iOException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.open();
        try {
            this.fd_.writeBytes(byArray, n, n2, this.forceToStorage_);
        }
        catch (AS400SecurityException aS400SecurityException) {
            IOException iOException = new IOException(aS400SecurityException.getMessage());
            try {
                iOException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        byte[] byArray = new byte[string.length() * 3];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') {
                byArray[n] = -64;
                byArray[n + 1] = -128;
                n += 2;
                continue;
            }
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n] = (byte)c;
                ++n;
                continue;
            }
            if (c >= '\u0080' && c <= '\u07ff') {
                byArray[n] = (byte)(0xC0 | (c & 0x7C0) >>> 6);
                byArray[n + 1] = (byte)(0x80 | c & 0x3F);
                n += 2;
                continue;
            }
            byArray[n] = (byte)(0xE0 | (c & 0xF000) >>> 4);
            byArray[n + 1] = (byte)(0x80 | (c & 0xFC0) >>> 6);
            byArray[n + 2] = (byte)(0x80 | c & 0x3F);
            n += 3;
        }
        byte[] byArray2 = new byte[2];
        byArray2[1] = (byte)n;
        byArray2[0] = (byte)(n >>> 8);
        this.writeBytes(byArray2, 0, 2);
        this.writeBytes(byArray, 0, n);
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
    }
}

