/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ISeriesNetServerShare;

public class ISeriesNetServerFileShare
extends ISeriesNetServerShare {
    static final long serialVersionUID = 1L;
    public static final int NO_MAX = -1;
    public static final int UNKNOWN = -1;
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    public static final int NOT_ENABLED = 0;
    public static final int ENABLED = 1;
    public static final int ENABLED_AND_MIXED = 2;
    String path_;
    int permissions_;
    int maxNumberOfUsers_;
    int curNumberOfUsers_;
    int ccsidForTextConversion_;
    String textConversionEnablement_;
    String[] fileExtensions_;
    String encryptionRequired_;
    String authorizationList_;

    ISeriesNetServerFileShare(String string, int n, int n2, int n3, String string2, String string3, int n4, String string4, String[] stringArray, String string5, String string6) {
        this.setAttributeValues(string, n, n2, n3, string2, string3, n4, string4, stringArray, string5, string6);
    }

    void setAttributeValues(String string, int n, int n2, int n3, String string2, String string3, int n4, String string4, String[] stringArray, String string5, String string6) {
        super.setAttributeValues(string, string2, true);
        this.path_ = string3;
        this.permissions_ = n;
        this.maxNumberOfUsers_ = n2;
        this.curNumberOfUsers_ = n3;
        this.ccsidForTextConversion_ = n4;
        this.textConversionEnablement_ = string4;
        this.fileExtensions_ = stringArray;
        this.encryptionRequired_ = string5;
        this.authorizationList_ = string6;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.path_ = string.trim();
    }

    public int getPermissions() {
        return this.permissions_;
    }

    public void setPermissions(int n) {
        if (n != 1 && n != 2) {
            throw new ExtendedIllegalArgumentException(Integer.toString(n), 2);
        }
        this.permissions_ = n;
    }

    public int getMaximumNumberOfUsers() {
        return this.maxNumberOfUsers_;
    }

    public void setMaximumNumberOfUsers(int n) {
        if (n < -1) {
            throw new ExtendedIllegalArgumentException(Integer.toString(n), 2);
        }
        this.maxNumberOfUsers_ = n;
    }

    public int getCurrentNumberOfUsers() {
        return this.curNumberOfUsers_;
    }

    public int getTextConversionEnablement() {
        switch (this.textConversionEnablement_.charAt(0)) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
        }
        return 2;
    }

    public void setTextConversionEnablement(int n) {
        if (n < 0 || n > 2) {
            throw new ExtendedIllegalArgumentException(Integer.toString(n), 2);
        }
        char[] cArray = new char[1];
        switch (n) {
            case 0: {
                cArray[0] = 48;
                break;
            }
            case 1: {
                cArray[0] = 49;
                break;
            }
            default: {
                cArray[0] = 50;
            }
        }
        this.textConversionEnablement_ = new String(cArray);
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 2);
    }

    public int getCcsidForTextConversion() {
        return this.ccsidForTextConversion_;
    }

    public void setCcsidForTextConversion(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException(Integer.toString(n), 2);
        }
        this.ccsidForTextConversion_ = n;
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 1);
    }

    public String[] getFileExtensions() {
        String[] stringArray = new String[this.fileExtensions_.length];
        System.arraycopy(this.fileExtensions_, 0, stringArray, 0, this.fileExtensions_.length);
        return stringArray;
    }

    public void setFileExtensions(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("extensions");
        }
        this.fileExtensions_ = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.fileExtensions_[i] = stringArray[i].trim();
        }
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 4);
    }

    public int getEncryptionRequired() {
        if (this.encryptionRequired_ == null) {
            throw new NullPointerException("Encryption required");
        }
        switch (this.encryptionRequired_.charAt(0)) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
        }
        return 0;
    }

    public void setEncryptionRequired(int n) {
        if (n < 0 || n > 1) {
            throw new ExtendedIllegalArgumentException(Integer.toString(n), 2);
        }
        char[] cArray = new char[1];
        switch (n) {
            case 0: {
                cArray[0] = 48;
                break;
            }
            case 1: {
                cArray[0] = 49;
                break;
            }
            default: {
                cArray[0] = 48;
            }
        }
        this.encryptionRequired_ = new String(cArray);
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 5);
    }

    public String getAuthorizationList() {
        if (this.authorizationList_ == null) {
            throw new NullPointerException("Authorization list");
        }
        return this.authorizationList_;
    }

    public void setAuthorizationList(String string) {
        if (string.length() != 0) {
            this.authorizationList_ = string;
        }
        if (this.authorizationList_ != null) {
            this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 6);
        }
    }
}

