/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBNativeDatabaseRequestDS;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import java.sql.SQLException;
import java.util.StringTokenizer;

class JDLibraryList {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    public static final String LIBL_ = "*LIBL";
    public static final String USRLIBL_ = "*USRLIBL";
    private char[] indicators_;
    private String defaultSchema_;
    private String[] list_;
    private String libListType_;

    JDLibraryList(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    JDLibraryList(String object, String string, String string2, String string3) {
        Object object2;
        int n;
        boolean bl = false;
        String string4 = object;
        this.defaultSchema_ = null;
        if (!("".equals(string) && string == null || string.length() <= 0)) {
            this.defaultSchema_ = string.startsWith("\"") ? string : string.toUpperCase();
        }
        if (this.defaultSchema_ != null) {
            if (object != null && ((String)object).length() > 0) {
                n = 0;
                if (((String)object).toUpperCase().indexOf(this.defaultSchema_) >= 0) {
                    object2 = new StringTokenizer((String)object, " ,:;");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        if (!((StringTokenizer)object2).nextToken().toUpperCase().equals(this.defaultSchema_)) continue;
                        n = 1;
                    }
                }
                if (n == 0) {
                    object = this.defaultSchema_ + "," + (String)object;
                }
            } else {
                object = this.defaultSchema_;
            }
        }
        this.list_ = null;
        n = -1;
        this.libListType_ = string3 != null && string3.length() > 0 ? (string3.equals(LIBL_) || string3.equals(USRLIBL_) ? string3 : LIBL_) : LIBL_;
        if (((String)object).length() != 0) {
            if (this.defaultSchema_ == null && ((String)(object2 = ((String)object).trim())).length() > 0 && ((String)object2).startsWith(",")) {
                bl = true;
            }
            boolean bl2 = ((String)object).toUpperCase().indexOf(this.libListType_) != -1;
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ,:;", true);
            int n2 = stringTokenizer.countTokens();
            if (bl2) {
                --n2;
            }
            this.indicators_ = new char[n2];
            this.list_ = new String[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                Object object3 = stringTokenizer.nextToken();
                if (((String)object3).compareTo(" ") == 0 || ((String)object3).compareTo(",") == 0 || ((String)object3).compareTo(":") == 0 || ((String)object3).compareTo(";") == 0) continue;
                if (((String)object3).startsWith("\"")) {
                    int n4 = ((String)object3).indexOf("\"", 1);
                    while (stringTokenizer.hasMoreTokens() && n4 == -1) {
                        object3 = (String)object3 + stringTokenizer.nextToken();
                        n4 = ((String)object3).indexOf("\"", 1);
                    }
                } else {
                    object3 = ((String)object3).toUpperCase();
                }
                if (((String)object3).equalsIgnoreCase(this.libListType_)) {
                    if (n != -1) continue;
                    n = n3;
                    continue;
                }
                this.indicators_[n3] = bl2 ? (n == -1 ? 70 : 76) : (string4.equals("") && string != null && !string.equals("") ? (n3 == 0 ? 70 : 76) : (n3 == 0 ? 67 : 76));
                this.list_[n3] = object3;
                ++n3;
            }
            if (n3 != n2) {
                String[] stringArray = this.list_;
                this.list_ = new String[n3];
                System.arraycopy(stringArray, 0, this.list_, 0, n3);
            }
            if (this.defaultSchema_ == null && !bl && string2.equals("sql") && this.list_.length > 0) {
                this.defaultSchema_ = this.list_[0];
            }
            if (this.list_.length > 0 && this.list_[0].length() > 10 && this.list_[0].equals(this.defaultSchema_)) {
                String[] stringArray = this.list_;
                this.list_ = new String[stringArray.length - 1];
                if (this.list_.length > 0) {
                    System.arraycopy(stringArray, 1, this.list_, 0, this.list_.length);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Schema " + this.defaultSchema_ + " is too long to be in library list by Toolbox (Hostserver will add it), but will still be set as default SQL schema");
                }
            }
            if (n > 1) {
                int n5 = n / 2 - 1;
                for (int i = 0; i <= n5; ++i) {
                    int n6 = n - i - 1;
                    String string5 = this.list_[i];
                    this.list_[i] = this.list_[n6];
                    this.list_[n6] = string5;
                }
            }
        } else {
            this.list_ = new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOnServer(AS400JDBCConnection aS400JDBCConnection, int n) throws SQLException {
        if (this.list_.length > 0) {
            DBNativeDatabaseRequestDS dBNativeDatabaseRequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            try {
                dBNativeDatabaseRequestDS = DBDSPool.getDBNativeDatabaseRequestDS(6156, n, Integer.MIN_VALUE, 0);
                dBNativeDatabaseRequestDS.setListOfLibraries(this.indicators_, this.list_, aS400JDBCConnection.getConverter());
                dBReplyRequestedDS = aS400JDBCConnection.sendAndReceive(dBNativeDatabaseRequestDS);
                int n2 = dBReplyRequestedDS.getErrorClass();
                int n3 = dBReplyRequestedDS.getReturnCode();
                if (n2 != 0) {
                    if (n2 == 5 && n3 == 1301) {
                        aS400JDBCConnection.postWarning(JDError.getSQLWarning(aS400JDBCConnection, n, n2, n3));
                    } else {
                        JDError.throwSQLException(this, aS400JDBCConnection, n, n2, n3);
                    }
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("HY000", dBDataStreamException);
            }
            finally {
                if (dBNativeDatabaseRequestDS != null) {
                    dBNativeDatabaseRequestDS.returnToPool();
                    dBNativeDatabaseRequestDS = null;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                }
            }
        }
    }

    String getDefaultSchema() {
        return this.defaultSchema_;
    }

    public String toString() {
        return "";
    }
}

