/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.DBBaseReplyDS;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBSQLAttributesDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;

class JDTransactionManager {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int COMMIT_SERVER_MODE_CS_ = 1;
    private static final int COMMIT_SERVER_MODE_CHG_ = 2;
    static final int COMMIT_MODE_NOT_SET_ = -1;
    private static final int COMMIT_MODE_NONE_ = 0;
    private static final int COMMIT_MODE_CHG_ = 1;
    private static final int COMMIT_MODE_CS_ = 2;
    private static final int COMMIT_MODE_ALL_ = 3;
    private static final int COMMIT_MODE_RR_ = 4;
    private static final String[] COMMIT_MODE_ = new String[]{"NONE", "CHG", "CS", "ALL", "RR"};
    static final int CURSOR_HOLD_FALSE = 0;
    static final int CURSOR_HOLD_TRUE = 1;
    private boolean activeLocal_ = false;
    private boolean activeGlobal_ = false;
    private boolean autoCommit_;
    private AS400JDBCConnection connection_;
    private int holdIndicator_;
    private int currentCommitMode_;
    private int currentIsolationLevel_;
    private int id_;
    private int initialCommitMode_;
    private boolean localAutoCommit_ = true;
    private boolean localTransaction_ = true;
    private int serverCommitMode_;
    private int currentLocatorPersistence_ = -1;
    private int requestedLocatorPersistence_ = -1;
    private boolean serverAllowsLocatorPersistenceChange_ = true;

    JDTransactionManager(AS400JDBCConnection aS400JDBCConnection, int n, String string, boolean bl) throws SQLException {
        this.autoCommit_ = bl;
        this.connection_ = aS400JDBCConnection;
        this.holdIndicator_ = 1;
        this.id_ = n;
        this.currentIsolationLevel_ = JDTransactionManager.mapStringToLevel(string);
        this.initialCommitMode_ = this.currentCommitMode_ = JDTransactionManager.mapLevelToCommitMode(this.currentIsolationLevel_);
        this.serverCommitMode_ = this.connection_.getNewAutoCommitSupport() == 1 && bl ? 0 : this.currentCommitMode_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() throws SQLException {
        try {
            DBBaseRequestDS dBBaseRequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            try {
                dBBaseRequestDS = DBDSPool.getDBSQLRequestDS(6151, this.id_, -2113929216, 0);
                ((DBSQLRequestDS)dBBaseRequestDS).setHoldIndicator(this.getHoldIndicator());
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                int n = dBReplyRequestedDS.getErrorClass();
                if (n != 0) {
                    int n2 = dBReplyRequestedDS.getReturnCode();
                    JDError.throwSQLException(this, this.connection_, this.id_, n, n2);
                }
            }
            finally {
                if (dBBaseRequestDS != null) {
                    dBBaseRequestDS.returnToPool();
                    dBBaseRequestDS = null;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                }
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        this.resetServer();
        this.activeLocal_ = false;
    }

    boolean getAutoCommit() {
        return this.autoCommit_;
    }

    int getCommitMode() {
        if (this.serverCommitMode_ == 1) {
            return 2;
        }
        if (this.serverCommitMode_ == 2) {
            return 1;
        }
        return this.serverCommitMode_;
    }

    int getHoldIndicator() {
        return this.holdIndicator_;
    }

    int getIsolation() {
        return this.currentIsolationLevel_;
    }

    boolean isGlobalActive() {
        return this.activeGlobal_;
    }

    boolean isLocalActive() {
        return this.activeLocal_;
    }

    boolean isLocalTransaction() {
        return this.localTransaction_;
    }

    private static int mapLevelToCommitMode(int n) throws SQLException {
        int n2;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 4;
                break;
            }
            default: {
                JDError.throwSQLException("HY024");
                n2 = -1;
            }
        }
        return n2;
    }

    static int mapStringToLevel(String string) throws SQLException {
        int n;
        if (string.equalsIgnoreCase("none")) {
            n = 0;
        } else if (string.equalsIgnoreCase("read committed")) {
            n = 2;
        } else if (string.equalsIgnoreCase("read uncommitted")) {
            n = 1;
        } else if (string.equalsIgnoreCase("repeatable read")) {
            n = 4;
        } else if (string.equalsIgnoreCase("serializable")) {
            n = 8;
        } else {
            JDError.throwSQLException("HY024");
            n = -1;
        }
        return n;
    }

    void markGlobalTransactionBoundary() {
        this.activeGlobal_ = false;
    }

    void processCommitOnReturn(DBBaseReplyDS dBBaseReplyDS) throws DBDataStreamException {
        DBReplySQLCA dBReplySQLCA = dBBaseReplyDS.getSQLCA();
        if (dBReplySQLCA.getEyecatcherBit54()) {
            this.activeLocal_ = false;
        }
    }

    private void resetServer() throws SQLException {
        if (this.connection_.getNewAutoCommitSupport() == 0) {
            this.serverCommitMode_ = this.initialCommitMode_;
            this.setCommitMode(this.currentCommitMode_);
        }
    }

    void resetXAServer() throws SQLException {
        this.resetServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() throws SQLException {
        try {
            DBBaseRequestDS dBBaseRequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            try {
                dBBaseRequestDS = DBDSPool.getDBSQLRequestDS(6152, this.id_, Integer.MIN_VALUE, 0);
                ((DBSQLRequestDS)dBBaseRequestDS).setHoldIndicator(this.getHoldIndicator());
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                int n = dBReplyRequestedDS.getErrorClass();
                if (n != 0) {
                    int n2 = dBReplyRequestedDS.getReturnCode();
                    JDError.throwSQLException(this, this.connection_, this.id_, n, n2);
                }
            }
            finally {
                if (dBBaseRequestDS != null) {
                    dBBaseRequestDS.returnToPool();
                    dBBaseRequestDS = null;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                }
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        this.resetServer();
        this.activeLocal_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAutoCommit(boolean bl) throws SQLException {
        if (!this.localTransaction_) {
            if (bl) {
                JDError.throwSQLException("25000");
            } else {
                this.localAutoCommit_ = false;
            }
        } else {
            if (!this.autoCommit_ && bl && this.activeLocal_) {
                this.commit();
                this.connection_.postWarning(JDError.getSQLWarning("01H30"));
            }
            this.autoCommit_ = bl;
            if (this.connection_.getNewAutoCommitSupport() == 0) {
                this.setCommitMode(this.currentCommitMode_);
            } else {
                DBBaseRequestDS dBBaseRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                try {
                    dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setAutoCommit(bl ? 232 : 213);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setCommitmentControlLevelParserOption(this.getIsolationLevel());
                    this.serverCommitMode_ = this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1 ? 0 : this.currentCommitMode_;
                    boolean bl2 = this.setRequestLocatorPersistence((DBSQLAttributesDS)dBBaseRequestDS, this.getIsolationLevel());
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                    int n = dBReplyRequestedDS.getErrorClass();
                    int n2 = dBReplyRequestedDS.getReturnCode();
                    if (n != 0 && bl2) {
                        this.serverAllowsLocatorPersistenceChange_ = false;
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                        dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        ((DBSQLAttributesDS)dBBaseRequestDS).setAutoCommit(bl ? 232 : 213);
                        ((DBSQLAttributesDS)dBBaseRequestDS).setCommitmentControlLevelParserOption(this.getIsolationLevel());
                        this.serverCommitMode_ = this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1 ? 0 : this.currentCommitMode_;
                        dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                        n = dBReplyRequestedDS.getErrorClass();
                        n2 = dBReplyRequestedDS.getReturnCode();
                    }
                    if (n != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, n, n2);
                    }
                    this.persistenceUpdated();
                }
                catch (DBDataStreamException dBDataStreamException) {
                    JDError.throwSQLException("HY000", dBDataStreamException);
                }
                finally {
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                }
            }
        }
    }

    private boolean setRequestLocatorPersistence(DBSQLAttributesDS dBSQLAttributesDS, int n) throws DBDataStreamException {
        this.requestedLocatorPersistence_ = -1;
        if (this.serverAllowsLocatorPersistenceChange_) {
            if (n == 0) {
                if (this.currentLocatorPersistence_ != 0) {
                    dBSQLAttributesDS.setLocatorPersistence(0);
                    this.requestedLocatorPersistence_ = 0;
                    return true;
                }
            } else if (this.currentLocatorPersistence_ != 1) {
                dBSQLAttributesDS.setLocatorPersistence(1);
                this.requestedLocatorPersistence_ = 1;
                return true;
            }
        }
        return false;
    }

    private void persistenceUpdated() {
        if (this.serverAllowsLocatorPersistenceChange_ && this.requestedLocatorPersistence_ != -1) {
            this.currentLocatorPersistence_ = this.requestedLocatorPersistence_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCommitMode(int n) throws SQLException {
        if (this.autoCommit_) {
            n = 0;
        }
        if (n != this.serverCommitMode_) {
            JDSQLStatement jDSQLStatement = new JDSQLStatement("SET TRANSACTION ISOLATION LEVEL " + COMMIT_MODE_[n]);
            try {
                DBBaseRequestDS dBBaseRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                try {
                    dBBaseRequestDS = DBDSPool.getDBSQLRequestDS(6150, this.id_, -2113929216, 0);
                    boolean bl = false;
                    if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                        bl = true;
                    }
                    ((DBSQLRequestDS)dBBaseRequestDS).setStatementText(jDSQLStatement.toString(), this.connection_.getPackageCCSID_Converter(), bl);
                    ((DBSQLRequestDS)dBBaseRequestDS).setStatementType(jDSQLStatement.getNativeType());
                    ((DBSQLRequestDS)dBBaseRequestDS).setCursorName("MURCH", this.connection_.getConverter());
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                    int n2 = dBReplyRequestedDS.getErrorClass();
                    int n3 = dBReplyRequestedDS.getReturnCode();
                    if (n2 != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, n2, n3);
                    }
                }
                finally {
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("HY000", dBDataStreamException);
            }
            this.serverCommitMode_ = n;
        }
    }

    void setHoldIndicator(String string) throws SQLException {
        if (string.equalsIgnoreCase("TRUE")) {
            this.holdIndicator_ = 1;
        } else if (string.equalsIgnoreCase("FALSE")) {
            this.holdIndicator_ = 0;
        } else {
            JDError.throwSQLException("HY024");
            this.holdIndicator_ = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsolation(int n) throws SQLException {
        if (this.activeLocal_ && this.connection_.getNewAutoCommitSupport() == 0) {
            JDError.throwSQLException("25000");
        }
        this.currentCommitMode_ = JDTransactionManager.mapLevelToCommitMode(n);
        this.currentIsolationLevel_ = n;
        if (this.connection_.getNewAutoCommitSupport() == 0) {
            this.setCommitMode(this.currentCommitMode_);
        } else {
            DBBaseRequestDS dBBaseRequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            int n2 = this.currentCommitMode_;
            try {
                if (this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1) {
                    n2 = 0;
                }
                if (this.serverCommitMode_ != n2) {
                    dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setCommitmentControlLevelParserOption(this.getIsolationLevel());
                    boolean bl = this.setRequestLocatorPersistence((DBSQLAttributesDS)dBBaseRequestDS, this.getIsolationLevel());
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                    int n3 = dBReplyRequestedDS.getErrorClass();
                    int n4 = dBReplyRequestedDS.getReturnCode();
                    if (n3 != 0 && bl) {
                        this.serverAllowsLocatorPersistenceChange_ = false;
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                        dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        ((DBSQLAttributesDS)dBBaseRequestDS).setCommitmentControlLevelParserOption(this.getIsolationLevel());
                        dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                        n3 = dBReplyRequestedDS.getErrorClass();
                        n4 = dBReplyRequestedDS.getReturnCode();
                    }
                    if (n3 != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, n3, n4);
                    }
                    this.persistenceUpdated();
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("HY000", dBDataStreamException);
            }
            finally {
                if (dBBaseRequestDS != null) {
                    dBBaseRequestDS.returnToPool();
                    dBBaseRequestDS = null;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                }
            }
            this.serverCommitMode_ = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocalTransaction(boolean bl) throws SQLException {
        this.localTransaction_ = bl;
        if (this.localTransaction_) {
            this.autoCommit_ = this.localAutoCommit_;
            if (this.connection_.getNewAutoCommitSupport() == 0) {
                this.setCommitMode(this.currentCommitMode_);
            } else {
                DBBaseRequestDS dBBaseRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                try {
                    dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setAutoCommit(this.autoCommit_ ? 232 : 213);
                    boolean bl2 = false;
                    if (this.connection_.getNewAutoCommitSupport() == 1 && this.autoCommit_) {
                        ((DBSQLAttributesDS)dBBaseRequestDS).setCommitmentControlLevelParserOption(0);
                        bl2 = this.setRequestLocatorPersistence((DBSQLAttributesDS)dBBaseRequestDS, 0);
                        this.serverCommitMode_ = 0;
                    }
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                    int n = dBReplyRequestedDS.getErrorClass();
                    int n2 = dBReplyRequestedDS.getReturnCode();
                    if (n != 0 && bl2) {
                        this.serverAllowsLocatorPersistenceChange_ = false;
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                        dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        ((DBSQLAttributesDS)dBBaseRequestDS).setAutoCommit(this.autoCommit_ ? 232 : 213);
                        if (this.connection_.getNewAutoCommitSupport() == 1 && this.autoCommit_) {
                            ((DBSQLAttributesDS)dBBaseRequestDS).setCommitmentControlLevelParserOption(0);
                            this.serverCommitMode_ = 0;
                        }
                        dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                        n = dBReplyRequestedDS.getErrorClass();
                        n2 = dBReplyRequestedDS.getReturnCode();
                    }
                    if (n != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, n, n2);
                    }
                    this.persistenceUpdated();
                }
                catch (DBDataStreamException dBDataStreamException) {
                    JDError.throwSQLException("HY000", dBDataStreamException);
                }
                finally {
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                }
            }
        } else {
            this.localAutoCommit_ = this.autoCommit_;
            this.autoCommit_ = false;
            if (this.connection_.getNewAutoCommitSupport() == 0) {
                this.setCommitMode(this.currentCommitMode_);
            } else {
                DBBaseRequestDS dBBaseRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                try {
                    dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setAutoCommit(213);
                    if (this.serverCommitMode_ != this.currentCommitMode_) {
                        ((DBSQLAttributesDS)dBBaseRequestDS).setCommitmentControlLevelParserOption(this.getIsolationLevel());
                    }
                    boolean bl3 = this.setRequestLocatorPersistence((DBSQLAttributesDS)dBBaseRequestDS, this.getIsolationLevel());
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                    int n = dBReplyRequestedDS.getErrorClass();
                    int n3 = dBReplyRequestedDS.getReturnCode();
                    if (n != 0 && bl3) {
                        this.serverAllowsLocatorPersistenceChange_ = false;
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                        dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        ((DBSQLAttributesDS)dBBaseRequestDS).setAutoCommit(213);
                        if (this.serverCommitMode_ != this.currentCommitMode_) {
                            ((DBSQLAttributesDS)dBBaseRequestDS).setCommitmentControlLevelParserOption(this.getIsolationLevel());
                        }
                        dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                        n = dBReplyRequestedDS.getErrorClass();
                        n3 = dBReplyRequestedDS.getReturnCode();
                    }
                    if (n != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, n, n3);
                    }
                    this.persistenceUpdated();
                }
                catch (DBDataStreamException dBDataStreamException) {
                    JDError.throwSQLException("HY000", dBDataStreamException);
                }
                finally {
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                }
                this.serverCommitMode_ = this.currentCommitMode_;
            }
        }
    }

    void statementExecuted() {
        if (this.localTransaction_) {
            this.activeLocal_ = !this.autoCommit_;
        } else {
            this.activeGlobal_ = true;
        }
    }

    private int getIsolationLevel() {
        int n = this.currentCommitMode_;
        if (n == 1) {
            n = 2;
        } else if (n == 2) {
            n = 1;
        }
        if (this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1) {
            n = 0;
        }
        return n;
    }
}

