/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReturnObjectInformationRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDFieldMap;
import com.ibm.as400.access.JDHardcodedFieldMap;
import com.ibm.as400.access.JDMappedRow;
import com.ibm.as400.access.JDMappedRowCache;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDServerRowCache;
import com.ibm.as400.access.JDSimpleFieldMap;
import com.ibm.as400.access.JDSimpleRowCache;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLVarchar;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

class JDUtilities {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final byte escape = 27;
    static final int vrm740 = AS400.generateVRM(7, 4, 0);
    static final int vrm710 = AS400.generateVRM(7, 1, 0);
    static final int vrm610 = AS400.generateVRM(6, 1, 0);
    static final int vrm540 = AS400.generateVRM(5, 4, 0);
    static final int vrm530 = AS400.generateVRM(5, 3, 0);
    static final int vrm520 = AS400.generateVRM(5, 2, 0);
    static final int vrm510 = AS400.generateVRM(5, 1, 0);
    static final int vrm450 = AS400.generateVRM(4, 5, 0);
    static final int vrm440 = AS400.generateVRM(4, 4, 0);
    static final int vrm430 = AS400.generateVRM(4, 3, 0);
    static int JDBCLevel_ = 30;
    static int JVMLevel_ = 120;
    private static final Object bigDecimalLock_ = new Object();
    static Method toPlainStringMethod;
    static Object[] emptyArgs;
    static String[][] typeNameToTypeCode;
    static Hashtable typeNameHashtable;
    public static Hashtable instanceHashtable;

    JDUtilities() {
    }

    static final void decompress(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n;
        int n5 = n3;
        int n6 = n + n2;
        while (n4 < n6) {
            if (byArray[n4] == 27) {
                if (byArray[n4 + 1] == 27) {
                    byArray2[n5++] = 27;
                    n4 += 2;
                    continue;
                }
                int n7 = BinaryConverter.byteArrayToInt(byArray, n4 + 2);
                for (int i = 1; i <= n7; ++i) {
                    byArray2[n5++] = byArray[n4 + 1];
                }
                n4 += 6;
                continue;
            }
            byArray2[n5++] = byArray[n4++];
        }
    }

    static final String padZeros(int n, int n2) {
        String string = "000000000" + Integer.toString(n);
        return string.substring(string.length() - n2);
    }

    static final String padZeros(long l, int n) {
        String string = "000000000000" + Long.toString(l);
        return string.substring(string.length() - n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ResultSet getLibraries(Object object, AS400JDBCConnection aS400JDBCConnection, SQLConversionSettings sQLConversionSettings, boolean bl) throws SQLException {
        aS400JDBCConnection.checkOpen();
        JDMappedRowCache jDMappedRowCache = null;
        if (sQLConversionSettings == null) {
            sQLConversionSettings = SQLConversionSettings.getConversionSettings(aS400JDBCConnection);
        }
        int n = aS400JDBCConnection.getID();
        DBReplyRequestedDS dBReplyRequestedDS = null;
        try {
            DBReturnObjectInformationRequestDS dBReturnObjectInformationRequestDS = null;
            try {
                dBReturnObjectInformationRequestDS = DBDSPool.getDBReturnObjectInformationRequestDS(6144, n, -1946157056, 0);
                if (!bl) {
                    dBReturnObjectInformationRequestDS.setLibraryName("%", aS400JDBCConnection.getConverter());
                    dBReturnObjectInformationRequestDS.setLibraryNameSearchPatternIndicator(241);
                } else {
                    dBReturnObjectInformationRequestDS.setLibraryName("*LIBL", aS400JDBCConnection.getConverter());
                    dBReturnObjectInformationRequestDS.setLibraryNameSearchPatternIndicator(240);
                }
                dBReturnObjectInformationRequestDS.setLibraryReturnInfoBitmap(Integer.MIN_VALUE);
                dBReplyRequestedDS = aS400JDBCConnection.sendAndReceive(dBReturnObjectInformationRequestDS);
                int n2 = dBReplyRequestedDS.getErrorClass();
                if (n2 != 0) {
                    int n3 = dBReplyRequestedDS.getReturnCode();
                    JDError.throwSQLException(object, aS400JDBCConnection, n, n2, n3);
                }
                DBDataFormat dBDataFormat = dBReplyRequestedDS.getDataFormat();
                DBData dBData = dBReplyRequestedDS.getResultData();
                JDServerRow jDServerRow = new JDServerRow(aS400JDBCConnection, n, dBDataFormat, sQLConversionSettings);
                JDSimpleRowCache jDSimpleRowCache = new JDSimpleRowCache(new JDServerRowCache(jDServerRow, aS400JDBCConnection, n, 1, dBData, true, 1004));
                boolean bl2 = true;
                JDFieldMap[] jDFieldMapArray = null;
                String[] stringArray = null;
                SQLData[] sQLDataArray = null;
                int[] nArray = null;
                if (!bl2) {
                    stringArray = new String[]{"TABLE_SCHEM"};
                    sQLDataArray = new SQLData[]{new SQLVarchar(128, sQLConversionSettings)};
                    nArray = new int[]{0};
                    jDFieldMapArray = new JDFieldMap[1];
                } else {
                    stringArray = new String[]{"TABLE_SCHEM", "TABLE_CATALOG"};
                    sQLDataArray = new SQLData[]{new SQLVarchar(128, sQLConversionSettings), new SQLVarchar(128, sQLConversionSettings)};
                    nArray = new int[]{0, 1};
                    jDFieldMapArray = new JDFieldMap[2];
                }
                jDFieldMapArray[0] = new JDSimpleFieldMap(1);
                if (bl2) {
                    jDFieldMapArray[1] = new JDHardcodedFieldMap(aS400JDBCConnection.getCatalog());
                }
                JDMappedRow jDMappedRow = new JDMappedRow(stringArray, sQLDataArray, nArray, jDFieldMapArray);
                jDMappedRowCache = new JDMappedRowCache(jDMappedRow, jDSimpleRowCache);
            }
            finally {
                if (dBReturnObjectInformationRequestDS != null) {
                    dBReturnObjectInformationRequestDS.returnToPool();
                    dBReturnObjectInformationRequestDS = null;
                }
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException(object, "HY000", dBDataStreamException);
        }
        return new AS400JDBCResultSet(jDMappedRowCache, aS400JDBCConnection.getCatalog(), "Schemas", aS400JDBCConnection, dBReplyRequestedDS);
    }

    static final String stripOuterDoubleQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    static final String prepareForDoubleQuotes(String string) {
        if ((string = JDUtilities.stripOuterDoubleQuotes(string)).indexOf(34) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) != '\"') continue;
            stringBuffer.insert(i, '\"');
        }
        return stringBuffer.toString();
    }

    static final String prepareForSingleQuotes(String string, boolean bl) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        } else if (bl && string.indexOf(39) == -1) {
            string = string.toUpperCase();
        }
        if (string.indexOf(34) == -1 && string.indexOf(39) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = stringBuffer.charAt(i);
            if (c == '\"') {
                if (i <= 0 || stringBuffer.charAt(i - 1) != '\"') continue;
                stringBuffer.deleteCharAt(i);
                --i;
                continue;
            }
            if (c != '\'') continue;
            stringBuffer.insert(i, '\'');
        }
        return stringBuffer.toString();
    }

    static final String stripOutDoubleEmbededQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.indexOf(34) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = stringBuffer.charAt(i);
            if (c != '\"' || i <= 0 || stringBuffer.charAt(i - 1) != '\"') continue;
            stringBuffer.deleteCharAt(i);
            --i;
        }
        return stringBuffer.toString();
    }

    static final String readerToString(Reader reader, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2;
            char[] cArray = new char[n == 0 ? 1 : n];
            int n3 = 0;
            while (reader.ready() && (n2 = reader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n2);
                n3 += n2;
            }
            if (n3 != n) {
                JDError.throwSQLException("HY090");
            }
        }
        catch (IOException iOException) {
            JDError.throwSQLException("HY105");
        }
        return stringBuffer.toString();
    }

    static final String readerToString(Reader reader) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            char[] cArray = new char[32000];
            int n2 = 0;
            while (reader.ready() && (n = reader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n);
                n2 += n;
            }
        }
        catch (IOException iOException) {
            JDError.throwSQLException("HY105");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runCommand(Connection connection, String string, boolean bl) throws SQLException {
        try (Statement statement = null;){
            statement = connection.createStatement();
            String string2 = "0000000000" + string.length();
            string2 = string2.substring(string2.length() - 10) + ".00000";
            String string3 = bl ? "CALL QSYS.QCMDEXC('" : "CALL QSYS/QCMDEXC('";
            String string4 = string3 + string + "', " + string2 + ")";
            statement.executeUpdate(string4);
        }
    }

    static final byte[] streamToBytes(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = new byte[n];
        try {
            byte[] byArray2 = new byte[n == 0 ? 1 : n];
            int n2 = 0;
            int n3 = inputStream.read(byArray2);
            while (n3 >= 0 && n2 < n) {
                if (n3 > 0) {
                    if (n2 + n3 <= n) {
                        System.arraycopy(byArray2, 0, byArray, n2, n3);
                    } else {
                        System.arraycopy(byArray2, 0, byArray, n2, n - n2);
                    }
                    n2 += n3;
                }
                n3 = inputStream.read(byArray2);
            }
            if (n2 < n) {
                JDError.throwSQLException("07006");
            }
        }
        catch (IOException iOException) {
            JDError.throwSQLException("HY105");
        }
        return byArray;
    }

    static final byte[] streamToBytes(InputStream inputStream) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 4096;
        byte[] byArray = new byte[n];
        try {
            int n2 = inputStream.read(byArray);
            while (n2 >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            JDError.throwSQLException("HY105");
        }
        return byteArrayOutputStream.toByteArray();
    }

    static String streamToString(InputStream inputStream, String string) throws SQLException {
        byte[] byArray = JDUtilities.streamToBytes(inputStream);
        try {
            return new String(byArray, 0, byArray.length, string);
        }
        catch (IOException iOException) {
            JDError.throwSQLException("HY105");
            return null;
        }
    }

    static final String streamToString(InputStream inputStream, int n, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            byte[] byArray = new byte[n == 0 ? 1 : n];
            int n2 = 0;
            while (inputStream.available() > 0) {
                int n3 = inputStream.read(byArray);
                stringBuffer.append(new String(byArray, 0, n3, string));
                n2 += n3;
            }
            if (n2 != n) {
                JDError.throwSQLException("HY090");
            }
        }
        catch (IOException iOException) {
            JDError.throwSQLException("HY105");
        }
        return stringBuffer.toString();
    }

    static final String upperCaseIfNotQuoted(String string) {
        if (string.startsWith("\"")) {
            return string;
        }
        return string.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bigDecimalToPlainString(BigDecimal bigDecimal) {
        if (JVMLevel_ >= 150) {
            Object object;
            if (toPlainStringMethod == null) {
                object = bigDecimalLock_;
                synchronized (object) {
                    if (toPlainStringMethod == null) {
                        try {
                            Class<?> clazz = Class.forName("java.math.BigDecimal");
                            Class[] classArray = new Class[]{};
                            toPlainStringMethod = clazz.getMethod("toPlainString", classArray);
                            emptyArgs = new Object[0];
                        }
                        catch (Exception exception) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logException(null, "Exception while calling BigDecimal.toPlainString.", exception);
                            }
                            toPlainStringMethod = null;
                            return bigDecimal.toString();
                        }
                    }
                }
            }
            try {
                object = (String)toPlainStringMethod.invoke((Object)bigDecimal, emptyArgs);
            }
            catch (Exception exception) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logException(null, "Exception while calling BigDecimal.toPlainString.", exception);
                }
                object = bigDecimal.toString();
            }
            return object;
        }
        return bigDecimal.toString();
    }

    static final String stripXMLDeclaration(String string) throws SQLException {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && (string.charAt(n) == '\ufeff' || Character.isWhitespace(string.charAt(n))); ++n) {
        }
        if (n + 1 < n2 && string.charAt(n) == '<' && string.charAt(n + 1) == '?') {
            n += 2;
            while (n + 1 < n2 && (string.charAt(n) != '?' || string.charAt(n + 1) != '>')) {
                ++n;
            }
            if (n + 1 < n2 && string.charAt(n) == '?' && string.charAt(n + 1) == '>') {
                return string.substring(n + 2);
            }
        }
        return string;
    }

    static final boolean hasXMLDeclaration(String string) {
        if (string.length() < 6) {
            return false;
        }
        return string.substring(0, 7).indexOf("<?xml") != -1;
    }

    static final String handleXMLDeclarationEncoding(String string) {
        if (string.length() < 6) {
            return string;
        }
        if (string.substring(0, 7).indexOf("<?xml") != -1) {
            int n = string.indexOf("?>");
            int n2 = string.indexOf("encoding=");
            if (n != -1 && n2 != -1) {
                int n3 = string.indexOf(" ", n2);
                if (n3 == -1 || n3 > n) {
                    n3 = n;
                }
                return string.substring(0, n2) + string.substring(n3);
            }
        }
        return string;
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case -360: {
                return "DECFLOAT";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case 70: {
                return "DATALINK";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case 92: {
                return "TIME";
            }
            case 91: {
                return "DATE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -8: {
                return "ROWID";
            }
            case -15: {
                return "NCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case -16: {
                return "NVARCHAR";
            }
            case 2009: {
                return "SQLXML";
            }
            case 16: {
                return "BOOLEAN";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTypeCode(String string) throws SQLException {
        Object object = typeNameToTypeCode;
        synchronized (typeNameToTypeCode) {
            int n;
            if (typeNameHashtable == null) {
                typeNameHashtable = new Hashtable();
                for (n = 0; n < typeNameToTypeCode.length; ++n) {
                    typeNameHashtable.put(typeNameToTypeCode[n][0], new Integer(typeNameToTypeCode[n][1]));
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = (Integer)typeNameHashtable.get(string);
            if (object == null) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Unable to get type from " + string);
                }
                JDError.throwSQLException("07006");
                return 0;
            }
            n = (Integer)object;
            if (n != 0) {
                return n;
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(null, "Unable to get type from " + string);
            }
            JDError.throwSQLException("HY004");
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean classIsInstanceOf(Class clazz, String string) {
        Object object = typeNameToTypeCode;
        synchronized (typeNameToTypeCode) {
            Boolean bl;
            if (instanceHashtable == null) {
                instanceHashtable = new Hashtable();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            object = (Hashtable)instanceHashtable.get(clazz);
            if (object == null) {
                object = new Hashtable();
                instanceHashtable.put(clazz, object);
            }
            if ((bl = (Boolean)((Hashtable)object).get(string)) == null) {
                boolean bl2 = false;
                Class clazz2 = clazz;
                while (clazz2 != null && !bl2) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(null, "JDUtilities.classIsInstance checking " + clazz2.getName() + " of " + clazz.getName() + " for " + string);
                    }
                    if (string.equals(clazz2.getName())) {
                        bl2 = true;
                        continue;
                    }
                    Class<?>[] classArray = clazz2.getInterfaces();
                    for (int i = 0; !bl2 && i < classArray.length; ++i) {
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(null, "DB2Utilities.classIsInstance checking " + classArray[i].getName() + " of " + clazz.getName() + " for " + string);
                        }
                        if (!classArray[i].getName().equals(string)) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    clazz2 = clazz2.getSuperclass();
                }
                bl = new Boolean(bl2);
                ((Hashtable)object).put(string, bl);
            }
            return bl;
        }
    }

    public static String trimTrailingSpace(String string) {
        int n = string.length() - 1;
        if (n >= 0 && string.charAt(n) == ' ') {
            while (n >= 0 && string.charAt(n) == ' ') {
                --n;
            }
            if (n >= 0) {
                return string.substring(0, n + 1);
            }
            return "";
        }
        return string;
    }

    static {
        try {
            Class.forName("java.util.concurrent.Semaphore");
            JVMLevel_ = 150;
            Class.forName("java.sql.SQLXML");
            JDBCLevel_ = 40;
            JVMLevel_ = 160;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        toPlainStringMethod = null;
        typeNameToTypeCode = new String[][]{{"ARRAY", "2003"}, {"BIGINT", "-5"}, {"BINARY", "-2"}, {"BIT", "-7"}, {"BLOB", "2004"}, {"BOOLEAN", "16"}, {"CHAR", "1"}, {"CLOB", "2005"}, {"DATALINK", "70"}, {"DATE", "91"}, {"DBCLOB", "2005"}, {"DECIMAL", "3"}, {"DISTINCT", "2001"}, {"DOUBLE", "8"}, {"FLOAT", "6"}, {"INTEGER", "4"}, {"JAVA_OBJECT", "2000"}, {"LONGNVARCHAR", "-16"}, {"LONGVARBINARY", "-4"}, {"LONGVARCHAR", "-1"}, {"NULL", "0"}, {"NUMERIC", "2"}, {"DECFLOAT", "-360"}, {"OTHER", "1111"}, {"REAL", "7"}, {"REF", "2006"}, {"ROWID", "-8"}, {"SMALLINT", "5"}, {"STRUCT", "2002"}, {"TIME", "92"}, {"TIMESTAMP", "93"}, {"TINYINT", "-6"}, {"VARBINARY", "-3"}, {"VARCHAR", "12"}, {"NCHAR", "-15"}, {"GRAPHIC", "-15"}, {"NCLOB", "2011"}, {"NVARCHAR", "-9"}, {"SQLXML", "2009"}, {"VARGRAPHIC", "-9"}};
        typeNameHashtable = null;
    }
}

