/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class JobDescription
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final int VRM520 = AS400.generateVRM(5, 2, 0);
    private static final int VRM530 = AS400.generateVRM(5, 3, 0);
    private static final int VRM540 = AS400.generateVRM(5, 4, 0);
    private int vrm_;
    private AS400 system_;
    private String name_;
    private String library_;
    private transient boolean loaded_;
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private String jobDescriptionName_;
    private String jobDescriptionLibraryName_;
    private String userName_;
    private String[] initialLibraryList_;
    private String jobDate_;
    private String jobSwitches_;
    private String jobQueueName_;
    private String jobQueueLibraryName_;
    private String jobQueuePriority_;
    private String holdOnJobQueue_;
    private String outputQueueName_;
    private String outputQueueLibraryName_;
    private String outputQueuePriority_;
    private String printerDeviceName_;
    private String printText_;
    private int syntaxCheckSeverity_;
    private int endSeverity_;
    private int messageLoggingSeverity_;
    private String messageLoggingLevel_;
    private String messageLoggingText_;
    private String loggingOfCLPrograms_;
    private String inquiryMessageReply_;
    private String deviceRecoveryAction_;
    private String timeSliceEndPool_;
    private String accountingCode_;
    private String routingData_;
    private String textDescription_;
    private int jobMessageQueueMaximumSize_;
    private String jobMessageQueueFullAction_;
    private String CYMDJobDate_;
    private String allowMultipleThreads_;
    private String spooledFileAction_;
    private String[] iaspNames_;
    private String ddmConversation_;
    private String jobLogOutput_;
    private transient ObjectDescription objectDescription_;

    public JobDescription(AS400 aS400, String string, String string2) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("library");
        }
        if (string2 == null) {
            throw new NullPointerException("name");
        }
        this.system_ = aS400;
        this.name_ = string2;
        this.library_ = string;
    }

    public JobDescription(AS400 aS400, QSYSObjectPathName qSYSObjectPathName) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (qSYSObjectPathName == null) {
            throw new NullPointerException("path");
        }
        this.system_ = aS400;
        this.name_ = qSYSObjectPathName.getObjectName();
        this.library_ = qSYSObjectPathName.getLibraryName();
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException {
        int n;
        int n2;
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.library_ == null) {
            throw new ExtendedIllegalStateException("library", 4);
        }
        int n3 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n3, null);
        AS400Text aS400Text = new AS400Text(20, n3);
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(this.name_);
        for (int i = 0; i < 10 - this.name_.length(); ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.library_);
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        int n4 = 2048;
        programParameterArray[0] = new ProgramParameter(n4);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n4));
        programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("JOBD0100"));
        programParameterArray[3] = new ProgramParameter(aS400Text.toBytes(stringBuffer.toString().trim().toUpperCase()));
        programParameterArray[4] = errorCode_;
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QWDRJOBD.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray = programParameterArray[0].getOutputData();
        int n5 = BinaryConverter.byteArrayToInt(byArray, 0);
        if (n5 < (n2 = BinaryConverter.byteArrayToInt(byArray, 4))) {
            if (Trace.traceOn_) {
                Trace.log(1, "JobDescription: Not enough bytes, trying again. Bytes returned = " + n5 + "; bytes available = " + n2);
            }
            n4 = n2;
            try {
                programParameterArray[0].setOutputDataLength(n4);
                programParameterArray[1].setInputData(BinaryConverter.intToByteArray(n4));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byArray = programParameterArray[0].getOutputData();
        }
        this.jobDescriptionName_ = convTable.byteArrayToString(byArray, 8, 10).trim();
        this.jobDescriptionLibraryName_ = convTable.byteArrayToString(byArray, 18, 10).trim();
        this.userName_ = convTable.byteArrayToString(byArray, 28, 10).trim();
        this.jobDate_ = convTable.byteArrayToString(byArray, 38, 8).trim();
        this.jobSwitches_ = convTable.byteArrayToString(byArray, 46, 8).trim();
        this.jobQueueName_ = convTable.byteArrayToString(byArray, 54, 10).trim();
        this.jobQueueLibraryName_ = convTable.byteArrayToString(byArray, 64, 10).trim();
        this.jobQueuePriority_ = convTable.byteArrayToString(byArray, 74, 2).trim();
        this.holdOnJobQueue_ = convTable.byteArrayToString(byArray, 76, 10).trim();
        this.outputQueueName_ = convTable.byteArrayToString(byArray, 86, 10).trim();
        this.outputQueueLibraryName_ = convTable.byteArrayToString(byArray, 96, 10).trim();
        this.outputQueuePriority_ = convTable.byteArrayToString(byArray, 106, 2).trim();
        this.printerDeviceName_ = convTable.byteArrayToString(byArray, 108, 10).trim();
        this.printText_ = convTable.byteArrayToString(byArray, 118, 30).trim();
        this.syntaxCheckSeverity_ = BinaryConverter.byteArrayToInt(byArray, 148);
        this.endSeverity_ = BinaryConverter.byteArrayToInt(byArray, 152);
        this.messageLoggingSeverity_ = BinaryConverter.byteArrayToInt(byArray, 156);
        this.messageLoggingLevel_ = convTable.byteArrayToString(byArray, 160, 1).trim();
        this.messageLoggingText_ = convTable.byteArrayToString(byArray, 161, 10).trim();
        this.loggingOfCLPrograms_ = convTable.byteArrayToString(byArray, 171, 10).trim();
        this.inquiryMessageReply_ = convTable.byteArrayToString(byArray, 181, 10).trim();
        this.deviceRecoveryAction_ = convTable.byteArrayToString(byArray, 191, 13).trim();
        this.timeSliceEndPool_ = convTable.byteArrayToString(byArray, 204, 10).trim();
        this.accountingCode_ = convTable.byteArrayToString(byArray, 214, 15).trim();
        this.routingData_ = convTable.byteArrayToString(byArray, 229, 80).trim();
        this.textDescription_ = convTable.byteArrayToString(byArray, 309, 50).trim();
        this.jobMessageQueueMaximumSize_ = BinaryConverter.byteArrayToInt(byArray, 376);
        this.jobMessageQueueFullAction_ = convTable.byteArrayToString(byArray, 380, 10).trim();
        this.CYMDJobDate_ = convTable.byteArrayToString(byArray, 390, 10).trim();
        this.allowMultipleThreads_ = convTable.byteArrayToString(byArray, 400, 10).trim();
        int n6 = BinaryConverter.byteArrayToInt(byArray, 364);
        this.initialLibraryList_ = new String[n6];
        int n7 = BinaryConverter.byteArrayToInt(byArray, 360);
        for (n = 0; n < n6; ++n) {
            this.initialLibraryList_[n] = convTable.byteArrayToString(byArray, n7 + n * 11, 10).trim();
        }
        if (this.vrm_ == 0) {
            this.vrm_ = this.system_.getVRM();
        }
        if (this.vrm_ >= VRM520) {
            this.spooledFileAction_ = convTable.byteArrayToString(byArray, 410, 10).trim();
            n = BinaryConverter.byteArrayToInt(byArray, 420);
            int n8 = BinaryConverter.byteArrayToInt(byArray, 424);
            int n9 = BinaryConverter.byteArrayToInt(byArray, 428);
            this.iaspNames_ = new String[n8];
            for (int i = 0; i < n8; ++i) {
                int n10 = n + i * n9;
                this.iaspNames_[i] = convTable.byteArrayToString(byArray, n10, 10).trim();
            }
        }
        if (this.vrm_ >= VRM530) {
            this.ddmConversation_ = convTable.byteArrayToString(byArray, 432, 10).trim();
        }
        if (this.vrm_ >= VRM540) {
            this.jobLogOutput_ = convTable.byteArrayToString(byArray, 442, 10).trim();
        }
        this.loaded_ = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.loaded_ = false;
    }

    private void loadInformation() throws RuntimeException {
        try {
            this.refresh();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            Trace.log(2, "Exception rethrown by loadInformation():", (Throwable)exception);
            IllegalStateException illegalStateException = new IllegalStateException(exception.getMessage());
            try {
                illegalStateException.initCause(exception);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw illegalStateException;
        }
    }

    public String getAccountingCode() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.accountingCode_;
    }

    public boolean isAllowMultipleThreads() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.allowMultipleThreads_.equals("*YES");
    }

    public String getCYMDJobDate() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.CYMDJobDate_;
    }

    public String getDeviceRecoveryAction() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.deviceRecoveryAction_;
    }

    public String getDDMConversation() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.ddmConversation_;
    }

    public int getEndSeverity() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.endSeverity_;
    }

    public boolean isHoldOnJobQueue() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.holdOnJobQueue_.equals("*YES");
    }

    public String[] getInitialLibraryList() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.initialLibraryList_;
    }

    public String getInquiryMessageReply() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.inquiryMessageReply_;
    }

    public String[] getInitialASPGroupNames() {
        return this.iaspNames_;
    }

    public String getJobDateString() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobDate_;
    }

    public String getLibraryName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobDescriptionLibraryName_;
    }

    public String getName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobDescriptionName_;
    }

    public String getJobLogOutput() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobLogOutput_;
    }

    public String getJobMessageQueueFullAction() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobMessageQueueFullAction_;
    }

    public int getJobMessageQueueMaximumSize() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobMessageQueueMaximumSize_;
    }

    public String getJobQueueLibraryName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobQueueLibraryName_;
    }

    public String getJobQueueName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobQueueName_;
    }

    public int getJobQueuePriority() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        try {
            return Integer.parseInt(this.jobQueuePriority_);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.log(2, "Exception swallowed by getJobQueuePriority():", (Throwable)numberFormatException);
            return 9;
        }
    }

    public byte getJobSwitches() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        byte by = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.jobSwitches_.charAt(i) != '1') continue;
            by = (byte)(by | 1 << 7 - i);
        }
        return by;
    }

    public boolean isLoggingOfCLPrograms() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.loggingOfCLPrograms_.equals("*YES");
    }

    public int getMessageLoggingLevel() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        try {
            return Integer.parseInt(this.messageLoggingLevel_);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.log(2, "Exception swallowed by getMessageLoggingLevel():", (Throwable)numberFormatException);
            return 0;
        }
    }

    public int getMessageLoggingSeverity() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.messageLoggingSeverity_;
    }

    public String getMessageLoggingText() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.messageLoggingText_;
    }

    public String getOutputQueueLibraryName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.outputQueueLibraryName_;
    }

    public String getOutputQueueName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.outputQueueName_;
    }

    public int getOutputQueuePriority() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        try {
            return Integer.parseInt(this.outputQueuePriority_);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.log(2, "Exception swallowed by getOutputQueuePriority():", (Throwable)numberFormatException);
            return 9;
        }
    }

    public String getPrinterDeviceName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.printerDeviceName_;
    }

    public String getPrintText() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.printText_;
    }

    public String getRoutingData() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.routingData_;
    }

    public String getSpooledFileAction() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.spooledFileAction_;
    }

    public int getSyntaxCheckSeverity() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.syntaxCheckSeverity_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String getTextDescription() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.textDescription_;
    }

    public String getTimeSliceEndPool() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.timeSliceEndPool_;
    }

    public String getUserName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.userName_;
    }

    public void setLibraryName(String string) {
        if (string == null) {
            throw new NullPointerException("library");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("library", 5);
        }
        this.library_ = string;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("name", 5);
        }
        this.name_ = string;
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.system_ = aS400;
        this.vrm_ = 0;
    }

    public boolean exists() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_.exists();
    }

    public ObjectDescription getObjectDescription() {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_;
    }

    private ObjectDescription getObjDesc() {
        return new ObjectDescription(this.system_, this.library_, this.name_, "JOBD");
    }
}

