/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.NPAttribute;
import java.io.Serializable;

class NPAttrFloat
extends NPAttribute
implements Cloneable,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final int DIGITS = 15;
    private static final int DECIMALPT = 5;
    private float attrValue_;

    NPAttrFloat(NPAttrFloat nPAttrFloat) {
        super(nPAttrFloat);
        this.attrValue_ = nPAttrFloat.attrValue_;
    }

    NPAttrFloat(int n) {
        super(n, 7);
    }

    NPAttrFloat(int n, float f) {
        super(n, 7);
        this.set(f);
    }

    NPAttrFloat(int n, byte[] byArray, int n2, int n3) {
        super(n, 7, byArray, n2, n3, null);
        this.buildFloatFromHostData();
    }

    private void buildHostData() {
        double d = Math.abs(this.attrValue_);
        d += 1.0E-6;
        int n = 8;
        int n2 = n - 1;
        byte[] byArray = new byte[n];
        double d2 = Math.pow(10.0, 5.0);
        byArray[n2] = this.attrValue_ < 0.0f ? 13 : 15;
        boolean bl = true;
        for (int i = -5; i < 10; ++i) {
            int n3 = (int)(d * d2) % 10;
            d2 /= 10.0;
            if (!bl) {
                byArray[n2] = (byte)n3;
            } else {
                int n4 = n2--;
                byArray[n4] = (byte)(byArray[n4] | (byte)n3 << 4);
            }
            bl = !bl;
        }
        super.setHostData(byArray, null);
    }

    private void buildFloatFromHostData() {
        int n = 8;
        this.attrValue_ = 0.0f;
        byte[] byArray = super.getHostData(null);
        if (byArray != null) {
            int n2;
            int n3 = 0;
            double d = Math.pow(10.0, 9.0);
            boolean bl = true;
            for (int i = 0; i < 15; ++i) {
                if (bl) {
                    n2 = byArray[n3] >> 4;
                    n2 &= 0xF;
                } else {
                    n2 = byArray[n3] & 0xF;
                    ++n3;
                }
                bl = !bl;
                this.attrValue_ += (float)n2 * (float)d;
                d /= 10.0;
            }
            n2 = byArray[n3] & 0xF;
            if (n2 == 13) {
                this.attrValue_ = (float)((double)this.attrValue_ * -1.0);
            }
        }
    }

    @Override
    protected Object clone() {
        NPAttrFloat nPAttrFloat = new NPAttrFloat(this);
        return nPAttrFloat;
    }

    float get() {
        return this.attrValue_;
    }

    void set(float f) {
        this.attrValue_ = f;
        this.buildHostData();
    }

    @Override
    void setHostData(byte[] byArray, ConverterImpl converterImpl) {
        super.setHostData(byArray, converterImpl);
        this.buildFloatFromHostData();
    }
}

