/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NetServer;
import com.ibm.as400.access.NetServerConnection;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ArrayResourceList;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ValueMap;
import java.beans.PropertyVetoException;
import java.util.Vector;

public class NetServerSession
extends Resource {
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.access.MRI2");
    private static final String ICON_BASE_NAME_ = "NetServerSession";
    private static final String PRESENTATION_KEY_ = "NETSERVER";
    private static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "NETSERVER");
    private static ProgramMap getterMap_ = new ProgramMap();
    private static ProgramMap openListAttributeMap_ = new ProgramMap();
    private static final String ENSS_ = "qzlsenss";
    private static final String OLST0300_ = "qzlsolst_zlsl0300";
    private static final int[] INDICES_ = new int[]{0};
    public static final String CONNECTION_COUNT = "CONNECTION_COUNT";
    public static final String SESSION_TIME = "SESSION_TIME";
    public static final String FILES_OPEN_COUNT = "FILES_OPEN_COUNT";
    public static final String IDLE_TIME = "IDLE_TIME";
    public static final String IS_ENCRYPT_PASSWORD = "IS_ENCRYPT_PASSWORD";
    public static final String IS_GUEST = "IS_GUEST";
    static final String SESSION_COUNT = "SESSION_COUNT";
    public static final String USER = "USER";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.access.NetServer";
    private static ProgramCallDocument staticDocument_;
    private ProgramCallDocument document_;
    private String name_;
    private ProgramAttributeGetter attributeGetter_;

    NetServerSession() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    NetServerSession(AS400 aS400, String string) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setName(string);
    }

    static Object computeResourceKey(AS400 aS400, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NetServerSession.class);
        stringBuffer.append(':');
        stringBuffer.append(aS400.getSystemName());
        stringBuffer.append(':');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void end() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        NetServerSession.endSession(this.getSystem(), this.name_);
    }

    static void endSession(AS400 aS400, String string) throws ResourceException {
        try {
            ProgramCallDocument programCallDocument = (ProgramCallDocument)staticDocument_.clone();
            programCallDocument.setSystem(aS400);
            programCallDocument.setValue("qzlsenss.workstationName", string);
            if (!programCallDocument.callProgram(ENSS_)) {
                throw new ResourceException(programCallDocument.getMessageList(ENSS_));
            }
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when ending a session.", (Throwable)pcmlException);
            throw new ResourceException(pcmlException);
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        super.establishConnection();
        AS400 aS400 = this.getSystem();
        this.document_ = (ProgramCallDocument)staticDocument_.clone();
        try {
            this.document_.setSystem(aS400);
            this.document_.setValue("qzlsolst_zlsl0300.informationQualifier", this.name_);
            this.attributeGetter_ = new ProgramAttributeGetter(aS400, this.document_, getterMap_);
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when establishing connection.", (Throwable)pcmlException);
            throw new ResourceException(pcmlException);
        }
    }

    @Override
    protected void freezeProperties() throws ResourceException {
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(this.name_);
        presentation.setFullName(this.name_);
        if (this.getResourceKey() == null) {
            this.setResourceKey(NetServerSession.computeResourceKey(this.getSystem(), this.name_));
        }
        super.freezeProperties();
    }

    static ResourceMetaData[] getAttributeMetaDataStatic() {
        return attributes_.getMetaData();
    }

    @Override
    public Object getAttributeValue(Object object) throws ResourceException {
        Object object2;
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        if ((object2 = super.getAttributeValue(object)) == null) {
            object2 = this.attributeGetter_.getValue(object);
        }
        return object2;
    }

    public String getName() {
        return this.name_;
    }

    static ResourceList list(AS400 aS400) throws ResourceException {
        try {
            Object object;
            ProgramCallDocument programCallDocument = (ProgramCallDocument)staticDocument_.clone();
            programCallDocument.setSystem(aS400);
            programCallDocument.setValue("qzlsolst_zlsl0300.informationQualifier", "*ALL");
            int n = 640;
            programCallDocument.setIntValue("qzlsolst_zlsl0300.lengthOfReceiverVariable", n);
            NetServer.callListProgram(programCallDocument, OLST0300_, true);
            int n2 = programCallDocument.getIntValue("qzlsolst_zlsl0300.listInformation.recordsReturned");
            int n3 = programCallDocument.getIntValue("qzlsolst_zlsl0300.listInformation.recordLength");
            Vector<NetServerSession> vector = new Vector<NetServerSession>();
            String string = "qzlsolst_zlsl0300.receiverVariable.";
            int n4 = 0;
            int[] nArray = new int[1];
            Object[] objectArray = openListAttributeMap_.getIDs();
            for (int i = 0; i < n2; ++i) {
                nArray[0] = i;
                object = (String)programCallDocument.getValue(string + "workstationName", nArray);
                NetServerSession netServerSession = new NetServerSession(aS400, (String)object);
                Object[] objectArray2 = openListAttributeMap_.getValues(objectArray, aS400, programCallDocument, null, nArray);
                for (int j = 0; j < objectArray2.length; ++j) {
                    netServerSession.initializeAttributeValue(objectArray[j], objectArray2[j]);
                }
                netServerSession.freezeProperties();
                vector.addElement(netServerSession);
                n4 += n3;
            }
            Object[] objectArray3 = new NetServerSession[vector.size()];
            vector.copyInto(objectArray3);
            object = presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_);
            return new ArrayResourceList((Resource[])objectArray3, (Presentation)object, NetServerSession.getAttributeMetaDataStatic());
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when listing sessions.", (Throwable)pcmlException);
            throw new ResourceException(pcmlException);
        }
    }

    public ResourceList listConnections() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerConnection.listConnectionsForSession(this.getSystem(), this.name_);
    }

    @Override
    public void refreshAttributeValues() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeGetter_.clearBuffer();
        super.refreshAttributeValues();
    }

    void setName(String string) {
        this.name_ = string;
    }

    static {
        attributes_.add((Object)CONNECTION_COUNT, Integer.class, true);
        getterMap_.add((Object)CONNECTION_COUNT, OLST0300_, "receiverVariable.numberOfConnections", INDICES_);
        openListAttributeMap_.add(CONNECTION_COUNT, OLST0300_, "receiverVariable.numberOfConnections");
        attributes_.add((Object)SESSION_TIME, Integer.class, true);
        getterMap_.add((Object)SESSION_TIME, OLST0300_, "receiverVariable.sessionTime", INDICES_);
        openListAttributeMap_.add(SESSION_TIME, OLST0300_, "receiverVariable.sessionTime");
        attributes_.add((Object)FILES_OPEN_COUNT, Integer.class, true);
        getterMap_.add((Object)FILES_OPEN_COUNT, OLST0300_, "receiverVariable.numberOfFilesOpen", INDICES_);
        openListAttributeMap_.add(FILES_OPEN_COUNT, OLST0300_, "receiverVariable.numberOfFilesOpen");
        attributes_.add((Object)IDLE_TIME, Integer.class, true);
        getterMap_.add((Object)IDLE_TIME, OLST0300_, "receiverVariable.idleTime", INDICES_);
        openListAttributeMap_.add(IDLE_TIME, OLST0300_, "receiverVariable.idleTime");
        attributes_.add((Object)IS_ENCRYPT_PASSWORD, Boolean.class, true);
        BooleanValueMap booleanValueMap = new BooleanValueMap(new String[]{"0", ""}, new String[]{"1"});
        getterMap_.add((Object)IS_ENCRYPT_PASSWORD, OLST0300_, "receiverVariable.encryptedPassword", INDICES_, (ValueMap)booleanValueMap);
        openListAttributeMap_.add((Object)IS_ENCRYPT_PASSWORD, OLST0300_, "receiverVariable.encryptedPassword", booleanValueMap);
        attributes_.add((Object)IS_GUEST, Boolean.class, true);
        booleanValueMap = new BooleanValueMap(new String[]{"1", ""}, new String[]{"0"});
        getterMap_.add((Object)IS_GUEST, OLST0300_, "receiverVariable.logonType", INDICES_, (ValueMap)booleanValueMap);
        openListAttributeMap_.add((Object)IS_GUEST, OLST0300_, "receiverVariable.logonType", booleanValueMap);
        attributes_.add((Object)SESSION_COUNT, Integer.class, true);
        getterMap_.add((Object)SESSION_COUNT, OLST0300_, "receiverVariable.numberOfSessions", INDICES_);
        openListAttributeMap_.add(SESSION_COUNT, OLST0300_, "receiverVariable.numberOfSessions");
        attributes_.add((Object)USER, String.class, true);
        getterMap_.add((Object)USER, OLST0300_, "receiverVariable.userProfileName", INDICES_);
        openListAttributeMap_.add(USER, OLST0300_, "receiverVariable.userProfileName");
        staticDocument_ = null;
        try {
            staticDocument_ = new ProgramCallDocument();
            staticDocument_.setDocument(DOCUMENT_NAME_);
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when instantiating ProgramCallDocument.", (Throwable)pcmlException);
        }
    }
}

