/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NetServer;
import com.ibm.as400.access.NetServerConnection;
import com.ibm.as400.access.NetServerFileShare;
import com.ibm.as400.access.NetServerPrintShare;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ArrayResourceList;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramAttributeSetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;
import java.util.Vector;

public abstract class NetServerShare
extends ChangeableResource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.access.MRI2");
    private static final String ICON_BASE_NAME_ = "NetServerShare";
    private static final String PRESENTATION_KEY_ = "NETSERVER";
    static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "NETSERVER");
    static ProgramMap getterMap_ = new ProgramMap();
    static final String OLST0100_ = "qzlsolst_zlsl0100";
    static final int ZLSL0100_MAX_RECORD_LENGTH_ = 1188;
    static final int[] INDICES_ = new int[]{0};
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String USER_COUNT = "USER_COUNT";
    static final String DOCUMENT_NAME_ = "com.ibm.as400.access.NetServer";
    static ProgramCallDocument staticDocument_;
    ProgramCallDocument document_;
    static final int FILE_SHARE = 0;
    static final int PRINT_SHARE = 1;
    static final int ALL_SHARES = -1;
    private String name_;
    private Object[] attrsToSetFirst_;
    private ProgramAttributeGetter attributeGetter_;
    private ProgramAttributeSetter attributeSetter_;

    NetServerShare() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    NetServerShare(AS400 aS400, String string) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setName(string);
    }

    public abstract void add() throws ResourceException;

    @Override
    protected void commitAttributeChanges(Object[] objectArray, Object[] objectArray2) throws ResourceException {
        super.commitAttributeChanges(objectArray, objectArray2);
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeSetter_.setValues(objectArray, objectArray2);
    }

    static Object computeResourceKey(AS400 aS400, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NetServerShare.class);
        stringBuffer.append(':');
        stringBuffer.append(aS400.getSystemName());
        stringBuffer.append(':');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    @Override
    protected abstract void establishConnection() throws ResourceException;

    abstract void establishConnection(boolean var1) throws ResourceException;

    void establishConnection(ProgramMap programMap, Object[] objectArray, boolean bl) throws ResourceException {
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        super.establishConnection();
        this.attrsToSetFirst_ = objectArray;
        AS400 aS400 = this.getSystem();
        if (this.document_ == null) {
            this.document_ = (ProgramCallDocument)staticDocument_.clone();
        }
        try {
            this.document_.setSystem(aS400);
            this.document_.setValue("qzlsolst_zlsl0100.informationQualifier", this.name_);
            this.attributeGetter_ = new ProgramAttributeGetter(aS400, this.document_, getterMap_);
            this.attributeSetter_ = new ProgramAttributeSetter(this.getSystem(), this.document_, programMap);
            if (bl) {
                this.attributeSetter_.initializeAttributeValues(this.attributeGetter_, this.attrsToSetFirst_);
            }
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when establishing connection to share.", (Throwable)pcmlException);
            throw new ResourceException(pcmlException);
        }
    }

    @Override
    protected void freezeProperties() throws ResourceException {
        if (this.getSystem() == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(this.name_);
        presentation.setFullName(this.name_);
        if (this.getResourceKey() == null) {
            this.setResourceKey(NetServerShare.computeResourceKey(this.getSystem(), this.name_));
        }
        super.freezeProperties();
    }

    static ResourceMetaData[] getAttributeMetaDataStatic() {
        return attributes_.getMetaData();
    }

    @Override
    public Object getAttributeUnchangedValue(Object object) throws ResourceException {
        Object object2 = super.getAttributeUnchangedValue(object);
        if (object2 == null) {
            if (!this.isConnectionEstablished()) {
                this.establishConnection();
            }
            object2 = this.attributeGetter_.getValue(object);
        }
        return object2;
    }

    public String getName() {
        return this.name_;
    }

    static ResourceList list(AS400 aS400, int n, String string, ProgramMap programMap) throws ResourceException {
        try {
            Object object;
            ProgramCallDocument programCallDocument = (ProgramCallDocument)staticDocument_.clone();
            programCallDocument.setSystem(aS400);
            String string2 = OLST0100_;
            programCallDocument.setValue(string2 + ".informationQualifier", string);
            int n2 = 11880;
            programCallDocument.setIntValue(string2 + ".lengthOfReceiverVariable", n2);
            NetServer.callListProgram(programCallDocument, string2, false);
            int n3 = programCallDocument.getIntValue(string2 + ".listInformation.recordsReturned");
            Vector<NetServerShare> vector = new Vector<NetServerShare>();
            String string3 = string2 + ".receiverVariable.";
            int n4 = 0;
            int[] nArray = new int[1];
            Object[] objectArray = programMap.getIDs();
            for (int i = 0; i < n3; ++i) {
                nArray[0] = i;
                int n5 = programCallDocument.getIntValue(string3 + "lengthOfThisEntry", nArray);
                object = (String)programCallDocument.getValue(string3 + "shareName", nArray);
                int n6 = programCallDocument.getIntValue(string3 + "deviceType", nArray);
                NetServerShare netServerShare = null;
                switch (n6) {
                    case 0: {
                        if (n != n6 && n != -1) break;
                        netServerShare = new NetServerFileShare(aS400, (String)object);
                        break;
                    }
                    case 1: {
                        if (n != n6 && n != -1) break;
                        netServerShare = new NetServerPrintShare(aS400, (String)object);
                        break;
                    }
                    default: {
                        Trace.log(2, "Bad value returned for shareType for share " + (String)object + ": " + n6);
                        throw new InternalErrorException(10);
                    }
                }
                if (netServerShare != null) {
                    Object[] objectArray2 = programMap.getValues(objectArray, aS400, programCallDocument, null, nArray);
                    for (int j = 0; j < objectArray2.length; ++j) {
                        netServerShare.initializeAttributeValue(objectArray[j], objectArray2[j]);
                    }
                    netServerShare.freezeProperties();
                    vector.addElement(netServerShare);
                }
                n4 += n5;
            }
            Presentation presentation = presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_);
            switch (n) {
                case 0: {
                    Object[] objectArray3 = new NetServerFileShare[vector.size()];
                    vector.copyInto(objectArray3);
                    return new ArrayResourceList((Resource[])objectArray3, presentation, NetServerShare.getAttributeMetaDataStatic());
                }
                case 1: {
                    object = new NetServerPrintShare[vector.size()];
                    vector.copyInto((Object[])object);
                    return new ArrayResourceList((Resource[])object, presentation, NetServerShare.getAttributeMetaDataStatic());
                }
                case -1: {
                    Object[] objectArray4 = new NetServerShare[vector.size()];
                    vector.copyInto(objectArray4);
                    return new ArrayResourceList((Resource[])objectArray4, presentation, NetServerShare.getAttributeMetaDataStatic());
                }
            }
            Trace.log(2, "Bad value for 'desiredShareType': " + n);
            throw new InternalErrorException(10);
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when listing shares.", (Throwable)pcmlException);
            throw new ResourceException(pcmlException);
        }
    }

    public ResourceList listConnections() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerConnection.listConnectionsForShare(this.getSystem(), this.name_);
    }

    @Override
    public void refreshAttributeValues() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeGetter_.clearBuffer();
        this.attributeSetter_.initializeAttributeValues(this.attributeGetter_, this.attrsToSetFirst_);
        super.refreshAttributeValues();
    }

    public void remove() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection(false);
        }
        NetServerShare.remove(this.getSystem(), this.name_);
        this.fireResourceDeleted();
    }

    static void remove(AS400 aS400, String string) throws ResourceException {
        try {
            ProgramCallDocument programCallDocument = (ProgramCallDocument)staticDocument_.clone();
            programCallDocument.setSystem(aS400);
            programCallDocument.setValue("qzlsrms.shareName", string);
            if (!programCallDocument.callProgram("qzlsrms")) {
                throw new ResourceException(programCallDocument.getMessageList("qzlsrms"));
            }
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when removing a share.", (Throwable)pcmlException);
            throw new ResourceException(pcmlException);
        }
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.name_;
        this.name_ = string;
        this.firePropertyChange("name", string2, string);
    }

    static {
        attributes_.add((Object)DESCRIPTION, String.class, "");
        getterMap_.add((Object)DESCRIPTION, OLST0100_, "receiverVariable.description", INDICES_);
        attributes_.add((Object)USER_COUNT, Integer.class, true);
        getterMap_.add((Object)USER_COUNT, OLST0100_, "receiverVariable.currentUsers", INDICES_);
        staticDocument_ = null;
        try {
            staticDocument_ = new ProgramCallDocument();
            staticDocument_.setDocument(DOCUMENT_NAME_);
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when instantiating ProgramCallDocument.", (Throwable)pcmlException);
        }
    }
}

