/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDescriptionEnumeration;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

public class ObjectList
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final String ALL = "*ALL";
    public static final String ALL_USER = "*ALLUSR";
    public static final String ASP_NAME_ALL = "*";
    public static final String ASP_NAME_SYSBAS = "*SYSBAS";
    public static final String ASP_NAME_CURASPGRP = "*CURASPGRP";
    public static final String ASP_NAME_ALLAVL = "*ALLAVL";
    public static final String ASP_SEARCH_TYPE_ASP = "*ASP";
    public static final String ASP_SEARCH_TYPE_ASPGRP = "*ASPGRP";
    public static final String AUTH_ALL = "*ALL";
    public static final String AUTH_ANY = "*ANY";
    public static final String AUTH_CHANGE = "*CHANGE";
    public static final String AUTH_DATA_ADD = "*ADD";
    public static final String AUTH_DATA_DELETE = "*DLT";
    public static final String AUTH_DATA_EXECUTE = "*EXECUTE";
    public static final String AUTH_DATA_READ = "*READ";
    public static final String AUTH_DATA_UPDATE = "*UPD";
    public static final String AUTH_LIST_MANAGEMENT = "*AUTLMGT";
    public static final String AUTH_OBJECT_ALTER = "*OBJALTER";
    public static final String AUTH_OBJECT_EXISTENCE = "*OBJEXIST";
    public static final String AUTH_OBJECT_MANAGEMENT = "*OBJMGT";
    public static final String AUTH_OBJECT_OPERATIONAL = "*OBJOPR";
    public static final String AUTH_OBJECT_REFERENCE = "*OBJREF";
    public static final String AUTH_USE = "*USE";
    public static final String CURRENT_LIBRARY = "*CURLIB";
    public static final String IBM = "*IBM";
    public static final String LIBRARY_LIST = "*LIBL";
    public static final byte STATUS_ANY = 92;
    public static final String USER_LIBRARY_LIST = "*USRLIBL";
    private static final byte BINARY = -62;
    private static final byte CHAR = -61;
    private static final byte STRUCT = -30;
    private AS400 system_;
    private int length_;
    private int recLen_;
    private byte[] handle_;
    private byte[] handleToClose_;
    private boolean isConnected_;
    private int currentLibAuthKey_ = 0;
    private String[] libAuthKeys_ = new String[10];
    private int currentObjectAuthKey_ = 0;
    private String[] objectAuthKeys_ = new String[11];
    private int currentStatusKey_ = 0;
    private byte[] statusKeys_ = new byte[5];
    private boolean statusSelection_ = true;
    private int currentKey_ = 0;
    private int[] keys_ = new int[1];
    private int currentSortKey_ = 0;
    private int[] sortKeys_ = new int[1];
    private boolean[] sortOrders_ = new boolean[1];
    private String objectName_;
    private String objectLibrary_;
    private String objectType_;
    private String aspDeviceName_;
    private String aspSearchType_ = "*ASP";

    public ObjectList(AS400 aS400) {
        this(aS400, "*ALL", "*ALL", "*ALL");
    }

    public ObjectList(AS400 aS400, String string, String string2, String string3) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("objectLibrary");
        }
        if (string2 == null) {
            throw new NullPointerException("objectName");
        }
        if (string3 == null) {
            throw new NullPointerException("objectType");
        }
        this.system_ = aS400;
        this.objectLibrary_ = QSYSObjectPathName.toQSYSName(string);
        this.objectName_ = QSYSObjectPathName.toQSYSName(string2);
        this.objectType_ = string3.toUpperCase();
    }

    public ObjectList(AS400 aS400, String string, String string2, String string3, String string4) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("objectLibrary");
        }
        if (string2 == null) {
            throw new NullPointerException("objectName");
        }
        if (string3 == null) {
            throw new NullPointerException("objectType");
        }
        this.system_ = aS400;
        this.objectLibrary_ = QSYSObjectPathName.toQSYSName(string);
        this.objectName_ = QSYSObjectPathName.toQSYSName(string2);
        this.objectType_ = string3.toUpperCase();
        this.aspDeviceName_ = string4;
    }

    public void addLibraryAuthorityCriteria(String string) {
        if (string == null) {
            throw new NullPointerException("authority");
        }
        if (!(string.equals("*ALL") || string.equals(AUTH_CHANGE) || string.equals(AUTH_USE) || string.equals(AUTH_OBJECT_OPERATIONAL) || string.equals(AUTH_OBJECT_MANAGEMENT) || string.equals(AUTH_OBJECT_EXISTENCE) || string.equals(AUTH_OBJECT_ALTER) || string.equals(AUTH_OBJECT_REFERENCE) || string.equals(AUTH_DATA_READ) || string.equals(AUTH_DATA_ADD) || string.equals(AUTH_DATA_UPDATE) || string.equals(AUTH_DATA_DELETE) || string.equals(AUTH_DATA_EXECUTE))) {
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        if (this.currentLibAuthKey_ >= 10) {
            if (Trace.traceOn_) {
                Trace.log(2, "Too many authorities added to ObjectList.");
            }
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        this.libAuthKeys_[this.currentLibAuthKey_++] = string;
        this.resetHandle();
    }

    public void addObjectAttributeToRetrieve(int n) {
        if (n < 200) {
            throw new ExtendedIllegalArgumentException("attribute", 2);
        }
        if (n == 10000 || n == 10001 || n == 10002) {
            return;
        }
        for (int i = 0; i < this.currentKey_; ++i) {
            if (this.keys_[i] != n) continue;
            return;
        }
        if (this.currentKey_ >= this.keys_.length) {
            int[] nArray = this.keys_;
            this.keys_ = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, this.keys_, 0, nArray.length);
        }
        this.keys_[this.currentKey_++] = n;
        this.resetHandle();
    }

    public void addObjectAttributeToSortOn(int n, boolean bl) {
        if (n < 200 || n > 9999) {
            throw new ExtendedIllegalArgumentException("attribute", 2);
        }
        this.addObjectAttributeToRetrieve(n);
        if (this.currentSortKey_ >= this.sortKeys_.length) {
            int[] nArray = this.sortKeys_;
            this.sortKeys_ = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, this.sortKeys_, 0, nArray.length);
            boolean[] blArray = this.sortOrders_;
            this.sortOrders_ = new boolean[blArray.length * 2];
            System.arraycopy(blArray, 0, this.sortOrders_, 0, blArray.length);
        }
        this.sortKeys_[this.currentSortKey_] = n;
        this.sortOrders_[this.currentSortKey_++] = bl;
        this.resetHandle();
    }

    public void addObjectAuthorityCriteria(String string) {
        if (string == null) {
            throw new NullPointerException("authority");
        }
        if (!(string.equals("*ALL") || string.equals(AUTH_CHANGE) || string.equals(AUTH_USE) || string.equals(AUTH_LIST_MANAGEMENT) || string.equals(AUTH_OBJECT_OPERATIONAL) || string.equals(AUTH_OBJECT_MANAGEMENT) || string.equals(AUTH_OBJECT_EXISTENCE) || string.equals(AUTH_OBJECT_ALTER) || string.equals(AUTH_OBJECT_REFERENCE) || string.equals(AUTH_DATA_READ) || string.equals(AUTH_DATA_ADD) || string.equals(AUTH_DATA_UPDATE) || string.equals(AUTH_DATA_DELETE) || string.equals(AUTH_DATA_EXECUTE) || string.equals(AUTH_ANY))) {
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        if (this.currentObjectAuthKey_ >= 11) {
            if (Trace.traceOn_) {
                Trace.log(2, "Too many authorities added to ObjectList.");
            }
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        if (string.equals(AUTH_ANY) && this.currentObjectAuthKey_ != 0) {
            if (Trace.traceOn_) {
                Trace.log(2, "Attempt to add AUTH_ANY auth after other auth was added.");
            }
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        if (this.currentObjectAuthKey_ > 0 && this.objectAuthKeys_[0].equals(AUTH_ANY)) {
            if (Trace.traceOn_) {
                Trace.log(2, "Attempt to add auth after AUTH_ANY auth was added.");
            }
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        this.objectAuthKeys_[this.currentObjectAuthKey_++] = string;
        this.resetHandle();
    }

    public void addObjectSelectionCriteria(byte by) {
        if (by != -63 && by != -60 && by != -45 && by != -41 && by != 92) {
            throw new ExtendedIllegalArgumentException("status", 2);
        }
        if (this.currentStatusKey_ >= 5) {
            if (Trace.traceOn_) {
                Trace.log(2, "Too many statuses specified for ObjectList.");
            }
            throw new ExtendedIllegalArgumentException("status", 2);
        }
        this.statusKeys_[this.currentStatusKey_] = by;
        this.resetHandle();
    }

    public void clearLibraryAuthorityCriteria() {
        this.currentLibAuthKey_ = 0;
        this.libAuthKeys_ = new String[10];
        this.resetHandle();
    }

    public void clearObjectAttributesToRetrieve() {
        this.keys_ = new int[1];
        this.currentKey_ = 0;
        this.resetHandle();
    }

    public void clearObjectAttributesToSortOn() {
        this.currentSortKey_ = 0;
        this.sortKeys_ = new int[1];
        this.sortOrders_ = new boolean[1];
        this.resetHandle();
    }

    public void clearObjectAuthorityCriteria() {
        this.currentObjectAuthKey_ = 0;
        this.objectAuthKeys_ = new String[11];
        this.resetHandle();
    }

    public void clearObjectSelectionCriteria() {
        this.currentStatusKey_ = 0;
        this.statusKeys_ = new byte[5];
        this.statusSelection_ = true;
        this.resetHandle();
    }

    public synchronized void close() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected_) {
            return;
        }
        if (this.handleToClose_ != null && (this.handle_ == null || this.handle_ == this.handleToClose_)) {
            this.handle_ = this.handleToClose_;
            this.handleToClose_ = null;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Closing object list with handle: ", this.handle_);
        }
        try {
            ListUtilities.closeList(this.system_, this.handle_);
        }
        finally {
            this.isConnected_ = false;
            this.handle_ = null;
        }
        if (this.handleToClose_ != null) {
            this.handle_ = this.handleToClose_;
            this.handleToClose_ = null;
            this.close();
        }
    }

    private void ensureSelectionKey(int n) {
        for (int i = 0; i < this.currentKey_; ++i) {
            if (this.keys_[i] != n) continue;
            return;
        }
        if (this.keys_.length <= this.currentKey_) {
            int[] nArray = this.keys_;
            this.keys_ = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, this.keys_, 0, nArray.length);
        }
        this.keys_[this.currentKey_++] = n;
    }

    private void ensureSortKeyAfter(int n, int n2) {
        int n3;
        int n4 = -1;
        for (n3 = 0; n3 < this.currentSortKey_; ++n3) {
            if (this.sortKeys_[n3] != n) continue;
            n4 = n3;
            break;
        }
        if (n4 == -1) {
            return;
        }
        n3 = n4 + 1;
        if (n4 < this.currentSortKey_ - 1 && this.sortKeys_[n3] == n2) {
            return;
        }
        int[] nArray = this.sortKeys_;
        boolean[] blArray = this.sortOrders_;
        this.sortKeys_ = new int[nArray.length + 1];
        this.sortOrders_ = new boolean[nArray.length + 1];
        System.arraycopy(nArray, 0, this.sortKeys_, 0, n3);
        System.arraycopy(blArray, 0, this.sortOrders_, 0, n3);
        this.sortKeys_[n3] = n2;
        this.sortOrders_[n3] = blArray[n4];
        if (n3 < nArray.length) {
            System.arraycopy(nArray, n3, this.sortKeys_, n3 + 1, nArray.length - n3);
            System.arraycopy(blArray, n3, this.sortOrders_, n3 + 1, nArray.length - n3);
        }
        ++this.currentSortKey_;
    }

    private void ensureSortKeyBefore(int n, int n2) {
        int n3 = -1;
        for (int i = 0; i < this.currentSortKey_; ++i) {
            if (this.sortKeys_[i] != n) continue;
            n3 = i;
            break;
        }
        if (n3 == -1) {
            return;
        }
        if (n3 > 0 && this.sortKeys_[n3 - 1] == n2) {
            return;
        }
        int[] nArray = this.sortKeys_;
        boolean[] blArray = this.sortOrders_;
        this.sortKeys_ = new int[nArray.length + 1];
        this.sortOrders_ = new boolean[nArray.length + 1];
        System.arraycopy(nArray, 0, this.sortKeys_, 0, n3);
        System.arraycopy(blArray, 0, this.sortOrders_, 0, n3);
        this.sortKeys_[n3] = n2;
        this.sortOrders_[n3] = blArray[n3];
        System.arraycopy(nArray, n3, this.sortKeys_, n3 + 1, nArray.length - n3);
        System.arraycopy(blArray, n3, this.sortOrders_, n3 + 1, nArray.length - n3);
        ++this.currentSortKey_;
    }

    private void fixUpKeys() {
        int n;
        block14: for (n = 0; n < this.currentKey_; ++n) {
            switch (this.keys_[n]) {
                case 401: {
                    this.ensureSelectionKey(402);
                    this.ensureSelectionKey(403);
                    continue block14;
                }
                case 509: {
                    this.ensureSelectionKey(510);
                    continue block14;
                }
                case 701: {
                    this.ensureSelectionKey(702);
                    continue block14;
                }
                case 514: {
                    this.ensureSelectionKey(515);
                    continue block14;
                }
                case 503: {
                    this.ensureSelectionKey(504);
                }
            }
        }
        n = 0;
        block15: while (n < this.currentSortKey_) {
            int n2 = this.currentSortKey_;
            for (n = 0; n < this.currentSortKey_; ++n) {
                switch (this.sortKeys_[n]) {
                    case 401: {
                        this.ensureSortKeyBefore(401, 402);
                        this.ensureSortKeyAfter(401, 403);
                        break;
                    }
                    case 509: {
                        this.ensureSortKeyBefore(509, 510);
                        break;
                    }
                    case 701: {
                        this.ensureSortKeyBefore(701, 702);
                        break;
                    }
                    case 514: {
                        this.ensureSortKeyBefore(514, 515);
                        break;
                    }
                    case 503: {
                        this.ensureSortKeyBefore(503, 504);
                    }
                }
                if (n2 == this.currentSortKey_) continue;
                n = 0;
                continue block15;
            }
        }
    }

    public String getAspDeviceName() {
        return this.aspDeviceName_;
    }

    public String getAspSearchType() {
        return this.aspSearchType_;
    }

    public synchronized int getLength() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.handle_ == null) {
            this.load();
        }
        return this.length_;
    }

    public String getLibrary() {
        return this.objectLibrary_;
    }

    public String getName() {
        return this.objectName_;
    }

    public synchronized Enumeration getObjects() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, RequestNotSupportedException {
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.handle_ == null) {
            this.load();
        }
        return new ObjectDescriptionEnumeration(this, this.length_);
    }

    public synchronized ObjectDescription[] getObjects(int n, int n2) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (n < -1) {
            throw new ExtendedIllegalArgumentException("listOffset", 4);
        }
        if (n2 < 0 && n != -1) {
            throw new ExtendedIllegalArgumentException("number", 4);
        }
        if (this.handle_ == null) {
            this.load();
        }
        if (this.length_ == 0 || n2 == 0 && n != -1) {
            return new ObjectDescription[0];
        }
        if (n == -1) {
            n2 = this.length_;
            n = 0;
        } else {
            if (n >= this.length_) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Value of parameter 'listOffset' is beyond end of list:", n + " (list length: " + this.length_ + ")");
                }
                return new ObjectDescription[0];
            }
            if (n + n2 > this.length_) {
                n2 = this.length_ - n;
            }
        }
        int n3 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n3, null);
        int n4 = n2 * this.recLen_;
        Object[] objectArray = new Object[1];
        byte[] byArray = ListUtilities.retrieveListEntries(this.system_, this.handle_, n4, n2, n, objectArray);
        byte[] byArray2 = (byte[])objectArray[0];
        if (byArray2 == null || byArray2.length == 0) {
            return new ObjectDescription[0];
        }
        int n5 = BinaryConverter.byteArrayToInt(byArray2, 4);
        int n6 = BinaryConverter.byteArrayToInt(byArray2, 12);
        ObjectDescription[] objectDescriptionArray = new ObjectDescription[n5];
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            String string = convTable.byteArrayToString(byArray, n7, 10).trim();
            String string2 = convTable.byteArrayToString(byArray, n7 + 10, 10).trim();
            String string3 = convTable.byteArrayToString(byArray, n7 + 20, 10).trim().substring(1);
            byte by = byArray[n7 + 30];
            int n8 = BinaryConverter.byteArrayToInt(byArray, n7 + 32);
            objectDescriptionArray[i] = this.aspDeviceName_ != null ? new ObjectDescription(this.system_, string2, string, string3, by, this.aspDeviceName_, this.aspSearchType_) : new ObjectDescription(this.system_, string2, string, string3, by);
            if (by != -63 && by != -45) {
                int n9 = n7 + 36;
                for (int j = 0; j < n8 && n9 + 16 < byArray.length; ++j) {
                    int n10 = BinaryConverter.byteArrayToInt(byArray, n9);
                    int n11 = BinaryConverter.byteArrayToInt(byArray, n9 + 4);
                    byte by2 = byArray[n9 + 8];
                    int n12 = BinaryConverter.byteArrayToInt(byArray, n9 + 12);
                    byte[] byArray3 = new byte[n12];
                    System.arraycopy(byArray, n9 + 16, byArray3, 0, n12);
                    Object object = null;
                    if (by2 == -62) {
                        object = new Integer(BinaryConverter.byteArrayToInt(byArray3, 0));
                        objectDescriptionArray[i].set(n11, object);
                    } else if (by2 == -61) {
                        switch (n11) {
                            case 304: 
                            case 305: 
                            case 501: 
                            case 502: 
                            case 512: 
                            case 518: 
                            case 601: 
                            case 602: {
                                object = byArray3;
                                break;
                            }
                            case 303: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 404: 
                            case 407: 
                            case 410: 
                            case 507: 
                            case 513: 
                            case 516: 
                            case 517: 
                            case 604: 
                            case 703: {
                                object = convTable.byteArrayToString(byArray3, 0, byArray3.length);
                                break;
                            }
                            default: {
                                object = convTable.byteArrayToString(byArray3, 0, byArray3.length).trim();
                            }
                        }
                        objectDescriptionArray[i].set(n11, object);
                    } else {
                        Trace.log(2, "Unknown key type for key " + n11 + ": " + by2);
                        throw new InternalErrorException(5, n11 + ": " + by2, null);
                    }
                    n9 += n10;
                }
            }
            n7 += n6;
        }
        return objectDescriptionArray;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String getType() {
        return this.objectType_;
    }

    public synchronized void load() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramCall programCall;
        int n;
        int n2;
        int n3;
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.handle_ != null || this.handleToClose_ != null) {
            this.close();
        }
        int n4 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n4, null);
        AS400Text aS400Text = new AS400Text(10, n4, this.system_);
        ProgramParameter[] programParameterArray = new ProgramParameter[this.aspDeviceName_ == null ? 12 : 15];
        programParameterArray[0] = new ProgramParameter(1);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(1));
        programParameterArray[2] = new ProgramParameter(80);
        programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray(-1));
        this.fixUpKeys();
        byte[] byArray = null;
        int n5 = this.currentSortKey_;
        if (n5 > 0) {
            byArray = new byte[4 + n5 * 12];
            BinaryConverter.intToByteArray(n5, byArray, 0);
            int n6 = 4;
            for (int i = 0; i < n5; ++i) {
                n3 = this.sortKeys_[i];
                n2 = this.sortOrders_[i];
                int n7 = ObjectDescription.keyLengths_.get(n3);
                short s = 4;
                int n8 = 53;
                switch (n3) {
                    case 205: 
                    case 301: 
                    case 304: 
                    case 305: 
                    case 314: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 512: 
                    case 518: 
                    case 601: 
                    case 602: 
                    case 603: 
                    case 701: 
                    case 702: {
                        s = 0;
                    }
                }
                n = 0;
                while (this.keys_[n] != n3) {
                    n8 += 16 + ObjectDescription.keyLengths_.get(this.keys_[n]);
                    ++n;
                }
                BinaryConverter.intToByteArray(n8, byArray, n6);
                BinaryConverter.intToByteArray(n7, byArray, n6 += 4);
                BinaryConverter.shortToByteArray(s, byArray, n6 += 4);
                byArray[n6 += 2] = n2 != 0 ? -15 : -14;
                n6 += 2;
            }
        } else {
            byArray = new byte[4];
        }
        programParameterArray[4] = new ProgramParameter(byArray);
        byte[] byArray2 = new byte[20];
        aS400Text.toBytes(this.objectName_, byArray2, 0);
        aS400Text.toBytes(this.objectLibrary_, byArray2, 10);
        programParameterArray[5] = new ProgramParameter(byArray2);
        programParameterArray[6] = new ProgramParameter(aS400Text.toBytes(this.objectType_));
        byte[] byArray3 = new byte[28 + (this.currentObjectAuthKey_ + this.currentLibAuthKey_) * 10];
        BinaryConverter.intToByteArray(byArray3.length, byArray3, 0);
        BinaryConverter.intToByteArray(1, byArray3, 4);
        BinaryConverter.intToByteArray(this.currentObjectAuthKey_ == 0 ? 0 : 28, byArray3, 8);
        BinaryConverter.intToByteArray(this.currentObjectAuthKey_, byArray3, 12);
        BinaryConverter.intToByteArray(this.currentLibAuthKey_ == 0 ? 0 : 28 + this.currentObjectAuthKey_ * 10, byArray3, 16);
        BinaryConverter.intToByteArray(this.currentLibAuthKey_, byArray3, 20);
        BinaryConverter.intToByteArray(0, byArray3, 24);
        n3 = 28;
        for (n2 = 0; n2 < this.currentObjectAuthKey_; ++n2) {
            aS400Text.toBytes(this.objectAuthKeys_[n2], byArray3, n3);
            n3 += 10;
        }
        for (n2 = 0; n2 < this.currentLibAuthKey_; ++n2) {
            aS400Text.toBytes(this.libAuthKeys_[n2], byArray3, n3);
            n3 += 10;
        }
        programParameterArray[7] = new ProgramParameter(byArray3);
        n2 = this.currentStatusKey_;
        byte[] byArray4 = this.statusKeys_;
        if (n2 == 0) {
            n2 = 1;
            byArray4 = new byte[]{92};
        }
        byte[] byArray5 = new byte[20 + n2];
        BinaryConverter.intToByteArray(byArray5.length, byArray5, 0);
        BinaryConverter.intToByteArray(this.statusSelection_ ? 0 : 1, byArray5, 4);
        BinaryConverter.intToByteArray(20, byArray5, 8);
        BinaryConverter.intToByteArray(n2, byArray5, 12);
        BinaryConverter.intToByteArray(0, byArray5, 16);
        System.arraycopy(byArray4, 0, byArray5, 20, n2);
        programParameterArray[8] = new ProgramParameter(byArray5);
        programParameterArray[9] = new ProgramParameter(BinaryConverter.intToByteArray(this.currentKey_));
        byte[] byArray6 = new byte[this.currentKey_ * 4];
        n3 = 0;
        for (n = 0; n < this.currentKey_; ++n) {
            BinaryConverter.intToByteArray(this.keys_[n], byArray6, n3);
            n3 += 4;
        }
        programParameterArray[10] = new ProgramParameter(byArray6);
        programParameterArray[11] = new ErrorCodeParameter();
        if (programParameterArray.length == 15) {
            programParameterArray[12] = new ProgramParameter(aS400Text.toBytes(ASP_NAME_ALL));
            programParameterArray[13] = new ProgramParameter(convTable.stringToByteArray("JIDF0000"));
            byte[] byArray7 = new byte[24];
            System.arraycopy(BinaryConverter.intToByteArray(24), 0, byArray7, 0, 4);
            for (int i = 4; i < byArray7.length; ++i) {
                byArray7[i] = 64;
            }
            convTable.stringToByteArray(this.aspDeviceName_, byArray7, 4);
            if (!(this.aspDeviceName_.equals(ASP_NAME_ALL) || this.aspDeviceName_.equals(ASP_NAME_SYSBAS) || this.aspDeviceName_.equals(ASP_NAME_CURASPGRP) || this.aspDeviceName_.equals(ASP_NAME_ALLAVL))) {
                convTable.stringToByteArray(this.aspSearchType_, byArray7, 14);
            }
            programParameterArray[14] = new ProgramParameter(byArray7);
        }
        if (!(programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYOLOBJ.PGM", programParameterArray)).run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        this.isConnected_ = true;
        byte[] byArray8 = programParameterArray[2].getOutputData();
        this.handle_ = new byte[4];
        System.arraycopy(byArray8, 8, this.handle_, 0, 4);
        byArray8 = ListUtilities.waitForListToComplete(this.system_, this.handle_, byArray8);
        this.length_ = BinaryConverter.byteArrayToInt(byArray8, 0);
        this.recLen_ = BinaryConverter.byteArrayToInt(byArray8, 12);
        if (this.recLen_ <= 0) {
            Trace.log(2, "invalid record length", this.recLen_);
            throw new InternalErrorException(2, this.recLen_);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded object list with length = " + this.length_ + " and handle: ", this.handle_);
        }
    }

    private synchronized void resetHandle() {
        if (this.handleToClose_ == null) {
            this.handleToClose_ = this.handle_;
        }
        this.handle_ = null;
    }

    public void setAspSearchType(String string) throws ExtendedIllegalArgumentException {
        if (string == null) {
            throw new NullPointerException("aspSearchType");
        }
        if (!string.equals(ASP_SEARCH_TYPE_ASP) && !string.equals(ASP_SEARCH_TYPE_ASPGRP)) {
            throw new ExtendedIllegalArgumentException("aspSearchType", 2);
        }
        this.aspSearchType_ = string;
    }

    public void setObjectSelection(boolean bl) {
        this.statusSelection_ = bl;
        this.resetHandle();
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for object list invoked.");
        }
        if (this.handle_ != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

