/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AFPResource;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.PrintObjectInputStreamImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

public class PrintObjectInputStream
extends InputStream {
    private transient AS400 system_;
    private transient PrintObjectInputStreamImpl impl_;

    PrintObjectInputStream(SpooledFile spooledFile, PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.system_ = spooledFile.getSystem();
        this.chooseImpl();
        this.system_.connectService(1);
        if (spooledFile.getImpl() == null) {
            spooledFile.chooseImpl();
        }
        this.impl_.createPrintObjectInputStream((SpooledFileImpl)spooledFile.getImpl(), printParameterList);
    }

    PrintObjectInputStream(SpooledFile spooledFile, PrintParameterList printParameterList, String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.system_ = spooledFile.getSystem();
        this.chooseImpl();
        this.system_.connectService(1);
        if (spooledFile.getImpl() == null) {
            spooledFile.chooseImpl();
        }
        this.impl_.createPrintObjectInputStream((SpooledFileImpl)spooledFile.getImpl(), printParameterList, string);
    }

    PrintObjectInputStream(AFPResource aFPResource, PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.system_ = aFPResource.getSystem();
        this.chooseImpl();
        this.system_.connectService(1);
        if (aFPResource.getImpl() == null) {
            aFPResource.chooseImpl();
        }
        this.impl_.createPrintObjectInputStream(aFPResource.getImpl(), printParameterList);
    }

    @Override
    public int available() throws IOException {
        return this.impl_.available();
    }

    private void chooseImpl() {
        if (this.system_ == null) {
            Trace.log(2, "Attempt to use PrintObjectInputStream before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectInputStreamImpl)this.system_.loadImpl2("com.ibm.as400.access.PrintObjectInputStreamImplRemote", "com.ibm.as400.access.PrintObjectInputStreamImplProxy");
    }

    @Override
    public void close() throws IOException {
        this.impl_.close();
    }

    @Override
    public void mark(int n) {
        this.impl_.mark(n);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int n = -1;
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 == 1) {
            n = byArray[0];
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.impl_.read(byArray, n, n2);
    }

    @Override
    public void reset() throws IOException {
        this.impl_.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.impl_.skip(l);
    }
}

