/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPAttributeValue;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPSelOutQ;
import com.ibm.as400.access.NPCPSelPrtD;
import com.ibm.as400.access.NPCPSelPrtF;
import com.ibm.as400.access.NPCPSelRes;
import com.ibm.as400.access.NPCPSelSplF;
import com.ibm.as400.access.NPCPSelWrtJ;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.PrintObjectListEvent;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.PrintObjectListListener;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Vector;

abstract class PrintObjectListImplRemote
implements PrintObjectListImpl,
Runnable {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    private NPCPAttributeIDList attrsToRetrieve_;
    private NPCPID idFilter_;
    private NPCPSelection selection_;
    private AS400ImplRemote system_;
    private int typeOfObject_ = 0;
    private transient boolean completed_ = false;
    private transient boolean closed_ = false;
    private final Object closeLock_ = new Object();
    private transient boolean waiting_ = false;
    private final Object waitLock_ = new Object();
    private transient int waitingForItem_ = -1;
    private transient Vector cpidList_ = null;
    private transient Vector cpattrList_ = null;
    private transient int numItems_ = 0;
    private transient Exception anyException_ = null;
    private transient Vector printObjectListListeners_ = null;
    private boolean useCache_ = true;

    PrintObjectListImplRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintObjectListListener(PrintObjectListListener printObjectListListener) {
        if (this.printObjectListListeners_ == null) {
            this.printObjectListListeners_ = new Vector();
        }
        Vector vector = this.printObjectListListeners_;
        synchronized (vector) {
            this.printObjectListListeners_.addElement(printObjectListListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildList() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        block25: {
            NPSystem nPSystem = NPSystem.getSystem(this.getSystem());
            if (nPSystem != null) {
                NPConversation nPConversation = nPSystem.getConversation();
                try {
                    if (nPConversation == null) break block25;
                    boolean bl = false;
                    boolean bl2 = true;
                    int n = 0;
                    ConverterImpl converterImpl = nPConversation.getConverter();
                    AS400Server aS400Server = nPConversation.getServer();
                    int n2 = aS400Server.newCorrelationId();
                    NPDataStream nPDataStream = new NPDataStream(this.typeOfObject_);
                    nPDataStream.setCorrelation(n2);
                    nPDataStream.setAction(22);
                    nPDataStream.setConverter(converterImpl);
                    if (this.selection_ != null) {
                        nPDataStream.addCodePoint(this.selection_);
                    }
                    if (this.idFilter_ != null) {
                        nPDataStream.addCodePoint(this.idFilter_);
                    }
                    if (this.attrsToRetrieve_ != null) {
                        nPDataStream.addCodePoint(this.attrsToRetrieve_);
                    } else {
                        nPDataStream.addCodePoint(this.getDefaultAttrsToList());
                    }
                    aS400Server.send(nPDataStream, n2);
                    do {
                        Object object;
                        Object object2;
                        Object object3;
                        NPCPAttributeValue nPCPAttributeValue;
                        NPDataStream nPDataStream2;
                        if ((nPDataStream2 = (NPDataStream)aS400Server.receive(n2)) == null) {
                            bl2 = false;
                            Trace.log(2, "buildList: Null reply from AS400Server.receive()!");
                            throw new InternalErrorException(4);
                        }
                        ++n;
                        boolean bl3 = bl2 = !nPDataStream2.isLastReply();
                        if (bl) continue;
                        nPDataStream2.setConverter(converterImpl);
                        int n3 = nPDataStream2.getReturnCode();
                        if (n3 == 0) {
                            nPCPAttributeValue = this.newNPCPID(nPDataStream2);
                            object3 = this.newNPCPAttribute(nPDataStream2);
                            if (nPCPAttributeValue == null) continue;
                            object2 = this.closeLock_;
                            synchronized (object2) {
                                if (this.closed_ || this.completed_) {
                                    bl = true;
                                } else {
                                    if (this.useCache_) {
                                        this.cpidList_.addElement(nPCPAttributeValue);
                                    }
                                    if (this.useCache_) {
                                        this.cpattrList_.addElement(object3);
                                    }
                                    ++this.numItems_;
                                    this.firePrintObjectList(5, (NPCPID)nPCPAttributeValue, (NPCPAttribute)object3, null);
                                    if (this.waiting_ && this.waitingForItem_ <= this.numItems_ && this.waitingForItem_ > -1) {
                                        object = this.waitLock_;
                                        synchronized (object) {
                                            this.waitLock_.notifyAll();
                                        }
                                    }
                                }
                            }
                        }
                        if (n3 == 9) {
                            nPCPAttributeValue = (NPCPAttribute)nPDataStream2.getCodePoint(8);
                            if (nPCPAttributeValue == null) continue;
                            object3 = nPCPAttributeValue.getStringValue(147);
                            object2 = nPCPAttributeValue.getStringValue(128);
                            object = nPCPAttributeValue.getStringValue(129);
                            if (Trace.traceOn_) {
                                Trace.log(2, "buildList: CPF Message(" + (String)object3 + ") = " + (String)object2 + ", HelpText= " + (String)object);
                            }
                            AS400Message aS400Message = new AS400Message((String)object3, (String)object2);
                            aS400Message.setHelp((String)object);
                            AS400Exception aS400Exception = new AS400Exception(aS400Message);
                            throw aS400Exception;
                        }
                        if (n3 == 20) continue;
                        Trace.log(2, "buildList: Host Return Code" + n3);
                        if (n3 == 4) {
                            throw new RequestNotSupportedException(nPConversation.getAttribute(141), 1);
                        }
                        throw new ErrorCompletingRequestException(1, "QNPSERVS RC = " + n3);
                    } while (bl2);
                }
                finally {
                    nPSystem.returnConversation(nPConversation);
                }
            }
        }
    }

    void checkRunTimeState() {
        if (this.getSystem() == null) {
            Trace.log(2, "checkRunTimeState: Parameter 'system' has not been set.");
            throw new ExtendedIllegalStateException("system", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.closeLock_;
        synchronized (object) {
            this.closed_ = true;
            this.cpidList_ = null;
            this.cpattrList_ = null;
            this.numItems_ = 0;
            this.anyException_ = null;
        }
        this.firePrintObjectList(1, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePrintObjectList(int n, NPCPID nPCPID, NPCPAttribute nPCPAttribute, Exception exception) {
        if (this.printObjectListListeners_ == null) {
            return;
        }
        PrintObjectListEvent printObjectListEvent = exception != null ? new PrintObjectListEvent((Object)this, exception) : (nPCPID != null ? new PrintObjectListEvent(this, nPCPID, nPCPAttribute) : new PrintObjectListEvent((Object)this, n));
        Vector vector = this.printObjectListListeners_;
        synchronized (vector) {
            int n2 = this.printObjectListListeners_.size();
            block10: for (int i = 0; i < n2; ++i) {
                switch (n) {
                    case 5: {
                        ((PrintObjectListListener)this.printObjectListListeners_.elementAt(i)).listObjectAdded(printObjectListEvent);
                        continue block10;
                    }
                    case 1: {
                        ((PrintObjectListListener)this.printObjectListListeners_.elementAt(i)).listClosed(printObjectListEvent);
                        continue block10;
                    }
                    case 2: {
                        ((PrintObjectListListener)this.printObjectListListeners_.elementAt(i)).listCompleted(printObjectListEvent);
                        continue block10;
                    }
                    case 3: {
                        ((PrintObjectListListener)this.printObjectListListeners_.elementAt(i)).listErrorOccurred(printObjectListEvent);
                        continue block10;
                    }
                    case 4: {
                        ((PrintObjectListListener)this.printObjectListListeners_.elementAt(i)).listOpened(printObjectListEvent);
                    }
                }
            }
        }
    }

    abstract NPCPAttributeIDList getDefaultAttrsToList();

    @Override
    public synchronized NPCPID getNPCPID(int n) {
        return (NPCPID)this.cpidList_.elementAt(n);
    }

    @Override
    public synchronized NPCPAttribute getNPCPAttribute(int n) {
        return (NPCPAttribute)this.cpattrList_.elementAt(n);
    }

    NPCPSelection getSelectionCP() {
        return this.selection_;
    }

    public final AS400ImplRemote getSystem() {
        return this.system_;
    }

    @Override
    public boolean isCompleted() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (this.anyException_ != null) {
            this.rethrowException();
        }
        return this.completed_;
    }

    abstract NPCPID newNPCPID(NPDataStream var1);

    NPCPAttribute newNPCPAttribute(NPDataStream nPDataStream) {
        return (NPCPAttribute)nPDataStream.getCodePoint(8);
    }

    @Override
    public void openAsynchronously() {
        this.checkRunTimeState();
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openSynchronously() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        Object object;
        this.checkRunTimeState();
        AS400ImplRemote aS400ImplRemote = this.getSystem();
        if (aS400ImplRemote != null && (object = NPSystem.getSystem(aS400ImplRemote)) != null) {
            NPConversation nPConversation = ((NPSystem)object).getConversation();
            ((NPSystem)object).returnConversation(nPConversation);
        }
        this.cpidList_ = new Vector();
        this.cpattrList_ = new Vector();
        this.numItems_ = 0;
        this.completed_ = false;
        this.closed_ = false;
        this.anyException_ = null;
        this.firePrintObjectList(4, null, null, null);
        try {
            this.buildList();
        }
        catch (Exception exception) {
            this.anyException_ = exception;
            this.firePrintObjectList(3, null, null, exception);
        }
        finally {
            this.firePrintObjectList(2, null, null, null);
            Object object2 = this.waitLock_;
            synchronized (object2) {
                this.completed_ = true;
                this.waitLock_.notifyAll();
            }
        }
        if (this.anyException_ != null) {
            this.rethrowException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintObjectListListener(PrintObjectListListener printObjectListListener) {
        if (this.printObjectListListeners_ != null) {
            Vector vector = this.printObjectListListeners_;
            synchronized (vector) {
                this.printObjectListListeners_.removeElement(printObjectListListener);
            }
        }
    }

    @Override
    public void resetAttributesToRetrieve() {
        this.attrsToRetrieve_ = null;
    }

    @Override
    public void resetFilter() {
        this.selection_.reset();
        this.idFilter_ = null;
    }

    private void rethrowException() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (this.anyException_ instanceof AS400Exception) {
            throw (AS400Exception)this.anyException_;
        }
        if (this.anyException_ instanceof AS400SecurityException) {
            throw (AS400SecurityException)this.anyException_;
        }
        if (this.anyException_ instanceof ConnectionDroppedException) {
            throw (ConnectionDroppedException)this.anyException_;
        }
        if (this.anyException_ instanceof ErrorCompletingRequestException) {
            throw (ErrorCompletingRequestException)this.anyException_;
        }
        if (this.anyException_ instanceof InterruptedException) {
            throw (InterruptedException)this.anyException_;
        }
        if (this.anyException_ instanceof IOException) {
            throw (IOException)this.anyException_;
        }
        if (this.anyException_ instanceof RequestNotSupportedException) {
            throw (RequestNotSupportedException)this.anyException_;
        }
        if (this.anyException_ instanceof ExtendedIllegalStateException) {
            throw (ExtendedIllegalStateException)this.anyException_;
        }
        if (this.anyException_ instanceof NullPointerException) {
            throw (NullPointerException)this.anyException_;
        }
        Trace.log(2, "rethrowException: Exception was not rethrown.");
    }

    @Override
    public void run() {
        try {
            this.openSynchronously();
        }
        catch (Exception exception) {
            this.anyException_ = exception;
        }
    }

    @Override
    public void setAttributesToRetrieve(int[] nArray) {
        if (nArray == null) {
            Trace.log(2, "setAttributesToRetrieve: Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        if (this.attrsToRetrieve_ != null) {
            this.attrsToRetrieve_.reset();
        } else {
            this.attrsToRetrieve_ = new NPCPAttributeIDList();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.attrsToRetrieve_.addAttrID(nArray[i]);
        }
    }

    @Override
    public void setCache(boolean bl) {
        this.useCache_ = bl;
    }

    @Override
    public void setIDCodePointFilter(NPCPID nPCPID) {
        this.idFilter_ = nPCPID;
    }

    @Override
    public void setFilter(String string, String string2) {
        NPCPSelection nPCPSelection;
        if (string.equals("resource")) {
            nPCPSelection = (NPCPSelRes)this.getSelectionCP();
            ((NPCPSelRes)nPCPSelection).setResource(string2);
        }
        if (string.equals("queue")) {
            nPCPSelection = (NPCPSelOutQ)this.getSelectionCP();
            ((NPCPSelOutQ)nPCPSelection).setQueue(string2);
        } else if (string.equals("printer")) {
            nPCPSelection = (NPCPSelPrtD)this.getSelectionCP();
            ((NPCPSelPrtD)nPCPSelection).setPrinter(string2);
        } else if (string.equals("printerFile")) {
            nPCPSelection = (NPCPSelPrtF)this.getSelectionCP();
            ((NPCPSelPrtF)nPCPSelection).setPrinterFile(string2);
        } else if (string.equals("formType")) {
            nPCPSelection = (NPCPSelSplF)this.getSelectionCP();
            ((NPCPSelSplF)nPCPSelection).setFormType(string2);
        } else if (string.equals("spooledFileQueue")) {
            nPCPSelection = (NPCPSelSplF)this.getSelectionCP();
            ((NPCPSelSplF)nPCPSelection).setQueue(string2);
        } else if (string.equals("user")) {
            nPCPSelection = (NPCPSelSplF)this.getSelectionCP();
            ((NPCPSelSplF)nPCPSelection).setUser(string2);
        } else if (string.equals("userData")) {
            nPCPSelection = (NPCPSelSplF)this.getSelectionCP();
            ((NPCPSelSplF)nPCPSelection).setUserData(string2);
        } else if (string.equals("writerJobQueue")) {
            nPCPSelection = (NPCPSelWrtJ)this.getSelectionCP();
            ((NPCPSelWrtJ)nPCPSelection).setQueue(string2);
        } else if (string.equals("writer")) {
            nPCPSelection = (NPCPSelWrtJ)this.getSelectionCP();
            ((NPCPSelWrtJ)nPCPSelection).setWriter(string2);
        }
    }

    @Override
    public void setPrintObjectListAttrs(NPCPAttributeIDList nPCPAttributeIDList, NPCPID nPCPID, NPCPSelection nPCPSelection, int n) {
        this.attrsToRetrieve_ = nPCPAttributeIDList;
        this.idFilter_ = nPCPID;
        this.selection_ = nPCPSelection;
        this.typeOfObject_ = n;
    }

    @Override
    public void setSystem(AS400Impl aS400Impl) {
        this.system_ = (AS400ImplRemote)aS400Impl;
    }

    @Override
    public int size() {
        return this.numItems_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForItem(int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        while (this.numItems_ < n && !this.completed_ && !this.closed_) {
            this.waitingForItem_ = n;
            this.waiting_ = true;
            try {
                Object object = this.waitLock_;
                synchronized (object) {
                    if (!this.closed_ && !this.completed_) {
                        this.waitLock_.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.anyException_ = interruptedException;
            }
            if (this.anyException_ == null) continue;
            this.rethrowException();
        }
        this.waiting_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForListToComplete() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        while (!this.completed_ && !this.closed_) {
            this.waitingForItem_ = -1;
            this.waiting_ = true;
            try {
                Object object = this.waitLock_;
                synchronized (object) {
                    if (!this.completed_ && !this.closed_) {
                        this.waitLock_.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.anyException_ = interruptedException;
            }
            if (this.anyException_ == null) continue;
            this.rethrowException();
        }
        this.waiting_ = false;
    }
}

