/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDPrinterFile;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterFileImpl;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class PrinterFile
extends PrintObject
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PATH = "path";

    PrinterFile(AS400 aS400, NPCPIDPrinterFile nPCPIDPrinterFile, NPCPAttribute nPCPAttribute) {
        super(aS400, nPCPIDPrinterFile, nPCPAttribute, 5);
    }

    public PrinterFile() {
        super(null, null, 5);
    }

    public PrinterFile(AS400 aS400, String string) {
        super(aS400, PrinterFile.buildIDCodePoint(string), null, 5);
    }

    private static NPCPIDPrinterFile buildIDCodePoint(String string) {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "FILE");
        return new NPCPIDPrinterFile(qSYSObjectPathName.getObjectName(), qSYSObjectPathName.getLibraryName());
    }

    @Override
    void checkRunTimeState() {
        super.checkRunTimeState();
        if (this.getIDCodePoint() == null) {
            Trace.log(2, "Parameter 'path' has not been set.");
            throw new ExtendedIllegalStateException(PATH, 4);
        }
    }

    @Override
    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use PrinterFile before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrinterFileImpl)aS400.loadImpl2("com.ibm.as400.access.PrinterFileImplRemote", "com.ibm.as400.access.PrinterFileImplProxy");
        super.setImpl();
    }

    public String getName() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return nPCPID.getStringValue(92);
    }

    public String getPath() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return QSYSObjectPathName.toPath(nPCPID.getStringValue(91), nPCPID.getStringValue(92), "FILE");
    }

    public void setAttributes(PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (printParameterList == null) {
            Trace.log(2, "Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        this.checkRunTimeState();
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((PrinterFileImpl)this.impl_).setAttributes(printParameterList);
        this.attrs = this.impl_.getAttrValue();
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null");
            throw new NullPointerException(PATH);
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException(PATH, 5);
        }
        String string2 = this.getPath();
        this.vetos.fireVetoableChange(PATH, string2, string);
        this.setIDCodePoint(PrinterFile.buildIDCodePoint(string));
        this.changes.firePropertyChange(PATH, string2, string);
    }
}

