/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PxDSRV;
import com.ibm.as400.access.Trace;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

class PxDSFactory {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Hashtable factory_ = new Hashtable();

    PxDSFactory() {
    }

    public PxDSRV getNextDS(InputStream inputStream) throws IOException {
        if (Trace.isTraceProxyOn()) {
            Trace.log(6, this, "getNextDS");
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            Short s = new Short(dataInputStream.readShort());
            if (this.factory_.containsKey(s)) {
                PxDSRV pxDSRV;
                block11: {
                    PxDSRV pxDSRV2 = (PxDSRV)this.factory_.get(s);
                    if (Trace.isTraceProxyOn()) {
                        Trace.log(6, "getNextDS. Factory read ds type " + s + " (" + pxDSRV2 + ").");
                    }
                    pxDSRV = null;
                    try {
                        pxDSRV = (PxDSRV)pxDSRV2.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        if (!Trace.isTraceErrorOn()) break block11;
                        Trace.log(2, "Clone error in ds factory", (Throwable)cloneNotSupportedException);
                    }
                }
                pxDSRV.readFrom(inputStream, this);
                if (Trace.isTraceProxyOn()) {
                    Trace.log(6, "getNextDS. returning " + pxDSRV);
                }
                return pxDSRV;
            }
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Factory read ds type " + s + ".");
            }
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ds type " + s + " not registered in factory.");
            }
            throw new InternalErrorException(2);
        }
        catch (IOException iOException) {
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "exception thrown from getNextDS " + iOException);
            }
            throw iOException;
        }
    }

    public void register(PxDSRV pxDSRV) {
        Short s = new Short(pxDSRV.getType());
        if (this.factory_.contains(s)) {
            throw new InternalErrorException(4);
        }
        this.factory_.put(s, pxDSRV);
    }
}

