/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PSController;
import com.ibm.as400.access.ProxyServer;
import com.ibm.as400.access.PxBooleanParm;
import com.ibm.as400.access.PxRepSV;
import com.ibm.as400.access.PxReqSV;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.net.InetAddress;
import java.net.UnknownHostException;

class PxEndReqSV
extends PxReqSV {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String PROXY_SERVER_END_ = ResourceBundleLoader.getText("PROXY_SERVER_END");
    private static final String PROXY_SERVER_END_REJECTED_ = ResourceBundleLoader.getText("PROXY_SERVER_END_REJECTED");
    private PSController controller_;
    private ProxyServer proxyServer_;

    public PxEndReqSV(ProxyServer proxyServer, PSController pSController) {
        super((short)11040);
        this.proxyServer_ = proxyServer;
        this.controller_ = pSController;
    }

    @Override
    public PxRepSV process() {
        InetAddress inetAddress = this.controller_.getClientAddress();
        try {
            if (InetAddress.getLocalHost().equals(inetAddress)) {
                boolean bl = ((PxBooleanParm)this.getParm(0)).getBooleanValue();
                Verbose.println(ResourceBundleLoader.substitute(PROXY_SERVER_END_, inetAddress));
                if (bl) {
                    System.exit(0);
                } else {
                    this.proxyServer_.stop();
                }
            } else {
                Verbose.println(ResourceBundleLoader.substitute(PROXY_SERVER_END_REJECTED_, inetAddress));
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Error while ending proxy server", (Throwable)unknownHostException);
            }
            Verbose.println(ResourceBundleLoader.substitute(PROXY_SERVER_END_REJECTED_, inetAddress));
        }
        return null;
    }
}

