/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.HistoryLog;
import com.ibm.as400.access.JobLog;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.Trace;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class QueuedMessageEnumeration
implements Enumeration {
    private QueuedMessage[] messageCache_;
    private MessageQueue mq_;
    private JobLog jl_;
    private HistoryLog hl_;
    private int counter_;
    private int numMessages_;
    private int listOffset_ = 0;
    private int cacheOffset_ = 0;

    QueuedMessageEnumeration(MessageQueue messageQueue, int n) {
        this.mq_ = messageQueue;
        this.numMessages_ = n;
    }

    QueuedMessageEnumeration(JobLog jobLog, int n) {
        this.jl_ = jobLog;
        this.numMessages_ = n;
    }

    QueuedMessageEnumeration(HistoryLog historyLog, int n) {
        this.hl_ = historyLog;
        this.numMessages_ = n;
    }

    @Override
    public final boolean hasMoreElements() {
        return this.counter_ < this.numMessages_;
    }

    public final Object nextElement() {
        if (this.counter_ >= this.numMessages_) {
            throw new NoSuchElementException();
        }
        if (this.messageCache_ == null || this.cacheOffset_ >= this.messageCache_.length) {
            try {
                this.messageCache_ = this.mq_ != null ? this.mq_.getMessages(this.listOffset_, 1000) : (this.hl_ != null ? this.hl_.getMessages(this.listOffset_, 1000) : this.jl_.getMessages(this.listOffset_, 1000));
                if (Trace.traceOn_) {
                    Trace.log(1, "Loaded next block in QueuedMessageEnumeration: " + this.messageCache_.length + " messages at list offset " + this.listOffset_ + " out of " + this.numMessages_ + " total.");
                }
            }
            catch (Exception exception) {
                Trace.log(2, "Exception while loading nextElement() in QueuedMessageEnumeration:", (Throwable)exception);
                throw new NoSuchElementException();
            }
            this.cacheOffset_ = 0;
            this.listOffset_ += this.messageCache_.length;
        }
        ++this.counter_;
        return this.messageCache_[this.cacheOffset_++];
    }
}

