/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SCS5224Writer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SCS5219Writer
extends SCS5224Writer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int QUALITY_DRAFT = 1;
    public static final int QUALITY_NEAR_LETTER = 2;
    private static final byte[] BUS = new byte[]{43, -44, 3, 10, 1};
    private static final byte[] EUS = new byte[]{43, -44, 2, 14};
    private static final byte[] SPPS = new byte[]{43, -46, 6, 64, 0, 0, 0, 0};
    private static final byte[] SCD = new byte[]{43, -46, 4, 41, 0, 0};
    private static final byte[] PPM = new byte[]{43, -46, 10, 72, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] SHM = new byte[]{43, -46, 4, 17, 0, 0};
    private static final byte[] SCG = new byte[]{43, -47, 6, 1, 0, 0, 0, 0};
    private boolean underline_ = false;
    private double paperWidth = 8.5;
    private double paperLength = 11.0;
    private byte paper = 1;
    private byte sourceDrawer = 1;
    private byte destinationDrawer = 1;
    private byte quality_ = (byte)2;
    private double leftMargin_ = 0.0;
    private int codepage_ = 0;
    private int charset_ = 0;
    byte plex_ = 0;

    public SCS5219Writer(OutputStream outputStream) {
        super(outputStream);
    }

    public SCS5219Writer(OutputStream outputStream, int n) throws UnsupportedEncodingException {
        super(outputStream, n);
    }

    public SCS5219Writer(OutputStream outputStream, int n, AS400 aS400) throws UnsupportedEncodingException {
        super(outputStream, n, aS400);
    }

    public SCS5219Writer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
    }

    @Override
    public void endPage() throws IOException {
        if (this.underline_) {
            this.addToBuffer(EUS);
        }
        super.endPage();
    }

    @Override
    void initPage() throws IOException {
        super.initPage();
        this.sendSPPS();
        this.sendPPM();
        this.setLeftMargin(this.leftMargin_);
        this.setUnderline(this.underline_);
        if (this.codepage_ != 0) {
            this.setCodePage(this.codepage_, this.charset_);
        }
    }

    private void sendPPM() throws IOException {
        byte[] byArray = PPM;
        byArray[6] = this.paper;
        byArray[7] = this.sourceDrawer;
        byArray[9] = this.destinationDrawer;
        byArray[10] = this.quality_;
        byArray[11] = this.plex_;
        this.addToBuffer(byArray);
        if (this.plex_ != 0) {
            this.plex_ = 0;
            byArray[11] = 0;
            this.addToBuffer(byArray);
        }
    }

    private void sendSPPS() throws IOException {
        int n = (int)(this.paperWidth * 1440.0);
        int n2 = (int)(this.paperLength * 1440.0);
        byte[] byArray = SPPS;
        byArray[4] = (byte)(n >> 8);
        byArray[5] = (byte)n;
        byArray[6] = (byte)(n2 >> 8);
        byArray[7] = (byte)n2;
        this.addToBuffer(byArray);
    }

    public void setCodePage(int n, int n2) throws IOException {
        byte[] byArray = SCG;
        if (n != 0 && n2 != 0) {
            this.codepage_ = n;
            this.charset_ = n2;
            byArray[4] = (byte)(n2 >> 8);
            byArray[5] = (byte)n2;
            byArray[6] = (byte)(n >> 8);
            byArray[7] = (byte)n;
            this.addToBuffer(byArray);
        }
    }

    @Override
    public void setCPI(int n) throws IOException {
        switch (n) {
            case 10: {
                this.CPI = (byte)10;
                break;
            }
            case 12: {
                this.CPI = (byte)12;
                break;
            }
            case 15: {
                this.CPI = (byte)15;
                break;
            }
            default: {
                String string = "CPI (" + String.valueOf(n) + ")";
                throw new ExtendedIllegalArgumentException(string, 2);
            }
        }
        this.fontOrCPI = true;
        if (!this.pageStarted_) {
            this.initPage();
        }
        byte[] byArray = SCD;
        byArray[byArray.length - 1] = this.CPI;
        this.addToBuffer(byArray);
    }

    public void setDestinationDrawer(int n) {
        if (n < 1 || n > 255) {
            String string = "Drawer (" + String.valueOf(n) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        this.destinationDrawer = (byte)n;
    }

    public void setEnvelopeSize(double d, double d2) {
        if (d < 0.1 || d > 14.0) {
            String string = "Width (" + String.valueOf(d) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        if (d2 < 0.1 || d2 > 14.0) {
            String string = "Length (" + String.valueOf(d2) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        this.paper = (byte)2;
        this.paperWidth = d;
        this.paperLength = d2;
    }

    public void setLeftMargin(double d) throws IOException {
        if (d < 0.0 || d > 14.0) {
            String string = "Left margin (" + String.valueOf(d) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        this.leftMargin_ = d;
        if (!this.pageStarted_) {
            this.initPage();
        }
        byte[] byArray = SHM;
        int n = (int)(d * 1440.0);
        byArray[4] = (byte)(n >> 8);
        byArray[5] = (byte)n;
        this.addToBuffer(byArray);
    }

    public void setPaperSize(double d, double d2) {
        if (d < 0.1 || d > 14.0) {
            String string = "Width (" + String.valueOf(d) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        if (d2 < 0.1 || d2 > 14.0) {
            String string = "Length (" + String.valueOf(d2) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        this.paper = 1;
        this.paperWidth = d;
        this.paperLength = d2;
    }

    public void setQuality(int n) {
        switch (n) {
            case 1: 
            case 2: {
                this.quality_ = (byte)n;
                break;
            }
            default: {
                String string = "Quality (" + String.valueOf(n) + ")";
                throw new ExtendedIllegalArgumentException(string, 2);
            }
        }
    }

    public void setSourceDrawer(int n) {
        if (n < 1 || n > 255) {
            String string = "Drawer (" + String.valueOf(n) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        this.sourceDrawer = (byte)n;
    }

    public void setUnderline(boolean bl) throws IOException {
        this.underline_ = bl;
        if (this.pageStarted_) {
            if (this.underline_) {
                this.addToBuffer(BUS);
            } else {
                this.addToBuffer(EUS);
            }
        }
    }
}

