/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class SCS5256Writer
extends OutputStreamWriter {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final byte[] CR = new byte[]{13};
    private static final byte[] LF = new byte[]{37};
    private static final byte[] NL = new byte[]{21};
    private static final byte[] FF = new byte[]{12};
    private static final byte[] SGEA = new byte[]{43, -56, 1};
    private static final byte[] SHF = new byte[]{43, -63, 2, 0};
    private static final byte[] SVF = new byte[]{43, -62, 2, 0};
    private static final byte[] AHPP = new byte[]{52, -64, 0};
    private static final byte[] AVPP = new byte[]{52, -60, 0};
    private static final byte[] RHPP = new byte[]{52, -56, 0};
    private static final byte[] RVPP = new byte[]{52, 76, 0};
    private OutputStream outPut;
    private Converter cvt;
    private byte[] buffer = new byte[300];
    private int dataLength = 0;
    private int horizontalFormat_ = -1;
    private int verticalFormat_ = -1;
    boolean pageStarted_ = false;

    public SCS5256Writer(OutputStream outputStream) {
        super(outputStream);
        this.outPut = outputStream;
        this.cvt = new Converter();
    }

    public SCS5256Writer(OutputStream outputStream, int n) throws UnsupportedEncodingException {
        super(outputStream);
        this.outPut = outputStream;
        this.cvt = new Converter(n);
    }

    public SCS5256Writer(OutputStream outputStream, int n, AS400 aS400) throws UnsupportedEncodingException {
        super(outputStream);
        this.outPut = outputStream;
        this.cvt = new Converter(n, aS400);
    }

    public SCS5256Writer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream);
        this.outPut = outputStream;
        this.cvt = new Converter(string);
    }

    public void absoluteHorizontalPosition(int n) throws IOException {
        byte[] byArray = AHPP;
        if (n < 0 || n > 255) {
            String string = "Column (" + String.valueOf(n) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        if (!this.pageStarted_) {
            this.initPage();
        }
        byArray[byArray.length - 1] = (byte)n;
        this.addToBuffer(byArray);
    }

    public void absoluteVerticalPosition(int n) throws IOException {
        byte[] byArray = AVPP;
        if (n < 0 || n > 255) {
            String string = "Line (" + String.valueOf(n) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        if (!this.pageStarted_) {
            this.initPage();
        }
        byArray[byArray.length - 1] = (byte)n;
        this.addToBuffer(byArray);
    }

    void addToBuffer(byte[] byArray) throws IOException {
        if (this.outPut == null) {
            throw new IOException("Stream closed");
        }
        int n = byArray.length;
        if (this.dataLength + n > this.buffer.length) {
            this.flush();
        }
        for (int i = 0; i < n; ++i) {
            this.buffer[this.dataLength] = byArray[i];
            ++this.dataLength;
        }
    }

    public void carriageReturn() throws IOException {
        this.addToBuffer(CR);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.outPut.close();
        this.outPut = null;
        this.cvt = null;
    }

    public void endPage() throws IOException {
        this.addToBuffer(FF);
        this.pageStarted_ = false;
    }

    @Override
    public void flush() throws IOException {
        if (this.dataLength > 0) {
            if (this.outPut == null) {
                throw new IOException("Stream closed");
            }
            this.outPut.write(this.buffer, 0, this.dataLength);
            this.dataLength = 0;
        }
    }

    int getCcsid() {
        if (this.cvt == null) {
            return 0;
        }
        return this.cvt.getCcsid();
    }

    @Override
    public String getEncoding() {
        if (this.cvt == null) {
            return null;
        }
        return this.cvt.getEncoding();
    }

    void initPage() throws IOException {
        this.pageStarted_ = true;
        this.sendSGEA();
        if (this.horizontalFormat_ != -1) {
            this.setHorizontalFormat(this.horizontalFormat_);
        }
        if (this.verticalFormat_ != -1) {
            this.setVerticalFormat(this.verticalFormat_);
        }
    }

    public void lineFeed() throws IOException {
        this.addToBuffer(LF);
    }

    public void newLine() throws IOException {
        this.addToBuffer(NL);
    }

    public void relativeHorizontalPosition(int n) throws IOException {
        byte[] byArray = RHPP;
        if (n < 0 || n > 255) {
            String string = "chars (" + String.valueOf(n) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        if (!this.pageStarted_) {
            this.initPage();
        }
        byArray[byArray.length - 1] = (byte)n;
        this.addToBuffer(byArray);
    }

    public void relativeVerticalPosition(int n) throws IOException {
        byte[] byArray = RVPP;
        if (n < 0 || n > 255) {
            String string = "lines (" + String.valueOf(n) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        if (!this.pageStarted_) {
            this.initPage();
        }
        byArray[byArray.length - 1] = (byte)n;
        this.addToBuffer(byArray);
    }

    private void sendSGEA() throws IOException {
        this.addToBuffer(SGEA);
    }

    public void setHorizontalFormat(int n) throws IOException {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        if (n < 0 || n > 255) {
            String string = "NumOfChars (" + String.valueOf(n) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        this.horizontalFormat_ = n;
        for (int i = 0; i < byArray.length - 1; ++i) {
            byArray[i] = SHF[i];
        }
        byArray[byArray.length - 1] = (byte)n;
        this.addToBuffer(byArray);
    }

    public void setVerticalFormat(int n) throws IOException {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        if (n < 0 || n > 255) {
            String string = "NumOfLines (" + String.valueOf(n) + ")";
            throw new ExtendedIllegalArgumentException(string, 2);
        }
        this.verticalFormat_ = n;
        for (int i = 0; i < byArray.length - 1; ++i) {
            byArray[i] = SVF[i];
        }
        byArray[byArray.length - 1] = (byte)n;
        this.addToBuffer(byArray);
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        String string = new String(cArray, n, n2);
        this.write(string);
    }

    @Override
    public void write(int n) throws IOException {
        String string = String.valueOf(n);
        this.write(string);
    }

    @Override
    public void write(String string) throws IOException {
        byte[] byArray;
        if (this.outPut == null) {
            throw new IOException("Stream closed");
        }
        if (!this.pageStarted_) {
            this.initPage();
        }
        if (this.dataLength + (byArray = this.cvt.stringToByteArray(string)).length > this.buffer.length) {
            this.flush();
            if (byArray.length > this.buffer.length) {
                this.outPut.write(byArray, 0, byArray.length);
                return;
            }
        }
        System.arraycopy(byArray, 0, this.buffer, this.dataLength, byArray.length);
        this.dataLength += byArray.length;
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        String string2 = string.substring(n, n + n2);
        this.write(string2);
    }
}

