/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBoolean
extends SQLDataBase {
    static final String copyright = "Copyright (C) 2020-2020 International Business Machines Corporation and others.";
    private boolean value_ = false;
    private int vrm_;

    SQLBoolean(int n, SQLConversionSettings sQLConversionSettings) {
        this(0, n, sQLConversionSettings);
    }

    SQLBoolean(int n, int n2, SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
        this.vrm_ = n2;
    }

    @Override
    public Object clone() {
        return new SQLBoolean(this.vrm_, this.settings_);
    }

    @Override
    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        byte by = byArray[n];
        this.value_ = by != -16;
    }

    @Override
    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        byArray[n] = this.value_ ? -15 : -16;
    }

    public static Boolean getBooleanObject(Object object, String string) throws SQLException {
        if (string == null) {
            return null;
        }
        return new Boolean(SQLBoolean.getBoolean(object, string));
    }

    public static boolean getBoolean(Object object, String string) throws SQLException {
        string = string.toUpperCase().trim();
        boolean bl = false;
        if ("TRUE".equals(string) || "T".equals(string) || "Y".equals(string) || "YES".equals(string) || "ON".equals(string)) {
            bl = true;
        } else if ("FALSE".equals(string) || "F".equals(string) || "N".equals(string) || "NO".equals(string) || "OFF".equals(string)) {
            bl = false;
        } else {
            try {
                double d = Double.parseDouble(string);
                if (d == 0.0) {
                    if (string.charAt(0) == '0') {
                        bl = false;
                    } else {
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(object, "Unable to assign string (" + string + ")");
                        }
                        JDError.throwSQLException(object, "07006");
                    }
                } else {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(object, "Unable to assign string (" + string + ")");
                }
                JDError.throwSQLException(object, "07006", numberFormatException);
            }
        }
        return bl;
    }

    public static Boolean getBooleanObject(Object object, Number number) throws SQLException {
        if (number == null) {
            return null;
        }
        return new Boolean(SQLBoolean.getBoolean(object, number));
    }

    public static boolean getBoolean(Object object, Number number) {
        double d = number.doubleValue();
        boolean bl = d != 0.0;
        return bl;
    }

    public static boolean getBoolean(Object object, long l) {
        boolean bl = l != 0L;
        return bl;
    }

    @Override
    public void set(Object object, Calendar calendar, int n) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (object instanceof String) {
            this.value_ = SQLBoolean.getBoolean((Object)this, (String)object);
        } else if (object instanceof Number) {
            this.value_ = SQLBoolean.getBoolean((Object)this, (Number)object);
        } else if (object instanceof Boolean) {
            this.value_ = (Boolean)object;
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    public void set(int n) {
        this.value_ = n == 0;
    }

    @Override
    public int getSQLType() {
        return 41;
    }

    @Override
    public String getCreateParameters() {
        return null;
    }

    @Override
    public int getDisplaySize() {
        return 1;
    }

    @Override
    public String getJavaClassName() {
        return "java.lang.Boolean";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "BOOLEAN";
    }

    @Override
    public int getMaximumPrecision() {
        return 1;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 2436;
    }

    @Override
    public int getPrecision() {
        return 1;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 16;
    }

    @Override
    public String getTypeName() {
        return "BOOLEAN";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public int getActualSize() {
        return 1;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = this.value_ ? new BigDecimal(1) : new BigDecimal(0);
        if (n > 0) {
            bigDecimal = bigDecimal.setScale(n);
        }
        return bigDecimal;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Clob getClob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.value_;
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.value_) {
            return 1;
        }
        return 0;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.value_) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.value_) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public int getInt() throws SQLException {
        if (this.value_) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getLong() throws SQLException {
        if (this.value_) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public Object getObject() throws SQLException {
        return new Boolean(this.value_);
    }

    @Override
    public short getShort() throws SQLException {
        if (this.value_) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getString() throws SQLException {
        if (this.value_) {
            return "1";
        }
        return "0";
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public String getNString() throws SQLException {
        return this.getString();
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public NClob getNClob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() {
        this.savedValue_ = new Boolean(this.value_);
    }
}

