/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCRowId;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLRowID
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final byte[] default_ = new byte[0];
    private int length_ = 0;
    private byte[] value_ = default_;

    SQLRowID(SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
    }

    @Override
    public Object clone() {
        return new SQLRowID(this.settings_);
    }

    @Override
    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(byArray, n);
        this.value_ = new byte[this.length_];
        System.arraycopy(byArray, n + 2, this.value_, 0, this.length_);
    }

    @Override
    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.unsignedShortToByteArray(this.length_, byArray, n);
        int n2 = this.value_.length < byArray.length ? this.value_.length : byArray.length;
        System.arraycopy(this.value_, 0, byArray, n + 2, n2);
        for (int i = n + 2 + n2; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    @Override
    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof RowId) {
            this.value_ = ((RowId)object).getBytes();
        } else if (object instanceof String) {
            try {
                this.value_ = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else if (object instanceof byte[]) {
            this.value_ = (byte[])object;
        } else if (object instanceof InputStream) {
            int n2 = n;
            if (n2 >= 0) {
                int n3;
                InputStream inputStream = (InputStream)object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n4 = n2 < 1000000 ? n2 : 1000000;
                byte[] byArray = new byte[n4];
                try {
                    n3 = 0;
                    int n5 = inputStream.read(byArray, 0, n4);
                    while (n5 > -1 && n3 < n2) {
                        byteArrayOutputStream.write(byArray, 0, n5);
                        int n6 = n2 - (n3 += n5);
                        if (n6 < n4) {
                            n4 = n6;
                        }
                        n5 = inputStream.read(byArray, 0, n4);
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
                this.value_ = byteArrayOutputStream.toByteArray();
                n3 = this.value_.length;
                if (this.value_.length > 40) {
                    byte[] byArray2 = new byte[40];
                    System.arraycopy(this.value_, 0, byArray2, 0, 40);
                    this.value_ = byArray2;
                }
                this.truncated_ = n3 - this.value_.length;
                this.outOfBounds_ = false;
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Reader) {
            int n7 = n;
            if (n7 >= 0) {
                try {
                    int n8;
                    int n9 = n7 < 1000000 ? n7 : 1000000;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    HexReaderInputStream hexReaderInputStream = new HexReaderInputStream((Reader)object);
                    byte[] byArray = new byte[n9];
                    int n10 = 0;
                    int n11 = hexReaderInputStream.read(byArray, 0, n9);
                    while (n11 > -1 && n10 < n7) {
                        byteArrayOutputStream.write(byArray, 0, n11);
                        n8 = n7 - (n10 += n11);
                        if (n8 < n9) {
                            n9 = n8;
                        }
                        n11 = hexReaderInputStream.read(byArray, 0, n9);
                    }
                    this.value_ = byteArrayOutputStream.toByteArray();
                    n8 = this.value_.length;
                    if (this.value_.length > 40) {
                        byte[] byArray3 = new byte[40];
                        System.arraycopy(this.value_, 0, byArray3, 0, 40);
                        this.value_ = byArray3;
                    }
                    hexReaderInputStream.close();
                    this.truncated_ = n8 - this.value_.length;
                    this.outOfBounds_ = false;
                }
                catch (ExtendedIOException extendedIOException) {
                    JDError.throwSQLException((Object)this, "07006", extendedIOException);
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else {
                if (JDTrace.isTraceOn()) {
                    if (object == null) {
                        JDTrace.logInformation(this, "Unable to assign null object");
                    } else {
                        JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                    }
                }
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Blob) {
            this.value_ = ((Blob)object).getBytes(1L, (int)((Blob)object).length());
        } else if (object instanceof Clob) {
            try {
                this.value_ = BinaryConverter.stringToBytes(((Clob)object).getSubString(1L, (int)((Clob)object).length()));
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        int n12 = this.value_.length;
        if (n12 > 40) {
            byte[] byArray = new byte[40];
            System.arraycopy(this.value_, 0, byArray, 0, 40);
            this.value_ = byArray;
            this.truncated_ = n12 - 40;
            this.outOfBounds_ = false;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
        this.length_ = this.value_.length;
    }

    @Override
    public int getSQLType() {
        return 25;
    }

    @Override
    public String getCreateParameters() {
        return null;
    }

    @Override
    public int getDisplaySize() {
        return 40;
    }

    @Override
    public String getJavaClassName() {
        return "[B";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "ROWID";
    }

    @Override
    public int getMaximumPrecision() {
        return 40;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 904;
    }

    @Override
    public int getPrecision() {
        return 40;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return -8;
    }

    @Override
    public String getTypeName() {
        return "ROWID";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.value_.length;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new ByteArrayInputStream(this.getBytes());
    }

    @Override
    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        byte[] byArray = this.getBytes();
        return new AS400JDBCBlob(byArray, byArray.length);
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length > n && n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.value_, 0, byArray, 0, n);
            return byArray;
        }
        return this.value_;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    @Override
    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = BinaryConverter.bytesToHexString(this.getBytes());
        return new AS400JDBCClob(string, string.length());
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCRowId(this.getBytes());
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    @Override
    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = BinaryConverter.bytesToHexString(this.getBytes());
        return new AS400JDBCNClob(string, string.length());
    }

    @Override
    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    @Override
    public RowId getRowId() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCRowId(this.getBytes());
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() throws SQLException {
        this.savedValue_ = this.value_;
    }
}

