/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLSmallint
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private short value_ = 0;
    private int scale_;
    private BigDecimal bigDecimalValue_ = null;
    private int vrm_;

    SQLSmallint(int n, SQLConversionSettings sQLConversionSettings) {
        this(0, n, sQLConversionSettings);
    }

    SQLSmallint(int n, int n2, SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
        this.scale_ = n;
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Short.toString(this.value_));
        }
        this.vrm_ = n2;
    }

    @Override
    public Object clone() {
        return new SQLSmallint(this.scale_, this.vrm_, this.settings_);
    }

    @Override
    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        this.value_ = BinaryConverter.byteArrayToShort(byArray, n);
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Short.toString(this.value_)).movePointLeft(this.scale_);
            this.value_ = (short)this.bigDecimalValue_.intValue();
        }
    }

    @Override
    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.shortToByteArray(this.value_, byArray, n);
    }

    @Override
    public void set(Object object, Calendar calendar, int n) throws SQLException {
        block25: {
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            if (object instanceof String) {
                boolean bl = false;
                try {
                    int n2 = Integer.parseInt((String)object);
                    if (n2 > Short.MAX_VALUE) {
                        this.truncated_ = 6;
                        this.outOfBounds_ = true;
                        this.value_ = Short.MAX_VALUE;
                    } else if (n2 < Short.MIN_VALUE) {
                        this.truncated_ = 6;
                        this.outOfBounds_ = true;
                        this.value_ = Short.MIN_VALUE;
                    } else {
                        this.value_ = (short)n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                if (bl) {
                    try {
                        double d = Double.valueOf((String)object);
                        if (d > 32767.0) {
                            this.truncated_ = 6;
                            this.outOfBounds_ = true;
                            this.value_ = Short.MAX_VALUE;
                            break block25;
                        }
                        if (d < -32768.0) {
                            this.truncated_ = 6;
                            this.outOfBounds_ = true;
                            this.value_ = Short.MIN_VALUE;
                            break block25;
                        }
                        this.value_ = (short)d;
                    }
                    catch (NumberFormatException numberFormatException) {
                        JDError.throwSQLException((Object)this, "07006", numberFormatException);
                    }
                }
            } else if (object instanceof Number) {
                long l = ((Number)object).longValue();
                if (l > 32767L) {
                    this.truncated_ = 6;
                    this.outOfBounds_ = true;
                    this.value_ = Short.MAX_VALUE;
                } else if (l < -32768L) {
                    this.truncated_ = 6;
                    this.outOfBounds_ = true;
                    this.value_ = Short.MIN_VALUE;
                } else {
                    this.value_ = (short)l;
                }
            } else if (object instanceof Boolean) {
                this.value_ = (Boolean)object == true ? (short)1 : 0;
            } else {
                if (JDTrace.isTraceOn()) {
                    if (object == null) {
                        JDTrace.logInformation(this, "Unable to assign null object");
                    } else {
                        JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                    }
                }
                JDError.throwSQLException((Object)this, "07006");
            }
        }
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Short.toString(this.value_)).movePointLeft(this.scale_);
            this.value_ = (short)this.bigDecimalValue_.intValue();
        }
    }

    @Override
    public int getSQLType() {
        return 26;
    }

    @Override
    public String getCreateParameters() {
        return null;
    }

    @Override
    public int getDisplaySize() {
        return 6;
    }

    @Override
    public String getJavaClassName() {
        return "java.lang.Integer";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "SMALLINT";
    }

    @Override
    public int getMaximumPrecision() {
        return 5;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 500;
    }

    @Override
    public int getPrecision() {
        return 5;
    }

    @Override
    public int getRadix() {
        return 10;
    }

    @Override
    public int getScale() {
        return this.scale_;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public String getTypeName() {
        return "SMALLINT";
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public int getActualSize() {
        return 2;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            if (n >= 0) {
                return this.bigDecimalValue_.setScale(n);
            }
            return this.bigDecimalValue_;
        }
        if (n <= 0) {
            return BigDecimal.valueOf(this.value_);
        }
        return BigDecimal.valueOf(this.value_).setScale(n);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_ != 0;
    }

    @Override
    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 127 || this.value_ < -128) {
            this.truncated_ = 1;
            this.outOfBounds_ = true;
        }
        return (byte)this.value_;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.doubleValue();
        }
        return this.value_;
    }

    @Override
    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.floatValue();
        }
        return this.value_;
    }

    @Override
    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new Integer(this.value_);
    }

    @Override
    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.toString();
        }
        return Short.toString(this.value_);
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() {
        this.savedValue_ = new Short(this.value_);
    }
}

