/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.SQLException;

class SerializableReader
extends Reader
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private char[] charArray_;
    private transient CharArrayReader reader_;

    public SerializableReader(Reader reader, int n) throws IOException, SQLException {
        this.charArray_ = new char[n];
        int n2 = reader.read(this.charArray_);
        if (n2 != n || reader.read() != -1) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Length parameter does not match actual length of buffer.");
            }
            throw new SQLException("Length parameter (" + n + ") does not match actual length of buffer (" + n2 + ").");
        }
        this.reader_ = new CharArrayReader(this.charArray_);
    }

    public SerializableReader(Reader reader) throws IOException, SQLException {
        this.charArray_ = SerializableReader.readerToChars(reader);
        this.reader_ = new CharArrayReader(this.charArray_);
    }

    static final char[] readerToChars(Reader reader) throws SQLException {
        char[] cArray;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            int n2;
            cArray = new char[32000];
            while (reader.ready() && (n2 = reader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n2);
                n += n2;
            }
        }
        catch (IOException iOException) {
            JDError.throwSQLException("HY105");
        }
        cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public void close() {
        this.reader_.close();
    }

    @Override
    public void mark(int n) throws IOException {
        this.reader_.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.reader_.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.reader_.read();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.reader_.read(cArray, n, n2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.reader_ = new CharArrayReader(this.charArray_);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader_.ready();
    }

    @Override
    public void reset() throws IOException {
        this.reader_.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.reader_.skip(l);
    }
}

