/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDSplF;
import com.ibm.as400.access.NPCPSelSplF;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectList;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.Serializable;

public class SpooledFileList
extends PrintObjectList
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final String FORM_TYPE_FILTER = "formTypeFilter";
    private static final String QUEUE_FILTER = "queueFilter";
    private static final String USER_FILTER = "userFilter";
    private static final String USER_DATA_FILTER = "userDataFilter";
    private static final String END_DATE_FILTER = "endDateFilter";
    private static final String END_TIME_FILTER = "endTimeFilter";
    private static final String START_DATE_FILTER = "startDateFilter";
    private static final String START_TIME_FILTER = "startTimeFilter";
    private static final String JOB_SYSTEM_FILTER = "jobSystemFilter";

    public SpooledFileList() {
        super(1, new NPCPSelSplF());
    }

    public SpooledFileList(AS400 aS400) {
        super(1, new NPCPSelSplF(), aS400);
    }

    @Override
    void chooseImpl() {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use SpooledFileList before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectListImpl)aS400.loadImpl2("com.ibm.as400.access.SpooledFileListImplRemote", "com.ibm.as400.access.SpooledFileListImplProxy");
        super.setImpl();
    }

    public String getFormTypeFilter() {
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        return nPCPSelSplF.getFormType();
    }

    public String getQueueFilter() {
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        return nPCPSelSplF.getQueue();
    }

    public String getUserFilter() {
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        return nPCPSelSplF.getUser();
    }

    public String getUserDataFilter() {
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        return nPCPSelSplF.getUserData();
    }

    public String getJobSystemFilter() {
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        return nPCPSelSplF.getJobSystem();
    }

    public String getEndDateFilter() {
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        return nPCPSelSplF.getEndDate();
    }

    public String getEndTimeFilter() {
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        return nPCPSelSplF.getEndTime();
    }

    @Override
    PrintObject newNPObject(NPCPID nPCPID, NPCPAttribute nPCPAttribute) {
        return new SpooledFile(this.system_, (NPCPIDSplF)nPCPID, nPCPAttribute);
    }

    public String getStartDateFilter() {
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        return nPCPSelSplF.getStartDate();
    }

    public String getStartTimeFilter() {
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        return nPCPSelSplF.getStartTime();
    }

    public void setFormTypeFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'formTypeFilter' is null");
            throw new NullPointerException(FORM_TYPE_FILTER);
        }
        if (string.length() > 10) {
            Trace.log(2, "Parameter 'formTypeFilter' is greater than 10 characters in length.");
            throw new ExtendedIllegalArgumentException("formTypeFilter(" + string + ")", 2);
        }
        String string2 = this.getFormTypeFilter();
        this.vetos.fireVetoableChange(FORM_TYPE_FILTER, string2, string);
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        nPCPSelSplF.setFormType(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("formType", string);
        }
        this.changes.firePropertyChange(FORM_TYPE_FILTER, string2, string);
    }

    public void setQueueFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'queueFilter' is null");
            throw new NullPointerException(QUEUE_FILTER);
        }
        String string2 = this.getQueueFilter();
        this.vetos.fireVetoableChange(QUEUE_FILTER, string2, string);
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        nPCPSelSplF.setQueue(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("spooledFileQueue", string);
        }
        this.changes.firePropertyChange(QUEUE_FILTER, string2, string);
    }

    public void setJobSystemFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'jobSystemFilter' is null");
            throw new NullPointerException(JOB_SYSTEM_FILTER);
        }
        String string2 = this.getJobSystemFilter();
        this.vetos.fireVetoableChange(JOB_SYSTEM_FILTER, string2, string);
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        nPCPSelSplF.setJobSystem(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("jobSystem", string);
        }
        this.changes.firePropertyChange(JOB_SYSTEM_FILTER, string2, string);
    }

    public void setEndDateFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'endDateFilter' is null");
            throw new NullPointerException(END_DATE_FILTER);
        }
        if (string.length() > 7) {
            Trace.log(2, "Parameter 'endDateFilter' has invalid length.");
            throw new ExtendedIllegalArgumentException("endDateFilter(" + string + ")", 1);
        }
        String string2 = this.getEndDateFilter();
        this.vetos.fireVetoableChange(END_DATE_FILTER, string2, string);
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        nPCPSelSplF.setEndDate(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("endDate", string);
        }
        this.changes.firePropertyChange(END_DATE_FILTER, string2, string);
    }

    public void setEndTimeFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'endTimeFilter' is null");
            throw new NullPointerException(END_TIME_FILTER);
        }
        String string2 = this.getEndTimeFilter();
        this.vetos.fireVetoableChange(END_TIME_FILTER, string2, string);
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        nPCPSelSplF.setEndTime(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("endTime", string);
        }
        this.changes.firePropertyChange(END_TIME_FILTER, string2, string);
    }

    public void setStartDateFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'startDateFilter' is null");
            throw new NullPointerException(START_DATE_FILTER);
        }
        String string2 = this.getStartDateFilter();
        this.vetos.fireVetoableChange(START_DATE_FILTER, string2, string);
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        nPCPSelSplF.setStartDate(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("startDate", string);
        }
        this.changes.firePropertyChange(START_DATE_FILTER, string2, string);
    }

    public void setStartTimeFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'startTimeFilter' is null");
            throw new NullPointerException(START_TIME_FILTER);
        }
        String string2 = this.getStartTimeFilter();
        this.vetos.fireVetoableChange(START_TIME_FILTER, string2, string);
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        nPCPSelSplF.setStartTime(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("StartTime", string);
        }
        this.changes.firePropertyChange(START_TIME_FILTER, string2, string);
    }

    public void setUserFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'userFilter' is null");
            throw new NullPointerException(USER_FILTER);
        }
        if (string.length() > 10) {
            Trace.log(2, "Parameter 'userFilter' is greater than 10 characters in length.");
            throw new ExtendedIllegalArgumentException("userFilter(" + string + ")", 1);
        }
        String string2 = this.getUserFilter();
        this.vetos.fireVetoableChange(USER_FILTER, string2, string);
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        nPCPSelSplF.setUser(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("user", string);
        }
        this.changes.firePropertyChange(USER_FILTER, string2, string);
    }

    public void setUserDataFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'userDataFilter' is null");
            throw new NullPointerException(USER_DATA_FILTER);
        }
        if (string.length() > 10) {
            Trace.log(2, "Parameter 'userDataFilter' is greater than 10 characters in length.");
            throw new ExtendedIllegalArgumentException("userDataFilter(" + string + ")", 1);
        }
        String string2 = this.getUserDataFilter();
        this.vetos.fireVetoableChange(USER_DATA_FILTER, string2, string);
        NPCPSelSplF nPCPSelSplF = (NPCPSelSplF)this.getSelectionCP();
        nPCPSelSplF.setUserData(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("userData", string);
        }
        this.changes.firePropertyChange(USER_DATA_FILTER, string2, string);
    }
}

