/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPData;
import com.ibm.as400.access.NPCPIDOutQ;
import com.ibm.as400.access.NPCPIDPrinterFile;
import com.ibm.as400.access.NPCPIDSplF;
import com.ibm.as400.access.NPCPSplFHandle;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataAnalyzer;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.OutputQueueImplRemote;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterFileImpl;
import com.ibm.as400.access.PrinterFileImplRemote;
import com.ibm.as400.access.SpooledFileOutputStreamImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class SpooledFileOutputStreamImplRemote
implements SpooledFileOutputStreamImpl {
    static final String DT_AUTO = "*AUTO";
    static final String DT_PRTF = "*PRTF";
    private byte[] buffer_ = new byte[4096];
    private NPConversation conversation_;
    private NPCPAttribute cpAttr_;
    private NPCPAttribute cpCPFMsg_;
    private NPCPIDSplF cpIDSplF_;
    private NPCPIDOutQ cpIDOutQ_;
    private NPCPIDPrinterFile cpIDPrtrFile_;
    private NPCPSplFHandle cpSplFHndl_;
    private boolean fCreatePending_;
    private NPSystem npSystem_;
    private int offset_ = 0;
    private AS400ImplRemote sys_;

    SpooledFileOutputStreamImplRemote() {
    }

    @Override
    public synchronized void createSpooledFileOutputStream(AS400Impl aS400Impl, PrintParameterList printParameterList, PrinterFileImpl printerFileImpl, OutputQueueImpl outputQueueImpl) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.fCreatePending_ = true;
        this.sys_ = (AS400ImplRemote)aS400Impl;
        this.npSystem_ = NPSystem.getSystem(this.sys_);
        this.conversation_ = this.npSystem_.getConversation();
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpIDSplF_ = new NPCPIDSplF();
        this.cpSplFHndl_ = new NPCPSplFHandle();
        if (printerFileImpl != null) {
            this.cpIDPrtrFile_ = (NPCPIDPrinterFile)((PrinterFileImplRemote)printerFileImpl).getIDCodePoint();
        }
        if (outputQueueImpl != null) {
            this.cpIDOutQ_ = (NPCPIDOutQ)((OutputQueueImplRemote)outputQueueImpl).getIDCodePoint();
        }
        String string = null;
        this.cpAttr_ = new NPCPAttribute();
        if (printParameterList != null) {
            this.cpAttr_.addUpdateAttributes(printParameterList.getAttrCodePoint());
        }
        if ((string = (string = this.cpAttr_.getStringValue(90)) == null ? DT_AUTO : string.toUpperCase().trim()).equals(DT_AUTO)) {
            this.fCreatePending_ = true;
        } else {
            if (string.equals(DT_PRTF)) {
                string = "";
            }
            this.makeCreateRequest(string);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (this.offset_ != 0) {
            this.makeWriteRequest(this.buffer_, 0, this.offset_);
            this.offset_ = 0;
        }
        if (this.fCreatePending_) {
            this.makeCreateRequest(null);
        }
        NPDataStream nPDataStream = new NPDataStream(1);
        NPDataStream nPDataStream2 = new NPDataStream(1);
        nPDataStream.setAction(5);
        nPDataStream.addCodePoint(this.cpSplFHndl_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            this.conversation_.makeRequest(nPDataStream, nPDataStream2);
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
        finally {
            if (this.conversation_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.conversation_ = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.conversation_ != null) {
            if (!this.fCreatePending_) {
                NPDataStream nPDataStream = new NPDataStream(1);
                nPDataStream.setAction(5);
                nPDataStream.addCodePoint(this.cpSplFHndl_);
                AS400Server aS400Server = this.conversation_.getServer();
                if (aS400Server != null) {
                    nPDataStream.setConverter(this.conversation_.getConverter());
                    aS400Server.sendAndDiscardReply(nPDataStream);
                }
            }
            this.npSystem_.returnConversation(this.conversation_);
        }
        super.finalize();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.offset_ != 0) {
            this.makeWriteRequest(this.buffer_, 0, this.offset_);
            this.offset_ = 0;
        }
    }

    @Override
    public synchronized NPCPIDSplF getSpooledFile() throws IOException {
        NPCPIDSplF nPCPIDSplF = null;
        if (this.conversation_ != null) {
            this.flush();
        }
        if (this.fCreatePending_) {
            Trace.log(2, "Spooled File has not been created.");
            throw new ExtendedIllegalStateException(3);
        }
        nPCPIDSplF = this.cpIDSplF_;
        return nPCPIDSplF;
    }

    private synchronized void makeCreateRequest(String string) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (string != null && !string.equals("")) {
            if (this.cpAttr_ == null) {
                this.cpAttr_ = new NPCPAttribute();
            }
            this.cpAttr_.setAttrValue(90, string);
        }
        NPDataStream nPDataStream = new NPDataStream(1);
        NPDataStream nPDataStream2 = new NPDataStream(1);
        nPDataStream.setAction(1);
        if (this.cpAttr_ != null) {
            nPDataStream.addCodePoint(this.cpAttr_);
        }
        if (this.cpIDOutQ_ != null) {
            nPDataStream.addCodePoint(this.cpIDOutQ_);
        }
        if (this.cpIDPrtrFile_ != null) {
            nPDataStream.addCodePoint(this.cpIDPrtrFile_);
        }
        nPDataStream2.addCodePoint(this.cpSplFHndl_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        nPDataStream2.addCodePoint(this.cpIDSplF_);
        try {
            this.conversation_.makeRequest(nPDataStream, nPDataStream2);
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
        this.fCreatePending_ = false;
    }

    private synchronized void makeWriteRequest(byte[] byArray, int n, int n2) throws IOException {
        Object object;
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (this.fCreatePending_) {
            object = NPDataAnalyzer.sniff(byArray, n, n2);
            this.makeCreateRequest((String)object);
        }
        object = new NPDataStream(1);
        NPDataStream nPDataStream = new NPDataStream(1);
        NPCPData nPCPData = new NPCPData();
        nPCPData.setDataBuffer(byArray, n2, n);
        ((NPDataStream)object).setAction(4);
        ((NPDataStream)object).addCodePoint(this.cpSplFHndl_);
        ((NPDataStream)object).addCodePoint(nPCPData);
        nPDataStream.addCodePoint(this.cpCPFMsg_);
        try {
            this.conversation_.makeRequest((NPDataStream)object, nPDataStream);
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "SpooledFileOutputStream already closed.");
            throw new IOException();
        }
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            int n5 = this.buffer_.length - this.offset_;
            if (n5 >= n4) {
                System.arraycopy(byArray, n3, this.buffer_, this.offset_, n4);
                n3 += n4;
                this.offset_ += n4;
                n4 = 0;
                continue;
            }
            if (n5 != 0) {
                System.arraycopy(byArray, n3, this.buffer_, this.offset_, n5);
                n3 += n5;
                this.offset_ += n5;
                n4 -= n5;
            }
            if (this.offset_ == 0) continue;
            this.makeWriteRequest(this.buffer_, 0, this.offset_);
            this.offset_ = 0;
        }
    }
}

