/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.SystemValueInfo;
import com.ibm.as400.access.SystemValueList;
import com.ibm.as400.access.SystemValueUtility;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class SystemValueGroup
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 system_;
    private String groupName_;
    private String groupDescription_;
    private Vector infos_;
    private transient PropertyChangeSupport propertyChangeListeners_;
    private transient VetoableChangeSupport vetoableChangeListeners_;

    public SystemValueGroup() {
        this.system_ = null;
        this.groupName_ = null;
        this.groupDescription_ = null;
        this.infos_ = null;
        this.propertyChangeListeners_ = null;
        this.vetoableChangeListeners_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValueGroup object.");
        }
        this.infos_ = new Vector();
    }

    public SystemValueGroup(AS400 aS400, String string, String string2) {
        this.system_ = null;
        this.groupName_ = null;
        this.groupDescription_ = null;
        this.infos_ = null;
        this.propertyChangeListeners_ = null;
        this.vetoableChangeListeners_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValueGroup object, system: " + aS400 + ", group name: " + string);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'groupName' is null.");
            throw new NullPointerException("groupName");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'groupDescription' is null.");
            throw new NullPointerException("groupDescription");
        }
        this.system_ = aS400;
        this.groupName_ = string;
        this.groupDescription_ = string2;
        this.infos_ = new Vector();
    }

    public SystemValueGroup(AS400 aS400, String string, String string2, String[] stringArray) {
        this.system_ = null;
        this.groupName_ = null;
        this.groupDescription_ = null;
        this.infos_ = null;
        this.propertyChangeListeners_ = null;
        this.vetoableChangeListeners_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValueGroup object, system: " + aS400 + ", group name: " + string);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'groupName' is null.");
            throw new NullPointerException("groupName");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'groupDescription' is null.");
            throw new NullPointerException("groupDescription");
        }
        if (stringArray == null) {
            Trace.log(2, "Parameter 'names' is null.");
            throw new NullPointerException("names");
        }
        this.system_ = aS400;
        this.groupName_ = string;
        this.groupDescription_ = string2;
        this.infos_ = new Vector(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.add(stringArray[i]);
        }
    }

    public SystemValueGroup(AS400 aS400, String string, String string2, int n) {
        int n2;
        block13: {
            this.system_ = null;
            this.groupName_ = null;
            this.groupDescription_ = null;
            this.infos_ = null;
            this.propertyChangeListeners_ = null;
            this.vetoableChangeListeners_ = null;
            if (Trace.traceOn_) {
                Trace.log(1, "Constructing SystemValueGroup object, system: " + aS400 + ", group name: " + string + ", group:", n);
            }
            if (aS400 == null) {
                Trace.log(2, "Parameter 'system' is null.");
                throw new NullPointerException("system");
            }
            if (string == null) {
                Trace.log(2, "Parameter 'groupName' is null.");
                throw new NullPointerException("groupName");
            }
            if (string2 == null) {
                Trace.log(2, "Parameter 'groupDescription' is null.");
                throw new NullPointerException("groupDescription");
            }
            if (n < 0 || n > 9) {
                Trace.log(2, "Value of parameter 'group' is not valid:", n);
                throw new ExtendedIllegalArgumentException("group", 2);
            }
            this.system_ = aS400;
            this.groupName_ = string;
            this.groupDescription_ = string2;
            n2 = Integer.MAX_VALUE;
            try {
                n2 = aS400.getVRM();
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block13;
                Trace.log(4, "Couldn't retrieve VRM for system value group:", (Throwable)exception);
            }
        }
        Vector vector = SystemValueList.groups[n];
        int n3 = vector.size();
        this.infos_ = new Vector(n3);
        for (int i = 0; i < n3; ++i) {
            SystemValueInfo systemValueInfo = (SystemValueInfo)vector.elementAt(i);
            if (systemValueInfo.release_ > n2) continue;
            this.infos_.addElement(systemValueInfo);
        }
        if (n2 <= 327936) {
            switch (n) {
                case 5: {
                    this.infos_.removeElement(SystemValueList.lookup("QFRCCVNRST"));
                    break;
                }
                case 7: {
                    this.infos_.addElement(SystemValueList.lookup("QFRCCVNRST"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding to system value group, name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        SystemValueInfo systemValueInfo = SystemValueList.lookup(string.toUpperCase());
        Vector vector = this.infos_;
        synchronized (vector) {
            if (!this.infos_.contains(systemValueInfo)) {
                this.infos_.addElement(systemValueInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValueGroup systemValueGroup = this;
        synchronized (systemValueGroup) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValueGroup systemValueGroup = this;
        synchronized (systemValueGroup) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if system value group contains, name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        SystemValueInfo systemValueInfo = SystemValueList.lookup(string.toUpperCase());
        Vector vector = this.infos_;
        synchronized (vector) {
            return this.infos_.contains(systemValueInfo);
        }
    }

    public String getGroupDescription() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value group description: " + this.groupDescription_);
        }
        return this.groupDescription_;
    }

    public String getGroupName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value group name: " + this.groupName_);
        }
        return this.groupName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNames() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value group names.");
        }
        Vector vector = this.infos_;
        synchronized (vector) {
            int n = this.infos_.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((SystemValueInfo)this.infos_.elementAt((int)i)).name_;
            }
            return stringArray;
        }
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSystemValues() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system values, system: " + this.system_ + " group name: " + this.groupName_);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to system before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        Vector vector = null;
        Vector vector2 = this.infos_;
        synchronized (vector2) {
            vector = SystemValueUtility.retrieve(this.system_, this.infos_.elements(), this.groupName_, this.groupDescription_);
        }
        return SystemValueList.sort(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(Vector vector) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Vector<SystemValue> vector2;
        Serializable serializable;
        Serializable serializable2;
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing system values.");
        }
        if (vector == null) {
            Trace.log(2, "Parameter 'systemValues' is null.");
            throw new NullPointerException("systemValues");
        }
        Hashtable<AS400, Vector<SystemValue>> hashtable = null;
        Object object = vector;
        synchronized (object) {
            int n = vector.size();
            if (Trace.traceOn_) {
                Trace.log(1, "Number of system values:", n);
            }
            if (n == 0) {
                return;
            }
            hashtable = new Hashtable<AS400, Vector<SystemValue>>(n);
            for (int i = 0; i < n; ++i) {
                try {
                    serializable2 = (SystemValue)vector.elementAt(i);
                    serializable = ((SystemValue)serializable2).getSystem();
                    vector2 = (Vector<SystemValue>)hashtable.get(serializable);
                    if (vector2 == null) {
                        vector2 = new Vector<SystemValue>();
                        hashtable.put((AS400)serializable, vector2);
                    }
                    vector2.addElement((SystemValue)serializable2);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    Trace.log(2, "Type of element 'systemValues[" + i + "]' is not valid:", (Throwable)classCastException);
                    throw new ExtendedIllegalArgumentException("systemValues[" + i + "]", 2);
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Number of systems:", hashtable.size());
        }
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            SystemValue systemValue;
            int n;
            Serializable serializable3;
            AS400 aS400 = (AS400)object.nextElement();
            Vector vector3 = (Vector)hashtable.get(aS400);
            if (Trace.traceOn_) {
                Trace.log(1, "Refreshing, system: " + aS400 + ", number of values:", vector3.size());
            }
            serializable2 = new Vector();
            serializable = new Vector();
            vector2 = new Vector();
            Vector<Serializable> vector4 = new Vector<Serializable>();
            for (int i = 0; i < vector3.size(); ++i) {
                serializable3 = (SystemValue)vector3.elementAt(i);
                SystemValueInfo systemValueInfo = ((SystemValue)serializable3).info_;
                if (((SystemValue)serializable3).getGroup() == 8) {
                    ((Vector)serializable).addElement(systemValueInfo);
                    vector4.addElement(serializable3);
                    continue;
                }
                ((Vector)serializable2).addElement(systemValueInfo);
                vector2.addElement((SystemValue)serializable3);
            }
            Vector vector5 = new Vector();
            serializable3 = new Vector();
            if (((Vector)serializable2).size() > 0) {
                vector5 = SystemValueUtility.retrieveFromSystem(aS400, (Vector)serializable2, false);
            }
            if (((Vector)serializable).size() > 0) {
                serializable3 = SystemValueUtility.retrieveFromSystem(aS400, (Vector)serializable, true);
            }
            for (n = 0; n < ((Vector)serializable2).size(); ++n) {
                systemValue = (SystemValue)vector2.elementAt(n);
                systemValue.value_ = vector5.elementAt(n);
            }
            for (n = 0; n < ((Vector)serializable).size(); ++n) {
                systemValue = (SystemValue)vector4.elementAt(n);
                systemValue.value_ = ((Vector)serializable3).elementAt(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing from system value group, name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        SystemValueInfo systemValueInfo = SystemValueList.lookup(string.toUpperCase());
        Vector vector = this.infos_;
        synchronized (vector) {
            return this.infos_.removeElement(systemValueInfo);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setGroupDescription(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system value group description: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'groupDescription' is null.");
            throw new NullPointerException("groupDescription");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.groupDescription_ = string;
        } else {
            String string2 = this.groupDescription_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("groupDescription", string2, string3);
            }
            this.groupDescription_ = string;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("groupDescription", string2, string3);
            }
        }
    }

    public void setGroupName(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system value group name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'groupName' is null.");
            throw new NullPointerException("groupName");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.groupName_ = string;
        } else {
            String string2 = this.groupName_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("groupName", string2, string3);
            }
            this.groupName_ = string;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("groupName", string2, string3);
            }
        }
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS4003;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }

    public String toString() {
        Object object = "";
        if (this.groupName_ != null) {
            object = (String)object + this.groupName_ + " ";
        }
        object = (String)object + "{" + this.infos_.size() + "} ";
        if (this.groupDescription_ != null) {
            object = (String)object + this.groupDescription_ + " ";
        }
        if (this.system_ != null) {
            object = (String)object + this.system_ + " ";
        }
        object = (String)object + "[" + super.toString() + "]";
        return object;
    }
}

