/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ChangePasswordDialog;
import com.ibm.as400.access.MessageDialog;
import com.ibm.as400.access.PasswordDialog;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SignonEvent;
import com.ibm.as400.access.SignonHandlerAdapter;
import com.ibm.as400.access.Trace;
import java.awt.Frame;
import java.beans.PropertyVetoException;
import java.io.IOException;

final class ToolboxSignonHandler
extends SignonHandlerAdapter {
    private static final boolean DEBUG = false;
    private static final boolean PASSWORD_TRACE = false;
    private String systemName_ = "";
    private String userId_ = "";
    private boolean changingPassword_ = false;

    ToolboxSignonHandler() {
    }

    @Override
    public boolean connectionInitiated(SignonEvent signonEvent, boolean bl) {
        return this.handleSignon((AS400)signonEvent.getSource(), bl, false);
    }

    @Override
    public void exceptionOccurred(SignonEvent signonEvent) throws AS400SecurityException {
        AS400SecurityException aS400SecurityException = signonEvent.getException();
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            throw aS400SecurityException;
        }
        this.handleException(aS400, aS400SecurityException);
    }

    @Override
    public boolean passwordAboutToExpire(SignonEvent signonEvent, int n) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return true;
        }
        boolean bl = this.displayMessage(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("DLG_PASSWORD_EXP_WARNING"), Integer.toString(n)) + "  " + ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_PROMPT"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"), true);
        if (bl) {
            this.handlePasswordChange(aS400);
        }
        return true;
    }

    @Override
    public boolean passwordExpired(SignonEvent signonEvent) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        boolean bl = this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_EXPIRED") + "\n" + ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_PROMPT"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"), true);
        if (bl) {
            return this.handlePasswordChange(aS400);
        }
        return false;
    }

    @Override
    public boolean passwordIncorrect(SignonEvent signonEvent) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_INCORRECT"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(aS400, true, false);
    }

    @Override
    public boolean passwordLengthIncorrect(SignonEvent signonEvent) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_LENGTH_NOT_VALID"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(aS400, true, false);
    }

    @Override
    public boolean passwordMissing(SignonEvent signonEvent) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("DLG_MISSING_PASSWORD"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.connectionInitiated(signonEvent, true);
    }

    @Override
    public boolean systemNameMissing(SignonEvent signonEvent) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("DLG_MISSING_USERID"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(aS400, true, true);
    }

    @Override
    public boolean userIdAboutToBeDisabled(SignonEvent signonEvent) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_INCORRECT_USERID_DISABLE"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(aS400, true, false);
    }

    @Override
    public boolean userIdDefaultAlreadyAssigned(SignonEvent signonEvent, String string) {
        this.displayMessage(ResourceBundleLoader.getText("DLG_DEFAULT_USER_EXISTS"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        this.displayMessage(ResourceBundleLoader.getText("DLG_SET_DEFAULT_USER_FAILED"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return true;
    }

    @Override
    public boolean userIdDisabled(SignonEvent signonEvent) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_USERID_DISABLE"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(aS400, true, false);
    }

    @Override
    public boolean userIdLengthIncorrect(SignonEvent signonEvent) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_USERID_LENGTH_NOT_VALID"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(aS400, true, false);
    }

    @Override
    public boolean userIdMissing(SignonEvent signonEvent) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("DLG_MISSING_USERID"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(aS400, true, false);
    }

    @Override
    public boolean userIdUnknown(SignonEvent signonEvent) {
        AS400 aS400 = (AS400)signonEvent.getSource();
        if (!aS400.isGuiAvailable()) {
            return this.noGuiAvailable();
        }
        this.displayMessage(ResourceBundleLoader.getText("EXC_USERID_UNKNOWN"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
        return this.handleSignon(aS400, true, false);
    }

    private void displayMessage(String string, String string2) {
        this.displayMessage(string, string2, false);
    }

    private boolean displayMessage(String string, String string2, boolean bl) {
        MessageDialog messageDialog = new MessageDialog(new Frame(), string, string2, bl);
        return messageDialog.display();
    }

    private void handleException(AS400 aS400, AS400SecurityException aS400SecurityException) throws AS400SecurityException {
        switch (aS400SecurityException.getReturnCode()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 39: 
            case 44: 
            case 63: 
            case 65: {
                if (this.changingPassword_) {
                    this.displayMessage(aS400SecurityException.getMessage(), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
                    if (this.handlePasswordChange(aS400)) break;
                    throw aS400SecurityException;
                }
                this.displayMessage(aS400SecurityException.getMessage(), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
                if (this.handleSignon(aS400, true, false)) break;
                throw aS400SecurityException;
            }
            case 7: {
                boolean bl = this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_EXPIRED") + "\n" + ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_PROMPT"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"), true);
                if (bl) {
                    if (this.handlePasswordChange(aS400)) break;
                    throw aS400SecurityException;
                }
                throw aS400SecurityException;
            }
            default: {
                String string = this.changingPassword_ ? ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE") : ResourceBundleLoader.getText("DLG_SIGNON_TITLE");
                this.displayMessage(aS400SecurityException.getMessage(), string);
                throw aS400SecurityException;
            }
        }
    }

    private boolean handlePasswordChange(AS400 aS400) {
        ChangePasswordDialog changePasswordDialog = new ChangePasswordDialog(new Frame(), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
        boolean bl = false;
        boolean bl2 = false;
        do {
            String string;
            String string2;
            if (!changePasswordDialog.prompt(aS400.getSystemName(), aS400.getUserId())) {
                this.changingPassword_ = false;
                break;
            }
            String string3 = changePasswordDialog.getOldPassword();
            if (!this.validatePasswordInfo(string3, string2 = changePasswordDialog.getNewPassword(), string = changePasswordDialog.getConfirmPassword())) continue;
            this.changingPassword_ = true;
            try {
                aS400.changePassword(string3, string2);
            }
            catch (AS400SecurityException aS400SecurityException) {
                this.displayMessage(aS400SecurityException.getMessage(), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
                return this.handlePasswordChange(aS400);
            }
            catch (IOException iOException) {
                this.displayMessage(iOException.getMessage(), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
                return this.handlePasswordChange(aS400);
            }
            this.changingPassword_ = false;
            bl = true;
            bl2 = true;
        } while (!bl2);
        return bl;
    }

    private boolean handleSignon(AS400 aS400, boolean bl, boolean bl2) {
        if (!bl && aS400.getSystemName().length() != 0 && aS400.getUserId().length() != 0) {
            return true;
        }
        if (aS400.isGuiAvailable()) {
            if (Trace.traceOn_) {
                Trace.log(1, "Signing-on with prompting turned on.");
            }
            boolean bl3 = false;
            do {
                String string;
                String string2;
                PasswordDialog passwordDialog = this.setupPasswordDialog(aS400);
                if (bl2) {
                    passwordDialog.enableSystemNameField();
                }
                if (!passwordDialog.prompt()) {
                    return false;
                }
                String string3 = passwordDialog.getSystemName().trim();
                if (!this.validateInfo(string3, string2 = passwordDialog.getUserId().trim().toUpperCase(), string = passwordDialog.getPassword(), aS400)) continue;
                try {
                    this.systemName_ = string3;
                    aS400.setSystemName(this.systemName_);
                    if (string2.length() != 0) {
                        this.userId_ = string2;
                        aS400.setUserId(this.userId_);
                    }
                    if (string.length() != 0) {
                        aS400.setPassword(string);
                    }
                    if (passwordDialog.getDefaultState() && this.userId_.length() != 0) {
                        if (Trace.traceOn_) {
                            Trace.log(1, "Setting default user from dialog...");
                        }
                        if (!AS400.setDefaultUser(this.systemName_, this.userId_)) {
                            if (Trace.traceOn_) {
                                Trace.log(4, "Failed to set default user.");
                            }
                            if (aS400.isGuiAvailable()) {
                                this.displayMessage(ResourceBundleLoader.getText("DLG_DEFAULT_USER_EXISTS") + "\n\n" + ResourceBundleLoader.getText("DLG_SET_DEFAULT_USER_FAILED"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
                            }
                        }
                    }
                    if (Trace.traceOn_) {
                        Trace.log(1, "Setting password cache entry from dialog...");
                    }
                    aS400.setUsePasswordCache(passwordDialog.getPasswordCacheState());
                    bl3 = true;
                }
                catch (PropertyVetoException propertyVetoException) {
                    this.displayMessage(propertyVetoException.getMessage(), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
                    return this.handleSignon(aS400, bl, bl2);
                }
            } while (!bl3);
        } else if (Trace.traceOn_) {
            Trace.log(3, "No GUI is available to sign-on handler.");
        }
        return true;
    }

    private boolean noGuiAvailable() {
        Trace.log(2, "The internal Toolbox sign-on handler requires a GUI in order to gather new information.");
        return false;
    }

    private PasswordDialog setupPasswordDialog(AS400 aS400) {
        String string;
        PasswordDialog passwordDialog = new PasswordDialog(new Frame(), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"), aS400.isShowCheckboxes());
        String string2 = aS400.getSystemName();
        if (string2.length() == 0) {
            string2 = this.systemName_;
        }
        if (string2.length() == 0) {
            passwordDialog.enableDefaultUserCheckbox();
            passwordDialog.setDefaultUserState(false);
        } else {
            passwordDialog.setSystemName(string2);
            this.systemName_ = string2;
            if (AS400.getDefaultUser(string2) == null) {
                passwordDialog.enableDefaultUserCheckbox();
                passwordDialog.setDefaultUserState(true);
            } else {
                passwordDialog.disableDefaultUserCheckbox();
            }
        }
        passwordDialog.setPasswordCacheState(aS400.isUsePasswordCache());
        String string3 = aS400.getUserId();
        if (string3.length() == 0) {
            string3 = this.userId_;
        }
        if (string3.length() == 0 && string2.length() != 0 && (string = AS400.getDefaultUser(string2)) != null) {
            string3 = string;
        }
        if (string3.length() != 0) {
            passwordDialog.setUserId(string3);
            this.userId_ = string3;
        }
        return passwordDialog;
    }

    private boolean validateInfo(String string, String string2, String string3, AS400 aS400) {
        boolean bl = true;
        if (string.length() == 0 || !aS400.isUseDefaultUser() && string2.length() == 0 || !aS400.isUsePasswordCache() && string3.length() == 0) {
            this.displayMessage(ResourceBundleLoader.getText("DLG_MISSING_PASSWORD"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
            bl = false;
        } else if (string3.length() > 128) {
            Trace.log(2, "Length of password is greater than 128 characters: " + string3.length());
            this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_LENGTH_NOT_VALID"), ResourceBundleLoader.getText("DLG_SIGNON_TITLE"));
            bl = false;
        }
        return bl;
    }

    private boolean validatePasswordInfo(String string, String string2, String string3) {
        if (string.length() == 0 || string2.length() == 0 || string3.length() == 0) {
            this.displayMessage(ResourceBundleLoader.getText("DLG_MISSING_PASSWORD"), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
            return false;
        }
        if (!string2.equals(string3)) {
            this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_NOT_MATCH"), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
            return false;
        }
        if (string.length() > 128) {
            Trace.log(2, "Length of old password is greater than 128 characters: " + string.length());
            this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_LENGTH_NOT_VALID"), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
            return false;
        }
        if (string2.length() > 128) {
            Trace.log(2, "Length of new password is greater than 128 characters: " + string2.length());
            this.displayMessage(ResourceBundleLoader.getText("EXC_PASSWORD_NEW_NOT_VALID"), ResourceBundleLoader.getText("DLG_CHANGE_PASSWORD_TITLE"));
            return false;
        }
        return true;
    }
}

