/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.jdbcClient;

import com.ibm.as400.access.AS400JDBCSQLSyntaxErrorException;
import com.ibm.as400.access.JVMInfo;
import com.ibm.as400.access.jdbcClient.ClientBlob;
import com.ibm.as400.access.jdbcClient.ClientClob;
import com.ibm.as400.access.jdbcClient.ReflectionUtil;
import com.ibm.as400.access.jdbcClient.StringFormatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessControlException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.transaction.xa.XAException;

public class Main
implements Runnable {
    public static String[] knownDrivers = new String[]{"com.ibm.as400.access.AS400JDBCDriver", "com.ibm.db2.jdbc.app.DB2Driver", "com.ibm.jtopenlite.database.jdbc.JDBCDriver"};
    private static PrintStream defaultOutput = System.out;
    public static String usage = "Usage:  java -cp jt400.jar  com.ibm.as400.access.jdbcClient.Main <jdbcUrl> <userid> <password>\n        java -jar jt400.jar <jdbcUrl> <userid> <password>";
    public static String[] commandHelp = new String[]{"com.ibm.as400.access.jdbcClient.Main executes SQL commands using a JDBC connection.  ", "  This program is provided AS IS and formal support will NOT be provided.", "  This program should not be used in a production environment.", "", "Parameters are passed to a CALL procedure by using the following ", "CALL ... -- INPARM [p1]....    Calls the stored procedure with the specified parameters", "", "Using CL:  [as400 command] will use QSYS.QCMDEXEC to execute the as400 command ", "", "Besides SQL COMMANDS, the following COMMANDS and SUBCOMMANDS are available", "", "!USAGE                          Displays this information", "!HELP                           Displays this information", "!PREPARE [sql statement]        prepares an sql statement", "!EXECUTEQUERY                   Invokes executeQuery on the prepared statement", "!EXECUTEUPDATE                  Invokes executeUpdate on the prepared statement", "!SETPARM [index],[value]        Sets the parameter for the sql statement", "!SETPARMFROMVAR [index],[var]   Sets the parameter using a variable", "!SETRESULTSETTYPE [..]          Sets the results set type for prepare", "!SETRESULTSETCONCURRENCY [..]   ..", "!SETRESULTSETHOLDABILITY [..]   ..", "!REUSE STATEMENT [true|false]   Controls whethe the stmt object is reused", "!PROMPT [string]                Set the string to use for the prompt", "!ECHO [string]                  Echos the string", "!ECHOCOMMAND [true|false]       Should the input command be echod.", "!ECHOCOMMENTS [true|false]      Should the comments be echod.", "!PRINTSTACKTRACE [true|false]   Should the stack trace be printed for SQLExceptions.", "-- [string]                     Specifies a comment", "!SETQUERYTIMEOUT [number]       Sets the query timeout for subsequent statements", "!RESET CONNECTION PROPERTIES    Resets connection properties", "!ADD CONNECTION PROPERTY        Set properties to be used on subsequent connects", "!REUSE CONNECTION [true|false]  Should the connection be reused by connect to ", "!CONNECT TO URL [URL] [USERID=..] [PASSWORD=...]  Connect using the URL", "!CONNECT TO SCHEMA [schema]            Reconnect using the current URL to the specified schema", "!CONNECT RESET                  Closes the current connection", "!EXISTFILE                      Indicates if the specified file exists (on the client)", "!GC                             Force the Java garbage collector to run", "!OUTPUT FORMAT [xml | html]     Set the output format to include XML or HTML", "!SHOWMIXEDUX [true | false]     Set if mixed UX strings will be displayed", "!SET AUTOCOMMIT [true|false]    Sets the autocommit value", "!SET TRANSACTIONISOLATION [VALUE] Sets the autocommit value", "                                 Supported values are ", "                               TRANSACTION_READ_UNCOMMITTED", "                               TRANSACTION_READ_COMMITTED", "                               TRANSACTION_REPEATABLE_READ", "                               TRANSACTION_SERIALIZABLE", "!GETSERVERJOBNAME               Returns connection.getServerJobName", "!CLOSESTATEMENTRS [on|off]      Close statement and result set after execution of query default off", "!MEASUREEXECUTE [on|off]        Measure time to do execute", "!CHARACTERDETAILS [on|off]      Turn on to see entire character details -- default of off", "!MANUALFETCH [on|off]           Set if manual fetch operations should be used", "!RS.NEXT,!RS.FIRST, !RS.LAST, !RS.PREVIOUS, !RS.ABSOLUTE pos, !RS.RELATIVE pos, !RS.BEFOREFIRST, !RS.AFTERLAST", "                               Call rs.next,... for manually fetching", "!DMD.GETCOLUMNS catalog, schemaPattern, tableNamePattern, columnNamePattern ", "!DMD.GETTABLES catalog, schemaPattern, tableNamePattern, type1 | type2", "!DMD.GETINDEXINFO catalog, schema, table, booleanUnique, booleanApproximate ", "!DMD.GETSCHEMAS", "!HISTORY.CLEAR                    Clears the stored history", "!HISTORY.SHOW                     Shows the history of commands", "!SETCLITRACE [true|false]         Sets CLI tracing for native JDBC driver -- valid V5R5 and later", "!SETDB2TRACE [0|1|2|3|4]          Sets jdbc tracing for native JDBC driver  -- valid V5R5 and later", "!SYSTEMDEBUGGER                   Starts the system debugger (requires tes.jar on classpath)", "", "Parameters for prepared statements and callable statements may be specified in the following formats", "UX'....'                       Unicode string (in hexadecimal)", "X'....'                        Byte array (in hexademical)", "FILEBLOB=<filename>            A Blob retrieved from the named file", "FILECLOB=<filename>            A clob retrieved from the named file", "SAVEDPARM=<number>             A parameter from a previous CALL statement", "GEN_BYTE_ARRAY+<count>         A generated byte array of count bytes", "GEN_HEX_STRING+<count>         A generated hex string", "GEN_CHAR_ARRAY+<count>C<ccsid> A generated character string", "SQLARRAY[TYPE:e1:e2:...]       A JAVA.SQL.ARRAY type", "                               Types are String:BigDecimal:Date:Time:Timestamp:Blob:Clob:int:short:long:float:double:byteArray", "SQLARRAY[Time:e1 e2 ...]       A JAVA.SQL.ARRAY with time blank sep", "SQLARRAY[Timestamp:e1|e2 ...]  A JAVA.SQL.ARRAY with timestamp | sep", "", "The following prefixes are available", "!INVISIBLE:     The command and its results are not echoed", "!SILENT:        The exceptions and warnings from the command are not echoed", "!SILENTRS:      The result sets from the command are not echoed", "", "", "The following 'reflection' based commands are available", "!SETVAR [VARNAME] = [METHODCALL]  Sets a variable use a method.. i.e. ", "                                 SETVAR BLOB = RS.getBlob(1)", "!SETVAR [VARNAME] [PARAMETER SPECIFICATION] Sets a variable using a parameter specification", "!SETNEWVAR [VARNAME] = [CONSTRUCTORCALL]  Sets a variable by calling the contructor", "                                 SETNEWVAR DS = com.ibm.db2.jdbc.app.UDBDataSource()", "!SHOWVARMETHODS [VARNAME]         Shows the methods for a variable", "!CALLMETHOD [METHODCALL]          Calls a method on a variable", "  Hint:  To see a result set use !CALLMETHOD com.ibm.as400.access.jdbcClient.Main.dispResultSet(RS)", "  Hint:  To access an array use  !SETVAR LIST=java.util.Arrays.asList(ARRAYVARIABLE)", "", "!THREAD [COMMAND]                      Runs a command in its own thread.", "!THREADPERSIST [THREADNAME]            Create a thread that persist.", "!THREADEXEC [THREADNAME] [COMMAND]     Execute a command in a persistent thread.", "!REPEAT [NUMBER] [COMMAND]             Repeat a command a number of times.", "!EXIT_REPEAT_ON_EXCEPTION [false|true] Exit the repeat if an exception occurs. ", ""};
    String url_;
    String userid_;
    String password_;
    boolean prompt_ = true;
    String promptString_ = ">";
    boolean echoCommand_ = false;
    boolean printStackTrace_ = false;
    boolean exitRepeatOnException_ = false;
    boolean exceptionOccurred_ = false;
    int queryTimeout_ = 0;
    boolean measureExecute_ = false;
    boolean manualFetch_ = false;
    int resultSetType_ = 1003;
    int resultSetConcurrency_ = 1007;
    int resultSetHoldability_ = 1;
    boolean jdk16_ = false;
    private boolean hideWarnings_ = false;
    private boolean toolboxDriver_ = false;
    Connection connection_;
    Statement stmt_;
    private int manualResultSetNumCols_;
    private ResultSet manualResultSet_;
    private String[] manualResultSetColumnLabel_;
    private int showLobThreshold_ = 4096;
    private boolean characterDetails_ = false;
    private int stringSampleSize_ = 256;
    private boolean showMixedUX_;
    private int[] manualResultSetColType_;
    private boolean closeStatementRS_;
    private PreparedStatement pstmt_;
    private String[] savedStringParm_ = new String[256];
    private boolean echoComments_ = false;
    private String urlArgs_ = "";
    private boolean debug_ = false;
    private String conLabel_;
    private CallableStatement cstmt_;
    private String cstmtSql_;
    private Vector threads_ = new Vector();
    boolean html_ = false;
    boolean xml_ = false;
    private boolean silent_;
    private boolean silentrs_;
    private boolean useConnectionPool_ = false;
    private boolean reuseStatement_ = false;
    private Connection poolConnection = null;
    private String poolUserId = null;
    private String poolPassword = null;
    private String poolUrl = null;
    private Hashtable connectionPool = new Hashtable();
    private Hashtable variables = new Hashtable();
    private int conCount;
    private String conName = "CON";
    private Vector history = new Vector();
    String command_;
    PrintStream out_;
    private long startTime_;
    private long finishTime_;

    void initializeDefaults() {
        String string;
        try {
            string = System.getProperty("com.ibm.as400.access.jdbcClient.debug");
            if (string != null && (string = string.toUpperCase()).equals("TRUE")) {
                this.debug_ = true;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            string = System.getProperty("com.ibm.as400.access.jdbcClient.printStackTrace");
            if (string != null && (string = string.toUpperCase()).equals("TRUE")) {
                this.printStackTrace_ = true;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        for (int i = 0; i < knownDrivers.length; ++i) {
            try {
                Class.forName(knownDrivers[i]);
                continue;
            }
            catch (Exception exception) {
                if (!(this.debug_ | this.printStackTrace_)) continue;
                exception.printStackTrace();
            }
        }
        this.jdk16_ = JVMInfo.isJDK16();
        this.addVariable("MAIN", this);
        String string2 = null;
        try {
            string2 = System.getProperty("com.ibm.as400.access.jdbcClient.drivers");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        while (string2 != null) {
            String string3 = null;
            int n = string2.indexOf(":");
            if (n > 0) {
                string3 = string2.substring(0, n);
                if ((string2 = string2.substring(n + 1).trim()).length() == 0) {
                    string2 = null;
                }
            } else {
                string3 = string2;
                string2 = null;
            }
            try {
                Class.forName(string3);
            }
            catch (Exception exception) {
                System.out.println("Exception " + exception);
                if (!this.debug_ && !this.printStackTrace_) continue;
                exception.printStackTrace();
            }
        }
    }

    public Main(String string, String string2, String string3) throws SQLException {
        this.initializeDefaults();
        this.setUrl(string);
        this.userid_ = string2;
        this.password_ = string3;
        try {
            this.connection_ = DriverManager.getConnection(this.url_, this.userid_, this.password_);
            this.addVariable("CON", this.connection_);
        }
        catch (SQLException sQLException) {
            System.out.println("Warning:  Exception '" + sQLException.toString() + "' connecting to " + this.url_ + " using " + this.userid_);
            if (this.printStackTrace_) {
                sQLException.printStackTrace(System.out);
            }
            System.out.println("CON is not defined");
            this.connection_ = null;
        }
    }

    Main() {
        this.initializeDefaults();
    }

    public static String readLine(BufferedReader bufferedReader) throws Exception {
        String string = null;
        string = bufferedReader.readLine();
        if (string != null && string.indexOf("\\u") >= 0) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            int n3 = string.indexOf("\\u", n2);
            while (n3 >= 0) {
                stringBuffer.append(string.substring(n2, n3));
                if (n3 + 6 <= n) {
                    try {
                        stringBuffer.append(Main.getUnicodeCharacter(string, n3 + 2));
                    }
                    catch (SQLException sQLException) {
                        throw new SQLException("Escape sequence '" + string.substring(n3, n3 + 6) + "' invalid in " + string);
                    }
                } else {
                    throw new SQLException("Escape sequence '" + string.substring(n3) + "' invalid in " + string);
                }
                n2 = n3 + 6;
                n3 = string.indexOf("\\u", n2);
            }
            stringBuffer.append(string.substring(n2));
            string = stringBuffer.toString();
        }
        return string;
    }

    private static char getUnicodeCharacter(String string, int n) throws SQLException {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            char c = string.charAt(n + i);
            n2 = n2 * 16 + Main.hexValue(c);
        }
        return (char)n2;
    }

    private static int hexValue(char c) throws SQLException {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return 10 + c - 97;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return 10 + c - 65;
            }
        }
        throw new SQLException("invalid escape digit '" + c + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int go(InputStream inputStream, PrintStream printStream) {
        int n = 0;
        boolean bl = true;
        PrintStream printStream2 = defaultOutput;
        defaultOutput = printStream;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            if (this.prompt_) {
                printStream.print(this.promptString_);
            }
            try {
                string = Main.readLine(bufferedReader);
                if (string == null) {
                    bl = false;
                }
            }
            catch (SQLException sQLException) {
                printStream.println("Exception reading: " + sQLException.toString());
                if (this.printStackTrace_) {
                    sQLException.printStackTrace(printStream);
                }
                string = null;
            }
            while (bl) {
                if (string != null) {
                    bl = this.executeTopLevelCommand(string, printStream);
                }
                if (!bl) continue;
                if (this.prompt_) {
                    printStream.print(this.promptString_);
                }
                try {
                    string = Main.readLine(bufferedReader);
                    if (string != null) {
                        string = string.trim();
                        continue;
                    }
                    bl = false;
                }
                catch (SQLException sQLException) {
                    printStream.println("Exception reading: " + sQLException.toString());
                    if (this.printStackTrace_) {
                        sQLException.printStackTrace(printStream);
                    }
                    string = null;
                }
            }
            if (this.connection_ != null) {
                this.connection_.close();
                this.cstmt_ = null;
                this.cstmtSql_ = "";
                this.variables.remove("CSTMT");
            }
            this.connection_ = null;
            this.variables.remove("CON");
        }
        catch (Exception exception) {
            printStream.println("Outermost Exception " + exception);
            if (this.printStackTrace_) {
                exception.printStackTrace(printStream);
            }
        }
        catch (UnknownError unknownError) {
            printStream.println("Outermost UnknownError " + unknownError);
            if (this.printStackTrace_) {
                unknownError.printStackTrace(printStream);
            }
        }
        finally {
            defaultOutput = printStream2;
        }
        return n;
    }

    public Main(Main main, String string, PrintStream printStream) {
        this.inheritVariables(main);
        this.command_ = string;
        this.out_ = printStream;
    }

    private void inheritVariables(Main main) {
        this.variables = main.variables;
        this.url_ = main.url_;
        this.userid_ = main.userid_;
        this.password_ = main.password_;
        this.prompt_ = main.prompt_;
        this.echoCommand_ = main.echoCommand_;
        this.exitRepeatOnException_ = main.exitRepeatOnException_;
        this.printStackTrace_ = main.printStackTrace_;
        this.queryTimeout_ = main.queryTimeout_;
        this.measureExecute_ = main.measureExecute_;
        this.manualFetch_ = main.manualFetch_;
        this.resultSetType_ = main.resultSetType_;
        this.resultSetConcurrency_ = main.resultSetConcurrency_;
        this.resultSetHoldability_ = main.resultSetHoldability_;
        this.jdk16_ = main.jdk16_;
        this.hideWarnings_ = main.hideWarnings_;
        this.toolboxDriver_ = main.toolboxDriver_;
        this.connection_ = main.connection_;
        this.stmt_ = main.stmt_;
        this.manualResultSetNumCols_ = main.manualResultSetNumCols_;
        this.manualResultSet_ = main.manualResultSet_;
        this.manualResultSetColumnLabel_ = main.manualResultSetColumnLabel_;
        this.showLobThreshold_ = main.showLobThreshold_;
        this.characterDetails_ = main.characterDetails_;
        this.stringSampleSize_ = main.stringSampleSize_;
        this.showMixedUX_ = main.showMixedUX_;
        this.manualResultSetColType_ = main.manualResultSetColType_;
        this.closeStatementRS_ = main.closeStatementRS_;
        this.pstmt_ = main.pstmt_;
        this.savedStringParm_ = main.savedStringParm_;
        this.echoComments_ = main.echoComments_;
        this.urlArgs_ = main.urlArgs_;
        this.debug_ = main.debug_;
        this.conLabel_ = main.conLabel_;
        this.cstmt_ = main.cstmt_;
        this.cstmtSql_ = main.cstmtSql_;
        this.threads_ = main.threads_;
        this.html_ = main.html_;
        this.xml_ = main.xml_;
        this.useConnectionPool_ = main.useConnectionPool_;
        this.reuseStatement_ = main.reuseStatement_;
        this.poolConnection = main.poolConnection;
        this.poolUserId = main.poolUserId;
        this.poolPassword = main.poolPassword;
        this.poolUrl = main.poolUrl;
        this.connectionPool = main.connectionPool;
        this.conCount = main.conCount;
        this.conName = main.conName;
        this.silent_ = main.silent_;
        this.silentrs_ = main.silentrs_;
        this.history = main.history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        this.out_.println("Thread " + thread + " running " + this.command_);
        String string = this.command_.toUpperCase();
        if (string.startsWith("PERSIST")) {
            this.command_ = null;
            while (this.command_ == null) {
                Main main = this;
                synchronized (main) {
                    while (this.command_ == null) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.out_.println("Interrupted Exception : " + interruptedException);
                            if (!this.printStackTrace_) continue;
                            interruptedException.printStackTrace(this.out_);
                        }
                    }
                }
                string = this.command_.toUpperCase().trim();
                if (string.equals("QUIT") || string.equals("EXIT")) continue;
                this.out_.println("Thread " + thread + " running " + this.command_);
                this.executeTopLevelCommand(this.command_, this.out_);
                this.command_ = null;
            }
        } else {
            this.out_.println("Thread " + thread + " running " + this.command_);
            this.executeTopLevelCommand(this.command_, this.out_);
            this.out_.println("Thread " + thread + " ending");
        }
        this.out_.println("Thread " + thread + " ending");
    }

    public synchronized void setCommand(String string) {
        this.command_ = string;
        this.notify();
    }

    public void useConnectionPool(boolean bl) {
        this.useConnectionPool_ = bl;
    }

    public void setUrl(String string) {
        this.url_ = string;
        if (this.url_.indexOf(":as400:") > 0) {
            this.toolboxDriver_ = true;
        }
    }

    public void setUserId(String string) {
        if (this.debug_) {
            this.out_.println("User ID set to " + string);
        }
        this.userid_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public String removeProperty(String object, String string) {
        int n = string.indexOf("=");
        while (n > 0) {
            int n2;
            String string2 = string.substring(0, n).trim();
            int n3 = ((String)object).indexOf(string2);
            while (n3 > 0) {
                n2 = ((String)object).indexOf(";", n3);
                object = n2 > 0 ? ((String)object).substring(0, n3).trim() + ((String)object).substring(n2 + 1).trim() : ((String)object).substring(0, n3).trim();
                n3 = ((String)object).indexOf(string2);
            }
            n2 = string.indexOf(";", n);
            string = n2 > 0 ? string.substring(n2 + 1) : "";
            n = string.indexOf("=");
        }
        return object;
    }

    public void setManualResultSetColType(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.manualResultSetColType_ = new int[this.manualResultSetNumCols_ + 1];
        for (int i = 1; i <= this.manualResultSetNumCols_; ++i) {
            this.manualResultSetColType_[i] = resultSetMetaData.getColumnType(i);
        }
    }

    public Connection getPooledConnection(String string, String string2, String string3, PrintStream printStream) throws SQLException {
        if (this.poolConnection != null && string.equals(this.poolUserId) && string2.equals(this.poolPassword) && string3.equals(this.poolUrl)) {
            this.connection_ = this.poolConnection;
            this.addVariable("CON", this.connection_);
        } else {
            String string4;
            if (this.poolConnection != null) {
                string4 = this.poolUserId + "." + this.poolPassword + "." + this.poolUrl;
                this.connectionPool.put(string4, this.poolConnection);
                if (this.debug_) {
                    printStream.println("Added connection to pool for " + (String)string4);
                }
            }
            string4 = string + "." + string2 + "." + string3;
            this.connection_ = (Connection)this.connectionPool.get(string4);
            if (this.connection_ != null) {
                this.addVariable("CON", this.connection_);
                if (this.debug_) {
                    printStream.println("Retrieved connection from pool for " + string4);
                }
                this.connectionPool.remove(string4);
            } else {
                if (this.debug_) {
                    printStream.println("Didn't retrieve connection from pool for " + string4);
                }
                this.connection_ = string.equals("null") && string2.equals("null") ? DriverManager.getConnection(string3) : DriverManager.getConnection(string3, string, string2);
                this.addVariable("CON", this.connection_);
            }
            this.poolConnection = this.connection_;
            this.poolUserId = string;
            this.poolPassword = string2;
            this.poolUrl = string3;
        }
        return this.connection_;
    }

    void executeSqlQuery(String string, PrintStream printStream) throws Exception {
        this.history.addElement(string);
        if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
            if (this.stmt_ != null) {
                try {
                    this.stmt_.close();
                    this.stmt_ = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
            this.addVariable("STMT", this.stmt_);
        }
        if (this.queryTimeout_ != 0) {
            this.stmt_.setQueryTimeout(this.queryTimeout_);
        }
        if (this.stmt_ != null) {
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            ResultSet resultSet = this.stmt_.executeQuery(string);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("EXECUTE TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            SQLWarning sQLWarning = this.stmt_.getWarnings();
            if (this.manualFetch_) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.manualResultSetNumCols_ = resultSetMetaData.getColumnCount();
                this.setManualResultSetColType(resultSetMetaData);
                this.manualResultSet_ = resultSet;
                this.addVariable("RS", this.manualResultSet_);
                this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, false, this.manualResultSetNumCols_, this.html_, this.xml_, this.showMixedUX_, this.silentrs_);
            } else {
                this.dispResultSet(printStream, resultSet, false);
                if (sQLWarning != null && !this.silent_) {
                    Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                }
                if (this.closeStatementRS_) {
                    resultSet.close();
                }
            }
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("WITH FETCH TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
        } else {
            printStream.println("UNABLE to EXECUTE SELECT because not connected");
        }
    }

    public void executeCLCommand(String string, PrintStream printStream) throws Exception {
        this.history.addElement("CL: " + string);
        int n = string.length();
        String string2 = n < 10 ? "000000000" + n + ".00000" : (n < 100 ? "00000000" + n + ".00000" : (n < 1000 ? "0000000" + n + ".00000" : (n < 10000 ? "000000" + n + ".00000" : "00000" + n + ".00000")));
        String string3 = "CALL QSYS.QCMDEXC('" + string + "    ', " + string2 + ")";
        if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
            if (this.stmt_ != null) {
                this.stmt_.close();
                this.stmt_ = null;
            }
            this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
            this.addVariable("STMT", this.stmt_);
        }
        if (this.stmt_ != null) {
            SQLWarning sQLWarning;
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            this.stmt_.executeUpdate(string3);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            if ((sQLWarning = this.stmt_.getWarnings()) != null && !this.silent_) {
                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
            }
        } else {
            printStream.println("UNABLE to EXECUTE SELECT because not connected");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeCallCommand(String string, PrintStream printStream) throws Exception {
        this.history.addElement(string);
        if (this.connection_ != null) {
            block33: {
                ResultSet resultSet;
                int n;
                int n2;
                int n3 = string.indexOf("-- INPARM");
                String string2 = null;
                if (n3 > 0) {
                    string2 = string.substring(n3 + 9).trim();
                    string = string.substring(0, n3);
                }
                if (!string.equals(this.cstmtSql_)) {
                    this.cstmt_ = this.connection_.prepareCall(string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                    this.cstmtSql_ = string;
                    this.addVariable("CSTMT", this.cstmt_);
                }
                ParameterMetaData parameterMetaData = this.cstmt_.getParameterMetaData();
                int n4 = parameterMetaData.getParameterCount();
                for (n2 = 1; n2 <= n4; ++n2) {
                    int n5 = parameterMetaData.getParameterMode(n2);
                    if (n5 == 4 || n5 == 2) {
                        n = parameterMetaData.getParameterType(n2);
                        switch (n) {
                            case -8: 
                            case -4: 
                            case -3: 
                            case -2: 
                            case 16: 
                            case 2003: 
                            case 2004: {
                                this.cstmt_.registerOutParameter(n2, n);
                                break;
                            }
                            default: {
                                this.cstmt_.registerOutParameter(n2, 12);
                            }
                        }
                    }
                    if (n5 != 1 && n5 != 2) continue;
                    String string3 = string2;
                    if (string2 != null && (n3 = string2.indexOf(",")) >= 0) {
                        string3 = string2.substring(0, n3).trim();
                        string2 = string2.substring(n3 + 1).trim();
                    }
                    if (string3 != null) {
                        this.setParameter(this.cstmt_, string3, n2, printStream);
                        continue;
                    }
                    printStream.println("Warning:  thisParm is null");
                    printStream.println("--INPARM not found but num param > 0 ");
                }
                n2 = this.cstmt_.execute() ? 1 : 0;
                SQLWarning sQLWarning = this.cstmt_.getWarnings();
                if (sQLWarning != null) {
                    if (!this.silent_) {
                        Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                    }
                    if (this.html_) {
                        printStream.println("Statement was " + string);
                    }
                }
                block11: for (n = 1; n <= n4; ++n) {
                    int n6 = parameterMetaData.getParameterMode(n);
                    if (n6 != 4 && n6 != 2) continue;
                    int n7 = parameterMetaData.getParameterType(n);
                    switch (n7) {
                        case -8: 
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            printStream.print("Parameter " + n + " returned ");
                            byte[] byArray = this.cstmt_.getBytes(n);
                            if (byArray == null) {
                                printStream.println("null");
                                continue block11;
                            }
                            if (byArray.length < this.showLobThreshold_) {
                                printStream.print("X'");
                                for (int i = 0; i < byArray.length; ++i) {
                                    int n8 = 0xFF & byArray[i];
                                    if (n8 < 16) {
                                        printStream.print("0" + Integer.toHexString(n8));
                                        continue;
                                    }
                                    printStream.print(Integer.toHexString(n8));
                                }
                                printStream.println("'");
                                continue block11;
                            }
                            CRC32 cRC32 = new CRC32();
                            cRC32.update(byArray);
                            printStream.println("ARRAY[size=" + byArray.length + ",CRC32=" + cRC32.getValue() + "]");
                            continue block11;
                        }
                        case 2003: {
                            printStream.print("Parameter " + n + " returned ARRAY ");
                            this.printArray(printStream, this.cstmt_.getArray(n));
                            printStream.println();
                            continue block11;
                        }
                        case 16: {
                            printStream.print("Parameter " + n + " returned ");
                            boolean bl = this.cstmt_.getBoolean(n);
                            if (this.cstmt_.wasNull()) {
                                printStream.println("null");
                                continue block11;
                            }
                            if (bl) {
                                printStream.println("true");
                                continue block11;
                            }
                            printStream.println("false");
                            continue block11;
                        }
                        default: {
                            printStream.print("Parameter " + n + " returned ");
                            this.savedStringParm_[n] = this.cstmt_.getString(n);
                            this.printUnicodeString(printStream, this.savedStringParm_[n]);
                            printStream.println();
                        }
                    }
                }
                if (n2 != 0 && (resultSet = this.cstmt_.getResultSet()) != null) {
                    if (this.manualFetch_) {
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        this.manualResultSetNumCols_ = resultSetMetaData.getColumnCount();
                        this.setManualResultSetColType(resultSetMetaData);
                        this.manualResultSet_ = resultSet;
                        this.addVariable("RS", this.manualResultSet_);
                        this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, false, this.manualResultSetNumCols_, this.html_, this.xml_, this.showMixedUX_, this.silentrs_);
                    } else {
                        this.dispResultSet(printStream, resultSet, false);
                        if (this.closeStatementRS_) {
                            resultSet.close();
                            resultSet = null;
                        }
                    }
                    if (!this.manualFetch_) {
                        try {
                            while (this.cstmt_.getMoreResults()) {
                                printStream.println("<<<< NEXT RESULT SET >>>>>>>");
                                resultSet = this.cstmt_.getResultSet();
                                this.dispResultSet(printStream, resultSet, false);
                                if (!this.closeStatementRS_) continue;
                                resultSet.close();
                                resultSet = null;
                            }
                        }
                        catch (Exception exception) {
                            String string4 = exception.toString();
                            if (string4.indexOf("implemented") >= 0) break block33;
                            throw exception;
                        }
                    }
                }
            }
            if (!this.manualFetch_ && !this.closeStatementRS_) return;
        }
        printStream.println("UNABLE to EXECUTE CALL because not connected");
    }

    public void executeSqlCommand(String string, PrintStream printStream) throws Exception {
        if (this.connection_ != null) {
            SQLWarning sQLWarning;
            if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
                if (this.stmt_ != null) {
                    try {
                        this.stmt_.close();
                        this.stmt_ = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                this.addVariable("STMT", this.stmt_);
            }
            if (this.queryTimeout_ != 0) {
                this.stmt_.setQueryTimeout(this.queryTimeout_);
            }
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            this.stmt_.executeUpdate(string);
            this.history.addElement(string);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            if ((sQLWarning = this.stmt_.getWarnings()) != null && !this.silent_) {
                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
            }
        } else {
            printStream.println("UNABLE to EXECUTE because not connected");
        }
    }

    public void processException(SQLException sQLException, String string, PrintStream printStream) {
        if (!this.silent_) {
            printStream.println("\n*** SQLException caught ***");
            printStream.println("Statement was " + string);
            Throwable throwable = sQLException;
            while (throwable != null) {
                if (throwable instanceof SQLException) {
                    int n;
                    sQLException = throwable;
                    printStream.println("SQLState: " + sQLException.getSQLState());
                    String string2 = sQLException.getMessage();
                    string2 = Main.cleanupMessage(string2);
                    printStream.println("Message:  " + string2);
                    if (throwable instanceof AS400JDBCSQLSyntaxErrorException) {
                        AS400JDBCSQLSyntaxErrorException aS400JDBCSQLSyntaxErrorException = (AS400JDBCSQLSyntaxErrorException)throwable;
                        int n2 = aS400JDBCSQLSyntaxErrorException.getLocationOfSyntaxError();
                        String string3 = aS400JDBCSQLSyntaxErrorException.getSqlStatementText();
                        printStream.println("... Syntax error at " + n2 + " in " + string3);
                        if (n2 > 0 && string3 != null) {
                            try {
                                printStream.println("... " + string3.substring(0, n2 - 1) + "=====>" + string3.substring(n2 - 1));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    printStream.println("Vendor:   " + sQLException.getErrorCode());
                    if (this.debug_ || this.printStackTrace_) {
                        sQLException.printStackTrace(printStream);
                    }
                    if ((n = sQLException.getErrorCode()) == -104) {
                        printStream.println("\nToken not valid found.  Use !HELP to see what you can do");
                    }
                    if ((throwable = sQLException.getNextException()) == null) {
                        try {
                            throwable = sQLException.getCause();
                        }
                        catch (Throwable throwable2) {}
                    }
                } else if (throwable != null) {
                    printStream.println("Throwable: " + throwable);
                    if (this.printStackTrace_) {
                        throwable.printStackTrace(printStream);
                    }
                    try {
                        throwable = throwable.getCause();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                if (throwable != null) {
                    printStream.println("Next exception:");
                    continue;
                }
                printStream.println("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTopLevelCommand(String string, PrintStream printStream) {
        boolean bl = true;
        this.silent_ = false;
        this.silentrs_ = false;
        if ((string = string.trim()).toUpperCase().startsWith("!INVISIBLE:")) {
            this.silent_ = true;
            string = string.substring(11).trim();
        } else if (this.echoCommand_) {
            printStream.println(string);
            if (this.html_) {
                printStream.println("<BR>");
            }
        }
        if (string.toUpperCase().startsWith("!SILENT:")) {
            this.silent_ = true;
            string = string.substring(8).trim();
        }
        if (string.toUpperCase().startsWith("!SILENTRS:")) {
            this.silentrs_ = true;
            string = string.substring(10).trim();
        }
        try {
            String string2 = string.toUpperCase();
            if (string2.startsWith("SELECT") || string2.startsWith("VALUES") || string2.startsWith("WITH ")) {
                this.executeSqlQuery(string, printStream);
            } else if (string2.startsWith("CL:")) {
                String string3 = string.substring(3).trim();
                this.executeCLCommand(string3, printStream);
            } else if (string2.startsWith("!PROMPT")) {
                if (string.length() > 7) {
                    this.prompt_ = true;
                    this.promptString_ = string.substring(7).trim();
                } else {
                    this.prompt_ = false;
                }
            } else if (string2.startsWith("!ECHO") && !string2.startsWith("!ECHOCOMMAND") && !string2.startsWith("!ECHOCOMMENTS") || string2.startsWith("--") || string2.startsWith("//") || string2.startsWith("/*")) {
                this.history.addElement(string);
                if (this.echoComments_) {
                    printStream.println(string);
                    if (this.html_) {
                        printStream.println("<BR>");
                    }
                }
            } else if (string2.equals("!QUIT") || string2.equals("!EXIT") || string2.equals("QUIT") || string2.equals("EXIT")) {
                bl = false;
            } else if (string.length() > 0 && string.startsWith("!")) {
                string = string.substring(1);
                this.executeCommand(string, printStream);
            } else if (string2.startsWith("CALL ")) {
                this.executeCallCommand(string, printStream);
            } else if (string2.length() != 0) {
                this.executeSqlCommand(string, printStream);
            }
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred_ = true;
            this.processException(sQLException, string, printStream);
        }
        catch (Exception exception) {
            this.exceptionOccurred_ = true;
            printStream.println("\n*** exception caught *** " + exception);
            printStream.println("Statement was " + string);
            if (this.printStackTrace_) {
                exception.printStackTrace(printStream);
            }
        }
        catch (UnknownError unknownError) {
            this.exceptionOccurred_ = true;
            printStream.println("\n*** java.lang.UnknownError caught ***" + unknownError);
            printStream.println("Statement was " + string);
            if (this.printStackTrace_) {
                unknownError.printStackTrace(printStream);
            }
        }
        finally {
            block49: {
                if (this.stmt_ != null) {
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                    }
                    catch (Exception exception) {
                        printStream.println("Exception :" + exception);
                        if (!this.printStackTrace_) break block49;
                        exception.printStackTrace(printStream);
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeCommand(String string, PrintStream printStream) {
        boolean bl = true;
        this.silentrs_ = false;
        string = string.trim();
        try {
            String string2 = string.toUpperCase();
            if (string2.startsWith("PREPARE")) {
                this.history.addElement("!" + string);
                string = string.substring(7).trim();
                if (this.pstmt_ != null && this.closeStatementRS_) {
                    this.pstmt_.close();
                }
                this.pstmt_ = this.connection_.prepareStatement(string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                this.addVariable("PSTMT", this.pstmt_);
                return bl;
            }
            if (string2.startsWith("SETRESULTSETTYPE")) {
                this.history.addElement("!" + string);
                string = string.substring(16).trim();
                if (string.indexOf("FORWARD_ONLY") >= 0) {
                    this.resultSetType_ = 1003;
                    return bl;
                } else if (string.indexOf("SCROLL_INSENSITIVE") >= 0) {
                    this.resultSetType_ = 1004;
                    return bl;
                } else if (string.indexOf("SCROLL_SENSITIVE") >= 0) {
                    this.resultSetType_ = 1005;
                    return bl;
                } else {
                    printStream.println("Value of '" + string + " not valid use");
                    printStream.println("     FORWARD_ONLY, SCROLL_INSENSITIVE, or SCROLL_SENSITIVE");
                }
                return bl;
            }
            if (string2.startsWith("SETRESULTSETCONCURRENCY")) {
                this.history.addElement("!" + string);
                string = string.substring(15).trim();
                if (string.indexOf("READ_ONLY") >= 0) {
                    this.resultSetConcurrency_ = 1007;
                    return bl;
                } else if (string.indexOf("UPDATABLE") >= 0) {
                    this.resultSetConcurrency_ = 1008;
                    return bl;
                } else {
                    printStream.println("Value of '" + string + " not valid. Use");
                    printStream.println(" READ_ONLY or UPDATABLE ");
                }
                return bl;
            }
            if (string2.startsWith("SETRESULTSETHOLDABILITY")) {
                this.history.addElement("!" + string);
                string = string.substring(15).trim();
                if (string.indexOf("HOLD") >= 0) {
                    this.resultSetHoldability_ = 1;
                    return bl;
                } else if (string.indexOf("CLOSE") >= 0) {
                    this.resultSetHoldability_ = 2;
                    return bl;
                } else {
                    printStream.println("Value of '" + string + " not valid. Use");
                    printStream.println(" HOLD_CURSORS_OVER_COMMIT or CLOSE_CURSORS_AT_COMMIT");
                }
                return bl;
            }
            if (string2.startsWith("EXECUTEQUERY")) {
                this.history.addElement("!" + string);
                if (this.pstmt_ != null) {
                    if (this.measureExecute_) {
                        this.startTime_ = System.currentTimeMillis();
                    }
                    ResultSet resultSet = this.pstmt_.executeQuery();
                    if (this.measureExecute_) {
                        this.finishTime_ = System.currentTimeMillis();
                        printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                    }
                    if (this.manualFetch_) {
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        this.manualResultSetNumCols_ = resultSetMetaData.getColumnCount();
                        this.setManualResultSetColType(resultSetMetaData);
                        this.manualResultSet_ = resultSet;
                        this.addVariable("RS", this.manualResultSet_);
                        this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, false, this.manualResultSetNumCols_, this.html_, this.xml_, this.showMixedUX_, this.silentrs_);
                        return bl;
                    } else {
                        this.dispResultSet(printStream, resultSet, false);
                        SQLWarning sQLWarning = this.pstmt_.getWarnings();
                        if (sQLWarning != null && !this.silent_) {
                            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                        }
                        if (!this.closeStatementRS_) return bl;
                        resultSet.close();
                    }
                    return bl;
                } else {
                    printStream.println("UNABLE to EXECUTE QUERY because prepared statement does not exist");
                }
                return bl;
            }
            if (string2.startsWith("EXECUTEUPDATE")) {
                this.history.addElement("!" + string);
                if (this.pstmt_ != null) {
                    SQLWarning sQLWarning;
                    if (this.measureExecute_) {
                        this.startTime_ = System.currentTimeMillis();
                    }
                    this.pstmt_.executeUpdate();
                    if (this.measureExecute_) {
                        this.finishTime_ = System.currentTimeMillis();
                        printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                    }
                    if ((sQLWarning = this.pstmt_.getWarnings()) == null || this.silent_) return bl;
                    Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                    return bl;
                } else {
                    printStream.println("UNABLE to EXECUTE UPDATE because prepared statement does not exist");
                }
                return bl;
            }
            if (string2.startsWith("SETPARMFROMVAR")) {
                this.history.addElement("!" + string);
                if (this.pstmt_ != null) {
                    int n = (string = string.substring(14).trim()).indexOf(",");
                    if (n > 0) {
                        String string3 = string.substring(0, n).trim();
                        int n2 = Integer.parseInt(string3);
                        String string4 = string.substring(n + 1).trim();
                        Object v = this.variables.get(string4);
                        if (v != null) {
                            this.pstmt_.setObject(n2, v);
                            SQLWarning sQLWarning = this.pstmt_.getWarnings();
                            if (sQLWarning == null || this.silent_) return bl;
                            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                            return bl;
                        } else {
                            printStream.println("Unable to find object for variable " + string4);
                            this.showValidVariables(printStream);
                        }
                        return bl;
                    } else {
                        printStream.println("UNABLE to find comma for SETPARM  --> SETPARM [index],[value]");
                    }
                    return bl;
                } else {
                    printStream.println("UNABLE to SETPARM because prepared statement does not exist");
                }
                return bl;
            }
            if (string2.startsWith("SETPARM")) {
                this.history.addElement("!" + string);
                if (this.pstmt_ != null) {
                    int n = (string = string.substring(7).trim()).indexOf(",");
                    if (n > 0) {
                        String string5 = string.substring(0, n).trim();
                        int n3 = Integer.parseInt(string5);
                        String string6 = string.substring(n + 1).trim();
                        this.setParameter(this.pstmt_, string6, n3, printStream);
                        return bl;
                    } else {
                        printStream.println("UNABLE to find comma for SETPARM  --> SETPARM [index],[value]");
                    }
                    return bl;
                } else {
                    printStream.println("UNABLE to SETPARM because prepared statement does not exist");
                }
                return bl;
            }
            if (string2.startsWith("ECHO") && !string2.startsWith("ECHOCOMMAND") && !string2.startsWith("ECHOCOMMENTS") || string2.startsWith("--") || string2.startsWith("//") || string2.startsWith("/*")) {
                this.history.addElement("!" + string);
                if (!this.echoComments_) return bl;
                printStream.println(string);
                if (!this.html_) return bl;
                printStream.println("<BR>");
                return bl;
            }
            if (string2.startsWith("SETQUERYTIMEOUT")) {
                this.history.addElement("!" + string);
                String string7 = string.substring(16).trim();
                try {
                    this.queryTimeout_ = Integer.parseInt(string7);
                    printStream.println("-->Query timeout set to " + this.queryTimeout_);
                    return bl;
                }
                catch (Exception exception) {
                    printStream.println("Unable to parse (" + string7 + ")");
                }
                return bl;
            }
            if (string2.startsWith("RESET CONNECTION PROPERTIES")) {
                this.history.addElement("!" + string);
                this.urlArgs_ = "";
                return bl;
            }
            if (string2.startsWith("ADD CONNECTION PROPERTY")) {
                this.history.addElement("!" + string);
                String string8 = string.substring(23).trim();
                this.urlArgs_ = this.removeProperty(this.urlArgs_, string8);
                this.urlArgs_ = this.urlArgs_ + "; " + string8;
                return bl;
            }
            if (string2.startsWith("CONNECT TO URL")) {
                this.history.addElement("!" + string);
                if (this.connection_ != null && this.connection_ != this.poolConnection) {
                    this.connection_.close();
                    this.cstmt_ = null;
                    this.cstmtSql_ = "";
                    this.variables.remove("CSTMT");
                }
                String string9 = string.substring(14).trim();
                String string10 = null;
                String string11 = null;
                int n = string9.indexOf("USERID=");
                if (n > 0) {
                    int n4;
                    string10 = string9.substring(n + 7).trim();
                    string9 = string9.substring(0, n).trim();
                    int n5 = string10.indexOf(" ");
                    if (n5 >= 0) {
                        string10 = string10.substring(0, n5);
                    }
                    if ((n4 = string.indexOf("PASSWORD=")) > 0) {
                        string11 = string.substring(n4 + 9).trim();
                        n5 = string11.indexOf(" ");
                        if (n5 > 0) {
                            string11 = string11.substring(0, n5);
                        }
                        if (this.debug_) {
                            printStream.println("Connecting using " + this.userid_ + ", " + this.password_ + " to " + string9);
                        }
                        Driver driver = null;
                        try {
                            Object object;
                            if (string9.indexOf("jdbc:db2://") >= 0) {
                                if (this.debug_) {
                                    printStream.println("Loading jcc driver");
                                }
                                Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
                                object = DriverManager.getDriver(this.url_);
                                if (object.getClass().getName().equals("com.ibm.db2.jdbc.app.DB2Driver")) {
                                    if (this.debug_) {
                                        printStream.println("removing native driver");
                                    }
                                    driver = object;
                                    DriverManager.deregisterDriver(driver);
                                }
                            }
                            if (this.useConnectionPool_) {
                                this.connection_ = this.getPooledConnection(string10, string11, string9, printStream);
                            } else {
                                if (this.measureExecute_) {
                                    this.startTime_ = System.currentTimeMillis();
                                }
                                this.connection_ = DriverManager.getConnection(string9, string10, string11);
                                if (this.measureExecute_) {
                                    this.finishTime_ = System.currentTimeMillis();
                                    printStream.println("CONNECT TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                                }
                                this.addVariable("CON", this.connection_);
                                object = this.connection_.getWarnings();
                                if (object != null && !this.silent_) {
                                    Main.dispWarning(printStream, (SQLWarning)object, this.hideWarnings_, this.html_);
                                }
                            }
                        }
                        catch (Exception exception) {
                            printStream.println("Exception " + exception);
                            if (this.printStackTrace_) {
                                exception.printStackTrace(printStream);
                            }
                            string11 = null;
                        }
                        if (driver != null) {
                            DriverManager.registerDriver(driver);
                        }
                        this.conLabel_ = this.conName;
                        if (this.conCount > 0) {
                            this.conLabel_ = this.conLabel_ + this.conCount;
                        }
                        ++this.conCount;
                    }
                }
                if (string11 != null) return bl;
                printStream.println("Usage:  CONNECT TO URL [URL] [USERID=XXXX] [PASSWORD=YYYY]");
                printStream.println("  i.e.  CONNECT TO URL jdbc:db2:localhost USERID=MYUSER PASSWORD=XXXXX");
                printStream.println("        CONNECT TO URL jdbc:db2://localhost/*LOCAL USERID=MYUSER PASSWORD=XXXXX");
                printStream.println("        CONNECT TO URL jdbc:db2:SAMPLE\\;transaction isolation=serializable USERID=MYUSER PASSWORD=XXXXXXX");
                return bl;
            }
            if (string2.startsWith("CONNECT TO SCHEMA")) {
                String string12;
                Object object;
                int n;
                int n6;
                String string13;
                this.history.addElement("!" + string);
                if (this.connection_ != null) {
                    if (this.connection_ != this.poolConnection) {
                        this.connection_.close();
                        this.cstmt_ = null;
                        this.cstmtSql_ = "";
                        this.variables.remove("CSTMT");
                    }
                    this.connection_ = null;
                }
                if ((string13 = string.substring(17).trim()).length() > 0) {
                    n6 = string13.indexOf(47);
                    if (n6 >= 0) {
                        n = this.url_.indexOf(":");
                        n = this.url_.indexOf(":", n + 1);
                        object = this.url_.substring(0, n + 1);
                        string12 = (String)object + string13 + this.urlArgs_;
                    } else {
                        n = this.url_.indexOf(";");
                        string12 = n < 0 ? this.url_ + "/" + string13 + this.urlArgs_ : this.url_.substring(0, n) + "/" + string13 + this.url_.substring(n) + this.urlArgs_;
                    }
                } else {
                    string12 = this.url_ + this.urlArgs_;
                }
                n6 = string12.indexOf(" ;");
                while (n6 > 0) {
                    string12 = string12.substring(0, n6) + string12.substring(n6 + 1);
                    n6 = string12.indexOf(" ;");
                }
                if (this.userid_ != null) {
                    if (this.debug_) {
                        printStream.println("Connecting using " + this.userid_ + ", " + this.password_ + " to " + string12);
                    }
                    if (this.useConnectionPool_) {
                        this.connection_ = this.getPooledConnection(this.userid_, this.password_, string12, printStream);
                    } else {
                        SQLWarning sQLWarning;
                        if (this.measureExecute_) {
                            this.startTime_ = System.currentTimeMillis();
                        }
                        this.connection_ = DriverManager.getConnection(string12, this.userid_, this.password_);
                        if (this.measureExecute_) {
                            this.finishTime_ = System.currentTimeMillis();
                            printStream.println("CONNECT TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                        }
                        if ((sQLWarning = this.connection_.getWarnings()) != null && !this.silent_) {
                            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                        }
                    }
                    this.addVariable("CON", this.connection_);
                } else {
                    if (this.debug_) {
                        printStream.println("Connecting using default id and password to " + string12);
                    }
                    if (this.useConnectionPool_) {
                        this.connection_ = this.getPooledConnection("null", "null", string12, printStream);
                    } else {
                        this.connection_ = DriverManager.getConnection(string12);
                        SQLWarning sQLWarning = this.connection_.getWarnings();
                        if (sQLWarning != null && !this.silent_) {
                            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                        }
                    }
                    this.addVariable("CON", this.connection_);
                }
                this.conLabel_ = this.conName;
                if (this.conCount > 0) {
                    this.conLabel_ = this.conLabel_ + this.conCount;
                }
                ++this.conCount;
                int n7 = string13.indexOf(59);
                if (n7 > 0) {
                    string13 = string13.substring(0, n7).trim();
                }
                if (string13.length() <= 0) return bl;
                n = string13.lastIndexOf("/");
                if (n >= 0) {
                    string13 = string13.substring(n + 1);
                }
                object = this.connection_.prepareStatement("SET CURRENT PATH " + string13 + ", SYSTEM PATH");
                object.execute();
                object.close();
                return bl;
            }
            if (string2.startsWith("CONNECT RESET")) {
                this.history.addElement("!" + string);
                if (this.connection_ == null) return bl;
                if (this.connection_ != this.poolConnection) {
                    this.connection_.close();
                    this.cstmt_ = null;
                    this.cstmtSql_ = "";
                    this.variables.remove("CSTMT");
                }
                this.connection_ = null;
                this.variables.remove("CON");
                return bl;
            }
            if (string2.startsWith("CHARACTERDETAILS")) {
                this.history.addElement("!" + string);
                String string14 = string.substring(16).trim().toUpperCase();
                if (string14.equals("TRUE")) {
                    this.characterDetails_ = true;
                    return bl;
                } else if (string14.equals("ON")) {
                    this.characterDetails_ = true;
                    return bl;
                } else if (string14.equals("FALSE")) {
                    this.characterDetails_ = false;
                    return bl;
                } else if (string14.equals("OFF")) {
                    this.characterDetails_ = false;
                    return bl;
                } else {
                    printStream.println("Invalid arg '" + string14 + "' for CHARACTERDETAILS");
                }
                return bl;
            }
            if (string2.startsWith("ECHOCOMMAND")) {
                this.history.addElement("!" + string);
                String string15 = string.substring(11).trim().toUpperCase();
                if (string15.equals("TRUE")) {
                    this.echoCommand_ = true;
                    return bl;
                } else if (string15.equals("ON")) {
                    this.echoCommand_ = true;
                    return bl;
                } else if (string15.equals("FALSE")) {
                    this.echoCommand_ = false;
                    return bl;
                } else if (string15.equals("OFF")) {
                    this.echoCommand_ = false;
                    return bl;
                } else {
                    printStream.println("Invalid arg '" + string15 + "' for ECHOCOMMAND");
                }
                return bl;
            }
            if (string2.startsWith("ECHOCOMMENTS")) {
                this.history.addElement("!" + string);
                String string16 = string.substring(12).trim().toUpperCase();
                if (string16.equals("TRUE")) {
                    this.echoComments_ = true;
                    return bl;
                } else if (string16.equals("ON")) {
                    this.echoComments_ = true;
                    return bl;
                } else if (string16.equals("FALSE")) {
                    this.echoComments_ = false;
                    return bl;
                } else if (string16.equals("OFF")) {
                    this.echoComments_ = false;
                    return bl;
                } else {
                    printStream.println("Invalid arg '" + string16 + "' for ECHOCOMMENTS");
                }
                return bl;
            }
            if (string2.startsWith("EXIT_REPEAT_ON_EXCEPTION") || string2.startsWith("EXIT REPEAT ON EXCEPTION")) {
                this.history.addElement("!" + string);
                String string17 = string.substring(24).trim().toUpperCase();
                if (string17.equals("TRUE")) {
                    this.exitRepeatOnException_ = true;
                    return bl;
                } else if (string17.equals("ON")) {
                    this.exitRepeatOnException_ = true;
                    return bl;
                } else if (string17.equals("FALSE")) {
                    this.exitRepeatOnException_ = false;
                    return bl;
                } else if (string17.equals("OFF")) {
                    this.exitRepeatOnException_ = false;
                    return bl;
                } else {
                    printStream.println("Invalid arg '" + string17 + "' for EXIT REPEAT ON EXCEPTION");
                }
                return bl;
            }
            if (string2.startsWith("PRINTSTACKTRACE")) {
                this.history.addElement("!" + string);
                String string18 = string.substring(15).trim().toUpperCase();
                if (string18.equals("TRUE")) {
                    this.printStackTrace_ = true;
                    return bl;
                } else if (string18.equals("ON")) {
                    this.printStackTrace_ = true;
                    return bl;
                } else if (string18.equals("FALSE")) {
                    this.printStackTrace_ = false;
                    return bl;
                } else if (string18.equals("OFF")) {
                    this.printStackTrace_ = false;
                    return bl;
                } else {
                    printStream.println("Invalid arg '" + string18 + "' for PRINTSTACKTRACE");
                }
                return bl;
            }
            if (string2.startsWith("CLOSESTATEMENTRS")) {
                this.history.addElement("!" + string);
                String string19 = string.substring(16).trim().toUpperCase();
                if (string19.equals("TRUE")) {
                    this.closeStatementRS_ = true;
                    return bl;
                } else if (string19.equals("ON")) {
                    this.closeStatementRS_ = true;
                    return bl;
                } else if (string19.equals("FALSE")) {
                    this.closeStatementRS_ = false;
                    return bl;
                } else if (string19.equals("OFF")) {
                    this.closeStatementRS_ = false;
                    return bl;
                } else {
                    printStream.println("Invalid arg '" + string19 + "' for closeStatementRS");
                }
                return bl;
            }
            if (string2.startsWith("MEASUREEXECUTE")) {
                this.history.addElement("!" + string);
                String string20 = string.substring(14).trim().toUpperCase();
                if (string20.equals("TRUE")) {
                    this.measureExecute_ = true;
                    return bl;
                } else if (string20.equals("ON")) {
                    this.measureExecute_ = true;
                    return bl;
                } else if (string20.equals("FALSE")) {
                    this.measureExecute_ = false;
                    return bl;
                } else if (string20.equals("OFF")) {
                    this.measureExecute_ = false;
                    return bl;
                } else {
                    printStream.println("Invalid arg '" + string20 + "' for measureExecute");
                }
                return bl;
            }
            if (string2.startsWith("EXISTFILE")) {
                this.history.addElement("!" + string);
                String string21 = string.substring(9).trim();
                try {
                    File file = new File(string21);
                    if (file.exists()) {
                        printStream.println("EXISTFILE " + string21 + ": YES");
                        return bl;
                    }
                    printStream.println("EXISTFILE " + string21 + ": NO");
                    return bl;
                }
                catch (Exception exception) {
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) return bl;
                    exception.printStackTrace(printStream);
                }
                return bl;
            }
            if (string2.startsWith("GC")) {
                this.history.addElement("!" + string);
                this.startTime_ = System.currentTimeMillis();
                System.gc();
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("GC ran in " + (this.finishTime_ - this.startTime_) + " milliseconds");
                return bl;
            }
            if (string2.startsWith("OUTPUT FORMAT ")) {
                this.history.addElement("!" + string);
                String string22 = string.substring(14).trim().toUpperCase();
                if (string22.equals("XML")) {
                    this.xml_ = true;
                    this.html_ = false;
                    return bl;
                } else if (string22.equals("HTML")) {
                    this.html_ = true;
                    this.xml_ = false;
                    return bl;
                } else {
                    printStream.println("Error.  Did not recognize output format '" + string22 + "'");
                }
                return bl;
            }
            if (string2.startsWith("SHOWMIXEDUX ")) {
                this.history.addElement("!" + string);
                String string23 = string.substring(11).trim().toUpperCase();
                if (string23.equals("TRUE")) {
                    this.showMixedUX_ = true;
                    return bl;
                } else if (string23.equals("FALSE")) {
                    this.showMixedUX_ = false;
                    return bl;
                } else {
                    printStream.println("Error.  Did not recognize SHOWMIXEDUX value  '" + string23 + "'");
                }
                return bl;
            }
            if (string2.startsWith("QUIT") || string2.startsWith("EXIT")) {
                bl = false;
                return bl;
            }
            if (string2.startsWith("SET AUTOCOMMIT")) {
                this.history.addElement("!" + string);
                String string24 = string.substring(14).trim();
                if (string24.startsWith("true")) {
                    this.connection_.setAutoCommit(true);
                    return bl;
                } else if (string24.startsWith("false")) {
                    this.connection_.setAutoCommit(false);
                    return bl;
                } else {
                    printStream.println("SET AUTOCOMMIT:  Didn't understand \"" + string24 + "\"");
                    printStream.println("  Usage:  SET AUTOCOMMIT true");
                    printStream.println("          SET AUTOCOMMIT false");
                }
                return bl;
            }
            if (string2.startsWith("REUSE CONNECTION")) {
                this.history.addElement("!" + string);
                String string25 = string.substring(16).trim();
                if (string25.startsWith("true")) {
                    this.useConnectionPool_ = true;
                    return bl;
                } else if (string25.startsWith("false")) {
                    this.useConnectionPool_ = false;
                    return bl;
                } else {
                    printStream.println("REUSE CONNECTION:  Didn't understand \"" + string25 + "\"");
                    printStream.println("  Usage:  REUSE CONNECTION true");
                    printStream.println("          REUSE CONNECTION false");
                }
                return bl;
            }
            if (string2.startsWith("REUSE STATEMENT")) {
                this.history.addElement("!" + string);
                String string26 = string.substring(16).trim();
                if (string26.startsWith("true")) {
                    this.reuseStatement_ = true;
                    return bl;
                } else if (string26.startsWith("false")) {
                    this.reuseStatement_ = false;
                    return bl;
                } else {
                    printStream.println("REUSE STATEMENT:  Didn't understand \"" + string26 + "\"");
                    printStream.println("  Usage:  REUSE STATEMENT true");
                    printStream.println("          REUSE STATEMENT false");
                }
                return bl;
            }
            if (string2.startsWith("SETCLITRACE")) {
                this.history.addElement("!" + string);
                boolean bl2 = false;
                boolean bl3 = false;
                String string27 = string.substring(11).trim();
                if (string27.startsWith("true")) {
                    bl2 = true;
                    bl3 = true;
                } else if (string27.startsWith("false")) {
                    bl2 = false;
                    bl3 = true;
                }
                if (bl3) {
                    try {
                        Class<?> clazz = Class.forName("com.ibm.db2.jdbc.app.T");
                        Class[] classArray = new Class[]{Boolean.TYPE};
                        Method method = clazz.getMethod("setCliTrace", classArray);
                        Object[] objectArray = new Object[]{new Boolean(bl2)};
                        method.invoke(null, objectArray);
                        return bl;
                    }
                    catch (Exception exception) {
                        printStream.println("Exception while setting cli trace");
                        printStream.println("Exception " + exception);
                        if (!this.printStackTrace_) return bl;
                        exception.printStackTrace(printStream);
                    }
                    return bl;
                } else {
                    printStream.println("SETCLITRACE:  Didn't understand \"" + string27 + "\"");
                    printStream.println("  Usage:  SETCLITRACE true");
                    printStream.println("          SETCLITRACE false");
                }
                return bl;
            }
            if (string2.startsWith("SETDB2TRACE")) {
                this.history.addElement("!" + string);
                try {
                    String string28 = string.substring(11).trim();
                    Class<?> clazz = Class.forName("com.ibm.db2.jdbc.app.T");
                    Class[] classArray = new Class[]{Integer.TYPE};
                    Method method = clazz.getMethod("setDb2Trace", classArray);
                    Object[] objectArray = new Object[]{string28.startsWith("true") ? new Integer(3) : (string28.startsWith("false") ? new Integer(0) : new Integer(Integer.parseInt(string28)))};
                    method.invoke(null, objectArray);
                    return bl;
                }
                catch (Exception exception) {
                    printStream.println("Exception while setting cli trace");
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) return bl;
                    exception.printStackTrace(printStream);
                }
                return bl;
            }
            if (string2.startsWith("SYSTEMDEBUGGER")) {
                this.history.addElement("!" + string);
                try {
                    Class<?> clazz = Class.forName("com.ibm.iseries.debug.util.Util");
                    Class[] classArray = new Class[]{};
                    Method method = clazz.getMethod("registerApp", classArray);
                    Object[] objectArray = new Object[]{};
                    method.invoke(null, objectArray);
                    Class<?> clazz2 = Class.forName("utilities.Debug");
                    Class[] classArray2 = new Class[1];
                    objectArray = new Object[1];
                    String[] stringArray = new String[]{"-u", this.getUser(), "-s", this.getSystem(), "-j", this.getServerJobName()};
                    objectArray[0] = stringArray;
                    classArray2[0] = stringArray.getClass();
                    Method method2 = clazz2.getMethod("main", classArray2);
                    method2.invoke(null, objectArray);
                    return bl;
                }
                catch (Exception exception) {
                    printStream.println("Exception starting  SYSTEMDEBUGGER");
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) return bl;
                    exception.printStackTrace(printStream);
                }
                return bl;
            }
            if (string2.startsWith("SET TRANSACTIONISOLATION")) {
                this.history.addElement("!" + string);
                String string29 = string.substring(24).trim();
                if (string29.startsWith("TRANSACTION_READ_UNCOMMITTED")) {
                    this.connection_.setTransactionIsolation(1);
                    return bl;
                } else if (string29.startsWith("TRANSACTION_READ_COMMITTED")) {
                    this.connection_.setTransactionIsolation(2);
                    return bl;
                } else if (string29.startsWith("TRANSACTION_REPEATABLE_READ")) {
                    this.connection_.setTransactionIsolation(4);
                    return bl;
                } else if (string29.startsWith("TRANSACTION_SERIALIZABLE")) {
                    this.connection_.setTransactionIsolation(8);
                    return bl;
                } else {
                    printStream.println("SET TRANSACTIONISOLATION:  Didn't understand \"" + string29 + "\"");
                    printStream.println("  Usage:  SET TRANSACTIONISOLATION TRANSACTION_READ_UNCOMMITTED");
                    printStream.println("          SET TRANSACTIONISOLATION TRANSACTION_READ_COMMITTED");
                    printStream.println("          SET TRANSACTIONISOLATION TRANSACTION_REPEATABLE_READ");
                    printStream.println("          SET TRANSACTIONISOLATION TRANSACTION_SERIALIZABLE");
                }
                return bl;
            }
            if (string2.startsWith("USAGE") || string2.startsWith("HELP")) {
                for (int i = 0; i < commandHelp.length; ++i) {
                    printStream.println(commandHelp[i]);
                }
                return bl;
            }
            if (string2.startsWith("GETSERVERJOBNAME")) {
                this.history.addElement("!" + string);
                String string30 = this.getServerJobName();
                printStream.println("getServerJobName returned " + string30);
                return bl;
            }
            if (string2.startsWith("DMD.GETCOLUMNS")) {
                this.history.addElement("!" + string);
                try {
                    String string31 = null;
                    String string32 = null;
                    String string33 = null;
                    String string34 = null;
                    DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                    String string35 = string.substring(14).trim();
                    int n = string35.indexOf(",");
                    if (n > 0) {
                        string31 = string35.substring(0, n).trim();
                        if (string31.equals("null")) {
                            string31 = null;
                        }
                        if ((n = (string35 = string35.substring(n + 1)).indexOf(",")) > 0) {
                            string32 = string35.substring(0, n).trim();
                            if (string32.equals("null")) {
                                string32 = null;
                            }
                            if ((n = (string35 = string35.substring(n + 1)).indexOf(",")) > 0) {
                                string33 = string35.substring(0, n).trim();
                                if (string33.equals("null")) {
                                    string33 = null;
                                }
                                if ((string34 = string35.substring(n + 1).trim()).equals("null")) {
                                    string34 = null;
                                }
                            }
                        }
                    }
                    printStream.println("Calling dmd.getColumns(" + string31 + ", " + string32 + ", " + string33 + ", " + string34 + ")");
                    ResultSet resultSet = databaseMetaData.getColumns(string31, string32, string33, string34);
                    if (resultSet == null) return bl;
                    this.dispResultSet(printStream, resultSet, false);
                    resultSet.close();
                    return bl;
                }
                catch (Exception exception) {
                    printStream.println("databaseMetaData.getColumns failed with exception " + exception);
                    if (!this.printStackTrace_) return bl;
                    exception.printStackTrace(printStream);
                }
                return bl;
            }
            if (string2.startsWith("DMD.GETTABLES")) {
                this.history.addElement("!" + string);
                try {
                    Object object;
                    String string36 = null;
                    String string37 = null;
                    String string38 = null;
                    String string39 = null;
                    String[] stringArray = null;
                    DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                    String string40 = string.substring(14).trim();
                    int n = string40.indexOf(",");
                    if (n > 0) {
                        string36 = string40.substring(0, n).trim();
                        if (string36.equals("null")) {
                            string36 = null;
                        }
                        if ((n = (string40 = string40.substring(n + 1)).indexOf(",")) > 0) {
                            string37 = string40.substring(0, n).trim();
                            if (string37.equals("null")) {
                                string37 = null;
                            }
                            if ((n = (string40 = string40.substring(n + 1)).indexOf(",")) > 0) {
                                string38 = string40.substring(0, n).trim();
                                if (string38.equals("null")) {
                                    string38 = null;
                                }
                                if ((string39 = string40.substring(n + 1).trim()).equals("null")) {
                                    string39 = null;
                                } else {
                                    object = new Vector();
                                    int n8 = string39.indexOf(124);
                                    while (n8 > 0) {
                                        String string41 = string39.substring(0, n8);
                                        ((Vector)object).add(string41);
                                        string39 = string39.substring(1 + n8);
                                        n8 = string39.indexOf(124);
                                    }
                                    ((Vector)object).add(string39);
                                    int n9 = ((Vector)object).size();
                                    stringArray = new String[n9];
                                    for (int i = 0; i < n9; ++i) {
                                        stringArray[i] = (String)((Vector)object).elementAt(i);
                                    }
                                }
                            }
                        }
                    }
                    printStream.println("Calling dmd.getTables(" + string36 + ", " + string37 + ", " + string38 + ", " + string39 + "=" + StringFormatUtil.stringArrayContents(stringArray) + ")");
                    object = databaseMetaData.getTables(string36, string37, string38, stringArray);
                    if (object == null) return bl;
                    this.dispResultSet(printStream, (ResultSet)object, false);
                    object.close();
                    return bl;
                }
                catch (Exception exception) {
                    printStream.println("databaseMetaData.getTables failed with exception " + exception);
                    if (!this.printStackTrace_) return bl;
                    exception.printStackTrace(printStream);
                }
                return bl;
            }
            if (string2.startsWith("DMD.GETINDEXINFO")) {
                this.history.addElement("!" + string);
                try {
                    Object object;
                    String string42 = null;
                    String string43 = null;
                    String string44 = null;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                    String string45 = string.substring(16).trim();
                    int n = string45.indexOf(",");
                    if (n > 0) {
                        string42 = string45.substring(0, n).trim();
                        if (string42.equals("null")) {
                            string42 = null;
                        }
                        if ((n = (string45 = string45.substring(n + 1)).indexOf(",")) > 0) {
                            string43 = string45.substring(0, n).trim();
                            if (string43.equals("null")) {
                                string43 = null;
                            }
                            if ((n = (string45 = string45.substring(n + 1)).indexOf(",")) > 0) {
                                string44 = string45.substring(0, n).trim();
                                if (string44.equals("null")) {
                                    string44 = null;
                                }
                                if ((n = (string45 = string45.substring(n + 1)).indexOf(",")) > 0) {
                                    object = string45.substring(0, n).trim();
                                    bl4 = ((String)object).equalsIgnoreCase("true");
                                    String string46 = string45 = string45.substring(n + 1);
                                    bl5 = string46.equalsIgnoreCase("true");
                                }
                            }
                        }
                    }
                    printStream.println("Calling dmd.getIndexInfo(" + string42 + ", " + string43 + ", " + string44 + ", " + bl4 + "," + bl5 + ")");
                    object = databaseMetaData.getIndexInfo(string42, string43, string44, bl4, bl5);
                    if (object == null) return bl;
                    this.dispResultSet(printStream, (ResultSet)object, false);
                    object.close();
                    return bl;
                }
                catch (Exception exception) {
                    printStream.println("databaseMetaData.getIndexInfo failed with exception " + exception);
                    if (!this.printStackTrace_) return bl;
                    exception.printStackTrace(printStream);
                }
                return bl;
            }
            if (string2.startsWith("DMD.GETSCHEMAS")) {
                this.history.addElement("!" + string);
                try {
                    DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                    printStream.println("Calling dmd.getSchemas()");
                    ResultSet resultSet = databaseMetaData.getSchemas();
                    if (resultSet == null) return bl;
                    this.dispResultSet(printStream, resultSet, false);
                    resultSet.close();
                    return bl;
                }
                catch (Exception exception) {
                    printStream.println("databaseMetaData.getSchemas failed with exception " + exception);
                    if (!this.printStackTrace_) return bl;
                    exception.printStackTrace(printStream);
                }
                return bl;
            }
            if (string2.startsWith("HISTORY.CLEAR")) {
                this.history.clear();
                return bl;
            }
            if (string2.startsWith("HISTORY.SHOW")) {
                Enumeration enumeration = this.history.elements();
                while (enumeration.hasMoreElements()) {
                    String string47 = (String)enumeration.nextElement();
                    printStream.println(string47);
                }
                return bl;
            }
            if (string2.startsWith("MANUALFETCH")) {
                this.history.addElement("!" + string);
                String string48 = string.substring(11).trim().toUpperCase();
                if (string48.equals("TRUE")) {
                    this.manualFetch_ = true;
                    return bl;
                } else if (string48.equals("ON")) {
                    this.manualFetch_ = true;
                    return bl;
                } else if (string48.equals("FALSE")) {
                    this.manualFetch_ = false;
                    return bl;
                } else if (string48.equals("OFF")) {
                    this.manualFetch_ = false;
                    return bl;
                } else {
                    printStream.println("Invalid arg '" + string48 + "' for MANUALFETCH");
                }
                return bl;
            }
            if (string2.startsWith("RS.NEXT")) {
                this.history.addElement("!" + string);
                boolean bl6 = this.manualResultSet_.next();
                if (bl6) {
                    Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return bl;
                } else {
                    printStream.println("rs.next returned false");
                }
                return bl;
            }
            if (string2.startsWith("RS.FIRST")) {
                this.history.addElement("!" + string);
                boolean bl7 = this.manualResultSet_.first();
                if (bl7) {
                    Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return bl;
                } else {
                    printStream.println("rs.first returned false");
                }
                return bl;
            }
            if (string2.startsWith("RS.BEFOREFIRST")) {
                this.history.addElement("!" + string);
                this.manualResultSet_.beforeFirst();
                printStream.println("rs.beforeFirst called");
                return bl;
            }
            if (string2.startsWith("RS.AFTERLAST")) {
                this.history.addElement("!" + string);
                this.manualResultSet_.afterLast();
                printStream.println("rs.afterLast called");
                return bl;
            }
            if (string2.startsWith("RS.LAST")) {
                this.history.addElement("!" + string);
                boolean bl8 = this.manualResultSet_.last();
                if (bl8) {
                    Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return bl;
                } else {
                    printStream.println("rs.last returned false");
                }
                return bl;
            }
            if (string2.startsWith("RS.PREVIOUS")) {
                this.history.addElement("!" + string);
                boolean bl9 = this.manualResultSet_.previous();
                if (bl9) {
                    Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return bl;
                } else {
                    printStream.println("rs.previous returned false");
                }
                return bl;
            }
            if (string2.startsWith("RS.ABSOLUTE")) {
                this.history.addElement("!" + string);
                String string49 = string.substring(11).trim().toUpperCase();
                int n = Integer.parseInt(string49);
                boolean bl10 = this.manualResultSet_.absolute(n);
                if (bl10) {
                    Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return bl;
                } else {
                    printStream.println("rs.absolute returned false");
                }
                return bl;
            }
            if (string2.startsWith("RS.RELATIVE")) {
                this.history.addElement("!" + string);
                String string50 = string.substring(11).trim().toUpperCase();
                int n = Integer.parseInt(string50);
                boolean bl11 = this.manualResultSet_.relative(n);
                if (bl11) {
                    Main.dispRow(printStream, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return bl;
                } else {
                    printStream.println("rs.relative returned false");
                }
                return bl;
            }
            if (string2.startsWith("SETVAR")) {
                this.history.addElement("!" + string);
                try {
                    String string51 = string.substring(6).trim();
                    int n = string51.indexOf("=");
                    if (n > 0) {
                        String string52 = string51.substring(0, n).trim();
                        Object object = this.callMethod(string51 = string51.substring(n + 1), printStream);
                        if (object != null) {
                            this.addVariable(string52, object);
                            printStream.println(string52 + "=" + object.toString());
                            return bl;
                        } else {
                            printStream.println("ERROR:  Method not found or output is null");
                        }
                        return bl;
                    }
                    int n10 = string51.indexOf(" ");
                    if (n10 > 0) {
                        String string53 = string51.substring(0, n10).trim();
                        Object object = this.getParameterObject(string51 = string51.substring(n10 + 1), printStream);
                        if (object != null) {
                            this.addVariable(string53, object);
                            printStream.println(string53 + "=" + object.toString());
                            return bl;
                        } else {
                            printStream.println("ERROR:  Unable to get parameter ");
                        }
                        return bl;
                    }
                    printStream.println("ERROR:  '=' or ' ' not found after SETVAR [VAR]");
                    return bl;
                }
                catch (Exception exception) {
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) return bl;
                    exception.printStackTrace(printStream);
                }
                return bl;
            }
            if (string2.startsWith("SETNEWVAR")) {
                this.history.addElement("!" + string);
                try {
                    String string54 = string.substring(9).trim();
                    int n = string54.indexOf("=");
                    if (n > 0) {
                        String string55 = string54.substring(0, n).trim();
                        Object object = this.callNewMethod(string54 = string54.substring(n + 1), printStream);
                        if (object != null) {
                            this.addVariable(string55, object);
                            printStream.println(string55 + "=" + object.toString());
                            return bl;
                        } else {
                            printStream.println("ERROR:  Method not found or output is null");
                        }
                        return bl;
                    }
                    printStream.println("line missing =");
                    return bl;
                }
                catch (Exception exception) {
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) return bl;
                    exception.printStackTrace(printStream);
                }
                return bl;
            }
            if (string2.startsWith("SHOWVARMETHODS")) {
                this.history.addElement("!" + string);
                String string56 = string.substring(14).trim();
                this.showMethods(string56, printStream);
                return bl;
            } else if (string2.startsWith("THREAD ")) {
                this.history.addElement("!" + string);
                String string57 = string.substring(7).trim();
                printStream.println("Starting thread for " + string57);
                Main main = new Main(this, string57, printStream);
                Thread thread = new Thread(main);
                thread.start();
                this.threads_.add(thread);
                return bl;
            } else if (string2.startsWith("THREADPERSIST ")) {
                this.history.addElement("!" + string);
                String string58 = string.substring(14).trim();
                printStream.println("Starting runnable " + string58);
                String string59 = "PERSIST";
                Main main = new Main(this, string59, printStream);
                this.variables.put(string58, main);
                Thread thread = new Thread(main);
                thread.setName(string58);
                thread.setDaemon(true);
                thread.start();
                printStream.println("Started thread " + string58 + "-T");
                this.variables.put(string58 + "-T", thread);
                return bl;
            } else if (string2.startsWith("THREADEXEC ")) {
                this.history.addElement("!" + string);
                String string60 = string.substring(11).trim();
                int n = string60.indexOf(32);
                if (n > 0) {
                    String string61 = string60.substring(0, n);
                    String string62 = string60.substring(n + 1);
                    Main main = (Main)this.variables.get(string61);
                    if (main != null) {
                        main.setCommand(string62);
                        return bl;
                    } else {
                        printStream.println("ERROR: Unable to find thread " + string61);
                    }
                    return bl;
                } else {
                    printStream.println("ERROR:  THREADEXEC: no space after thread name");
                }
                return bl;
            } else if (string2.startsWith("REPEAT ")) {
                this.history.addElement("!" + string);
                String string63 = string.substring(7).trim();
                int n = string63.indexOf(" ");
                if (n > 0) {
                    int n11 = Integer.parseInt(string63.substring(0, n));
                    if (n11 > 0) {
                        String string64 = string63.substring(n).trim();
                        int n12 = n11;
                        int n13 = 1;
                        while (n11 > 0) {
                            printStream.println("Iteration " + n13 + " of " + n12);
                            ++n13;
                            this.exceptionOccurred_ = false;
                            this.executeTopLevelCommand(string64, printStream);
                            --n11;
                            if (!this.exitRepeatOnException_ || !this.exceptionOccurred_) continue;
                            n11 = 0;
                        }
                        return bl;
                    } else {
                        printStream.println("Error.. invalid repeat count " + string63.substring(0, n));
                    }
                    return bl;
                } else {
                    printStream.println("Error.  No count for repeat");
                }
                return bl;
            } else if (string2.startsWith("CALLMETHOD")) {
                int n;
                this.history.addElement("!" + string);
                String string65 = string.substring(10).trim();
                Object object = this.callMethod(string65, printStream);
                printStream.println("Call returned " + object);
                if (object != null && object instanceof InputStream) {
                    printStream.println("InputStream[ ");
                    InputStream inputStream = (InputStream)object;
                    n = inputStream.read();
                    while (n > 0) {
                        printStream.print(" " + Integer.toHexString(n));
                        n = inputStream.read();
                    }
                    printStream.println("]");
                }
                if (object == null || !object.getClass().isArray()) return bl;
                int n14 = Array.getLength(object);
                printStream.println("  .. Array of size " + n14);
                for (n = 0; n < n14; ++n) {
                    Object object2 = Array.get(object, n);
                    if (object2 instanceof DriverPropertyInfo) {
                        DriverPropertyInfo driverPropertyInfo = (DriverPropertyInfo)object2;
                        printStream.println("[" + n + "]=" + driverPropertyInfo.name + " " + driverPropertyInfo.value + " " + driverPropertyInfo.description);
                        continue;
                    }
                    if (object2 instanceof Byte) {
                        int n15 = 0xFF & ((Byte)object2).intValue();
                        printStream.println("[" + n + "]=0x" + Integer.toHexString(n15) + " a[" + StringFormatUtil.asciiChar(n15) + "] e[" + StringFormatUtil.ebcdicChar(n15) + "]");
                        continue;
                    }
                    printStream.println("[" + n + "][" + object2.getClass().getName() + "]=" + object2);
                }
                return bl;
            } else {
                if (string2.length() == 0) return bl;
                if (this.connection_ != null) {
                    SQLWarning sQLWarning;
                    if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
                        if (this.stmt_ != null) {
                            this.stmt_.close();
                            this.stmt_ = null;
                        }
                        this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                        this.addVariable("STMT", this.stmt_);
                    }
                    if (this.queryTimeout_ != 0) {
                        this.stmt_.setQueryTimeout(this.queryTimeout_);
                    }
                    if (this.measureExecute_) {
                        this.startTime_ = System.currentTimeMillis();
                    }
                    this.stmt_.executeUpdate(string);
                    this.history.addElement(string);
                    if (this.measureExecute_) {
                        this.finishTime_ = System.currentTimeMillis();
                        printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                    }
                    if ((sQLWarning = this.stmt_.getWarnings()) == null || this.silent_) return bl;
                    Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                    return bl;
                } else {
                    printStream.println("UNABLE to EXECUTE because not connected");
                }
            }
            return bl;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred_ = true;
            if (this.silent_) return bl;
            this.processException(sQLException, string, printStream);
            return bl;
        }
        catch (Exception exception) {
            this.exceptionOccurred_ = true;
            printStream.println("\n*** exception caught *** " + exception);
            printStream.println("Statement was " + string);
            if (!this.printStackTrace_) return bl;
            exception.printStackTrace(printStream);
            return bl;
        }
        catch (UnknownError unknownError) {
            this.exceptionOccurred_ = true;
            printStream.println("\n*** java.lang.UnknownError caught ***" + unknownError);
            printStream.println("Statement was " + string);
            if (!this.printStackTrace_) return bl;
            unknownError.printStackTrace(printStream);
            return bl;
        }
        finally {
            block353: {
                if (this.stmt_ != null) {
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                    }
                    catch (Exception exception) {
                        printStream.println("Exception " + exception);
                        if (!this.printStackTrace_) break block353;
                        exception.printStackTrace(printStream);
                    }
                }
            }
        }
    }

    private String getSystem() throws SQLException {
        String string = "";
        String string2 = this.connection_.getMetaData().getURL();
        if (string2.startsWith("jdbc:as400:")) {
            string = string2.substring(11);
            int n = string.indexOf(59);
            if (n > 0) {
                string = string.substring(0, n).replace('/', ' ').trim();
            }
        } else if (string2.startsWith("jdbc:db2:")) {
            string = "localhost";
        }
        return string;
    }

    private String getUser() throws Exception {
        return this.connection_.getMetaData().getUserName();
    }

    private String getServerJobName() {
        Object object;
        try {
            object = ReflectionUtil.callMethod_S(this.connection_, "getServerJobName");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                String string = databaseMetaData.getDriverName();
                if (string.indexOf("Toolbox") >= 0 || string.indexOf("jtopenlite") >= 0) {
                    try {
                        object = ReflectionUtil.callMethod_S(this.connection_, "getServerJobIdentifier");
                        if (((String)object).length() >= 26) {
                            object = ((String)object).substring(20).trim() + "/" + ((String)object).substring(10, 20).trim() + "/" + ((String)object).substring(0, 10).trim();
                        }
                    }
                    catch (Exception exception) {
                        return "server jobname is not available";
                    }
                }
                return "getServerJobName:3 failed with exception " + noSuchMethodException + " for driver " + string;
            }
            catch (Exception exception) {
                return "getServerJobName:2 failed with 2 exceptions " + noSuchMethodException + ":" + exception;
            }
        }
        catch (Exception exception) {
            return "getServerJobName:1 failed with exception " + exception;
        }
        return object;
    }

    private Object callMethod(String string, PrintStream printStream) {
        try {
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            Object object = null;
            int n = string.indexOf("(");
            if (n > 0) {
                int n2 = string.lastIndexOf(".", n);
                if (n2 > 0) {
                    String string2 = string.substring(0, n2).trim();
                    Object v = this.variables.get(string2);
                    Class<?> clazz = null;
                    string = string.substring(n2 + 1).trim();
                    n = string.indexOf("(");
                    String string3 = string.substring(0, n).trim();
                    string = string.substring(n + 1);
                    if (v == null) {
                        try {
                            clazz = Class.forName(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (v != null || clazz != null) {
                        if (n > 0) {
                            Method[] methodArray = v != null ? v.getClass().getMethods() : (clazz != null ? clazz.getMethods() : new Method[]{});
                            boolean bl2 = false;
                            for (int i = 0; !bl && i < methodArray.length && object == null; ++i) {
                                int n3 = 0;
                                int n4 = 0;
                                if (!methodArray[i].getName().equals(string3)) continue;
                                Class<?>[] classArray = methodArray[i].getParameterTypes();
                                String string4 = string;
                                Object[] objectArray = new Object[classArray.length];
                                bl = true;
                                bl2 = true;
                                n4 = classArray.length;
                                Object object2 = "";
                                for (n3 = 0; n3 < classArray.length; ++n3) {
                                    int n5;
                                    int n6;
                                    Object[] objectArray2;
                                    int n7;
                                    int n8;
                                    String string5;
                                    int n9 = 0;
                                    int n10 = 0;
                                    int n11 = 0;
                                    if (string4.length() > 1 && (string4.charAt(0) == '\"' || string4.charAt(0) == '\'')) {
                                        n9 = 1;
                                        n10 = string4.indexOf(string4.charAt(0), 1);
                                        if (n10 > 0) {
                                            if (string4.charAt(n10 + 1) == ',' || string4.charAt(n10 + 1) == ')') {
                                                n11 = n10 + 2;
                                            } else {
                                                stringBuffer.append("[,)] does not follow #" + string4.charAt(0) + "#\n");
                                                n10 = -1;
                                            }
                                        }
                                    } else {
                                        n10 = string4.indexOf(",");
                                        if (n10 < 0) {
                                            n10 = string4.indexOf(")");
                                        }
                                        if (n10 >= 0) {
                                            n11 = n10 + 1;
                                        }
                                    }
                                    if (n10 < 0) {
                                        bl = false;
                                        stringBuffer.append("Unable to find arg with remaining args " + string4 + "\n");
                                        stringBuffer.append("Number of parameters is " + classArray.length + "\n");
                                        bl = false;
                                        continue;
                                    }
                                    if (n9 > n10) continue;
                                    String string6 = string4.substring(n9, n10).trim();
                                    string4 = string4.substring(n11);
                                    Object v2 = this.variables.get(string6);
                                    if (v2 != null) {
                                        objectArray[n3] = v2;
                                        continue;
                                    }
                                    String string7 = classArray[n3].getName();
                                    object2 = (String)object2 + string7 + " ";
                                    if (string6.equals("null")) {
                                        objectArray[n3] = null;
                                        continue;
                                    }
                                    if (string7.equals("java.lang.String") || string7.equals("java.lang.Object")) {
                                        objectArray[n3] = string6;
                                        continue;
                                    }
                                    if (string7.equals("boolean")) {
                                        try {
                                            objectArray[n3] = new Boolean(string6);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string6 + " as integer\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string7.equals("short")) {
                                        try {
                                            objectArray[n3] = new Short(string6);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string6 + " as short\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string7.equals("int")) {
                                        try {
                                            objectArray[n3] = new Integer(string6);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string6 + " as integer\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string7.equals("long")) {
                                        try {
                                            objectArray[n3] = new Long(string6);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string6 + " as long\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string7.equals("float")) {
                                        try {
                                            objectArray[n3] = new Float(string6);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string6 + " as float\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string7.equals("double")) {
                                        try {
                                            objectArray[n3] = new Double(string6);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string6 + " as double\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string7.equals("[Ljava.lang.String;")) {
                                        if (string6.charAt(0) == '[') {
                                            string5 = string6.substring(1);
                                            n8 = string5.length();
                                            n7 = 1;
                                            for (int j = 0; j < n8; ++j) {
                                                if (string5.charAt(j) != '+') continue;
                                                ++n7;
                                            }
                                            objectArray[n3] = objectArray2 = new String[n7];
                                            int n12 = 0;
                                            n6 = 0;
                                            n5 = string5.indexOf(43, n6);
                                            if (n5 < 0) {
                                                n5 = string5.indexOf(93, n6);
                                            }
                                            while (n5 > 0) {
                                                if (n12 < n7) {
                                                    objectArray2[n12] = string5.substring(n6, n5);
                                                    ++n12;
                                                }
                                                if ((n6 = n5 + 1) >= n8) {
                                                    n5 = -1;
                                                    continue;
                                                }
                                                n5 = string5.indexOf(43, n6);
                                                if (n5 >= 0) continue;
                                                n5 = string5.indexOf(93, n6);
                                            }
                                            continue;
                                        }
                                        stringBuffer.append("Could not parse " + string6 + " as String array .. try [A+B+C]\n");
                                        bl = false;
                                        continue;
                                    }
                                    if (string7.equals("[I")) {
                                        if (string6.charAt(0) == '[') {
                                            string5 = string6.substring(1);
                                            n8 = string5.length();
                                            n7 = 1;
                                            for (int j = 0; j < n8; ++j) {
                                                if (string5.charAt(j) != '+') continue;
                                                ++n7;
                                            }
                                            objectArray[n3] = objectArray2 = (Object[])new int[n7];
                                            String string8 = "";
                                            try {
                                                n6 = 0;
                                                n5 = 0;
                                                int n13 = string5.indexOf(43, n5);
                                                if (n13 < 0) {
                                                    n13 = string5.indexOf(93, n5);
                                                }
                                                while (n13 > 0) {
                                                    if (n6 < n7) {
                                                        objectArray2[n6] = (String)Integer.parseInt(string5.substring(n5, n13));
                                                        ++n6;
                                                    }
                                                    if ((n5 = n13 + 1) >= n8) {
                                                        n13 = -1;
                                                        continue;
                                                    }
                                                    n13 = string5.indexOf(43, n5);
                                                    if (n13 >= 0) continue;
                                                    n13 = string5.indexOf(93, n5);
                                                }
                                                continue;
                                            }
                                            catch (Exception exception) {
                                                stringBuffer.append("Exception " + exception + " piece = " + string8 + "\n");
                                                stringBuffer.append("Could not parse " + string6 + " as Integer.. try [1+2+3]\n");
                                                bl = false;
                                                continue;
                                            }
                                        }
                                        stringBuffer.append("Could not parse " + string6 + " as Integer.. try [1+2+3]\n");
                                        bl = false;
                                        continue;
                                    }
                                    stringBuffer.append("Did not handle parameter with class " + string7 + "\n");
                                    bl = false;
                                }
                                if (bl) {
                                    if (n3 == n4) {
                                        if (string4.trim().equals(")") || string4.trim().length() == 0) {
                                            try {
                                                methodArray[i].setAccessible(true);
                                                object = methodArray[i].invoke(v, objectArray);
                                            }
                                            catch (Exception exception) {
                                                Exception exception2;
                                                Throwable throwable;
                                                if (exception instanceof InvocationTargetException && (throwable = exception.getCause()) != null && throwable instanceof Exception) {
                                                    exception2 = (Exception)throwable;
                                                }
                                                if (exception2 instanceof XAException) {
                                                    stringBuffer.append("XAException:" + exception2.toString() + " code=" + this.getXACodeInfo((XAException)exception2) + "\n");
                                                }
                                                stringBuffer.append("Exception " + exception2 + "\n");
                                                if (this.printStackTrace_) {
                                                    Main.printStackTraceToStringBuffer(exception2, stringBuffer);
                                                }
                                                stringBuffer.append("Calling method " + string3 + " with " + (String)object2 + " failed\n");
                                                bl = false;
                                            }
                                            continue;
                                        }
                                        stringBuffer.append("Not calling method " + string3 + " with " + (String)object2 + " because argsLeft = " + string4 + "\n");
                                        bl = false;
                                        continue;
                                    }
                                    stringBuffer.append("Not calling method " + string3 + " with " + (String)object2 + " because parsed parameter count = " + n3 + "\n");
                                    continue;
                                }
                                stringBuffer.append("Method not found " + string3 + "\n");
                            }
                            if (!bl2) {
                                stringBuffer.append("ERROR:  Method not found " + string3 + "\n");
                            }
                        } else {
                            stringBuffer.append("ERROR:  could find ( in " + string + "\n");
                        }
                    } else {
                        printStream.println("ERROR:  could not find variable or class " + string2);
                        this.showValidVariables(printStream);
                    }
                } else {
                    stringBuffer.append("ERROR:  could find . in " + string);
                }
            } else {
                stringBuffer.append("ERROR:  could find ( in " + string);
            }
            if (!bl) {
                printStream.println("No matching method found, possible errors are the following:\n" + stringBuffer.toString());
            }
            return object;
        }
        catch (Exception exception) {
            this.exceptionOccurred_ = true;
            printStream.println("Unexpected exception");
            printStream.println("Exception " + exception);
            if (this.printStackTrace_) {
                exception.printStackTrace(printStream);
            }
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.exceptionOccurred_ = true;
            printStream.println("NoClassDefFoundError " + noClassDefFoundError);
            if (this.printStackTrace_) {
                noClassDefFoundError.printStackTrace(printStream);
            }
            return null;
        }
    }

    private String getXACodeInfo(XAException xAException) {
        int n = xAException.errorCode;
        switch (n) {
            case 7: {
                return "XA_HEURCOM : The transaction branch has been heuristically committed.";
            }
            case 8: {
                return "XA_HEURHAZ : The transaction branch may have been heuristically completed.";
            }
            case 5: {
                return "XA_HEURMIX : The transaction branch has been heuristically committed and rolled back.";
            }
            case 6: {
                return "XA_HEURRB : The transaction branch has been heuristically rolled back.";
            }
            case 9: {
                return "XA_NOMIGRATE : Resumption must occur where the suspension occurred.";
            }
            case 101: {
                return "XA_RBCOMMFAIL : Indicates that the rollback was caused by a communication failure.";
            }
            case 102: {
                return "XA_RBDEADLOCK : A deadlock was detected.";
            }
            case 103: {
                return "XA_RBINTEGRITY : A condition that violates the integrity of the resource was detected.";
            }
            case 104: {
                return "XA_RBOTHER : The resource manager rolled back the transaction branch for a reason not on this list.";
            }
            case 105: {
                return "XA_RBPROTO : A protocol error occurred in the resource manager.";
            }
            case 100: {
                return "XA_RBROLLBACK : Indicates that the rollback was caused by an unspecified reason.";
            }
            case 106: {
                return "XA_RBTIMEOUT : A transaction branch took too long.";
            }
            case 107: {
                return "XA_RBTRANSIENT : May retry the transaction branch.";
            }
            case 3: {
                return "XA_RDONLY : The transaction branch was read-only and has been committed.";
            }
            case 4: {
                return "XA_RETRY : Routine returned with no effect and may be reissued.";
            }
            case -2: {
                return "XAER_ASYNC : There is an asynchronous operation already outstanding.";
            }
            case -8: {
                return "XAER_DUPID : The XID already exists.";
            }
            case -5: {
                return "XAER_INVAL : Invalid arguments were given.";
            }
            case -4: {
                return "XAER_NOTA : The XID is not valid.";
            }
            case -9: {
                return "XAER_OUTSIDE : The resource manager is doing work outside a global transaction.";
            }
            case -6: {
                return "XAER_PROTO : Routine was invoked in an improper context.";
            }
            case -3: {
                return "XAER_RMERR : A resource manager error has occurred in the transaction branch.";
            }
            case -7: {
                return "XAER_RMFAIL : Resource manager is unavailable.";
            }
        }
        return "" + n;
    }

    public static void printStackTraceToStringBuffer(Throwable throwable, StringBuffer stringBuffer) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = stringWriter.toString();
        stringBuffer.append(string);
    }

    private Object callNewMethod(String string, PrintStream printStream) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            Object var5_7 = null;
            int n = string.indexOf("(");
            if (n > 0) {
                String string2 = string.substring(0, n).trim();
                Class<?> clazz = null;
                string = string.substring(n + 1);
                try {
                    clazz = Class.forName(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (clazz != null) {
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    for (int i = 0; !bl && i < constructorArray.length && var5_7 == null; ++i) {
                        Class<?>[] classArray = constructorArray[i].getParameterTypes();
                        String string3 = string;
                        Object[] objectArray = new Object[classArray.length];
                        bl = true;
                        Object object = "(";
                        for (int j = 0; j < classArray.length; ++j) {
                            int n2;
                            int n3;
                            Object[] objectArray2;
                            int n4;
                            int n5;
                            String string4;
                            int n6 = 0;
                            int n7 = 0;
                            int n8 = 0;
                            if (string3.length() > 1 && string3.charAt(0) == '\"') {
                                n6 = 1;
                                n7 = string3.indexOf(34, 1);
                                if (n7 > 0) {
                                    if (string3.charAt(n7 + 1) == ',' || string3.charAt(n7 + 1) == ')') {
                                        n8 = n7 + 2;
                                    } else {
                                        stringBuffer.append("[,)] does not follow \n");
                                        n7 = -1;
                                    }
                                }
                            } else {
                                n7 = string3.indexOf(",");
                                if (n7 < 0) {
                                    n7 = string3.indexOf(")");
                                }
                                if (n7 >= 0) {
                                    n8 = n7 + 1;
                                }
                            }
                            if (n7 < 0) {
                                bl = false;
                                stringBuffer.append("Unable to find arg in " + string3 + "\n");
                                continue;
                            }
                            String string5 = string3.substring(n6, n7).trim();
                            string3 = string3.substring(n8);
                            String string6 = classArray[j].getName();
                            if (j > 0) {
                                object = (String)object + ",";
                            }
                            object = (String)object + string6;
                            Object v = this.variables.get(string5);
                            if (v != null) {
                                objectArray[j] = v;
                                continue;
                            }
                            if (string5.equals("null")) {
                                objectArray[j] = null;
                                continue;
                            }
                            if (string6.equals("java.lang.String")) {
                                objectArray[j] = string5;
                                continue;
                            }
                            if (string6.equals("int")) {
                                try {
                                    objectArray[j] = new Integer(string5);
                                }
                                catch (Exception exception) {
                                    stringBuffer.append("Could not parse " + string5 + " as integer\n");
                                    bl = false;
                                }
                                continue;
                            }
                            if (string6.equals("boolean")) {
                                try {
                                    objectArray[j] = new Boolean(string5);
                                }
                                catch (Exception exception) {
                                    stringBuffer.append("Could not parse " + string5 + " as integer\n");
                                    bl = false;
                                }
                                continue;
                            }
                            if (string6.equals("long")) {
                                try {
                                    objectArray[j] = new Long(string5);
                                }
                                catch (Exception exception) {
                                    stringBuffer.append("Could not parse " + string5 + " as long\n");
                                    bl = false;
                                }
                                continue;
                            }
                            if (string6.equals("[Ljava.lang.String;")) {
                                if (string5.charAt(0) == '[') {
                                    string4 = string5.substring(1);
                                    n5 = string4.length();
                                    n4 = 1;
                                    for (int k = 0; k < n5; ++k) {
                                        if (string4.charAt(k) != '+') continue;
                                        ++n4;
                                    }
                                    objectArray[j] = objectArray2 = new String[n4];
                                    int n9 = 0;
                                    n3 = 0;
                                    n2 = string4.indexOf(43, n3);
                                    if (n2 < 0) {
                                        n2 = string4.indexOf(93, n3);
                                    }
                                    while (n2 > 0) {
                                        if (n9 < n4) {
                                            objectArray2[n9] = string4.substring(n3, n2);
                                            ++n9;
                                        }
                                        if ((n3 = n2 + 1) >= n5) {
                                            n2 = -1;
                                            continue;
                                        }
                                        n2 = string4.indexOf(43, n3);
                                        if (n2 >= 0) continue;
                                        n2 = string4.indexOf(93, n3);
                                    }
                                    continue;
                                }
                                stringBuffer.append("Could not parse " + string5 + " as String array .. try [A+B+C]\n");
                                bl = false;
                                continue;
                            }
                            if (string6.equals("[I")) {
                                if (string5.charAt(0) == '[') {
                                    string4 = string5.substring(1);
                                    n5 = string4.length();
                                    n4 = 1;
                                    for (int k = 0; k < n5; ++k) {
                                        if (string4.charAt(k) != '+') continue;
                                        ++n4;
                                    }
                                    objectArray[j] = objectArray2 = (Object[])new int[n4];
                                    String string7 = "";
                                    try {
                                        n3 = 0;
                                        n2 = 0;
                                        int n10 = string4.indexOf(43, n2);
                                        if (n10 < 0) {
                                            n10 = string4.indexOf(93, n2);
                                        }
                                        while (n10 > 0) {
                                            if (n3 < n4) {
                                                objectArray2[n3] = (String)Integer.parseInt(string4.substring(n2, n10));
                                                ++n3;
                                            }
                                            if ((n2 = n10 + 1) >= n5) {
                                                n10 = -1;
                                                continue;
                                            }
                                            n10 = string4.indexOf(43, n2);
                                            if (n10 >= 0) continue;
                                            n10 = string4.indexOf(93, n2);
                                        }
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        stringBuffer.append("Exception " + exception + " piece = " + string7 + "\n");
                                        stringBuffer.append("Could not parse " + string5 + " as Integer.. try [1+2+3]\n");
                                        bl = false;
                                        continue;
                                    }
                                }
                                stringBuffer.append("Could not parse " + string5 + " as Integer.. try [1+2+3\n]");
                                bl = false;
                                continue;
                            }
                            stringBuffer.append("Did not handle parameter with class " + string6);
                            bl = false;
                        }
                        object = (String)object + ")";
                        if (!bl) continue;
                        if (string3.trim().equals(")") || string3.trim().length() == 0) {
                            try {
                                var5_7 = constructorArray[i].newInstance(objectArray);
                                bl = true;
                            }
                            catch (Exception exception) {
                                stringBuffer.append("Exception " + exception + "\n");
                                if (this.printStackTrace_) {
                                    Main.printStackTraceToStringBuffer(exception, stringBuffer);
                                }
                                for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
                                    stringBuffer.append("..Caused by " + throwable + "\n");
                                    if (!this.printStackTrace_) continue;
                                    Main.printStackTraceToStringBuffer(throwable, stringBuffer);
                                }
                                stringBuffer.append("Creating object  with " + (String)object + " failed\n");
                                bl = false;
                            }
                            continue;
                        }
                        stringBuffer.append("Not calling constructor  with " + (String)object + " because argsLeft = " + string3 + "\n");
                        bl = false;
                    }
                } else {
                    stringBuffer.append("ERROR:  could not find variable or class " + string2 + "\n");
                }
            } else {
                stringBuffer.append("ERROR:  could find ( in " + string + "\n");
            }
            if (!bl) {
                printStream.println("Unable to call method: Possible errors are the following\n" + stringBuffer.toString());
            }
            return var5_7;
        }
        catch (Exception exception) {
            printStream.println("Unexpected exception");
            printStream.println("Exception " + exception);
            if (this.printStackTrace_) {
                exception.printStackTrace(printStream);
            }
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            printStream.println("NoClassDefFoundError " + noClassDefFoundError);
            if (this.printStackTrace_) {
                noClassDefFoundError.printStackTrace(printStream);
            }
            return null;
        }
    }

    private void showValidVariables(PrintStream printStream) {
        printStream.println("Valid variables are the following");
        Enumeration enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            printStream.println(enumeration.nextElement());
        }
    }

    private void showMethods(String string, PrintStream printStream) {
        String string2 = string.trim();
        Object v = this.variables.get(string2);
        Class<?> clazz = null;
        if (v == null) {
            try {
                clazz = Class.forName(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (v != null || clazz != null) {
            Object object;
            Method[] methodArray = v != null ? v.getClass().getMethods() : (clazz != null ? clazz.getMethods() : new Method[]{});
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?> clazz2 = methodArray[i].getReturnType();
                object = methodArray[i].getName();
                Object object2 = clazz2 != null ? " @RETURNS " + clazz2.getName() : " @RETURNS void";
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                object = (String)object + "(";
                for (int j = 0; j < classArray.length; ++j) {
                    String string3 = classArray[j].getName();
                    if (j > 0) {
                        object = (String)object + ",";
                    }
                    object = (String)object + string3;
                }
                object = (String)object + ")" + (String)object2;
                vector.addElement(object);
            }
            Collections.sort(vector);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                int n = ((String)object).indexOf(" @RETURNS ");
                if (n > 0) {
                    printStream.println(((String)object).substring(n + 10) + " " + ((String)object).substring(0, n));
                    continue;
                }
                printStream.println((String)object);
            }
        } else {
            printStream.println("Could not find variable " + string2);
            this.showValidVariables(printStream);
        }
    }

    private static String[] dispColumnHeadings(PrintStream printStream, ResultSet resultSet, ResultSetMetaData resultSetMetaData, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append("<table border>\n");
        }
        String[] stringArray = new String[n + 1];
        for (int i = 1; i <= n; ++i) {
            stringArray[i] = resultSetMetaData.getColumnLabel(i);
            if (bl2) {
                stringBuffer.append("<th>" + stringArray[i].replace('_', ' '));
                continue;
            }
            if (bl3) continue;
            if (i > 1) {
                stringBuffer.append(",");
            }
            Main.appendUnicodeString(stringBuffer, stringArray[i], 65535, 65535, true, bl4);
        }
        if (bl2) {
            stringBuffer.append("<tr>\n");
        }
        if (bl3) {
            stringBuffer.append("<table>");
            if (!bl5) {
                printStream.println(stringBuffer.toString());
            }
        } else {
            stringBuffer.append("");
            if (!bl5) {
                printStream.println(stringBuffer.toString());
            }
        }
        return stringArray;
    }

    private static void dispRow(PrintStream printStream, ResultSet resultSet, boolean bl, int n, int[] nArray, String[] stringArray, String[] stringArray2, boolean bl2, boolean bl3, int n2, int n3, boolean bl4, boolean bl5, boolean bl6) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append("<row>\n");
        }
        for (int i = 1; i <= n; ++i) {
            if (bl3) {
                stringBuffer.append("<td>");
            } else if (bl2) {
                stringBuffer.append("   <" + stringArray[i] + ">");
            } else if (i > 1) {
                stringBuffer.append(",");
            }
            switch (nArray[i]) {
                case 2004: {
                    int n4;
                    Object object = resultSet.getBlob(i);
                    if (object != null && object.getClass().getName().equals("com.ibm.db2.jdbc.app.DB2BlobLocator")) {
                        try {
                            n4 = ReflectionUtil.callMethod_I(object, "getLocator");
                            stringBuffer.append("L#" + n4 + ":");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                case -8: 
                case -4: 
                case -3: 
                case -2: {
                    int n4;
                    Object object = resultSet.getBytes(i);
                    if (object == null) {
                        stringBuffer.append(resultSet.getString(i));
                        break;
                    }
                    if (((Object)object).length < n2) {
                        for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                            int n5 = object[n4] & 0xFF;
                            if (n5 >= 16) {
                                stringBuffer.append(Integer.toHexString(n5));
                                continue;
                            }
                            stringBuffer.append("0" + Integer.toHexString(n5));
                        }
                        break;
                    }
                    CRC32 cRC32 = new CRC32();
                    cRC32.update((byte[])object);
                    stringBuffer.append("ARRAY[size=" + ((Object)object).length + ",CRC32=" + cRC32.getValue() + "]");
                    break;
                }
                case 16: {
                    boolean bl7 = resultSet.getBoolean(i);
                    if (resultSet.wasNull()) {
                        stringBuffer.append("null");
                        break;
                    }
                    if (bl7) {
                        stringBuffer.append("true");
                        break;
                    }
                    stringBuffer.append("false");
                    break;
                }
                default: {
                    String string = resultSet.getString(i);
                    if (bl && string != null) {
                        string = string.trim();
                    }
                    if (stringArray2 != null && i - 1 < stringArray2.length && stringArray2[i - 1] != null) {
                        string = Main.formatString(string, stringArray2[i - 1]);
                    }
                    Main.appendUnicodeString(stringBuffer, string, n2, n3, bl4, bl5);
                }
            }
            if (!bl2) continue;
            stringBuffer.append("</" + stringArray[i] + ">\n");
        }
        if (bl3) {
            if (!bl6) {
                printStream.println(stringBuffer.toString() + "<tr>");
            }
        } else if (bl2) {
            if (!bl6) {
                printStream.println(stringBuffer.toString() + "</row>");
            }
        } else if (!bl6) {
            printStream.println(stringBuffer.toString());
        }
    }

    private static String stripTS(String string) {
        string = string.replace(' ', '-');
        int n = (string = string.replace(':', '.')).indexOf(".000000");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static String formatString(String string, String string2) {
        if (string2 != null) {
            int n = string2.indexOf("{STUFF}");
            if (n > 0) {
                return Main.formatString(string, string2.substring(0, n)) + string + Main.formatString(string, string2.substring(n + 7));
            }
            if (n == 0) {
                return string + Main.formatString(string, string2.substring(n + 7));
            }
            n = string2.indexOf("{STRIPPEDTS}");
            if (n > 0) {
                return Main.formatString(string, string2.substring(0, n)) + Main.stripTS(string) + Main.formatString(string, string2.substring(n + 12));
            }
            if (n == 0) {
                return Main.stripTS(string) + Main.formatString(string, string2.substring(n + 12));
            }
            n = string2.indexOf("{PART");
            if (n >= 0) {
                int n2 = string2.indexOf("}", n);
                int n3 = n2 - n + 1;
                int n4 = string2.charAt(n + 5) - 48;
                String string3 = string2.substring(n + 9, n2);
                String string4 = Main.getNthItem(string, string3, n4);
                if (n > 0) {
                    return Main.formatString(string, string2.substring(0, n)) + string4 + Main.formatString(string, string2.substring(n + n3));
                }
                return string4 + Main.formatString(string, string2.substring(n + n3));
            }
            return string2;
        }
        return string;
    }

    private static String getNthItem(String string, String string2, int n) {
        String string3 = string;
        int n2 = string2.length();
        int n3 = string3.indexOf(string2);
        int n4 = 1;
        while (n3 > 0) {
            if (n4 == n) {
                return string3.substring(0, n3);
            }
            string3 = string3.substring(n3 + n2);
            n3 = string3.indexOf(string2);
            ++n4;
        }
        return string3;
    }

    public static void dispResultSet(ResultSet resultSet) throws SQLException {
        Main.dispResultSet(defaultOutput, resultSet, false, null, false, false, 16384, 16384, true, true, false, false);
    }

    void dispResultSet(PrintStream printStream, ResultSet resultSet, boolean bl) throws SQLException {
        Main.dispResultSet(printStream, resultSet, bl, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.hideWarnings_, this.silentrs_);
    }

    static void dispResultSet(PrintStream printStream, ResultSet resultSet, boolean bl, String[] stringArray, boolean bl2, boolean bl3, int n, int n2, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        String[] stringArray2 = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, bl, n3, bl2, bl3, bl5, bl7);
        int[] nArray = new int[n3 + 1];
        for (int i = 1; i <= n3; ++i) {
            nArray[i] = resultSetMetaData.getColumnType(i);
        }
        boolean bl8 = resultSet.next();
        while (bl8) {
            Main.dispRow(printStream, resultSet, bl, n3, nArray, stringArray2, stringArray, bl2, bl3, n, n2, bl4, bl5, bl7);
            SQLWarning sQLWarning = resultSet.getWarnings();
            if (!bl7 && sQLWarning != null) {
                Main.dispWarning(printStream, sQLWarning, bl6, bl3);
            }
            bl8 = resultSet.next();
        }
        if (!bl7) {
            if (bl3) {
                printStream.println("</table>");
            }
            if (bl2) {
                printStream.println("</table>");
            }
        }
    }

    private static void dispWarning(PrintStream printStream, SQLWarning sQLWarning, boolean bl, boolean bl2) {
        if (bl) {
            return;
        }
        if (sQLWarning != null) {
            printStream.println("\n *** Warning ***\n");
            if (bl2) {
                printStream.println("<br>");
            }
            while (sQLWarning != null) {
                printStream.println("SQLState: " + sQLWarning.getSQLState());
                if (bl2) {
                    printStream.println("<br>");
                }
                printStream.println("Message:  " + Main.cleanupMessage(sQLWarning.getMessage()));
                if (bl2) {
                    printStream.println("<br>");
                }
                printStream.println("Vendor:   " + sQLWarning.getErrorCode());
                if (bl2) {
                    printStream.println("<br>");
                }
                printStream.println("");
                if (bl2) {
                    printStream.println("<br>");
                }
                sQLWarning = sQLWarning.getNextWarning();
            }
        }
    }

    private static String cleanupMessage(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= ' ' && cArray[i] <= '~') continue;
            bl = true;
            cArray[i] = 42;
        }
        if (!bl) {
            return string;
        }
        return new String(cArray);
    }

    private void printArray(PrintStream printStream, java.sql.Array array) throws SQLException {
        if (array == null) {
            printStream.print("nullArray");
        } else {
            Object[] objectArray = (Object[])array.getArray();
            if (objectArray == null) {
                printStream.print("XXXX_null_returned_from_outArray.getArray");
            } else {
                String string = objectArray.getClass().getComponentType().getName();
                printStream.print(string + "[" + objectArray.length + "]=[");
                for (int i = 0; i < objectArray.length; ++i) {
                    long l;
                    Object object;
                    if (i > 0) {
                        printStream.print(",");
                    }
                    if (objectArray[i] == null) {
                        printStream.print("null");
                        continue;
                    }
                    if (string.equals("[B")) {
                        printStream.print(StringFormatUtil.dumpBytes((byte[])objectArray[i]));
                        continue;
                    }
                    if (objectArray[i] instanceof Blob) {
                        object = (Blob)objectArray[i];
                        l = object.length();
                        printStream.print(StringFormatUtil.dumpBytes(object.getBytes(1L, (int)l)));
                        continue;
                    }
                    if (objectArray[i] instanceof Clob) {
                        object = (Clob)objectArray[i];
                        l = object.length();
                        this.printUnicodeString(printStream, object.getSubString(1L, (int)l));
                        continue;
                    }
                    if (objectArray[i] instanceof String) {
                        this.printUnicodeString(printStream, (String)objectArray[i]);
                        continue;
                    }
                    printStream.print(objectArray[i].toString());
                }
                printStream.print("]");
            }
        }
    }

    private void printUnicodeString(PrintStream printStream, String string) {
        int n;
        if (string != null && (n = string.length()) > this.showLobThreshold_) {
            printStream.print("CHARARRAY[size=" + n + ",CRC32=" + Main.getCRC32(string) + "]->");
            if (!this.characterDetails_) {
                string = string.substring(0, this.stringSampleSize_);
            }
        }
        if (string != null) {
            int n2;
            char[] cArray = string.toCharArray();
            boolean bl = false;
            for (n2 = 0; !bl && n2 < cArray.length; ++n2) {
                if (cArray[n2] == '\r' || cArray[n2] == '\n' || cArray[n2] == '\t' || cArray[n2] < '\u007f' && cArray[n2] >= ' ') continue;
                bl = true;
            }
            if (!bl) {
                printStream.print(string);
            } else if (this.showMixedUX_) {
                this.showMixedUXOutput(printStream, cArray);
            } else {
                printStream.print("U'");
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    int n3 = cArray[n2] & 0xFFFF;
                    if (n3 > 65280 && n3 < 65375 || n3 == 12288) {
                        if (n3 == 12288) {
                            printStream.print("| ");
                            continue;
                        }
                        printStream.print('|');
                        printStream.print((char)(n3 - 65248));
                        continue;
                    }
                    String string2 = Integer.toHexString(n3);
                    if (n3 >= 4096) {
                        printStream.print(string2);
                        continue;
                    }
                    if (n3 >= 256) {
                        printStream.print("0" + string2);
                        continue;
                    }
                    if (n3 >= 16) {
                        printStream.print("00" + string2);
                        continue;
                    }
                    printStream.print("000" + string2);
                }
                printStream.print("'");
            }
        } else {
            printStream.print(string);
        }
    }

    private static void appendUnicodeString(StringBuffer stringBuffer, String string, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        if (string != null && (n3 = string.length()) > n) {
            stringBuffer.append("CHARARRAY[size=" + n3 + ",CRC32=" + Main.getCRC32(string) + "]->");
            if (!bl) {
                string = string.substring(0, n2);
            }
        }
        if (string != null) {
            int n4;
            char[] cArray = string.toCharArray();
            boolean bl3 = false;
            for (n4 = 0; !bl3 && n4 < cArray.length; ++n4) {
                if (cArray[n4] == '\r' || cArray[n4] == '\n' || cArray[n4] == '\t' || cArray[n4] < '\u007f' && cArray[n4] >= ' ') continue;
                bl3 = true;
            }
            if (!bl3) {
                stringBuffer.append(string);
            } else if (bl2) {
                Main.appendMixedUXOutput(stringBuffer, cArray);
            } else {
                stringBuffer.append("U'");
                for (n4 = 0; n4 < cArray.length; ++n4) {
                    int n5 = cArray[n4] & 0xFFFF;
                    if (n5 > 65280 && n5 < 65375 || n5 == 12288) {
                        if (n5 == 12288) {
                            stringBuffer.append("| ");
                            continue;
                        }
                        stringBuffer.append('|');
                        stringBuffer.append((char)(n5 - 65248));
                        continue;
                    }
                    String string2 = Integer.toHexString(n5);
                    if (n5 >= 4096) {
                        stringBuffer.append(string2);
                        continue;
                    }
                    if (n5 >= 256) {
                        stringBuffer.append("0" + string2);
                        continue;
                    }
                    if (n5 >= 16) {
                        stringBuffer.append("00" + string2);
                        continue;
                    }
                    stringBuffer.append("000" + string2);
                }
                stringBuffer.append("'");
            }
        } else {
            stringBuffer.append(string);
        }
    }

    public void showMixedUXOutput(PrintStream printStream, char[] cArray) {
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            int n = cArray[i] & 0xFFFF;
            if (n == 10 || n >= 32 && n < 127) {
                if (bl) {
                    printStream.print("''");
                    bl = false;
                }
                printStream.print(cArray[i]);
                continue;
            }
            if (!bl) {
                bl = true;
                printStream.print("UX''");
            }
            String string = Integer.toHexString(n);
            if (n >= 4096) {
                printStream.print(string);
                continue;
            }
            if (n >= 256) {
                printStream.print("0" + string);
                continue;
            }
            if (n >= 16) {
                printStream.print("00" + string);
                continue;
            }
            printStream.print("000" + string);
        }
        if (bl) {
            printStream.print("''");
        }
    }

    public static void appendMixedUXOutput(StringBuffer stringBuffer, char[] cArray) {
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            int n = cArray[i] & 0xFFFF;
            if (n == 10 || n >= 32 && n < 127) {
                if (bl) {
                    stringBuffer.append("''");
                    bl = false;
                }
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (!bl) {
                bl = true;
                stringBuffer.append("UX''");
            }
            String string = Integer.toHexString(n);
            if (n >= 4096) {
                stringBuffer.append(string);
                continue;
            }
            if (n >= 256) {
                stringBuffer.append("0" + string);
                continue;
            }
            if (n >= 16) {
                stringBuffer.append("00" + string);
                continue;
            }
            stringBuffer.append("000" + string);
        }
        if (bl) {
            stringBuffer.append("''");
        }
    }

    public Object getParameterObject(String string, PrintStream printStream) {
        if (string.indexOf("UX'") == 0) {
            String string2;
            block24: {
                int n = string.length();
                if ((string = string.substring(3, n - 1)).indexOf("null") >= 0) {
                    return null;
                }
                string2 = null;
                try {
                    char[] cArray = new char[(n -= 4) / 4];
                    for (int i = 0; i < cArray.length; ++i) {
                        String string3 = string.substring(i * 4, i * 4 + 4);
                        cArray[i] = (char)Integer.parseInt(string3, 16);
                    }
                    string2 = new String(cArray);
                }
                catch (Exception exception) {
                    printStream.println("Processing of " + string + " failed");
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) break block24;
                    exception.printStackTrace(printStream);
                }
            }
            return string2;
        }
        if (string.indexOf("X'") == 0) {
            byte[] byArray;
            block25: {
                int n = string.length();
                if ((string = string.substring(2, n - 1)).indexOf("null") >= 0) {
                    return null;
                }
                byArray = null;
                try {
                    byArray = new byte[(n -= 3) / 2];
                    for (int i = 0; i < byArray.length; ++i) {
                        String string4 = string.substring(i * 2, i * 2 + 2);
                        byArray[i] = (byte)Integer.parseInt(string4, 16);
                    }
                }
                catch (Exception exception) {
                    printStream.println("Processing of " + string + " failed");
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) break block25;
                    exception.printStackTrace(printStream);
                }
            }
            return byArray;
        }
        if (string.indexOf("FILEBLOB=") == 0) {
            ClientBlob clientBlob;
            block26: {
                clientBlob = null;
                try {
                    String string5 = string.substring(9).trim();
                    byte[] byArray = null;
                    File file = new File(string5);
                    int n = (int)file.length();
                    byArray = new byte[n];
                    FileInputStream fileInputStream = new FileInputStream(string5);
                    fileInputStream.read(byArray);
                    fileInputStream.close();
                    clientBlob = new ClientBlob(byArray);
                }
                catch (Exception exception) {
                    printStream.println("Processing of " + string + " failed because of " + exception);
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) break block26;
                    exception.printStackTrace(printStream);
                }
            }
            return clientBlob;
        }
        if (string.indexOf("FILECLOB=") == 0) {
            ClientClob clientClob;
            block27: {
                clientClob = null;
                try {
                    String string6 = string.substring(9).trim();
                    char[] cArray = null;
                    File file = new File(string6);
                    int n = (int)file.length();
                    cArray = new char[n];
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string6));
                    bufferedReader.read(cArray, 0, n);
                    clientClob = new ClientClob(new String(cArray));
                }
                catch (Exception exception) {
                    printStream.println("Processing of " + string + " failed because of " + exception);
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) break block27;
                    exception.printStackTrace(printStream);
                }
            }
            return clientClob;
        }
        if (string.indexOf("SAVEDPARM=") == 0) {
            printStream.println("ERROR:  SAVEDPARM not supported yet");
        } else if (string.indexOf("SQLARRAY[") == 0) {
            printStream.println("ERROR:  SQLARRAY not supported yet");
        } else {
            if (string.indexOf("GEN_BYTE_ARRAY+") == 0) {
                return this.getGenByteArrayParm(string, printStream);
            }
            if (string.indexOf("GEN_HEX_STRING+") == 0) {
                printStream.println("ERROR:  GEN_HEX_STRING+ not supported yet");
            } else if (string.indexOf("GEN_CHAR_ARRAY+") == 0) {
                printStream.println("ERROR:  GEN_CHAR_ARRAY+ not supported yet");
            }
        }
        return string;
    }

    public void setParameter(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        if (string.indexOf("UX'") == 0) {
            this.handleUnicodeStringParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("X'") == 0) {
            this.handleByteArrayParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("FILEBLOB=") == 0) {
            this.handleFileBlobParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("FILECLOB=") == 0) {
            this.handleFileClobParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("SAVEDPARM=") == 0) {
            this.handleSavedParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("SQLARRAY[") == 0) {
            this.handleSqlarrayParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("GEN_BYTE_ARRAY+") == 0) {
            this.handleGenByteArrayParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("GEN_HEX_STRING+") == 0) {
            this.handleGenHexStringParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("GEN_CHAR_ARRAY+") == 0) {
            Object object;
            int n2;
            String string2;
            block31: {
                string2 = null;
                n2 = -1;
                try {
                    object = null;
                    String string3 = null;
                    int n3 = -1;
                    int n4 = -1;
                    String string4 = string.substring(15).trim();
                    n4 = string4.indexOf("C");
                    object = string4.substring(0, n4);
                    string3 = string4.substring(n4 + 1).trim();
                    n2 = Integer.parseInt((String)object);
                    n3 = Integer.parseInt(string3);
                    char[] cArray = new char[]{'a', 'b', 'c', 'd'};
                    char[] cArray2 = new char[]{'\u00c0', '\u35c0', '\ub5a0', '\u3055', '\u31ff', '\u3066'};
                    char[] cArray3 = new char[]{'\u3055', '\u31ff', '\u3066'};
                    char[] cArray4 = new char[]{'\u00c0', '\u35c0', '\ub5a0', '\u3055', '\u31ff', '\u3066'};
                    char[] cArray5 = new char[]{'\u5e03', '\u5f17', '\u672b', '\u5378', '\u59cb', '\u8679', '\u500c', '\u89f4', '\u9853', '\u8271', '\u8f44', '\u977e', '\u52f1'};
                    char[] cArray6 = new char[n2];
                    char[] cArray7 = new char[n2];
                    switch (n3) {
                        case 37: {
                            cArray6 = cArray;
                            break;
                        }
                        case 835: {
                            cArray6 = cArray5;
                            break;
                        }
                        case 1200: {
                            cArray6 = cArray4;
                            break;
                        }
                        case 1208: {
                            cArray6 = cArray2;
                            break;
                        }
                        case 13488: {
                            cArray6 = cArray3;
                        }
                    }
                    for (int i = 0; i < n2; ++i) {
                        cArray7[i] = cArray6[i % cArray6.length];
                    }
                    string2 = new String(cArray7);
                }
                catch (Exception exception) {
                    printStream.println("Processing of " + string + " failed");
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) break block31;
                    exception.printStackTrace(printStream);
                }
            }
            preparedStatement.setString(n, string2);
            printStream.println("CHARARRAY[size=" + n2 + ",CRC32=" + Main.getCRC32(string2) + ",CRC32xor1=" + this.getCRC32xor1(string2) + "]");
            object = preparedStatement.getWarnings();
            if (object != null && !this.silent_) {
                Main.dispWarning(printStream, (SQLWarning)object, this.hideWarnings_, this.html_);
            }
        } else {
            if (string.indexOf("'") == 0) {
                int n5 = string.indexOf("'", 1);
                string = n5 > 0 ? string.substring(1, n5) : string.substring(1);
            }
            preparedStatement.setString(n, string);
            SQLWarning sQLWarning = preparedStatement.getWarnings();
            if (sQLWarning != null && !this.silent_) {
                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
            }
        }
    }

    static String getCRC32(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[2 * n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[2 * i] = (byte)((c & 0xFF00) >> 16);
            byArray[2 * i + 1] = (byte)(c & 0xFF);
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return "" + cRC32.getValue();
    }

    String getCRC32xor1(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[2 * n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[2 * i] = (byte)((c & 0xFF00) >> 16);
            byArray[2 * i + 1] = byArray[2 * i] == -40 ? (byte)(c & 0xFF) : (byte)((c ^ '\u0001') & 0xFF);
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return "" + cRC32.getValue();
    }

    void handleUnicodeStringParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        String string2 = (String)this.getParameterObject(string, printStream);
        preparedStatement.setString(n, string2);
        SQLWarning sQLWarning = preparedStatement.getWarnings();
        if (sQLWarning != null && !this.silent_) {
            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
        }
    }

    void handleByteArrayParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        byte[] byArray = (byte[])this.getParameterObject(string, printStream);
        preparedStatement.setBytes(n, byArray);
        SQLWarning sQLWarning = preparedStatement.getWarnings();
        if (sQLWarning != null && !this.silent_) {
            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
        }
    }

    byte[] getGenByteArrayParm(String string, PrintStream printStream) {
        byte[] byArray;
        block3: {
            byArray = null;
            try {
                String string2 = string.substring(15);
                int n = Integer.parseInt(string2);
                byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)(i & 0xFF);
                }
            }
            catch (Exception exception) {
                printStream.println("Processing of " + string + " failed");
                printStream.println("Exception " + exception);
                if (!this.printStackTrace_) break block3;
                exception.printStackTrace(printStream);
            }
        }
        return byArray;
    }

    void handleGenByteArrayParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        byte[] byArray = this.getGenByteArrayParm(string, printStream);
        preparedStatement.setBytes(n, byArray);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        printStream.println("GEN_BYTE_ARRAY generated array of size = " + byArray.length + " with checksum of " + cRC32.getValue());
    }

    void handleSavedParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Object object;
        int n2;
        block3: {
            n2 = 0;
            try {
                object = string.substring(10);
                n2 = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                printStream.println("Processing of " + string + " failed");
                printStream.println("Exception " + exception);
                if (!this.printStackTrace_) break block3;
                exception.printStackTrace(printStream);
            }
        }
        preparedStatement.setString(n, this.savedStringParm_[n2]);
        printStream.println("SAVEDPARM set(" + n + "," + this.savedStringParm_[n2] + " from saved " + n2);
        object = preparedStatement.getWarnings();
        if (object != null && !this.silent_) {
            Main.dispWarning(printStream, (SQLWarning)object, this.hideWarnings_, this.html_);
        }
    }

    static void appendDigit(StringBuffer stringBuffer, int n) {
        switch (n) {
            case 0: {
                stringBuffer.append('0');
                break;
            }
            case 1: {
                stringBuffer.append('1');
                break;
            }
            case 2: {
                stringBuffer.append('2');
                break;
            }
            case 3: {
                stringBuffer.append('3');
                break;
            }
            case 4: {
                stringBuffer.append('4');
                break;
            }
            case 5: {
                stringBuffer.append('5');
                break;
            }
            case 6: {
                stringBuffer.append('6');
                break;
            }
            case 7: {
                stringBuffer.append('7');
                break;
            }
            case 8: {
                stringBuffer.append('8');
                break;
            }
            case 9: {
                stringBuffer.append('9');
                break;
            }
            case 10: {
                stringBuffer.append('a');
                break;
            }
            case 11: {
                stringBuffer.append('b');
                break;
            }
            case 12: {
                stringBuffer.append('c');
                break;
            }
            case 13: {
                stringBuffer.append('d');
                break;
            }
            case 14: {
                stringBuffer.append('e');
                break;
            }
            case 15: {
                stringBuffer.append('f');
            }
        }
    }

    void handleGenHexStringParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Object object;
        StringBuffer stringBuffer = null;
        byte[] byArray = null;
        try {
            object = string.substring(15);
            int n2 = Integer.parseInt((String)object);
            stringBuffer = new StringBuffer(2 * n2);
            byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = (byte)(i & 0xFF);
                Main.appendDigit(stringBuffer, (i & 0xF0) >> 4);
                Main.appendDigit(stringBuffer, i & 0xF);
            }
        }
        catch (Exception exception) {
            printStream.println("Processing of " + string + " failed");
            printStream.println("Exception " + exception);
            if (this.printStackTrace_) {
                exception.printStackTrace(printStream);
            }
            throw new SQLException("Unable to set HexString parameter");
        }
        preparedStatement.setString(n, stringBuffer.toString());
        object = new CRC32();
        object.update(byArray);
        printStream.println("GEN_BYTE_ARRAY generated array of size = " + byArray.length + " with checksum of " + ((CRC32)object).getValue());
        SQLWarning sQLWarning = preparedStatement.getWarnings();
        if (sQLWarning != null && !this.silent_) {
            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
        }
    }

    void handleFileBlobParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Blob blob = (Blob)this.getParameterObject(string, printStream);
        preparedStatement.setBlob(n, blob);
    }

    void handleFileClobParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Clob clob = (Clob)this.getParameterObject(string, printStream);
        preparedStatement.setClob(n, clob);
    }

    public java.sql.Array makeArray(Object object, String string) throws Exception {
        Object[] objectArray = new Object[]{};
        Class[] classArray = new Class[]{"".getClass(), objectArray.getClass()};
        java.sql.Array array = (java.sql.Array)ReflectionUtil.callMethod_O(this.connection_, "createArrayOf", classArray, string, object);
        return array;
    }

    void handleSqlarrayParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        block62: {
            try {
                String string2 = string.substring(9).trim();
                int n2 = string2.indexOf(":");
                boolean bl = false;
                if (n2 == -1 && (n2 = string2.indexOf("]")) > 0) {
                    bl = true;
                }
                if (n2 > 0) {
                    String string3 = string2.substring(0, n2);
                    string2 = bl ? string2.substring(n2) : string2.substring(n2 + 1);
                    Vector<String> vector = new Vector<String>();
                    String string4 = ":";
                    if (string3.equals("Time")) {
                        string4 = " ";
                    }
                    if (string3.equals("Timestamp")) {
                        string4 = "|";
                    }
                    n2 = string2.indexOf(string4);
                    while (n2 >= 0) {
                        String string5 = string2.substring(0, n2);
                        vector.addElement(string5);
                        string2 = string2.substring(n2 + 1);
                        n2 = string2.indexOf(string4);
                    }
                    int n3 = string2.indexOf("]");
                    if (n3 >= 0) {
                        if (!bl) {
                            vector.addElement(string2.substring(0, n3));
                        }
                        int n4 = vector.size();
                        String string6 = "String:BigDecimal:Date:Time:Timestamp:Blob:Clob:int:short:boolean:long:float:double:byteArray";
                        if (string3.equals("String")) {
                            String[] stringArray = new String[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string7 = (String)vector.get(i);
                                if ("null".equals(string7)) {
                                    stringArray[i] = null;
                                    continue;
                                }
                                if (string7.indexOf("UX'") == 0) {
                                    int n5 = string7.length();
                                    char[] cArray = new char[(n5 -= 4) / 4];
                                    for (int j = 0; j < cArray.length; ++j) {
                                        String string8 = string7.substring(3 + j * 4, 3 + j * 4 + 4);
                                        cArray[j] = (char)Integer.parseInt(string8, 16);
                                    }
                                    stringArray[i] = new String(cArray);
                                    continue;
                                }
                                stringArray[i] = string7;
                            }
                            preparedStatement.setArray(n, this.makeArray(stringArray, "VARCHAR"));
                            break block62;
                        }
                        if (string3.equals("Clob")) {
                            Clob[] clobArray = new Clob[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string9 = (String)vector.get(i);
                                clobArray[i] = "null".equals(string9) ? null : new ClientClob(string9);
                            }
                            preparedStatement.setArray(n, this.makeArray(clobArray, "CLOB"));
                            break block62;
                        }
                        if (string3.equals("BigDecimal")) {
                            BigDecimal[] bigDecimalArray = new BigDecimal[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string10 = (String)vector.get(i);
                                bigDecimalArray[i] = "null".equals(string10) ? null : new BigDecimal(string10);
                            }
                            preparedStatement.setArray(n, this.makeArray(bigDecimalArray, "DECIMAL"));
                            break block62;
                        }
                        if (string3.equals("Date")) {
                            Date[] dateArray = new Date[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string11 = (String)vector.get(i);
                                dateArray[i] = "null".equals(string11) ? null : Date.valueOf(string11);
                            }
                            preparedStatement.setArray(n, this.makeArray(dateArray, "DATE"));
                            break block62;
                        }
                        if (string3.equals("Time")) {
                            Time[] timeArray = new Time[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string12 = (String)vector.get(i);
                                timeArray[i] = "null".equals(string12) ? null : Time.valueOf(string12);
                            }
                            preparedStatement.setArray(n, this.makeArray(timeArray, "TIME"));
                            break block62;
                        }
                        if (string3.equals("Timestamp")) {
                            Timestamp[] timestampArray = new Timestamp[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string13 = (String)vector.get(i);
                                timestampArray[i] = "null".equals(string13) ? null : Timestamp.valueOf(string13);
                            }
                            preparedStatement.setArray(n, this.makeArray(timestampArray, "TIMESTAMP"));
                            break block62;
                        }
                        if (string3.equals("Integer")) {
                            Integer[] integerArray = new Integer[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string14 = (String)vector.get(i);
                                integerArray[i] = "null".equals(string14) ? null : new Integer(Integer.parseInt(string14));
                            }
                            preparedStatement.setArray(n, this.makeArray(integerArray, "INTEGER"));
                            break block62;
                        }
                        if (string3.equals("int")) {
                            int[] nArray = new int[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string15 = (String)vector.get(i);
                                nArray[i] = "null".equals(string15) ? 0 : Integer.parseInt(string15);
                            }
                            Integer[] integerArray = new Integer[n4];
                            for (int i = 0; i < n4; ++i) {
                                integerArray[i] = new Integer(nArray[i]);
                            }
                            preparedStatement.setArray(n, this.makeArray(integerArray, "INTEGER"));
                            break block62;
                        }
                        if (string3.equals("Short")) {
                            Short[] shortArray = new Short[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string16 = (String)vector.get(i);
                                shortArray[i] = "null".equals(string16) ? null : new Short((short)Integer.parseInt(string16));
                            }
                            preparedStatement.setArray(n, this.makeArray(shortArray, "SMALLINT"));
                            break block62;
                        }
                        if (string3.equals("short")) {
                            short[] sArray = new short[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string17 = (String)vector.get(i);
                                sArray[i] = "null".equals(string17) ? (short)0 : (short)Integer.parseInt(string17);
                            }
                            Short[] shortArray = new Short[n4];
                            for (int i = 0; i < n4; ++i) {
                                shortArray[i] = new Short(sArray[i]);
                            }
                            preparedStatement.setArray(n, this.makeArray(shortArray, "SMALLINT"));
                            break block62;
                        }
                        if (string3.equals("boolean") || string3.equals("Boolean")) {
                            boolean[] blArray = new boolean[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string18 = (String)vector.get(i);
                                blArray[i] = "null".equals(string18) ? false : Boolean.valueOf(string18);
                            }
                            Boolean[] booleanArray = new Boolean[n4];
                            for (int i = 0; i < n4; ++i) {
                                booleanArray[i] = new Boolean(blArray[i]);
                            }
                            preparedStatement.setArray(n, this.makeArray(booleanArray, "BOOLEAN"));
                            break block62;
                        }
                        if (string3.equals("Long")) {
                            Long[] longArray = new Long[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string19 = (String)vector.get(i);
                                longArray[i] = "null".equals(string19) ? null : new Long(Long.parseLong(string19));
                            }
                            preparedStatement.setArray(n, this.makeArray(longArray, "BIGINT"));
                            break block62;
                        }
                        if (string3.equals("long")) {
                            long[] lArray = new long[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string20 = (String)vector.get(i);
                                lArray[i] = "null".equals(string20) ? 0L : Long.parseLong(string20);
                            }
                            Long[] longArray = new Long[n4];
                            for (int i = 0; i < n4; ++i) {
                                longArray[i] = new Long(lArray[i]);
                            }
                            preparedStatement.setArray(n, this.makeArray(longArray, "BIGINT"));
                            break block62;
                        }
                        if (string3.equals("Float")) {
                            Float[] floatArray = new Float[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string21 = (String)vector.get(i);
                                floatArray[i] = "null".equals(string21) ? null : new Float((float)Double.parseDouble(string21));
                            }
                            preparedStatement.setArray(n, this.makeArray(floatArray, "REAL"));
                            break block62;
                        }
                        if (string3.equals("float")) {
                            float[] fArray = new float[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string22 = (String)vector.get(i);
                                fArray[i] = "null".equals(string22) ? 0.0f : (float)Double.parseDouble(string22);
                            }
                            Float[] floatArray = new Float[n4];
                            for (int i = 0; i < n4; ++i) {
                                floatArray[i] = new Float(fArray[i]);
                            }
                            preparedStatement.setArray(n, this.makeArray(floatArray, "REAL"));
                            break block62;
                        }
                        if (string3.equals("Double")) {
                            Double[] doubleArray = new Double[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string23 = (String)vector.get(i);
                                doubleArray[i] = "null".equals(string23) ? null : new Double(Double.parseDouble(string23));
                            }
                            preparedStatement.setArray(n, this.makeArray(doubleArray, "DOUBLE"));
                            break block62;
                        }
                        if (string3.equals("double")) {
                            double[] dArray = new double[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string24 = (String)vector.get(i);
                                dArray[i] = "null".equals(string24) ? 0.0 : Double.parseDouble(string24);
                            }
                            Double[] doubleArray = new Double[n4];
                            for (int i = 0; i < n4; ++i) {
                                doubleArray[i] = new Double(dArray[i]);
                            }
                            preparedStatement.setArray(n, this.makeArray(doubleArray, "DOUBLE"));
                            break block62;
                        }
                        if (string3.equals("byteArray")) {
                            byte[][] byArrayArray = new byte[n4][];
                            for (int i = 0; i < n4; ++i) {
                                String string25 = (String)vector.get(i);
                                if ("null".equals(string25)) {
                                    byArrayArray[i] = null;
                                    continue;
                                }
                                byte[] byArray = new byte[string25.length() / 2];
                                for (int j = 0; j < byArray.length; ++j) {
                                    String string26 = string25.substring(j * 2, j * 2 + 2);
                                    byArray[j] = (byte)Integer.parseInt(string26, 16);
                                }
                                byArrayArray[i] = byArray;
                            }
                            preparedStatement.setArray(n, this.makeArray(byArrayArray, "BINARY"));
                            break block62;
                        }
                        if (string3.equals("Blob")) {
                            Blob[] blobArray = new Blob[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string27 = (String)vector.get(i);
                                if ("null".equals(string27)) {
                                    blobArray[i] = null;
                                    continue;
                                }
                                byte[] byArray = new byte[string27.length() / 2];
                                for (int j = 0; j < byArray.length; ++j) {
                                    String string28 = string27.substring(j * 2, j * 2 + 2);
                                    byArray[j] = (byte)Integer.parseInt(string28, 16);
                                }
                                blobArray[i] = new ClientBlob(byArray);
                            }
                            preparedStatement.setArray(n, this.makeArray(blobArray, "BLOB"));
                            break block62;
                        }
                        if (string3.equalsIgnoreCase("null")) {
                            preparedStatement.setObject(n, null);
                            break block62;
                        }
                        throw new Exception("Type [" + string3 + "] not valid: valid types=" + string6);
                    }
                    throw new Exception("Unable to find ending brace for SQLARRAY[TYPE:e1:e2:...]");
                }
                throw new Exception("TYPE not found for SQLARRAY[TYPE:e1:e2:...]");
            }
            catch (Exception exception) {
                printStream.println("Processing of ARRAYPARAMETER '" + string + "' failed because of " + exception);
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                printStream.println("Exception " + exception);
                if (!this.printStackTrace_) break block62;
                exception.printStackTrace(printStream);
            }
        }
    }

    void addVariable(String string, Object object) {
        this.variables.put(string, object);
        if (string.equals("CON")) {
            this.connection_ = (Connection)object;
        } else if (string.equals("STMT")) {
            this.stmt_ = (Statement)object;
        } else if (string.equals("PSTMT")) {
            this.pstmt_ = (PreparedStatement)object;
        } else if (string.equals("CSTMT")) {
            this.cstmt_ = (CallableStatement)object;
        } else if (string.equals("RS")) {
            this.manualResultSet_ = (ResultSet)object;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(usage);
            System.exit(1);
        } else {
            try {
                Main main = stringArray.length == 1 ? new Main(stringArray[0], null, null) : (stringArray.length == 2 ? new Main(stringArray[0], stringArray[1], null) : new Main(stringArray[0], stringArray[1], stringArray[2]));
                int n = main.go(System.in, System.out);
                System.exit(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

