/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.list.AspListItem;
import com.ibm.as400.access.list.OpenList;
import java.io.IOException;

public class AspOpenList
extends OpenList {
    private static final long serialVersionUID = -7701422559222997434L;
    public static final String FORMAT_0100 = "YASP0100";
    public static final String FORMAT_0200 = "YASP0200";
    public static final String FORMAT_0300 = "YASP0300";
    public static final String FORMAT_0400 = "YASP0400";
    public static final String FORMAT_0500 = "YASP0500";
    public static final String FORMAT_0600 = "YASP0600";
    public static final String ASP_NUMBER = "ASPN_UMBER";
    public static final String RESOURCE_NAME = "RESOURCE_NAME";
    public static final String DEVICEDESCRIPTION_NAME = "DEVICEDESCRIPTION_NAME";
    public static final String DATABASE_NAME = "DATABASE_NAME";
    public static final String UNASSIGNED_DISK = "UNASSIGNED_DISK";
    public static final String ALL_ASP_SELECTED = "ALL_ASP_SELECTED";
    public static final String ALL_USER_ASP_SELECTED = "ALL_USER_ASP_SELECTED";
    public static final String ALL_IASP_SELECTED = "ALL_IASP_SELECTED";
    private int format_ = 1;
    private String aspName_;
    private int aspNumber_;
    private int filterKey_ = 1;
    private int filterNumber = 1;
    private byte[] filterNumberbyte_;
    private byte[] formatBytes_;
    private String filterDataType_;

    public AspOpenList(AS400 aS400) {
        super(aS400);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing AspOpenList object.");
        }
    }

    public AspOpenList(AS400 aS400, String string) {
        super(aS400);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing AspOpenList object.");
        }
        this.setFormat(string);
    }

    public AspOpenList(AS400 aS400, String string, String string2) {
        super(aS400);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing AspOpenList object.");
        }
        this.setFormat(string);
        this.setFilterKey(string2);
    }

    public AspOpenList(AS400 aS400, String string, int n) {
        super(aS400);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing AspOpenList object.");
        }
        this.setASPNumber(n);
        this.setFormat(string);
    }

    public AspOpenList(AS400 aS400, String string, String string2, String string3) {
        super(aS400);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing AspOpenList object.");
        }
        this.setFormat(string);
        this.setFilterKey(string2);
        this.setASPName(string3);
    }

    @Override
    protected byte[] callOpenListAPI() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object[] objectArray;
        if (Trace.isTraceOn()) {
            Trace.log(1, "Opening APSs list.");
        }
        CharConverter charConverter = new CharConverter(this.system_.getCcsid(), this.system_);
        if (Trace.isTraceOn()) {
            Trace.log(1, "The filter key of filter information is " + this.filterKey_);
        }
        int n = 16;
        int n2 = 4;
        if (this.filterKey_ == 4) {
            n = 32;
            n2 = 18;
        } else if (this.filterKey_ == 2 || this.filterKey_ == 3) {
            n = 24;
            n2 = 10;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "The filter information length " + n);
        }
        this.filterNumberbyte_ = BinaryConverter.intToByteArray(this.filterNumber);
        int n3 = 0;
        byte[] byArray = new byte[n];
        BinaryConverter.intToByteArray(n, byArray, n3);
        BinaryConverter.intToByteArray(this.filterKey_, byArray, n3 += 4);
        BinaryConverter.intToByteArray(n2, byArray, n3 += 4);
        n3 += 4;
        if (this.filterDataType_ == null || this.filterDataType_.length() == 0 || this.filterDataType_.equals(ALL_ASP_SELECTED)) {
            objectArray = new byte[]{-1, -1, -1, -1};
            System.arraycopy(objectArray, 0, byArray, n3, 4);
        } else if (this.filterDataType_.equals(ALL_IASP_SELECTED)) {
            objectArray = new byte[]{-1, -1, -1, -3};
            System.arraycopy(objectArray, 0, byArray, n3, 4);
        } else if (this.filterDataType_.equals(ALL_USER_ASP_SELECTED)) {
            objectArray = new byte[]{-1, -1, -1, -2};
            System.arraycopy(objectArray, 0, byArray, n3, 4);
        } else if (this.filterDataType_.equals(UNASSIGNED_DISK)) {
            objectArray = new byte[]{0, 0, 0, 0};
            System.arraycopy(objectArray, 0, byArray, n3, 4);
        } else if (this.filterDataType_.equals(ASP_NUMBER)) {
            BinaryConverter.intToByteArray(this.aspNumber_, byArray, n3);
        } else if (this.filterDataType_.equals(DATABASE_NAME)) {
            charConverter.stringToByteArray(this.aspName_, byArray, n3, 18);
        } else if (this.filterDataType_.equals(DEVICEDESCRIPTION_NAME) || this.filterDataType_.equals(RESOURCE_NAME)) {
            charConverter.stringToByteArray(this.aspName_, byArray, n3, 10);
        } else {
            Trace.log(2, "Error occur when set filter information");
        }
        this.formatBytes_ = new byte[]{-24, -63, -30, -41, -16, (byte)(0xF0 | this.format_), -16, -16};
        objectArray = new ProgramParameter[8];
        objectArray[0] = (byte)new ProgramParameter(0);
        objectArray[1] = (byte)new ProgramParameter(new byte[]{0, 0, 0, 0});
        objectArray[2] = (byte)new ProgramParameter(80);
        objectArray[3] = (byte)new ProgramParameter(new byte[]{-1, -1, -1, -1});
        objectArray[4] = (byte)new ProgramParameter(this.filterNumberbyte_);
        objectArray[5] = (byte)new ProgramParameter(byArray);
        objectArray[6] = (byte)new ProgramParameter(this.formatBytes_);
        objectArray[7] = (byte)EMPTY_ERROR_CODE_PARM;
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QYASPOL.PGM", (ProgramParameter[])objectArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        return objectArray[2].getOutputData();
    }

    public void setASPNumber(int n) {
        if (n <= 0) {
            Trace.log(2, "Value of parameter 'aspNumber' is not valid: " + n);
            throw new ExtendedIllegalArgumentException("aspNumber (" + n + ")", 2);
        }
        this.aspNumber_ = n;
        this.filterKey_ = 1;
        this.filterDataType_ = ASP_NUMBER;
    }

    public void setFormat(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'format ' is null.");
            throw new NullPointerException("format");
        }
        if (string.equalsIgnoreCase(FORMAT_0100)) {
            this.format_ = 1;
        } else if (string.equalsIgnoreCase(FORMAT_0200)) {
            this.format_ = 2;
        } else if (string.equalsIgnoreCase(FORMAT_0300)) {
            this.format_ = 3;
        } else if (string.equalsIgnoreCase(FORMAT_0400)) {
            this.format_ = 4;
        } else if (string.equalsIgnoreCase(FORMAT_0500)) {
            this.format_ = 5;
        } else if (string.equalsIgnoreCase(FORMAT_0600)) {
            this.format_ = 6;
        } else if (string.equalsIgnoreCase(UNASSIGNED_DISK)) {
            this.format_ = 3;
            this.filterDataType_ = UNASSIGNED_DISK;
        } else {
            Trace.log(2, "Value of parameter 'format' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("format (" + string + ")", 2);
        }
    }

    public void setFilterKey(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'filterDataType ' is null.");
            throw new NullPointerException("filterDataType");
        }
        this.filterDataType_ = string.toUpperCase().trim();
        if (this.filterDataType_.equals(ALL_ASP_SELECTED) || this.filterDataType_.equals(ALL_IASP_SELECTED) || this.filterDataType_.equals(ALL_USER_ASP_SELECTED) || this.filterDataType_.equals(UNASSIGNED_DISK) || this.filterDataType_.equals(ASP_NUMBER)) {
            this.filterKey_ = 1;
        } else if (this.filterDataType_.equals(RESOURCE_NAME)) {
            this.filterKey_ = 2;
        } else if (this.filterDataType_.equals(DEVICEDESCRIPTION_NAME)) {
            this.filterKey_ = 3;
        } else if (this.filterDataType_.equals(DATABASE_NAME)) {
            this.filterKey_ = 4;
        } else {
            Trace.log(2, "Parameter 'filterDataType ' is not valid:" + string + ", When filter set to YES");
            throw new ExtendedIllegalArgumentException("filterDataType (" + string + ")", 2);
        }
    }

    public void setASPName(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'ASP name for filter ' is null.");
            throw new NullPointerException("name");
        }
        this.aspName_ = string;
        if (string.length() < 10) {
            for (int i = 0; i < 10 - string.length(); ++i) {
                this.aspName_ = this.aspName_ + " ";
            }
        }
        Trace.log(3, "set ASP Name length is " + this.aspName_);
    }

    public String getASPFormat() {
        switch (this.format_) {
            case 1: {
                return FORMAT_0100;
            }
            case 2: {
                return FORMAT_0200;
            }
            case 3: {
                return FORMAT_0300;
            }
            case 4: {
                return FORMAT_0400;
            }
            case 5: {
                return FORMAT_0500;
            }
            case 6: {
                return FORMAT_0600;
            }
        }
        return FORMAT_0100;
    }

    @Override
    protected Object[] formatOutputData(byte[] byArray, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CharConverter charConverter = new CharConverter(this.system_.getCcsid(), this.system_);
        Object[] objectArray = new AspListItem[n];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            String string3;
            int n4;
            int n5;
            int n6;
            int n7;
            String string4;
            String string5;
            int n8 = BinaryConverter.byteArrayToInt(byArray, n3);
            n3 += 4;
            if (this.format_ == 1) {
                String string6 = charConverter.byteArrayToString(byArray, n3, 10).trim();
                String string7 = charConverter.byteArrayToString(byArray, n3 += 10, 10).trim();
                int n9 = BinaryConverter.byteArrayToInt(byArray, n3 += 10);
                int n10 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n11 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                string5 = charConverter.byteArrayToString(byArray, n3 += 4, 18).trim();
                string4 = charConverter.byteArrayToString(byArray, n3 += 18, 10).trim();
                n3 += 10;
                objectArray[i] = new AspListItem(n8, string6, string7, n9, n10, n11, string5, string4);
                continue;
            }
            if (this.format_ == 2) {
                int n12 = BinaryConverter.byteArrayToInt(byArray, n3);
                int n13 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n14 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n15 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n16 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n17 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n18 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                n7 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n19 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n20 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n21 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n22 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                n6 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                n5 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                n4 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                String string8 = charConverter.byteArrayToString(byArray, n3 += 4, 2).trim();
                String string9 = charConverter.byteArrayToString(byArray, n3 += 2, 1).trim();
                String string10 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                String string11 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                String string12 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                String string13 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                string3 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                string2 = charConverter.byteArrayToString(byArray, ++n3, 13).trim();
                int n23 = BinaryConverter.byteArrayToInt(byArray, n3 += 16);
                int n24 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n25 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                string = charConverter.byteArrayToString(byArray, n3 += 4, 1).trim();
                String string14 = charConverter.byteArrayToString(byArray, ++n3, 13).trim();
                String string15 = charConverter.byteArrayToString(byArray, n3 += 13, 1).trim();
                int n26 = BinaryConverter.byteArrayToInt(byArray, n3 += 2);
                int n27 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n28 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n29 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n30 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n31 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n32 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n33 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                n3 += 4;
                objectArray[i] = new AspListItem(n8, n12, n13, n14, n15, n16, n17, n18, n7, n19, n20, n21, n22, n6, n5, n4, string8, string9, string10, string11, string12, string13, string3, string2, n23, n24, n25, string, string14, string15, n26, n27, n28, n29, n30, n31, n32, n33);
                continue;
            }
            if (this.format_ == 3) {
                String string16 = charConverter.byteArrayToString(byArray, n3, 4).trim();
                String string17 = charConverter.byteArrayToString(byArray, n3 += 4, 4).trim();
                String string18 = charConverter.byteArrayToString(byArray, n3 += 4, 10).trim();
                String string19 = charConverter.byteArrayToString(byArray, n3 += 10, 10).trim();
                int n34 = BinaryConverter.byteArrayToInt(byArray, n3 += 10);
                int n35 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n36 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                n7 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                String string20 = charConverter.byteArrayToString(byArray, n3 += 4, 1).trim();
                String string21 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                String string22 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                String string23 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                n6 = BinaryConverter.byteArrayToInt(byArray, ++n3);
                n5 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                n4 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n37 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n38 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n39 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n40 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n41 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n42 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                string3 = charConverter.byteArrayToString(byArray, n3 += 4, 1).trim();
                string2 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                String string24 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                String string25 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                String string26 = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                string = charConverter.byteArrayToString(byArray, ++n3, 1).trim();
                ++n3;
                n3 += 2;
                objectArray[i] = new AspListItem(n8, string16, string17, string18, string19, n34, n35, n36, n7, string20, string21, string22, string23, n6, n5, n4, n37, n38, n39, n40, n41, n42, string3, string2, string24, string25, string26, string);
                continue;
            }
            if (this.format_ == 4) {
                String string27 = charConverter.byteArrayToString(byArray, n3, 4).trim();
                int n43 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                String string28 = charConverter.byteArrayToString(byArray, n3 += 4, 1).trim();
                ++n3;
                objectArray[i] = new AspListItem(n8, string27, n43, string28);
                continue;
            }
            if (this.format_ == 5) {
                String string29 = charConverter.byteArrayToString(byArray, n3, 2).trim();
                String string30 = charConverter.byteArrayToString(byArray, n3 += 4, 16).trim();
                int n44 = BinaryConverter.byteArrayToInt(byArray, n3 += 16);
                int n45 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n46 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                int n47 = BinaryConverter.byteArrayToInt(byArray, n3 += 4);
                string4 = charConverter.byteArrayToString(byArray, n3 += 4, 6);
                n3 += 6;
                objectArray[i] = new AspListItem(n8, string29, string30, n44, n45, n46, n47, string4);
                continue;
            }
            if (this.format_ != 6) continue;
            int n48 = BinaryConverter.byteArrayToInt(byArray, n3);
            String string31 = charConverter.byteArrayToString(byArray, n3 += 4, 10).trim();
            String string32 = charConverter.byteArrayToString(byArray, n3 += 10, 10).trim();
            String string33 = charConverter.byteArrayToString(byArray, n3 += 10, 4).trim();
            String string34 = charConverter.byteArrayToString(byArray, n3 += 4, 8).trim();
            string5 = charConverter.byteArrayToString(byArray, n3 += 8, 4).trim();
            n3 += 4;
            objectArray[i] = new AspListItem(n8, n48, string31, string32, string33, string34, string5);
        }
        return objectArray;
    }

    @Override
    protected int getBestGuessReceiverSize(int n) {
        switch (this.format_) {
            case 1: {
                return 64 * n;
            }
            case 2: {
                return 148 * n;
            }
            case 3: {
                return 94 * n;
            }
            case 4: {
                return 13 * n;
            }
            case 5: {
                return 46 * n;
            }
            case 6: {
                return 52 * n;
            }
        }
        return 148 * n;
    }

    public int getAspNumber() {
        return this.aspNumber_;
    }

    public String getAspName() {
        if (this.aspName_ == null) {
            this.aspName_ = "";
        }
        return this.aspName_;
    }

    public int getFilterKey() {
        return this.filterKey_;
    }

    public String getFilterDataType() {
        if (this.filterDataType_ == null) {
            this.filterDataType_ = "";
        }
        return this.filterDataType_;
    }
}

