/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.list.OpenListEnumeration;
import com.ibm.as400.access.list.OpenListException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class OpenList
implements Serializable {
    static final long serialVersionUID = -5967313807836097042L;
    protected static final ProgramParameter EMPTY_ERROR_CODE_PARM = new ErrorCodeParameter();
    protected AS400 system_;
    private int length_;
    private int enumerationBlockSize_ = 1000;
    private byte[] handle_;
    private boolean closeHandle_ = false;
    private Vector enumerations_;

    protected OpenList(AS400 aS400) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing OpenList object, system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    protected abstract byte[] callOpenListAPI() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException;

    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Closing open list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        try {
            ProgramParameter[] programParameterArray;
            Object object;
            if (this.enumerations_ != null) {
                for (int i = this.enumerations_.size() - 1; i >= 0; --i) {
                    object = (OpenListEnumeration)this.enumerations_.elementAt(i);
                    ((OpenListEnumeration)object).close();
                }
                this.enumerations_ = null;
            }
            if (!((ProgramCall)(object = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYCLST.PGM", programParameterArray = new ProgramParameter[]{new ProgramParameter(this.handle_), EMPTY_ERROR_CODE_PARM}))).run()) {
                throw new AS400Exception(((ProgramCall)object).getMessageList());
            }
        }
        finally {
            this.handle_ = null;
            this.closeHandle_ = false;
        }
    }

    protected void finalize() throws Throwable {
        block4: {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Finalize method for open list invoked.");
            }
            try {
                if (this.system_.isConnected(2)) {
                    this.close();
                }
            }
            catch (Exception exception) {
                if (!Trace.isTraceOn()) break block4;
                Trace.log(1, "Exception occurred while finalizing open list with handle:", this.handle_);
                Trace.log(2, exception);
            }
        }
        super.finalize();
    }

    protected abstract Object[] formatOutputData(byte[] var1, int var2, int var3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException;

    protected abstract int getBestGuessReceiverSize(int var1);

    public int getEnumerationBlockSize() {
        return this.enumerationBlockSize_;
    }

    public synchronized int getLength() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, OpenListException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Getting open list length.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.open();
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public synchronized Enumeration getItems() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, OpenListException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Retrieving open list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.open();
        }
        if (this.enumerations_ == null) {
            this.enumerations_ = new Vector();
        }
        OpenListEnumeration openListEnumeration = new OpenListEnumeration(this, this.length_);
        this.enumerations_.addElement(openListEnumeration);
        return openListEnumeration;
    }

    public synchronized Object[] getItems(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, OpenListException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Retrieving open list, list offset: " + n + ", number:", n2);
        }
        if (n < -1) {
            Trace.log(2, "Value of parameter 'listOffset' is not valid:", n);
            throw new ExtendedIllegalArgumentException("listOffset (" + n + ")", 4);
        }
        if (n2 < 0 && n != -1) {
            Trace.log(2, "Value of parameter 'number' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("number (" + n2 + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.open();
        }
        if (n == -1) {
            n2 = this.length_;
            n = 0;
        } else if (n + n2 > this.length_) {
            n2 = this.length_ - n;
        }
        int n3 = this.getBestGuessReceiverSize(n2);
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n3), new ProgramParameter(BinaryConverter.intToByteArray(n3)), new ProgramParameter(this.handle_), new ProgramParameter(80), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ProgramParameter(BinaryConverter.intToByteArray(n + 1)), EMPTY_ERROR_CODE_PARM};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYGTLE.PGM", programParameterArray);
        byte[] byArray = null;
        int n4 = 0;
        do {
            if (programCall.run()) {
                byArray = programParameterArray[3].getOutputData();
                n4 = BinaryConverter.byteArrayToInt(byArray, 4);
            } else {
                AS400Message[] aS400MessageArray = programCall.getMessageList();
                if (!aS400MessageArray[0].getID().equals("GUI0002")) {
                    throw new AS400Exception(aS400MessageArray);
                }
            }
            if (n4 >= n2) continue;
            if (Trace.isTraceOn()) {
                Trace.log(1, "Retrieved messages, records returned: " + n4 + ", number:", n2);
            }
            n3 *= 1 + n2 / (n4 + 1);
            if (Trace.isTraceOn()) {
                Trace.log(1, "Updated length: ", n3);
            }
            programParameterArray[0] = new ProgramParameter(n3);
            programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        } while (n4 < n2 || byArray == null);
        int n5 = BinaryConverter.byteArrayToInt(byArray, 12);
        int n6 = byArray[30] & 0xFF;
        if (n6 != 242) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to build object list on server, list status indicator:", n6);
            }
            throw new OpenListException(n6);
        }
        return this.formatOutputData(programParameterArray[0].getOutputData(), n4, n5);
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public boolean isOpen() {
        return this.handle_ == null || this.closeHandle_;
    }

    public synchronized void open() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, OpenListException {
        byte[] byArray;
        if (Trace.isTraceOn()) {
            Trace.log(1, "Opening object list.");
        }
        if (this.closeHandle_) {
            this.close();
        }
        if ((byArray = this.callOpenListAPI()) == null || byArray.length < 30) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Bad list information returned:", byArray);
            }
            throw new OpenListException(0x100000);
        }
        int n = byArray[30] & 0xFF;
        if (n != 242) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to build object list on server, list status indicator:", n);
            }
            throw new OpenListException(n);
        }
        this.length_ = BinaryConverter.byteArrayToInt(byArray, 0);
        this.handle_ = new byte[4];
        System.arraycopy(byArray, 8, this.handle_, 0, 4);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Opened object list, length: " + this.length_ + ", record length: " + BinaryConverter.byteArrayToInt(byArray, 12) + ", handle:", this.handle_);
        }
    }

    void remove(OpenListEnumeration openListEnumeration) {
        this.enumerations_.removeElement(openListEnumeration);
    }

    protected synchronized void resetHandle() {
        if (this.handle_ != null) {
            this.closeHandle_ = true;
        }
    }

    public void setEnumerationBlockSize(int n) {
        this.enumerationBlockSize_ = n < 1 ? 1000 : n;
    }
}

