/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.DataDescriptor;
import com.ibm.as400.data.Descriptor;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.PcmlStruct;
import com.ibm.as400.data.ProgramDescriptor;
import com.ibm.as400.data.RecordFormatDescriptor;
import com.ibm.as400.data.RfmlRecordFormat;
import com.ibm.as400.data.StructDescriptor;
import java.util.Enumeration;
import java.util.Vector;

abstract class DocNodeDescriptor
implements Descriptor {
    protected PcmlDocNode m_docNode;

    public DocNodeDescriptor(PcmlDocNode pcmlDocNode) {
        this.m_docNode = pcmlDocNode;
    }

    public PcmlDocNode getDocNode() {
        return this.m_docNode;
    }

    @Override
    public abstract String[] getAttributeList();

    @Override
    public abstract String getAttributeValue(String var1);

    @Override
    public Enumeration getChildren() {
        int n = this.m_docNode.getNbrChildren();
        Vector<StructDescriptor> vector = new Vector<StructDescriptor>(n);
        if (n > 0) {
            Enumeration enumeration = this.m_docNode.getChildren();
            while (enumeration.hasMoreElements()) {
                DocNodeDescriptor docNodeDescriptor;
                PcmlDocNode pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
                if (pcmlDocNode instanceof PcmlStruct) {
                    docNodeDescriptor = new StructDescriptor(pcmlDocNode);
                } else if (pcmlDocNode instanceof PcmlData) {
                    docNodeDescriptor = new DataDescriptor(pcmlDocNode);
                } else if (pcmlDocNode instanceof PcmlProgram) {
                    docNodeDescriptor = new ProgramDescriptor(pcmlDocNode);
                } else if (pcmlDocNode instanceof RfmlRecordFormat) {
                    docNodeDescriptor = new RecordFormatDescriptor(pcmlDocNode);
                } else {
                    Trace.log(2, "Unrecognized child element type: " + pcmlDocNode.getClass().getName());
                    throw new InternalErrorException(6);
                }
                vector.addElement((StructDescriptor)docNodeDescriptor);
            }
        }
        return vector.elements();
    }

    @Override
    public Descriptor getDescriptor(String string) {
        PcmlDocNode pcmlDocNode = (PcmlDocNode)this.m_docNode.getDoc().getElement(string);
        if (pcmlDocNode == null) {
            return null;
        }
        if (pcmlDocNode instanceof PcmlStruct) {
            return new StructDescriptor(pcmlDocNode);
        }
        if (pcmlDocNode instanceof PcmlData) {
            return new DataDescriptor(pcmlDocNode);
        }
        if (pcmlDocNode instanceof PcmlProgram) {
            return new ProgramDescriptor(pcmlDocNode);
        }
        if (pcmlDocNode instanceof RfmlRecordFormat) {
            return new RecordFormatDescriptor(pcmlDocNode);
        }
        Trace.log(2, "Unrecognized element type: " + pcmlDocNode.getClass().getName());
        throw new InternalErrorException(6);
    }

    @Override
    public String getName() {
        return this.m_docNode.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.m_docNode.getQualifiedName();
    }

    @Override
    public String getTagName() {
        return this.m_docNode.getTagName();
    }

    @Override
    public boolean hasChildren() {
        return this.m_docNode.hasChildren();
    }
}

