/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class PcmlMessageLog {
    private static OutputStream m_outputStream;
    private static StringBuffer m_cp37Table;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void main(String[] stringArray) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            PcmlMessageLog.setTraceEnabled(true);
            Trace.setTraceErrorOn(true);
            PcmlMessageLog.logError("This is a test error to the console");
            PcmlMessageLog.traceOut("Message to stdout");
            PcmlMessageLog.traceErr("Message to stderr");
            PcmlMessageLog.traceOut("Test dump of byte array: " + PcmlMessageLog.toHexString(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}));
            Trace.log(7, "Test dump of byte array: " + PcmlMessageLog.toHexString(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}));
            byte[] byArray = new byte[256];
            for (int n = -128; n < 127; n = (int)((byte)(n + 1))) {
                byArray[n - -128] = n;
            }
            byArray[255] = 127;
            PcmlMessageLog.dumpBytes(byArray);
            PcmlMessageLog.setLogFileName("pcml.log");
            PcmlMessageLog.logError("This is a test error to pcml.log");
            fileOutputStream = new FileOutputStream("user.log");
            PcmlMessageLog.setLogStream(fileOutputStream);
            PcmlMessageLog.logError("This is a test error to user.log with throwable", new IllegalArgumentException("test exception"));
            PcmlMessageLog.setLogFileName(null);
            PcmlMessageLog.logError("This is a test error back to the console");
            PcmlMessageLog.setTraceEnabled(false);
            Trace.log(7, "Message to stdout should not be sent");
            Trace.setTraceErrorOn(false);
            Trace.log(2, "Message to stderr should not be sent");
            System.out.println("Test complete!");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private PcmlMessageLog() {
    }

    public static void setLogFileName(String string) throws IOException {
        Trace.setFileName(string);
    }

    public static String getLogFileName() {
        return Trace.getFileName();
    }

    public static void setLogStream(OutputStream outputStream) {
        PrintWriter printWriter = null;
        if (outputStream != null) {
            m_outputStream = outputStream;
            printWriter = new PrintWriter(outputStream, true);
        } else {
            m_outputStream = System.err;
            printWriter = new PrintWriter(System.err, true);
        }
        try {
            Trace.setPrintWriter(printWriter);
        }
        catch (IOException iOException) {
            Trace.log(2, iOException);
        }
    }

    public static OutputStream getLogStream() {
        return m_outputStream;
    }

    public static void logError(Object object) {
        Trace.log(2, object.toString());
    }

    public static void logError(Object object, Throwable throwable) {
        Trace.log(2, object.toString(), throwable);
    }

    public static void printStackTrace(Throwable throwable) {
        PrintWriter printWriter = Trace.getPrintWriter();
        printWriter.println("Stack trace:");
        throwable.printStackTrace(printWriter);
    }

    public static void setTraceEnabled(boolean bl) {
        Trace.setTracePCMLOn(bl);
        if (bl) {
            Trace.setTraceOn(bl);
        }
    }

    public static boolean isTraceEnabled() {
        return Trace.isTracePCMLOn();
    }

    public static void traceOut(Object object) {
    }

    public static void traceErr(Object object) {
    }

    static void traceParameter(String string, String string2, byte[] byArray) {
        if (Trace.isTracePCMLOn()) {
            Trace.log(7, string + "\t  " + string2);
            PcmlMessageLog.dumpBytes(byArray);
        }
    }

    private static void dumpBytes(byte[] byArray) {
        int n;
        if (byArray == null || byArray.length == 0) {
            return;
        }
        int n2 = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = 0; n < n2; n += 4) {
            if (n % 32 == 0) {
                if (n == 0) {
                    Trace.log(7, "Offset : 0....... 4....... 8....... C....... 0....... 4....... 8....... C.......   0...4...8...C...0...4...8...C...");
                } else {
                    stringBuffer2.append(" *");
                    stringBuffer2.append(stringBuffer.toString());
                    stringBuffer2.append("*");
                    Trace.log(7, stringBuffer2.toString());
                    stringBuffer.setLength(0);
                    stringBuffer2.setLength(0);
                }
                Object object = "      " + Integer.toHexString(n);
                object = ((String)object).substring(((String)object).length() - 6);
                stringBuffer2.append((String)object);
                stringBuffer2.append(" : ");
            }
            stringBuffer2.append(PcmlMessageLog.toHexString(byArray, n, 4));
            stringBuffer2.append(" ");
            stringBuffer.append(PcmlMessageLog.toCP37String(byArray, n, 4));
        }
        if (n > 0) {
            for (int i = n2; i < n; ++i) {
                stringBuffer2.append("  ");
                stringBuffer.append(" ");
            }
            while (n % 32 != 0) {
                stringBuffer2.append("         ");
                stringBuffer.append("    ");
                n += 4;
            }
            stringBuffer2.append(" *");
            stringBuffer2.append(stringBuffer.toString());
            stringBuffer2.append("*");
            Trace.log(7, stringBuffer2.toString());
            stringBuffer2.setLength(0);
            stringBuffer.setLength(0);
        }
    }

    private static String toCP37String(byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0 || n < 0 || n >= byArray.length) {
            return "";
        }
        int n3 = byArray.length;
        int n4 = n + n2 <= n3 ? n + n2 - 1 : n3 - 1;
        StringBuffer stringBuffer = new StringBuffer(n4 - n + 1);
        for (int i = n; i <= n4; ++i) {
            if (byArray[i] < 0) {
                stringBuffer.append(m_cp37Table.charAt(256 + byArray[i]));
                continue;
            }
            stringBuffer.append(m_cp37Table.charAt(byArray[i]));
        }
        return stringBuffer.toString();
    }

    static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return PcmlMessageLog.toHexString(byArray, 0, byArray.length);
    }

    static String toHexString(byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0 || n < 0 || n >= byArray.length) {
            return "";
        }
        int n3 = byArray.length;
        int n4 = n + n2 <= n3 ? n + n2 - 1 : n3 - 1;
        StringBuffer stringBuffer = new StringBuffer((n4 - n + 1) * 2);
        for (int i = n; i <= n4; ++i) {
            stringBuffer.append(Trace.toHexString(byArray[i]));
        }
        return stringBuffer.toString();
    }

    static {
        m_cp37Table = new StringBuffer(256);
        for (int i = 0; i < 256; ++i) {
            m_cp37Table.append('.');
        }
        m_cp37Table.setCharAt(64, ' ');
        m_cp37Table.setCharAt(75, '.');
        m_cp37Table.setCharAt(76, '<');
        m_cp37Table.setCharAt(77, '(');
        m_cp37Table.setCharAt(78, '+');
        m_cp37Table.setCharAt(80, '&');
        m_cp37Table.setCharAt(90, '!');
        m_cp37Table.setCharAt(91, '$');
        m_cp37Table.setCharAt(92, '*');
        m_cp37Table.setCharAt(93, ')');
        m_cp37Table.setCharAt(94, ';');
        m_cp37Table.setCharAt(96, '-');
        m_cp37Table.setCharAt(97, '/');
        m_cp37Table.setCharAt(106, '|');
        m_cp37Table.setCharAt(107, ',');
        m_cp37Table.setCharAt(108, '%');
        m_cp37Table.setCharAt(109, '_');
        m_cp37Table.setCharAt(110, '>');
        m_cp37Table.setCharAt(111, '?');
        m_cp37Table.setCharAt(121, '`');
        m_cp37Table.setCharAt(122, ':');
        m_cp37Table.setCharAt(123, '#');
        m_cp37Table.setCharAt(124, '@');
        m_cp37Table.setCharAt(125, '\'');
        m_cp37Table.setCharAt(126, '=');
        m_cp37Table.setCharAt(127, '\"');
        m_cp37Table.setCharAt(129, 'a');
        m_cp37Table.setCharAt(130, 'b');
        m_cp37Table.setCharAt(131, 'c');
        m_cp37Table.setCharAt(132, 'd');
        m_cp37Table.setCharAt(133, 'e');
        m_cp37Table.setCharAt(134, 'f');
        m_cp37Table.setCharAt(135, 'g');
        m_cp37Table.setCharAt(136, 'h');
        m_cp37Table.setCharAt(137, 'i');
        m_cp37Table.setCharAt(145, 'j');
        m_cp37Table.setCharAt(146, 'k');
        m_cp37Table.setCharAt(147, 'l');
        m_cp37Table.setCharAt(148, 'm');
        m_cp37Table.setCharAt(149, 'n');
        m_cp37Table.setCharAt(150, 'o');
        m_cp37Table.setCharAt(151, 'p');
        m_cp37Table.setCharAt(152, 'q');
        m_cp37Table.setCharAt(153, 'r');
        m_cp37Table.setCharAt(162, 's');
        m_cp37Table.setCharAt(163, 't');
        m_cp37Table.setCharAt(164, 'u');
        m_cp37Table.setCharAt(165, 'v');
        m_cp37Table.setCharAt(166, 'w');
        m_cp37Table.setCharAt(167, 'x');
        m_cp37Table.setCharAt(168, 'y');
        m_cp37Table.setCharAt(169, 'z');
        m_cp37Table.setCharAt(193, 'A');
        m_cp37Table.setCharAt(194, 'B');
        m_cp37Table.setCharAt(195, 'C');
        m_cp37Table.setCharAt(196, 'D');
        m_cp37Table.setCharAt(197, 'E');
        m_cp37Table.setCharAt(198, 'F');
        m_cp37Table.setCharAt(199, 'G');
        m_cp37Table.setCharAt(200, 'H');
        m_cp37Table.setCharAt(201, 'I');
        m_cp37Table.setCharAt(209, 'J');
        m_cp37Table.setCharAt(210, 'K');
        m_cp37Table.setCharAt(211, 'L');
        m_cp37Table.setCharAt(212, 'M');
        m_cp37Table.setCharAt(213, 'N');
        m_cp37Table.setCharAt(214, 'O');
        m_cp37Table.setCharAt(215, 'P');
        m_cp37Table.setCharAt(216, 'Q');
        m_cp37Table.setCharAt(217, 'R');
        m_cp37Table.setCharAt(226, 'S');
        m_cp37Table.setCharAt(227, 'T');
        m_cp37Table.setCharAt(228, 'U');
        m_cp37Table.setCharAt(229, 'V');
        m_cp37Table.setCharAt(230, 'W');
        m_cp37Table.setCharAt(231, 'X');
        m_cp37Table.setCharAt(232, 'Y');
        m_cp37Table.setCharAt(233, 'Z');
        m_cp37Table.setCharAt(240, '0');
        m_cp37Table.setCharAt(241, '1');
        m_cp37Table.setCharAt(242, '2');
        m_cp37Table.setCharAt(243, '3');
        m_cp37Table.setCharAt(244, '4');
        m_cp37Table.setCharAt(245, '5');
        m_cp37Table.setCharAt(246, '6');
        m_cp37Table.setCharAt(247, '7');
        m_cp37Table.setCharAt(248, '8');
        m_cp37Table.setCharAt(249, '9');
    }
}

