/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.PcmlAttribute;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.RfmlData;
import com.ibm.as400.data.RfmlDocument;
import com.ibm.as400.data.RfmlRecordFormat;
import com.ibm.as400.data.RfmlStruct;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XMLErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class RfmlSAXParser
extends DefaultHandler
implements EntityResolver {
    private transient RfmlDocument m_rootNode;
    private transient PcmlDocNode m_currentNode;
    private transient String m_docName;
    private transient XMLErrorHandler m_xh;

    RfmlSAXParser() {
    }

    private void augmentTree(PcmlDocNode pcmlDocNode, Stack stack) {
        Enumeration enumeration = pcmlDocNode.getChildren();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            String string;
            RfmlData rfmlData;
            PcmlDocNode pcmlDocNode2 = (PcmlDocNode)enumeration.nextElement();
            if (pcmlDocNode2 instanceof RfmlData && (rfmlData = (RfmlData)pcmlDocNode2).getDataType() == 7 && rfmlData.getNbrChildren() == 0 && (string = rfmlData.getStruct()) != null) {
                PcmlDocNode pcmlDocNode3 = (PcmlDocNode)this.m_rootNode.getElement(string);
                if (pcmlDocNode3 instanceof RfmlStruct) {
                    if (stack.search(pcmlDocNode3) != -1) {
                        this.m_rootNode.addPcmlSpecificationError("CIRCULAR_REFERENCE", new Object[]{string, rfmlData.getBracketedTagName(), rfmlData.getNameForException()});
                    } else {
                        Enumeration enumeration2 = pcmlDocNode3.getChildren();
                        while (enumeration2.hasMoreElements()) {
                            PcmlDocNode pcmlDocNode4 = (PcmlDocNode)enumeration2.nextElement();
                            PcmlDocNode pcmlDocNode5 = (PcmlDocNode)pcmlDocNode4.clone();
                            rfmlData.addChild(pcmlDocNode5);
                            this.m_rootNode.addToHashtable(pcmlDocNode5);
                        }
                    }
                } else if (pcmlDocNode3 == null) {
                    this.m_rootNode.addPcmlSpecificationError("REF_NOT_FOUND", new Object[]{string, "<struct>", rfmlData.getBracketedTagName(), rfmlData.getNameForException()});
                } else {
                    this.m_rootNode.addPcmlSpecificationError("REF_WRONG_TYPE", new Object[]{string, "<struct>", rfmlData.getBracketedTagName(), rfmlData.getNameForException()});
                }
            }
            stack.push(pcmlDocNode2);
            this.augmentTree(pcmlDocNode2, stack);
            stack.pop();
        }
    }

    private void checkAttributes(PcmlDocNode pcmlDocNode) {
        Enumeration enumeration = pcmlDocNode.getChildren();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            PcmlDocNode pcmlDocNode2 = (PcmlDocNode)enumeration.nextElement();
            pcmlDocNode2.checkAttributes();
            this.checkAttributes(pcmlDocNode2);
        }
    }

    RfmlDocument getRfmlDocument() {
        return this.m_rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(String string, ClassLoader classLoader) throws MissingResourceException, IOException, ParseException, PcmlSpecificationException, SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException, SAXException {
        this.m_rootNode = null;
        this.m_currentNode = null;
        String string2 = string.endsWith(".rfml") || string.endsWith(".rfmlsrc") ? string.substring(0, string.lastIndexOf(46)) : string;
        this.m_docName = string2.substring(string2.lastIndexOf(46) + 1);
        try (InputStream inputStream = null;){
            Object object;
            inputStream = SystemResourceFinder.getRFMLDocument(string, classLoader);
            if (this.m_xh == null) {
                this.m_xh = new XMLErrorHandler(this.m_docName, 0);
            }
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            sAXParserFactory.setNamespaceAware(false);
            sAXParserFactory.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            try {
                object = sAXParser.getXMLReader();
                object.setErrorHandler(this.m_xh);
                object.setEntityResolver(this);
                sAXParser.parse(new InputSource(inputStream), (DefaultHandler)this);
            }
            catch (SAXException sAXException) {
                ParseException parseException;
                if (Trace.isTraceErrorOn()) {
                    sAXException.printStackTrace(Trace.getPrintWriter());
                }
                if ((parseException = this.m_xh.getException()) != null) {
                    throw parseException;
                }
                ParseException parseException2 = new ParseException(SystemResourceFinder.format("FAILED_TO_PARSE", new Object[]{this.m_docName}));
                parseException2.addMessage(sAXException.getMessage());
                throw parseException2;
            }
            inputStream.close();
            inputStream = null;
            object = this.m_xh.getException();
            if (object != null) {
                throw object;
            }
            this.augmentTree(this.m_rootNode, new Stack());
            this.checkAttributes(this.m_rootNode);
            if (this.m_rootNode != null && this.m_rootNode.getPcmlSpecificationException() != null) {
                throw this.m_rootNode.getPcmlSpecificationException();
            }
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        int n;
        String string3;
        if (string2 != null && string2.length() > 0 && (string3 = (n = string2.lastIndexOf("/")) == -1 ? string2 : string2.substring(n + 1)).equals("rfml.dtd")) {
            InputStream inputStream = SystemResourceFinder.getRFMLHeader();
            return new InputSource(inputStream);
        }
        try {
            return super.resolveEntity(string, string2);
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        PcmlDocNode pcmlDocNode = null;
        PcmlAttributeList pcmlAttributeList = new PcmlAttributeList(attributes.getLength());
        for (int i = 0; i < attributes.getLength(); ++i) {
            pcmlAttributeList.addAttribute(new PcmlAttribute(attributes.getQName(i), attributes.getValue(i), true));
        }
        pcmlDocNode = string3.equals("rfml") ? new RfmlDocument(pcmlAttributeList, this.m_docName) : (string3.equals("recordformat") ? new RfmlRecordFormat(pcmlAttributeList) : (string3.equals("struct") ? new RfmlStruct(pcmlAttributeList) : (string3.equals("data") ? new RfmlData(pcmlAttributeList) : null)));
        if (pcmlDocNode != null) {
            if (this.m_rootNode == null) {
                try {
                    this.m_rootNode = pcmlDocNode;
                }
                catch (ClassCastException classCastException) {
                    Trace.log(2, "Source document is not a well-formed RFML document.");
                    throw classCastException;
                }
                this.m_currentNode = pcmlDocNode;
            } else {
                this.m_currentNode.addChild(pcmlDocNode);
                this.m_currentNode = pcmlDocNode;
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.m_currentNode = (PcmlDocNode)this.m_currentNode.getParent();
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.m_xh == null) {
            throw sAXParseException;
        }
        this.m_xh.warning(sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.m_xh == null) {
            throw sAXParseException;
        }
        this.m_xh.error(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.m_xh == null) {
            throw sAXParseException;
        }
        this.m_xh.fatalError(sAXParseException);
    }
}

