/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.access.Trace;
import com.ibm.as400.micro.ConnectionHandler;
import com.ibm.as400.micro.MicroDataInputStream;
import com.ibm.as400.micro.MicroDataOutputStream;
import com.ibm.as400.micro.ResultSetHandler;
import com.ibm.as400.micro.Service;
import com.ibm.as400.micro.StatementHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class JdbcMeService
implements Service {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private Vector connections_ = new Vector();
    private Vector statements_ = new Vector();
    private Hashtable statementresults_;
    private Hashtable map_ = new Hashtable();
    private Properties properties_;
    private MicroDataInputStream in_;
    private MicroDataOutputStream out_;
    private int dataFlowType_ = 2;
    private int NextObjectId_ = 1;
    private ConnectionHandler connectionHandler_;
    private StatementHandler statementHandler_;
    private ResultSetHandler resultSetHandler_;

    public JdbcMeService() {
        this.statementresults_ = new Hashtable();
        this.registerDrivers();
    }

    @Override
    public void setDataStreams(MicroDataInputStream microDataInputStream, MicroDataOutputStream microDataOutputStream) {
        this.in_ = microDataInputStream;
        this.out_ = microDataOutputStream;
        this.connectionHandler_ = new ConnectionHandler(this, this.in_, this.out_);
        this.statementHandler_ = new StatementHandler(this, this.in_, this.out_);
        this.resultSetHandler_ = new ResultSetHandler(this, this.in_, this.out_);
    }

    @Override
    public boolean acceptsRequest(int n) {
        return n > 999 && n < 2000;
    }

    @Override
    public void handleRequest(int n) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, "Function id is " + Integer.toHexString(n));
        }
        if (this.isServiceRequest(n)) {
            this.process(n);
            return;
        }
        if (n == 4688) {
            block18: {
                boolean bl;
                if (Trace.isTraceOn()) {
                    Trace.log(6, "JDBC Service: The request is here. " + Integer.toHexString(n));
                }
                if (bl = Trace.isTraceOn()) {
                    Trace.setTraceOn(false);
                }
                String string = this.in_.readUTF();
                if (bl) {
                    Trace.setTraceOn(true);
                }
                try {
                    Connection connection = DriverManager.getConnection(string);
                    this.connections_.addElement(connection);
                    int n2 = this.getNextObjectId();
                    this.map_.put(new Integer(n2), new Integer(connection.hashCode()));
                    this.out_.writeInt(n2);
                    this.out_.flush();
                }
                catch (SQLException sQLException) {
                    this.handleException(sQLException);
                }
                catch (Exception exception) {
                    if (!Trace.isTraceOn()) break block18;
                    Trace.log(2, exception);
                }
            }
            return;
        }
        int n3 = this.in_.readInt();
        Object object = this.processJdbcObject(n3);
        if (object instanceof Connection) {
            this.connectionHandler_.process((Connection)object, n);
        } else if (object instanceof Statement) {
            this.statementHandler_.process((Statement)object, n);
        } else if (object instanceof ResultSet) {
            this.resultSetHandler_.process((ResultSet)object, n);
        } else {
            if (Trace.isTraceOn()) {
                Trace.log(6, "Error, unknown Jdbc object < " + object + ">");
            }
            try {
                throw new SQLException("Error, unknown Jdbc object < " + object + ">");
            }
            catch (SQLException sQLException) {
                this.handleException(sQLException);
            }
        }
    }

    public Object processJdbcObject(int n) throws IOException {
        block6: {
            Integer n2 = (Integer)this.map_.get(new Integer(n));
            int n3 = n2;
            Object var4_4 = null;
            try {
                int n4;
                int n5;
                Collection collection = this.statementresults_.values();
                for (ResultSet resultSet : collection) {
                    int n6 = resultSet.hashCode();
                    if (n3 != n6) continue;
                    return resultSet;
                }
                for (n5 = 0; n5 < this.statements_.size(); ++n5) {
                    Statement statement = (Statement)this.statements_.elementAt(n5);
                    n4 = statement.hashCode();
                    if (n3 != n4) continue;
                    return statement;
                }
                for (n5 = 0; n5 < this.connections_.size(); ++n5) {
                    Connection connection = (Connection)this.connections_.elementAt(n5);
                    n4 = connection.hashCode();
                    if (n3 != n4) continue;
                    return connection;
                }
            }
            catch (Exception exception) {
                if (!Trace.isTraceOn()) break block6;
                Trace.log(2, exception);
            }
        }
        if (Trace.isTraceOn()) {
            Trace.log(2, "ERROR! returning null from processJdbcObject!");
        }
        return null;
    }

    public void addStatement(Statement statement) {
        this.statements_.addElement(statement);
    }

    public void addConnection(Connection connection) {
        this.connections_.addElement(connection);
    }

    public void addResultSet(Statement statement, ResultSet resultSet) throws SQLException {
        this.statementresults_.remove(statement);
        this.statementresults_.put(statement, resultSet);
    }

    public void removeStatement(Statement statement) {
        this.statements_.remove(statement);
        this.statementresults_.remove(statement);
    }

    public void removeResultSet(ResultSet resultSet) throws SQLException {
        Collection collection = this.statementresults_.values();
        collection.remove(resultSet);
    }

    public void removeConnection(Connection connection) {
        Connection connection2 = null;
        for (int i = 0; i < this.statements_.size(); ++i) {
            Statement statement;
            block4: {
                statement = (Statement)this.statements_.elementAt(i);
                try {
                    connection2 = statement.getConnection();
                }
                catch (SQLException sQLException) {
                    if (!Trace.isTraceOn()) break block4;
                    Trace.log(2, "Exception thrown trying to get the connection for a statement.", (Throwable)sQLException);
                }
            }
            if (connection != connection2) continue;
            if (Trace.isTraceOn()) {
                Trace.log(6, "Implicitly closing a statement because of connection close");
            }
            this.removeStatement(statement);
        }
        this.connections_.remove(connection);
    }

    public void handleException(SQLException sQLException) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(2, sQLException);
        }
        this.out_.writeInt(-1);
        String string = sQLException.getSQLState();
        if (string == null) {
            string = "null";
        }
        this.out_.writeUTF(string);
        string = sQLException.getMessage();
        if (string == null) {
            string = "null";
        }
        this.out_.writeUTF(string);
        this.out_.flush();
    }

    public int getNextObjectId() {
        int n = this.NextObjectId_++;
        return n;
    }

    public int mapObject(Object object) {
        int n = this.getNextObjectId();
        this.map_.put(new Integer(n), new Integer(object.hashCode()));
        return n;
    }

    public void registerDrivers() {
        block3: {
            String string = "com.ibm.as400.access.AS400JDBCDriver";
            if (Trace.isTraceOn()) {
                Trace.log(6, "Loading driver: " + string);
            }
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!Trace.isTraceOn()) break block3;
                Trace.log(6, "Failed to load driver " + string);
            }
        }
    }

    public boolean isServiceRequest(int n) {
        return n > 1900 && n < 1999;
    }

    public void process(int n) throws IOException {
        switch (n) {
            case 6400: {
                this.setDataFlowType();
                break;
            }
            default: {
                System.out.println("Error - JDBC-ME Service request unrecognized - function code: " + n);
            }
        }
    }

    public int getDataFlowType() {
        return this.dataFlowType_;
    }

    public void setDataFlowType() throws IOException {
        int n = this.in_.readInt();
        if (n == 1 || n == 2 || n == 3) {
            this.dataFlowType_ = n;
            this.out_.writeInt(1);
            this.out_.flush();
        } else {
            this.handleServiceException("An invalid setting was passed for setting the data flow type: " + n);
        }
    }

    public void handleServiceException(String string) throws IOException {
        this.out_.writeInt(-1);
        this.out_.writeUTF("JDBC");
        this.out_.writeUTF(string);
        this.out_.flush();
    }
}

