/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

class DateValueMap
implements ValueMap,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final int FORMAT_6 = 6;
    public static final int FORMAT_7 = 7;
    public static final int FORMAT_13 = 13;
    public static final int FORMAT_DTS = 99;
    static final Date NO_DATE = new Date(0L);
    private static final String DTS = "*DTS";
    private static final String HHMMSS_ZEROS = "000000";
    private static final String CYYMMDD_ZEROS = "0000000";
    private int format_ = -1;

    public DateValueMap(int n) {
        if (n != 6 && n != 7 && n != 13 && n != 99) {
            throw new ExtendedIllegalArgumentException("format", 2);
        }
        this.format_ = n;
    }

    @Override
    public Object ltop(Object object, AS400 aS400) {
        if (object == null) {
            throw new NullPointerException("logicalValue");
        }
        switch (this.format_) {
            case 13: {
                return DateValueMap.dateToString13((Date)object);
            }
            case 7: {
                return DateValueMap.dateToString13((Date)object).substring(0, 7);
            }
            case 6: {
                return DateValueMap.dateToString13((Date)object).substring(7);
            }
            case 99: {
                if (aS400 == null) {
                    throw new NullPointerException("system");
                }
                try {
                    DateTimeConverter dateTimeConverter = new DateTimeConverter(aS400);
                    return dateTimeConverter.convert((Date)object, DTS);
                }
                catch (Exception exception) {
                    throw new ExtendedIllegalArgumentException("logicalValue", 2);
                }
            }
        }
        throw new ExtendedIllegalStateException("format", 6);
    }

    @Override
    public Object ptol(Object object, AS400 aS400) {
        if (object == null) {
            throw new NullPointerException("physicalValue");
        }
        switch (this.format_) {
            case 13: {
                return DateValueMap.string13ToDate((String)object);
            }
            case 7: {
                return DateValueMap.string13ToDate((String)object + HHMMSS_ZEROS);
            }
            case 6: {
                return DateValueMap.string13ToDate(CYYMMDD_ZEROS + (String)object);
            }
            case 99: {
                if (aS400 == null) {
                    throw new NullPointerException("system");
                }
                try {
                    byte[] byArray = (byte[])object;
                    if (byArray[0] == 64 || byArray[0] == 0) {
                        return NO_DATE;
                    }
                    DateTimeConverter dateTimeConverter = new DateTimeConverter(aS400);
                    return dateTimeConverter.convert((byte[])object, DTS);
                }
                catch (Exception exception) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "Error converting date from DTS format", (Throwable)exception);
                    }
                    throw new ExtendedIllegalArgumentException("physicalValue", 2);
                }
            }
        }
        throw new ExtendedIllegalArgumentException("physicalValue", 2);
    }

    private static String dateToString13(Date date) {
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer(13);
        int n = calendar.get(1);
        stringBuffer.append(n < 2000 ? (char)'0' : '1');
        stringBuffer.append(DateValueMap.twoDigits(n % 100));
        stringBuffer.append(DateValueMap.twoDigits(calendar.get(2) + 1));
        stringBuffer.append(DateValueMap.twoDigits(calendar.get(5)));
        stringBuffer.append(DateValueMap.twoDigits(calendar.get(11)));
        stringBuffer.append(DateValueMap.twoDigits(calendar.get(12)));
        stringBuffer.append(DateValueMap.twoDigits(calendar.get(13)));
        return stringBuffer.toString();
    }

    private static Date string13ToDate(String string) {
        int n = string.length();
        Calendar calendar = AS400Calendar.getGregorianInstance();
        if (n == 0) {
            return NO_DATE;
        }
        if (string.charAt(0) == '*') {
            return NO_DATE;
        }
        int n2 = Integer.parseInt(string.substring(0, 1));
        int n3 = Integer.parseInt(string.substring(1, 3));
        int n4 = Integer.parseInt(string.substring(3, 5));
        int n5 = Integer.parseInt(string.substring(5, 7));
        int n6 = Integer.parseInt(string.substring(7, 9));
        int n7 = Integer.parseInt(string.substring(9, 11));
        int n8 = Integer.parseInt(string.substring(11, 13));
        calendar.set(1, n3 + (n2 == 0 ? 1900 : 2000));
        calendar.set(2, n4 - 1);
        calendar.set(5, n5);
        calendar.set(11, n6);
        calendar.set(12, n7);
        calendar.set(13, n8);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static String twoDigits(int n) {
        if (n > 99) {
            throw new ExtendedIllegalArgumentException("value", 2);
        }
        String string = "00" + Integer.toString(n);
        return string.substring(string.length() - 2);
    }
}

