/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.AbstractValueMap;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.CommandAttributeSetter;
import com.ibm.as400.resource.CommandMap;
import com.ibm.as400.resource.DateValueMap;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.QuoteValueMap;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;
import java.util.Date;

public class RJavaProgram
extends ChangeableResource {
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_;
    private static final String ICON_BASE_NAME_ = "RJavaProgram";
    private static final String PRESENTATION_KEY_ = "JAVA_PROGRAM";
    public static final String YES = "*YES";
    public static final String NO = "*NO";
    static ResourceMetaDataTable attributes_;
    private static ProgramMap getterMap_;
    private static CommandMap setterMap_;
    private static final String CRTJVAPGM_ = "CRTJVAPGM";
    private static final String CHGJVAPGM_ = "CHGJVAPGM";
    private static final String PATH_PARAMETER_ = "CLSF";
    private static final String QJVAMAT_ = "qjvamat";
    public static final String TOTAL_CLASSES_IN_SOURCE = "TOTAL_CLASSES_IN_SOURCE";
    public static final String CLASSES_WITH_ERRORS = "CLASSES_WITH_ERRORS";
    public static final String CLASSES_WITH_CURRENT_JAVA_PROGRAMS = "CLASSES_WITH_CURRENT_JAVA_PROGRAMS";
    public static final String CLASSES_WITHOUT_CURRENT_JAVA_PROGRAMS = "CLASSES_WITHOUT_CURRENT_JAVA_PROGRAMS";
    public static final String ENABLE_PERFORMANCE_COLLECTION = "ENABLE_PERFORMANCE_COLLECTION";
    public static final String ENABLE_PERFORMANCE_COLLECTION_NONE = "*NONE";
    public static final String ENABLE_PERFORMANCE_COLLECTION_ENTRY_EXIT = "*ENTRYEXIT";
    public static final String ENABLE_PERFORMANCE_COLLECTION_FULL = "*FULL";
    public static final String PROFILING_DATA = "PROFILING_DATA";
    public static final String PROFILING_DATA_NOCOLLECTION = "*NOCOL";
    public static final String PROFILING_DATA_COLLECTION = "*COL";
    public static final String PROFILING_DATA_APPLY = "*APY";
    public static final String PROFILING_DATA_CLEAR = "*CLR";
    public static final String FILE_CHANGE = "FILE_CHANGE";
    public static final String JAVA_PROGRAMS = "JAVA_PROGRAMS";
    public static final String JAVA_PROGRAM_CREATION = "JAVA_PROGRAM_CREATION";
    public static final String JAVA_PROGRAM_SIZE = "JAVA_PROGRAM_SIZE";
    public static final String LICENSED_INTERNAL_CODE_OPTIONS = "LICENSED_INTERNAL_CODE_OPTIONS";
    public static final String OPTIMIZATION = "OPTIMIZATION";
    public static final Integer OPTIMIZATION_INTERPRET;
    private static final String OPTIMIZATION_INTERPRET_PHYSICAL = "*INTERPRET";
    public static final Integer OPTIMIZATION_10;
    public static final Integer OPTIMIZATION_20;
    public static final Integer OPTIMIZATION_30;
    public static final Integer OPTIMIZATION_40;
    public static final String OWNER = "OWNER";
    public static final String RELEASE_PROGRAM_CREATED_FOR = "RELEASE_PROGRAM_CREATED_FOR";
    public static final String USE_ADOPTED_AUTHORITY = "USE_ADOPTED_AUTHORITY";
    public static final String USER_PROFILE = "USER_PROFILE";
    public static final String USER_PROFILE_USER = "*USER";
    public static final String USER_PROFILE_OWNER = "*OWNER";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RJavaProgram";
    private static ProgramCallDocument staticDocument_;
    private String path_ = null;
    private ProgramAttributeGetter attributeGetter_ = null;
    private CommandAttributeSetter attributeSetter_ = null;
    private ProgramCallDocument document_ = null;

    public RJavaProgram() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    public RJavaProgram(AS400 aS400, String string) {
        this();
        try {
            this.setSystem(aS400);
            this.setPath(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void checkVRM() throws ResourceException {
        try {
            if (this.getSystem() != null && this.getSystem().getVRM() > 459008) {
                Trace.log(2, "RJavaProgram is not supported beyond IBM i 7.1.");
                throw new ResourceException(5);
            }
        }
        catch (ResourceException resourceException) {
            throw resourceException;
        }
        catch (Exception exception) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when checking system VRM.", (Throwable)exception);
            }
            throw new ResourceException(exception);
        }
    }

    @Override
    protected void commitAttributeChanges(Object[] objectArray, Object[] objectArray2) throws ResourceException {
        this.checkVRM();
        super.commitAttributeChanges(objectArray, objectArray2);
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeSetter_.setValues(objectArray, objectArray2);
    }

    static Object computeResourceKey(AS400 aS400, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RJavaProgram.class);
        stringBuffer.append(':');
        stringBuffer.append(aS400.getSystemName());
        stringBuffer.append(':');
        stringBuffer.append(aS400.getUserId());
        stringBuffer.append(':');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void delete() throws ResourceException {
        this.checkVRM();
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        StringBuffer stringBuffer = new StringBuffer("DLTJVAPGM CLSF('");
        stringBuffer.append(this.path_);
        stringBuffer.append("')");
        try {
            this.fireBusy();
            CommandCall commandCall = new CommandCall(this.getSystem(), stringBuffer.toString());
            if (!commandCall.run()) {
                throw new ResourceException(commandCall.getMessageList());
            }
        }
        catch (Exception exception) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when deleting a Java program", (Throwable)exception);
            }
            throw new ResourceException(exception);
        }
        finally {
            this.fireIdle();
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        AS400 aS400;
        block3: {
            super.establishConnection();
            if (this.path_ == null) {
                throw new ExtendedIllegalStateException("path", 4);
            }
            this.document_ = (ProgramCallDocument)staticDocument_.clone();
            aS400 = this.getSystem();
            try {
                this.document_.setSystem(aS400);
                this.document_.setIntValue("qjvamat.lengthOfPathName", this.path_.length());
                this.document_.setValue("qjvamat.pathName", this.path_);
            }
            catch (PcmlException pcmlException) {
                if (!Trace.isTraceOn()) break block3;
                Trace.log(2, "Error setting PCML document values", (Throwable)pcmlException);
            }
        }
        this.attributeGetter_ = new ProgramAttributeGetter(aS400, this.document_, getterMap_);
        this.attributeSetter_ = new CommandAttributeSetter(aS400, setterMap_);
        this.attributeSetter_.setParameterValue(CHGJVAPGM_, PATH_PARAMETER_, "'" + this.path_ + "'");
    }

    @Override
    protected void freezeProperties() throws ResourceException {
        super.freezeProperties();
        if (this.path_ == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        Presentation presentation = this.getPresentation();
        IFSFile iFSFile = new IFSFile(this.getSystem(), this.path_);
        presentation.setName(iFSFile.getName());
        presentation.setFullName(iFSFile.getPath());
        if (this.getResourceKey() == null) {
            this.setResourceKey(RJavaProgram.computeResourceKey(this.getSystem(), this.path_));
        }
    }

    @Override
    public Object getAttributeUnchangedValue(Object object) throws ResourceException {
        this.checkVRM();
        Object object2 = super.getAttributeUnchangedValue(object);
        if (object2 == null) {
            if (!this.isConnectionEstablished()) {
                this.establishConnection();
            }
            object2 = this.attributeGetter_.getValue(object);
        }
        return object2;
    }

    public String getPath() {
        return this.path_;
    }

    @Override
    public void refreshAttributeValues() throws ResourceException {
        this.checkVRM();
        super.refreshAttributeValues();
        if (this.attributeGetter_ != null) {
            this.attributeGetter_.clearBuffer();
        }
    }

    public void setPath(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.path_;
        this.path_ = string;
        this.firePropertyChange("path", string2, this.path_);
    }

    @Override
    public String toString() {
        return this.path_ == null ? "" : this.path_;
    }

    static {
        block6: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            attributes_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            getterMap_ = new ProgramMap();
            setterMap_ = new CommandMap();
            try {
                attributes_.add((Object)TOTAL_CLASSES_IN_SOURCE, Integer.class, true);
                getterMap_.add(TOTAL_CLASSES_IN_SOURCE, QJVAMAT_, "receiverVariable.numberOfTotalClassesInSource");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                attributes_.add((Object)CLASSES_WITH_ERRORS, Integer.class, true);
                getterMap_.add(CLASSES_WITH_ERRORS, QJVAMAT_, "receiverVariable.numberOfClassesWithErrors");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            attributes_.add((Object)CLASSES_WITH_CURRENT_JAVA_PROGRAMS, Integer.class, true);
            getterMap_.add(CLASSES_WITH_CURRENT_JAVA_PROGRAMS, QJVAMAT_, "receiverVariable.numberOfClassesWithCurrentJavaPrograms");
            attributes_.add((Object)CLASSES_WITHOUT_CURRENT_JAVA_PROGRAMS, Integer.class, true);
            getterMap_.add(CLASSES_WITHOUT_CURRENT_JAVA_PROGRAMS, QJVAMAT_, "receiverVariable.numberOfClassesWithoutCurrentJavaPrograms");
            attributes_.add(ENABLE_PERFORMANCE_COLLECTION, String.class, false, new Object[]{ENABLE_PERFORMANCE_COLLECTION_NONE, ENABLE_PERFORMANCE_COLLECTION_ENTRY_EXIT, ENABLE_PERFORMANCE_COLLECTION_FULL}, null, true);
            getterMap_.add((Object)ENABLE_PERFORMANCE_COLLECTION, QJVAMAT_, "receiverVariable.performanceCollectionEnabledFlag", new EnablePerformanceCollectionValueMap_());
            setterMap_.add(ENABLE_PERFORMANCE_COLLECTION, CHGJVAPGM_, "ENBPFRCOL");
            attributes_.add(PROFILING_DATA, String.class, false, new Object[]{PROFILING_DATA_NOCOLLECTION, PROFILING_DATA_COLLECTION, PROFILING_DATA_CLEAR, PROFILING_DATA_APPLY}, null, true);
            getterMap_.add((Object)PROFILING_DATA, QJVAMAT_, "receiverVariable.profilingDataStatus", new ProfilingDataValueMap_());
            setterMap_.add(PROFILING_DATA, CHGJVAPGM_, "PRFDTA");
            attributes_.add((Object)FILE_CHANGE, Date.class, true);
            getterMap_.add((Object)FILE_CHANGE, QJVAMAT_, "receiverVariable.fileChangeModifyDateAndTime", new DateValueMap(13));
            attributes_.add((Object)JAVA_PROGRAMS, Integer.class, true);
            getterMap_.add(JAVA_PROGRAMS, QJVAMAT_, "receiverVariable.numberOfJavaProgramsAttached");
            attributes_.add((Object)JAVA_PROGRAM_CREATION, Date.class, true);
            getterMap_.add((Object)JAVA_PROGRAM_CREATION, QJVAMAT_, "receiverVariable.javaProgramCreationDateAndTime", new DateValueMap(13));
            attributes_.add((Object)JAVA_PROGRAM_SIZE, Long.class, true);
            getterMap_.add((Object)JAVA_PROGRAM_SIZE, QJVAMAT_, "receiverVariable.sizeOfJavaProgramsAttached", new JavaProgramSizeValueMap_());
            attributes_.add((Object)LICENSED_INTERNAL_CODE_OPTIONS, String.class, false);
            getterMap_.add(LICENSED_INTERNAL_CODE_OPTIONS, QJVAMAT_, "receiverVariable.LICOptions");
            setterMap_.add(LICENSED_INTERNAL_CODE_OPTIONS, CHGJVAPGM_, "LICOPT", new QuoteValueMap());
            OPTIMIZATION_INTERPRET = new Integer(-1);
            OPTIMIZATION_10 = new Integer(10);
            OPTIMIZATION_20 = new Integer(20);
            OPTIMIZATION_30 = new Integer(30);
            OPTIMIZATION_40 = new Integer(40);
            attributes_.add(OPTIMIZATION, Integer.class, false, new Object[]{OPTIMIZATION_INTERPRET, OPTIMIZATION_10, OPTIMIZATION_20, OPTIMIZATION_30, OPTIMIZATION_40}, null, true);
            OptimizationValueMap_ optimizationValueMap_ = new OptimizationValueMap_();
            getterMap_.add((Object)OPTIMIZATION, QJVAMAT_, "receiverVariable.optimizationLevel", optimizationValueMap_);
            setterMap_.add(OPTIMIZATION, CHGJVAPGM_, "OPTIMIZE", optimizationValueMap_);
            attributes_.add((Object)OWNER, String.class, true);
            getterMap_.add(OWNER, QJVAMAT_, "receiverVariable.fileOwnerName");
            attributes_.add((Object)RELEASE_PROGRAM_CREATED_FOR, String.class, true);
            getterMap_.add((Object)RELEASE_PROGRAM_CREATED_FOR, QJVAMAT_, "receiverVariable.javaProgramVersion", new ReleaseProgramCreatedForValueMap_());
            attributes_.add(USE_ADOPTED_AUTHORITY, String.class, true, new Object[]{YES, NO}, null, true);
            getterMap_.add((Object)USE_ADOPTED_AUTHORITY, QJVAMAT_, "receiverVariable.useAdoptedAuthority", new UseAdoptedAuthorityValueMap_());
            attributes_.add(USER_PROFILE, String.class, true, new Object[]{USER_PROFILE_USER, USER_PROFILE_OWNER}, null, true);
            getterMap_.add((Object)USER_PROFILE, QJVAMAT_, "receiverVariable.adoptedAuthorityProfile", new UserProfileValueMap_());
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException pcmlException) {
                if (!Trace.isTraceOn()) break block6;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)pcmlException);
            }
        }
    }

    private static class UserProfileValueMap_
    extends AbstractValueMap {
        private UserProfileValueMap_() {
        }

        @Override
        public Object ptol(Object object) {
            return object.equals("1") ? RJavaProgram.USER_PROFILE_OWNER : RJavaProgram.USER_PROFILE_USER;
        }
    }

    private static class UseAdoptedAuthorityValueMap_
    extends AbstractValueMap {
        private UseAdoptedAuthorityValueMap_() {
        }

        @Override
        public Object ptol(Object object) {
            return object.equals("1") ? RJavaProgram.YES : RJavaProgram.NO;
        }
    }

    private static class ReleaseProgramCreatedForValueMap_
    extends AbstractValueMap {
        private ReleaseProgramCreatedForValueMap_() {
        }

        @Override
        public Object ptol(Object object) {
            byte[] byArray = (byte[])object;
            StringBuffer stringBuffer = new StringBuffer("V");
            stringBuffer.append(byArray[0]);
            stringBuffer.append("R");
            stringBuffer.append(byArray[1] >> 4);
            stringBuffer.append("M");
            stringBuffer.append(byArray[1] & 0xF);
            return stringBuffer.toString();
        }
    }

    private static class OptimizationValueMap_
    extends AbstractValueMap {
        private OptimizationValueMap_() {
        }

        @Override
        public Object ptol(Object object) {
            if ((Integer)object == 0) {
                return OPTIMIZATION_INTERPRET;
            }
            return object;
        }

        @Override
        public Object ltop(Object object) {
            if (object.equals(OPTIMIZATION_INTERPRET)) {
                return RJavaProgram.OPTIMIZATION_INTERPRET_PHYSICAL;
            }
            return object.toString();
        }
    }

    private static class JavaProgramSizeValueMap_
    extends AbstractValueMap {
        private JavaProgramSizeValueMap_() {
        }

        @Override
        public Object ptol(Object object) {
            if (object instanceof Integer) {
                return new Long(((Integer)object).intValue());
            }
            return object;
        }
    }

    private static class ProfilingDataValueMap_
    extends AbstractValueMap {
        private ProfilingDataValueMap_() {
        }

        @Override
        public Object ptol(Object object) {
            if (object.equals("2")) {
                return RJavaProgram.PROFILING_DATA_APPLY;
            }
            if (object.equals("1")) {
                return RJavaProgram.PROFILING_DATA_COLLECTION;
            }
            return RJavaProgram.PROFILING_DATA_NOCOLLECTION;
        }
    }

    private static class EnablePerformanceCollectionValueMap_
    extends AbstractValueMap {
        private EnablePerformanceCollectionValueMap_() {
        }

        @Override
        public Object ptol(Object object) {
            if (object.equals("11")) {
                return RJavaProgram.ENABLE_PERFORMANCE_COLLECTION_FULL;
            }
            if (object.equals("10")) {
                return RJavaProgram.ENABLE_PERFORMANCE_COLLECTION_ENTRY_EXIT;
            }
            return RJavaProgram.ENABLE_PERFORMANCE_COLLECTION_NONE;
        }
    }
}

