/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.DateValueMap;
import com.ibm.as400.resource.IntegerValueMap;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.QualifiedValueMap;
import com.ibm.as400.resource.RQueuedMessage;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ResourcePool;
import com.ibm.as400.resource.SubstringValueMap;
import com.ibm.as400.resource.SystemResourceList;
import java.beans.PropertyVetoException;

public class RJobLog
extends SystemResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final byte[] NEWEST;
    public static final String NEXT = "*NEXT";
    public static final byte[] OLDEST;
    public static final String PREVIOUS = "*PRV";
    private static final String PRESENTATION_KEY_ = "JOB_LOG";
    private static final String ICON_BASE_NAME_ = "RJobLog";
    private static PresentationLoader presentationLoader_;
    private static ResourceMetaDataTable selections_;
    private static ProgramMap selectionMap_;
    public static final String LIST_DIRECTION = "LIST_DIRECTION";
    public static final String STARTING_MESSAGE_KEY = "STARTING_MESSAGE_KEY";
    private static ProgramMap openListAttributeMap_;
    private static final String openListProgramName_ = "qgyoljbl";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RJobLog";
    private static ProgramCallDocument staticDocument_;
    private static final String DEFAULT_MESSAGE_FILE_ = "/QSYS.LIB/QCPFMSG.MSGF";
    private static final byte[] EMPTY_BYTES_;
    private static final byte[] BLANK_INTERNAL_JOB_ID_;
    private byte[] internalJobID_ = null;
    private String name_ = "*";
    private String number_ = "";
    private String user_ = "";

    public RJobLog() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RQueuedMessage.attributes_, selections_, null, openListProgramName_, null, selectionMap_);
        this.updatePresentation();
    }

    public RJobLog(AS400 aS400) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RJobLog(AS400 aS400, String string, String string2, String string3) {
        this();
        try {
            this.setSystem(aS400);
            this.setName(string);
            this.setUser(string2);
            this.setNumber(string3);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RJobLog(AS400 aS400, byte[] byArray) {
        this();
        try {
            this.setSystem(aS400);
            this.setName("*INT");
            this.setInternalJobID(byArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        ProgramCallDocument programCallDocument;
        block7: {
            if (this.internalJobID_ == null && !this.name_.equals("*")) {
                if (this.number_.length() == 0) {
                    throw new ExtendedIllegalStateException("number", 4);
                }
                if (this.user_.length() == 0) {
                    throw new ExtendedIllegalStateException("user", 4);
                }
            }
            super.establishConnection();
            programCallDocument = (ProgramCallDocument)staticDocument_.clone();
            try {
                if (this.internalJobID_ != null) {
                    programCallDocument.setValue("qgyoljbl.messageSelectionInformation.internalJobIdentifier", this.internalJobID_);
                    programCallDocument.setValue("qgyoljbl.messageSelectionInformation.qualifiedJobName.jobName", "*INT");
                } else {
                    programCallDocument.setValue("qgyoljbl.messageSelectionInformation.internalJobIdentifier", BLANK_INTERNAL_JOB_ID_);
                    programCallDocument.setValue("qgyoljbl.messageSelectionInformation.qualifiedJobName.jobName", this.name_.toUpperCase());
                    programCallDocument.setValue("qgyoljbl.messageSelectionInformation.qualifiedJobName.jobNumber", this.number_.toUpperCase());
                    programCallDocument.setValue("qgyoljbl.messageSelectionInformation.qualifiedJobName.userName", this.user_.toUpperCase());
                }
            }
            catch (PcmlException pcmlException) {
                if (!Trace.isTraceOn()) break block7;
                Trace.log(2, "Error setting path information in PCML document", (Throwable)pcmlException);
            }
        }
        this.setDocument(programCallDocument);
    }

    public byte[] getInternalJobID() {
        return this.internalJobID_;
    }

    public String getName() {
        return this.name_;
    }

    public String getNumber() {
        return this.number_;
    }

    public String getUser() {
        return this.user_;
    }

    public void setInternalJobID(byte[] byArray) throws PropertyVetoException {
        if (byArray == null) {
            throw new NullPointerException("internalJobID");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        byte[] byArray2 = this.internalJobID_;
        this.fireVetoableChange("internalJobID", byArray2, byArray);
        this.internalJobID_ = byArray;
        this.updatePresentation();
        this.firePropertyChange("internalJobID", byArray2, byArray);
    }

    public void setName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.name_;
        this.fireVetoableChange("name", string2, string);
        this.name_ = string;
        this.updatePresentation();
        this.firePropertyChange("name", string2, string);
    }

    public void setNumber(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("number");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.number_;
        this.fireVetoableChange("number", string2, string);
        this.number_ = string;
        this.updatePresentation();
        this.firePropertyChange("number", string2, string);
    }

    public void setUser(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("user");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.user_;
        this.fireVetoableChange("user", string2, string);
        this.user_ = string;
        this.updatePresentation();
        this.firePropertyChange("user", string2, string);
    }

    private void updatePresentation() {
        Presentation presentation = this.getPresentation();
        presentation.setName(this.name_);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.number_);
        stringBuffer.append('/');
        stringBuffer.append(this.user_);
        stringBuffer.append('/');
        stringBuffer.append(this.name_);
        presentation.setFullName(stringBuffer.toString());
    }

    public static void writeMessage(AS400 aS400, String string, int n) throws ResourceException {
        RJobLog.writeMessage(aS400, string, n, DEFAULT_MESSAGE_FILE_, null);
    }

    public static void writeMessage(AS400 aS400, String string, int n, byte[] byArray) throws ResourceException {
        RJobLog.writeMessage(aS400, string, n, DEFAULT_MESSAGE_FILE_, byArray);
    }

    public static void writeMessage(AS400 aS400, String string, int n, String string2) throws ResourceException {
        RJobLog.writeMessage(aS400, string, n, string2, null);
    }

    public static void writeMessage(AS400 aS400, String string, int n, String string2, byte[] byArray) throws ResourceException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("messageID");
        }
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = "*COMP";
                break;
            }
            case 2: {
                string3 = "*DIAG";
                break;
            }
            case 4: {
                string3 = "*INFO";
                break;
            }
            case 15: {
                string3 = "*ESCAPE";
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("messageType", 2);
            }
        }
        if (string2 == null) {
            throw new NullPointerException("messageFile");
        }
        if (string2.length() == 0) {
            throw new ExtendedIllegalArgumentException("messageFile", 2);
        }
        try {
            ProgramCallDocument programCallDocument = (ProgramCallDocument)staticDocument_.clone();
            programCallDocument.setSystem(aS400);
            programCallDocument.setValue("qmhsndpm.messageID", string);
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string2);
            programCallDocument.setValue("qmhsndpm.qualifiedMessageFileName.objectName", qSYSObjectPathName.getObjectName());
            programCallDocument.setValue("qmhsndpm.qualifiedMessageFileName.libraryName", qSYSObjectPathName.getLibraryName());
            if (byArray == null) {
                programCallDocument.setIntValue("qmhsndpm.lengthOfMessageDataOrImmediateText", 0);
                programCallDocument.setValue("qmhsndpm.messageDataOrImmediateText", "");
            } else {
                programCallDocument.setIntValue("qmhsndpm.lengthOfMessageDataOrImmediateText", byArray.length);
                programCallDocument.setValue("qmhsndpm.messageDataOrImmediateText", byArray);
            }
            programCallDocument.setValue("qmhsndpm.messageType", string3);
            if (!programCallDocument.callProgram("qmhsndpm")) {
                AS400Message[] aS400MessageArray = programCallDocument.getMessageList("qmhsndpm");
                if (aS400MessageArray.length == 1 && aS400MessageArray[0].getID().equals(string) && aS400MessageArray[0].getType() == n) {
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "False escape message ignored.");
                    }
                    return;
                }
                throw new ResourceException(aS400MessageArray);
            }
        }
        catch (PcmlException pcmlException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when writing a message", (Throwable)pcmlException);
            }
            throw new ResourceException(pcmlException);
        }
    }

    @Override
    Resource newResource(String string, int[] nArray) throws PcmlException, ResourceException {
        AS400 aS400 = this.getSystem();
        ProgramCallDocument programCallDocument = this.getDocument();
        byte[] byArray = (byte[])programCallDocument.getValue(string + ".receiverVariable.messageKey", nArray);
        String string2 = this.toString();
        Object object = RQueuedMessage.computeResourceKey(aS400, string2, byArray);
        RQueuedMessage rQueuedMessage = (RQueuedMessage)ResourcePool.GLOBAL_RESOURCE_POOL.getResource(object);
        if (rQueuedMessage == null) {
            rQueuedMessage = new RQueuedMessage();
            rQueuedMessage.setResourceKey(object);
        }
        Object[] objectArray = openListAttributeMap_.getIDs();
        Object[] objectArray2 = openListAttributeMap_.getValues(objectArray, aS400, programCallDocument, string, nArray);
        for (int i = 0; i < objectArray2.length; ++i) {
            rQueuedMessage.initializeAttributeValue(objectArray[i], objectArray2[i]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)rQueuedMessage.getAttributeValue("MESSAGE_ID"));
        stringBuffer.append('(');
        stringBuffer.append(Presentation.bytesToHex((byte[])rQueuedMessage.getAttributeValue("MESSAGE_KEY")));
        stringBuffer.append(')');
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string2);
        stringBuffer2.append('-');
        stringBuffer2.append(stringBuffer.toString());
        Presentation presentation = rQueuedMessage.getPresentation();
        presentation.setName(stringBuffer.toString());
        presentation.setFullName(stringBuffer2.toString());
        presentation.setValue("Description Text", rQueuedMessage.getAttributeValue("MESSAGE_TEXT"));
        presentation.setValue("Help Text", rQueuedMessage.getAttributeValue("MESSAGE_HELP"));
        return rQueuedMessage;
    }

    static {
        block2: {
            NEWEST = new byte[]{-1, -1, -1, -1};
            OLDEST = new byte[]{0, 0, 0, 0};
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            selections_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            selectionMap_ = new ProgramMap();
            selections_.add(LIST_DIRECTION, String.class, false, new String[]{NEXT, PREVIOUS}, NEXT, true);
            selectionMap_.add(LIST_DIRECTION, null, "messageSelectionInformation.listDirection");
            selections_.add(STARTING_MESSAGE_KEY, byte[].class, false, (Object[])new byte[][]{NEWEST, OLDEST}, OLDEST, false);
            selectionMap_.add(STARTING_MESSAGE_KEY, null, "messageSelectionInformation.startingMessageKey");
            openListAttributeMap_ = new ProgramMap();
            openListAttributeMap_.add("MESSAGE_SEVERITY", null, "receiverVariable.messageSeverity");
            openListAttributeMap_.add("MESSAGE_ID", null, "receiverVariable.messageIdentifier");
            openListAttributeMap_.add((Object)"MESSAGE_TYPE", null, "receiverVariable.messageType", new IntegerValueMap());
            openListAttributeMap_.add("MESSAGE_KEY", null, "receiverVariable.messageKey");
            openListAttributeMap_.add((Object)"MESSAGE_FILE", null, "receiverVariable.messageFile", new QualifiedValueMap(20, "MSGF"));
            openListAttributeMap_.add((Object)"DATE_SENT", null, "receiverVariable.dateAndTimeSent", new DateValueMap(13));
            openListAttributeMap_.add("MESSAGE_TEXT", null, "receiverVariable.messageWithReplacementData.data");
            openListAttributeMap_.add((Object)"SENDER_JOB_NAME", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(0, 10, true));
            openListAttributeMap_.add((Object)"SENDER_JOB_NUMBER", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(20, 6, true));
            openListAttributeMap_.add((Object)"SENDER_USER_NAME", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(10, 10, true));
            openListAttributeMap_.add("SENDING_PROGRAM_NAME", null, "receiverVariable.sendingProgramName.data");
            openListAttributeMap_.add("REPLY_STATUS", null, "receiverVariable.replyStatus.data");
            openListAttributeMap_.add("DEFAULT_REPLY", null, "receiverVariable.defaultReply.data");
            openListAttributeMap_.add("MESSAGE_HELP", null, "receiverVariable.messageHelpWithRDAndFC.data");
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException pcmlException) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)pcmlException);
            }
        }
        EMPTY_BYTES_ = new byte[0];
        BLANK_INTERNAL_JOB_ID_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    }
}

