/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;

public class RSoftwareResource
extends ChangeableResource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_;
    private static final String PRESENTATION_KEY_ = "SOFTWARE_RESOURCE";
    static ResourceMetaDataTable attributes_;
    private static ProgramMap getterMap_;
    private static final String QSZRTVPR_ = "qszrtvpr";
    public static final String LEVEL = "LEVEL";
    public static final String LOAD_ERROR_INDICATOR = "LOAD_ERROR_INDICATOR";
    public static final String LOAD_ERROR_INDICATOR_ERROR = "*ERROR";
    public static final String LOAD_ERROR_INDICATOR_NONE = "*NONE";
    public static final String LOAD_ID = "LOAD_ID";
    public static final String LOAD_ID_CODE = "*CODE";
    public static final String LOAD_STATE = "LOAD_STATE";
    public static final String LOAD_TYPE = "LOAD_TYPE";
    public static final String LOAD_TYPE_CODE = "*CODE";
    public static final String LOAD_TYPE_LANGUAGE = "*LNG";
    public static final String MINIMUM_BASE_VRM = "MINIMUM_BASE_VRM";
    public static final String MINIMUM_BASE_VRM_MATCH = "*MATCH";
    public static final String MINIMUM_TARGET_RELEASE = "MINIMUM_TARGET_RELEASE";
    public static final String PRIMARY_LANGUAGE_LOAD_ID = "PRIMARY_LANGUAGE_LOAD_ID";
    public static final String PRODUCT_ID = "PRODUCT_ID";
    public static final String PRODUCT_ID_OPERATING_SYSTEM = "*OPSYS";
    public static final String PRODUCT_OPTION = "PRODUCT_OPTION";
    public static final String PRODUCT_OPTION_BASE = "0000";
    public static final String REGISTRATION_TYPE = "REGISTRATION_TYPE";
    public static final String REGISTRATION_VALUE = "REGISTRATION_VALUE";
    public static final String RELEASE_LEVEL = "RELEASE_LEVEL";
    public static final String RELEASE_LEVEL_CURRENT = "*CUR";
    public static final String RELEASE_LEVEL_ONLY = "*ONLY";
    public static final String RELEASE_LEVEL_PREVIOUS = "*PRV";
    public static final String REQUIREMENTS_MET = "REQUIREMENTS_MET";
    public static final String REQUIREMENTS_MET_UNKNOWN = "0";
    public static final String REQUIREMENTS_MET_ALL = "1";
    public static final String REQUIREMENTS_MET_TOO_OLD_COMPARED_TO_BASE = "2";
    public static final String REQUIREMENTS_MET_TOO_OLD_COMPARED_TO_OPTION = "3";
    public static final String SUPPORTED_FLAG = "SUPPORTED_FLAG";
    public static final String SYMBOLIC_LOAD_STATE = "SYMBOLIC_LOAD_STATE";
    public static final String SYMBOLIC_LOAD_STATE_DEFINED = "*DEFINED";
    public static final String SYMBOLIC_LOAD_STATE_CREATED = "*CREATED";
    public static final String SYMBOLIC_LOAD_STATE_PACKAGED = "*PACKAGED";
    public static final String SYMBOLIC_LOAD_STATE_DAMAGED = "*DAMAGED";
    public static final String SYMBOLIC_LOAD_STATE_LOADED = "*LOADED";
    public static final String SYMBOLIC_LOAD_STATE_INSTALLED = "*INSTALLED";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RSoftwareResource";
    private static ProgramCallDocument staticDocument_;
    private String productID_ = "*OPSYS";
    private String releaseLevel_ = "*CUR";
    private String productOption_ = "0000";
    private String loadID_ = "*CODE";
    private ProgramAttributeGetter attributeGetter_ = null;
    private ProgramCallDocument document_ = null;

    public RSoftwareResource() {
        super(presentationLoader_.getPresentation(PRESENTATION_KEY_), null, attributes_);
    }

    public RSoftwareResource(AS400 aS400, String string) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setProductID(string);
    }

    public RSoftwareResource(AS400 aS400, String string, String string2, String string3) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setProductID(string);
        this.setReleaseLevel(string2);
        this.setProductOption(string3);
    }

    public RSoftwareResource(AS400 aS400, String string, String string2, String string3, String string4) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setProductID(string);
        this.setReleaseLevel(string2);
        this.setProductOption(string3);
        this.setLoadID(string4);
    }

    static Object computeResourceKey(AS400 aS400, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RSoftwareResource.class);
        stringBuffer.append(':');
        stringBuffer.append(aS400.getSystemName());
        stringBuffer.append(':');
        stringBuffer.append(aS400.getUserId());
        stringBuffer.append(':');
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        stringBuffer.append(':');
        stringBuffer.append(string3);
        stringBuffer.append(':');
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    @Override
    protected void establishConnection() throws ResourceException {
        AS400 aS400;
        block2: {
            super.establishConnection();
            this.document_ = (ProgramCallDocument)staticDocument_.clone();
            aS400 = this.getSystem();
            try {
                this.document_.setSystem(aS400);
                this.document_.setValue("qszrtvpr.productInformation.productID", this.productID_);
                this.document_.setValue("qszrtvpr.productInformation.releaseLevel", this.releaseLevel_);
                this.document_.setValue("qszrtvpr.productInformation.productOption", this.productOption_);
                this.document_.setValue("qszrtvpr.productInformation.loadID", this.loadID_);
            }
            catch (PcmlException pcmlException) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error setting PCML document values", (Throwable)pcmlException);
            }
        }
        this.attributeGetter_ = new ProgramAttributeGetter(aS400, this.document_, getterMap_);
    }

    @Override
    protected void freezeProperties() throws ResourceException {
        super.freezeProperties();
        Presentation presentation = this.getPresentation();
        presentation.setName(this.productID_);
        StringBuffer stringBuffer = new StringBuffer(this.productID_);
        stringBuffer.append('-');
        stringBuffer.append(this.releaseLevel_);
        stringBuffer.append('-');
        stringBuffer.append(this.productOption_);
        stringBuffer.append('-');
        stringBuffer.append(this.loadID_);
        presentation.setFullName(stringBuffer.toString());
        if (this.getResourceKey() == null) {
            this.setResourceKey(RSoftwareResource.computeResourceKey(this.getSystem(), this.productID_, this.releaseLevel_, this.productOption_, this.loadID_));
        }
    }

    @Override
    public Object getAttributeUnchangedValue(Object object) throws ResourceException {
        Object object2 = super.getAttributeUnchangedValue(object);
        if (object2 == null) {
            if (!this.isConnectionEstablished()) {
                this.establishConnection();
            }
            object2 = this.attributeGetter_.getValue(object);
            try {
                if (this.document_.getIntValue("qszrtvpr.receiver.bytesAvailable") == 0) {
                    throw new ResourceException(1);
                }
            }
            catch (PcmlException pcmlException) {
                throw new ResourceException(pcmlException);
            }
        }
        return object2;
    }

    public String getLoadID() {
        return this.loadID_;
    }

    public String getProductID() {
        return this.productID_;
    }

    public String getProductOption() {
        return this.productOption_;
    }

    public String getReleaseLevel() {
        return this.releaseLevel_;
    }

    @Override
    public void refreshAttributeValues() throws ResourceException {
        super.refreshAttributeValues();
        if (this.attributeGetter_ != null) {
            this.attributeGetter_.clearBuffer();
        }
    }

    public void setLoadID(String string) {
        if (string == null) {
            throw new NullPointerException("loadID");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.loadID_;
        this.loadID_ = string;
        this.firePropertyChange("loadID", string2, this.loadID_);
    }

    public void setProductID(String string) {
        if (string == null) {
            throw new NullPointerException("productID");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.productID_;
        this.productID_ = string;
        this.firePropertyChange("productID", string2, this.productID_);
    }

    public void setProductOption(String string) {
        if (string == null) {
            throw new NullPointerException("productOption");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.productOption_;
        this.productOption_ = string;
        this.firePropertyChange("productOption", string2, this.productOption_);
    }

    public void setReleaseLevel(String string) {
        if (string == null) {
            throw new NullPointerException("releaseLevel");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.releaseLevel_;
        this.releaseLevel_ = string;
        this.firePropertyChange("releaseLevel", string2, this.releaseLevel_);
    }

    static {
        block2: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            attributes_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            getterMap_ = new ProgramMap();
            attributes_.add((Object)LEVEL, String.class, true);
            getterMap_.add(LEVEL, QSZRTVPR_, "receiver.level");
            attributes_.add(LOAD_ERROR_INDICATOR, String.class, true, new Object[]{LOAD_ERROR_INDICATOR_ERROR, LOAD_ERROR_INDICATOR_NONE}, null, true);
            getterMap_.add(LOAD_ERROR_INDICATOR, QSZRTVPR_, "receiver.loadErrorIndicator");
            attributes_.add(LOAD_ID, String.class, true, new Object[]{"5050"}, null, false);
            getterMap_.add(LOAD_ID, QSZRTVPR_, "receiver.loadID");
            attributes_.add((Object)LOAD_STATE, String.class, true);
            getterMap_.add(LOAD_STATE, QSZRTVPR_, "receiver.loadState");
            attributes_.add(LOAD_TYPE, String.class, true, new Object[]{"*CODE", LOAD_TYPE_LANGUAGE}, null, true);
            getterMap_.add(LOAD_TYPE, QSZRTVPR_, "receiver.loadType");
            attributes_.add(MINIMUM_BASE_VRM, String.class, true, new Object[]{MINIMUM_BASE_VRM_MATCH}, null, false);
            getterMap_.add(MINIMUM_BASE_VRM, QSZRTVPR_, "receiver.minimumVRMofBaseRequiredOption");
            attributes_.add((Object)MINIMUM_TARGET_RELEASE, String.class, true);
            getterMap_.add(MINIMUM_TARGET_RELEASE, QSZRTVPR_, "receiver.minimumTargetRelease");
            attributes_.add((Object)PRIMARY_LANGUAGE_LOAD_ID, String.class, true);
            getterMap_.add(PRIMARY_LANGUAGE_LOAD_ID, QSZRTVPR_, "receiver.primaryLanguageLoadID");
            attributes_.add((Object)PRODUCT_ID, String.class, true);
            getterMap_.add(PRODUCT_ID, QSZRTVPR_, "receiver.productID");
            attributes_.add(PRODUCT_OPTION, String.class, true, new Object[]{PRODUCT_OPTION_BASE}, null, false);
            getterMap_.add(PRODUCT_OPTION, QSZRTVPR_, "receiver.productOption");
            attributes_.add((Object)REGISTRATION_TYPE, String.class, true);
            getterMap_.add(REGISTRATION_TYPE, QSZRTVPR_, "receiver.registrationType");
            attributes_.add((Object)REGISTRATION_VALUE, String.class, true);
            getterMap_.add(REGISTRATION_VALUE, QSZRTVPR_, "receiver.registrationValue");
            attributes_.add((Object)RELEASE_LEVEL, String.class, true);
            getterMap_.add(RELEASE_LEVEL, QSZRTVPR_, "receiver.releaseLevel");
            attributes_.add(REQUIREMENTS_MET, String.class, true, new Object[]{REQUIREMENTS_MET_UNKNOWN, REQUIREMENTS_MET_ALL, REQUIREMENTS_MET_TOO_OLD_COMPARED_TO_BASE, REQUIREMENTS_MET_TOO_OLD_COMPARED_TO_OPTION}, null, true);
            getterMap_.add(REQUIREMENTS_MET, QSZRTVPR_, "receiver.requirementsMetBetweenBaseAndOptionValue");
            attributes_.add((Object)SUPPORTED_FLAG, Boolean.class, true);
            getterMap_.add((Object)SUPPORTED_FLAG, QSZRTVPR_, "receiver.supportedFlag", new BooleanValueMap(REQUIREMENTS_MET_UNKNOWN, REQUIREMENTS_MET_ALL));
            attributes_.add(SYMBOLIC_LOAD_STATE, String.class, true, new Object[]{SYMBOLIC_LOAD_STATE_DEFINED, SYMBOLIC_LOAD_STATE_CREATED, SYMBOLIC_LOAD_STATE_PACKAGED, SYMBOLIC_LOAD_STATE_DAMAGED, SYMBOLIC_LOAD_STATE_LOADED, SYMBOLIC_LOAD_STATE_INSTALLED}, null, true);
            getterMap_.add(SYMBOLIC_LOAD_STATE, QSZRTVPR_, "receiver.symbolicLoadState");
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException pcmlException) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)pcmlException);
            }
        }
    }
}

