/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ReturnCodeException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import java.io.IOException;
import java.util.ResourceBundle;

public class ResourceException
extends Exception
implements ReturnCodeException {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static ResourceBundle resourceBundle_ = ResourceBundle.getBundle("com.ibm.as400.resource.ResourceMRI");
    private Throwable exception_ = null;
    private boolean expected_ = false;
    private AS400Message[] messageList_ = null;
    private int returnCode_ = 6;
    public static final int ATTRIBUTES_NOT_RETURNED = 1;
    public static final int ATTRIBUTES_NOT_SET = 2;
    public static final int MESSAGES_RETURNED = 3;
    public static final int OPERATION_FAILED = 4;
    public static final int OPERATION_NOT_SUPPORTED = 5;
    public static final int UNKNOWN_ERROR = 6;
    public static final int AUTHORITY_INSUFFICIENT = 7;
    public static final int ATTRIBUTE_READ_ONLY = 8;

    public ResourceException() {
    }

    public ResourceException(int n) {
        super(ResourceException.buildMessage(n, null));
        this.returnCode_ = n;
    }

    public ResourceException(Throwable throwable) {
        super(throwable instanceof PcmlException ? ((PcmlException)throwable).getLocalizedMessage() : throwable.getMessage());
        this.exception_ = throwable;
        if (Trace.isTraceOn()) {
            Trace.log(2, "ResourceException was thrown", throwable);
        }
    }

    public ResourceException(AS400Message[] aS400MessageArray) {
        super(ResourceException.buildMessage(3, aS400MessageArray));
        this.returnCode_ = 3;
        this.messageList_ = aS400MessageArray;
        if (Trace.isTraceOn()) {
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                Trace.log(2, aS400MessageArray[i].toString());
            }
        }
    }

    public ResourceException(int n, Throwable throwable) {
        super(ResourceException.buildMessage(n, null));
        this.exception_ = throwable;
        this.returnCode_ = n;
        if (Trace.isTraceOn()) {
            Trace.log(2, "ResourceException was thrown", throwable);
        }
    }

    public ResourceException(int n, Throwable throwable, boolean bl) {
        super(ResourceException.buildMessage(n, null));
        this.exception_ = throwable;
        this.expected_ = bl;
        this.returnCode_ = n;
    }

    private static String buildMessage(int n, AS400Message[] aS400MessageArray) {
        String string;
        switch (n) {
            case 1: {
                string = "EXC_ATTRIBUTES_NOT_RETURNED";
                break;
            }
            case 2: {
                string = "EXC_ATTRIBUTES_NOT_SET";
                break;
            }
            case 3: {
                if (aS400MessageArray != null && aS400MessageArray.length > 0) {
                    return aS400MessageArray[0].getText();
                }
                string = "EXC_MESSAGES_RETURNED";
                break;
            }
            case 4: {
                string = "EXC_OPERATION_FAILED";
                break;
            }
            case 5: {
                string = "EXC_OPERATION_NOT_SUPPORTED";
                break;
            }
            case 7: {
                string = "EXC_AUTHORITY_INSUFFICIENT";
                break;
            }
            case 8: {
                string = "EXC_ATTRIBUTE_READ_ONLY";
                break;
            }
            default: {
                string = "EXC_UNKNOWN_ERROR";
            }
        }
        return resourceBundle_.getString(string);
    }

    public Throwable getException() {
        return this.exception_;
    }

    public AS400Message[] getMessageList() {
        if (this.exception_ instanceof ResourceException) {
            return ((ResourceException)this.exception_).getMessageList();
        }
        return this.messageList_;
    }

    @Override
    public int getReturnCode() {
        if (this.exception_ instanceof ResourceException) {
            return ((ResourceException)this.exception_).getReturnCode();
        }
        return this.returnCode_;
    }

    public boolean isExpected() {
        return this.expected_;
    }

    public void unwrap() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Throwable throwable = this.exception_;
        while (throwable != null && throwable instanceof PcmlException) {
            throwable = ((PcmlException)throwable).getException();
        }
        if (throwable == null) {
            throwable = this.exception_;
        }
        if (throwable instanceof AS400SecurityException) {
            throw (AS400SecurityException)throwable;
        }
        if (throwable instanceof ErrorCompletingRequestException) {
            throw (ErrorCompletingRequestException)throwable;
        }
        if (throwable instanceof InterruptedException) {
            throw (InterruptedException)throwable;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof ObjectDoesNotExistException) {
            throw (ObjectDoesNotExistException)throwable;
        }
        if (throwable instanceof ResourceException) {
            ((ResourceException)this.exception_).unwrap();
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (this.messageList_ != null) {
            throw new AS400Exception(this.messageList_);
        }
        throw new InternalErrorException(10);
    }
}

