/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class ResourceListEnumeration
implements Enumeration {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean done_;
    private long index_;
    private ResourceList list_;

    public ResourceListEnumeration(ResourceList resourceList) throws ResourceException {
        if (resourceList == null) {
            throw new NullPointerException("list");
        }
        this.done_ = false;
        this.index_ = 0L;
        this.list_ = resourceList;
        if (!this.list_.isOpen()) {
            this.list_.open();
        }
    }

    @Override
    public boolean hasMoreElements() {
        if (this.done_) {
            return false;
        }
        try {
            if (this.index_ < this.list_.getListLength()) {
                return true;
            }
            if (this.list_.isComplete()) {
                this.done_ = true;
                return false;
            }
            this.list_.waitForResource(this.index_);
            if (this.index_ < this.list_.getListLength()) {
                return true;
            }
            this.done_ = true;
            this.list_.close();
            return false;
        }
        catch (ResourceException resourceException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when enumerating a resource list", (Throwable)resourceException);
            }
            this.done_ = true;
            return false;
        }
    }

    public Object nextElement() {
        if (this.done_) {
            throw new NoSuchElementException();
        }
        try {
            return this.list_.resourceAt(this.index_++);
        }
        catch (ResourceException resourceException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when enumerating a resource list", (Throwable)resourceException);
            }
            this.done_ = true;
            throw new NoSuchElementException();
        }
    }
}

