/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400Credential;
import com.ibm.as400.security.auth.AS400CredentialImpl;
import com.ibm.as400.security.auth.DestroyFailedException;
import com.ibm.as400.security.auth.RefreshFailedException;
import com.ibm.as400.security.auth.RetrieveFailedException;
import com.ibm.as400.security.auth.SwapFailedException;

class AS400CredentialImplRemote
implements AS400CredentialImpl {
    private AS400Credential credential_ = null;

    AS400CredentialImplRemote() {
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.credential_ = null;
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Credential implementation destroyed >> ").append(this.toString()).toString());
        }
    }

    AS400Credential getCredential() {
        return this.credential_;
    }

    @Override
    public int getTimeToExpiration() throws RetrieveFailedException {
        Trace.log(2, "Subclass must provide getTimeToExpiration() implementation");
        throw new RetrieveFailedException(37);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean isCurrent() {
        try {
            return !this.getCredential().isTimed() || this.getTimeToExpiration() > 0;
        }
        catch (RetrieveFailedException retrieveFailedException) {
            Trace.log(2, "Unable to retrieve credential time to expiration", (Throwable)retrieveFailedException);
            return false;
        }
    }

    @Override
    public void refresh() throws RefreshFailedException {
        Trace.log(2, "Subclass must provide refresh() implementation");
        throw new RefreshFailedException(37);
    }

    @Override
    public void setCredential(AS400Credential aS400Credential) {
        if (aS400Credential == null) {
            Trace.log(2, "Parameter 'credential' is null.");
            throw new NullPointerException("credential");
        }
        this.credential_ = aS400Credential;
    }

    @Override
    public AS400Credential swap(boolean bl) throws SwapFailedException {
        Trace.log(2, "Unsupported remote operation");
        throw new SwapFailedException(37);
    }
}

