/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ConnectionEvent;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400Credential;

class RefreshAgent
extends Thread
implements ConnectionListener {
    private int refreshInterval_;
    private int maxRefreshes_ = 0;
    private AS400Credential target_ = null;
    private Exception failure_ = null;
    private boolean stop_ = false;

    RefreshAgent() {
        this.setDaemon(true);
        this.setPriority(10);
    }

    RefreshAgent(AS400Credential aS400Credential, int n, int n2) {
        this();
        this.setTarget(aS400Credential);
        this.setRefreshInterval(n);
        this.setMaxRefreshes(n2);
        String string = aS400Credential.getClass().getName();
        int n3 = string.lastIndexOf(46);
        if (n3 >= 0) {
            string = string.substring(n3 + 1);
        }
        try {
            this.setName("Refresh" + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void connected(ConnectionEvent connectionEvent) {
    }

    @Override
    public void disconnected(ConnectionEvent connectionEvent) {
        try {
            AS400 aS400 = (AS400)connectionEvent.getSource();
            if (this.isAlive() && !aS400.isConnected()) {
                this.stopRefresh();
                if (Trace.isTraceOn()) {
                    Trace.log(3, new StringBuffer("RefreshAgent stopped after system disconnect >> ").append(this.target_.toString()).toString());
                }
            }
        }
        catch (Exception exception) {
            Trace.log(2, "RefreshAgent not stopped after system disconnect >> " + this.target_.toString(), (Throwable)exception);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.isAlive()) {
                this.stopRefresh();
            }
        }
        catch (Exception exception) {
            Trace.log(2, "RefreshAgent not stopped on finalize >> " + this.target_.toString(), (Throwable)exception);
        }
        super.finalize();
    }

    public Throwable getFailure() {
        return this.failure_;
    }

    @Override
    public void run() {
        this.stop_ = false;
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("RefreshAgent starting with maximum attempts ").append(this.maxRefreshes_).append(" and refresh interval ").append(this.refreshInterval_).append(" >> ").append(this.target_.toString()).toString());
        }
        this.validatePropertySet("target", this.target_);
        AS400 aS400 = this.target_.getSystem();
        aS400.addConnectionListener(this);
        this.failure_ = null;
        int n = 0;
        while (!(this.stop_ || this.failure_ != null || this.maxRefreshes_ >= 0 && n++ >= this.maxRefreshes_)) {
            try {
                this.target_.refresh();
                if (this.maxRefreshes_ >= 0 && n >= this.maxRefreshes_) continue;
                RefreshAgent.sleep(this.refreshInterval_ * 1000);
            }
            catch (InterruptedException interruptedException) {
                if (this.stop_) {
                    Trace.log(1, "RefreshAgent stopped on interrupt >> " + this.target_.toString());
                    continue;
                }
                Trace.log(2, "RefreshAgent interrupted >> " + this.target_.toString(), (Throwable)interruptedException);
                this.failure_ = interruptedException;
            }
            catch (Exception exception) {
                Trace.log(2, "RefreshAgent failed >> " + this.target_.toString(), (Throwable)exception);
                this.failure_ = exception;
            }
        }
        aS400.removeConnectionListener(this);
    }

    void setMaxRefreshes(int n) {
        this.validatePropertyChange("maxRefreshes");
        this.maxRefreshes_ = n;
    }

    void setRefreshInterval(int n) {
        this.validatePropertyChange("refreshInterval");
        this.refreshInterval_ = n;
    }

    void setTarget(AS400Credential aS400Credential) {
        this.validatePropertyChange("target");
        this.target_ = aS400Credential;
    }

    public void stopRefresh() {
        this.stop_ = true;
        if (this.isAlive()) {
            this.interrupt();
        }
    }

    void validatePropertyChange(String string) {
        if (this.isAlive()) {
            Trace.log(2, "Property " + string + " not changed (active=true).");
            throw new ExtendedIllegalStateException(string, 5);
        }
    }

    void validatePropertySet(String string, Object object) {
        if (object == null) {
            Trace.log(2, "Required property " + string + " not set.");
            throw new ExtendedIllegalStateException(4);
        }
    }
}

