/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400BasicAuthenticationPrincipal;
import com.ibm.as400.security.auth.AS400Principal;
import com.ibm.as400.security.auth.AuthenticationSystem;
import java.beans.PropertyVetoException;

public class UserProfilePrincipal
extends AS400Principal
implements AS400BasicAuthenticationPrincipal {
    static final long serialVersionUID = 4L;
    private static final int maxLen_ = 10;
    private String userProfileName_ = "";

    public UserProfilePrincipal() {
    }

    public UserProfilePrincipal(String string) {
        try {
            this.setUserProfileName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
    }

    public UserProfilePrincipal(AS400 aS400, String string) {
        super(aS400);
        try {
            this.setUserProfileName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof UserProfilePrincipal)) {
            return false;
        }
        return this.hashCode() == ((UserProfilePrincipal)object).hashCode();
    }

    @Override
    public String getUserProfileName() {
        return this.userProfileName_;
    }

    @Override
    public int hashCode() {
        if (this.userProfileName_ == null || this.userProfileName_.equals("")) {
            return super.hashCode();
        }
        int n = this.userProfileName_.hashCode();
        if (this.getSystem() != null) {
            n += this.getSystem().getSystemName().hashCode();
        }
        return n;
    }

    @Override
    public void initialize(String string) throws Exception {
        this.setSystem(AuthenticationSystem.localHost());
        this.setUserProfileName(string);
    }

    public void setUserProfileName(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "User profile name is null");
            throw new NullPointerException("name");
        }
        String string2 = string.trim().toUpperCase();
        if (string2.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum length of 10");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        String string3 = this.getUserProfileName();
        this.fireVetoableChange("userProfileName", string3, string2);
        this.userProfileName_ = string2;
        this.firePropertyChange("userProfileName", string3, string2);
    }

    @Override
    public String toString() {
        return new StringBuffer(256).append(super.toString()).append('[').append(this.getUserProfileName()).append(']').toString();
    }
}

